﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDNModule
{
    /// <summary>
    /// класс Css-стиля
    /// </summary>
    public class CSS_Class
    {
        /// <summary>
        /// имя стиля
        /// </summary>
        private string name;
        /// <summary>
        /// строка css-стиля
        /// </summary>
        private string cls = "";
        /// <summary>
        /// разобранные параметры стиля
        /// </summary>
        private Dictionary<string, string> prop = new Dictionary<string, string>();

        /// <summary>
        /// создание Css-стиля
        /// </summary>
        /// <param name="NAME">Имя Css-стиля</param>
        public CSS_Class(string NAME) { name = NAME; }

        /// <summary>
        /// добавляет всем сторонам цвет, или стиль, или тольщену
        /// </summary>
        private void add4elem(string st, string fn, string[] val)
        {
            if (val.Length == 0) { return; }
            int i = 0;
            prop[st + "top" + fn] = val[0];
            if (val.Length < 3) { i = 0; }
            else { i = 2; }
            prop[st + "bottom" + fn] = val[i];
            if (val.Length == 1) { i = 0; }
            else { i = 1; }
            prop[st + "right" + fn] = val[i];
            if (val.Length == 1) { i = 0; }
            else if (val.Length < 4) { i = 1; }
            else { i = 3; }
            prop[st + "left" + fn] = val[i];
        }
        /// <summary>
        /// добавляет цвет, стиль и толщену бордюров на все 1 сторону
        /// </summary>
        private void add3elemBorder(string st, string[] val)
        {
            if (val.Length < 3) { return; }
            prop[st + "-width"] = val[0];
            prop[st + "-style"] = val[1];
            prop[st + "-color"] = val[2];
        }
        /// <summary>
        /// добавляет параметры цвета, стиля и толщены на все 4 стороны
        /// </summary>
        private void addElemBorder(string[] val)
        {
            if (val.Length < 3) { return; }
            string[] s = new string[1];
            s[0] = val[0];
            add4elem("border-", "-width", s);
            s[0] = val[1];
            add4elem("border-", "-style", s);
            s[0] = val[2];
            add4elem("border-", "-color", s);
        }

        /// <summary>
        /// добавление Css-стиля из строки
        /// </summary>
        /// <param name="str">Css-текст</param>
        public void StyleAttribute(string str)
        {
            string[] s;
            if (str.IndexOf(';') >= 0)
            { s = str.ToLower().Split(';'); }
            else { s = new string[1]; s[0] = str.ToLower(); }

            foreach (string tt in s)
            {
                string[] t = tt.Split(':');
                string[] val = t[1].Trim().Split(' ');
                t[0] = t[0].Trim();
                if (t[0] == "border-color")
                { add4elem("border-", "-color", val); }
                else if (t[0] == "border-style")
                { add4elem("border-", "-style", val); }
                else if (t[0] == "border-width")
                { add4elem("border-", "-width", val); }
                else if (t[0] == "border-top" ||
                         t[0] == "border-bottom" ||
                         t[0] == "border-left" ||
                         t[0] == "border-right")
                { add3elemBorder(t[0], val); }
                else if (t[0] == "border")
                { addElemBorder(val); }

                else if (t[0] == "margin")
                { add4elem("margin-", "", val); }
                else if (t[0] == "padding")
                { add4elem("padding-", "", val); }
                else { prop[t[0]] = t[1]; }
            }
        }
        /// <summary>
        /// преобразование HTML-теговских элементов в Css-элементы и внесения их в стиль
        /// </summary>
        /// <param name="str">HTML-строка</param>
        /// <param name="html">HTML-тег</param>
        /// <param name="css">глобальная Css-таблица</param>
        public void StyleHtml(string str,string html,CSS_Table css)
        {
            string[] s = str.Split(' ');
            string id = "";
            foreach (string tt in s)
            {
                if (tt != "")
                {
                    string[] t = tt.Split('=');
                    if (t.Length > 1)
                    {
                        t[0] = t[0].Trim().ToLower();
                        string[] val = new string[1];
                        t[1] = t[1].Trim();
                        if (t[1] != "" && (
                           (t[1][0] == '"' && t[1][t[1].Length - 1] == '"') ||
                           (t[1][0] == '\'' && t[1][t[1].Length - 1] == '\'')))
                        { t[1] = t[1].Substring(1, t[1].Length - 2); }
                        val[0] = t[1];

                        if (t[0] == "border")
                        { add4elem("border-", "-width", val); }
                        else if (t[0] == "bgcolor")
                        { prop["background-color"] = val[0]; }
                        else if (t[0] == "text")
                        { prop["color"] = val[0]; }
                        else if (t[0] == "align")
                        { prop["text-align"] = val[0]; }
                        else if (t[0] == "valign")
                        { prop["vertical-align"] = val[0]; }
                        else if (t[0] == "style")
                        { StyleAttribute(val[0]); }
                        else if (t[0] == "class")
                        {
                            CopyFromCss_Class(css.Find(html, val[0], id));
                            cls = val[0];
                        }
                        else if (t[0] == "id")
                        { id = val[0]; }
                        else if (t[0] == "width")
                        { prop["width"] = val[0]; }
                        else if (t[0] == "height")
                        { prop["height"] = val[0]; }
                    }
                }
            }

            if (html == "b")
            { prop["font-weight"] = "bold"; }
            else if (html == "i")
            { prop["font-style"] = "italic"; }
            else if (html == "u")
            { prop["text-decoration"] = "underline"; }
            else if (html == "s")
            { prop["text-decoration"] = "line-through"; }
        }

        /// <summary>
        /// возвращает имя стиля
        /// </summary>
        public string Name { get { return name; } }
        /// <summary>
        /// возвращает информацию о свойствах стиля
        /// </summary>
        public Dictionary<string, string> Property { get { return prop; } }
        /// <summary>
        /// копирует содержимое другого стиля
        /// </summary>
        /// <param name="css">Css-стиль</param>
        public void CopyFromCss_Class(CSS_Class css)
        {
            if (css == null) { return; }
            foreach (string key in css.prop.Keys)
            { prop[key] = css.prop[key]; }
        }
        /// <summary>
        /// возвращает текст стиля
        /// </summary>
        public string CLASS { get { return cls; } }
    }

    /// <summary>
    /// класс Css-таблицы
    /// </summary>
    public class CSS_Table
    {
        /// <summary>
        /// лист Css-стилей
        /// </summary>
        private List<CSS_Class> css = new List<CSS_Class>();
        /// <summary>
        /// создание таблицы стилей из Css-текста
        /// </summary>
        /// <param name="str">Css-текст</param>
        public CSS_Table(string str) { AddStyles(str); }
        /// <summary>
        /// создание пустой таблицы стилей
        /// </summary>
        public CSS_Table() { }
        /// <summary>
        /// добавление Css-стилей
        /// </summary>
        /// <param name="str">Css-текст</param>
        public void AddStyles(string str)
        {
            string[] s = str.Split('}');
            foreach (string tt in s)
            {
                string[] t = tt.Split('{');
                string[] nm = t[0].Split(',');
                foreach (string name in nm)
                {
                    CSS_Class _css = new CSS_Class(name);
                    _css.StyleAttribute(t[1]);
                    css.Add(_css);
                }
            }
        }
        /// <summary>
        /// поиск Css-стиля
        /// </summary>
        /// <param name="index">номер стиля</param>
        public CSS_Class Find(int index)
        { return ((index < css.Count) ? css[index] : null); }
        /// <summary>
        /// поиск Css-стиля
        /// </summary>
        /// <param name="name">имя стиля</param>
        public CSS_Class Find(string name)
        {
            for (int i = 0; i < css.Count; i++)
            {
                if (css[i].Name == name)
                { return css[i]; }
            }
            return null;
        }
        /// <summary>
        /// поиск Css-стиля
        /// </summary>
        /// <param name="elemHTML">HTML-тег</param>
        /// <param name="name">имя стиля</param>
        public CSS_Class Find(string elemHTML, string name)
        { return Find(elemHTML,name,""); }
        /// <summary>
        /// поиск Css-стиля
        /// </summary>
        /// <param name="elemHTML">Html-тег</param>
        /// <param name="name">имя стиля</param>
        /// <param name="id">id-имя тега</param>
        public CSS_Class Find(string elemHTML, string name, string id)
        {
            CSS_Class res = new CSS_Class("FindClassElem");
            res.CopyFromCss_Class(Find("*"));
            if (elemHTML != "")
            { res.CopyFromCss_Class(Find(elemHTML)); }
            if (name != "")
            {
                if (elemHTML != "")
                { res.CopyFromCss_Class(Find(elemHTML + '.' + name)); }
                res.CopyFromCss_Class(Find('.' + name));
            }
            if (id != "")
            { res.CopyFromCss_Class(Find('#' + id)); }
            return ((res.Property.Count > 0) ? res : null);
        }
        /// <summary>
        /// поиск Css-стиля
        /// </summary>
        /// <param name="id">id-имя тега</param>
        public CSS_Class FindId(string id)
        { return Find('#' + id); }
        /// <summary>
        /// возвращает кол-во стилей
        /// </summary>
        public int Count { get { return css.Count; } }
    }

    /// <summary>
    /// Класс для хранения Css-стилей
    /// </summary>
    public class CSS_HTML
    {
        /// <summary>
        /// Css-таблица
        /// </summary>
        private CSS_Table css;
        /// <summary>
        /// создать таблицу Css
        /// </summary>
        /// <param name="str">Css-текст</param>
        public CSS_HTML(string str) { css = new CSS_Table(str); }
        /// <summary>
        /// Создание пустой таблици Css
        /// </summary>
        public CSS_HTML() { css = new CSS_Table(); }
        /// <summary>
        /// добавить Css-стили
        /// </summary>
        /// <param name="str">Css-текст</param>
        public void AddStyles(string str)
        { if (str != "") { css.AddStyles(str); } }
        /// <summary>
        /// получить Css-таблицу
        /// </summary>
        public CSS_Table CSS { get { return css; } }
    }
}
