﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DW.RtfWriter;

namespace CDNModule
{
    /// <summary>
    /// класс хронящий некоторые глобальные методы для HTML-разбора
    /// </summary>
    public class HTMLFunc
    {
        /// <summary>
        /// Текст между открывающимся и закрывающимся тегом
        /// </summary>
        static private string htmlEl = "";
        /// <summary>
        /// HTML-текст
        /// </summary>
        static private string html = "";
        /// <summary>
        /// начальная позиция
        /// </summary>
        static private int startOffset = 0;
        /// <summary>
        /// конечная позиция
        /// </summary>
        static private int endOffset = 0;
        /// <summary>
        /// неиспользуется
        /// </summary>
        private HTMLFunc() { }

        /// <summary>
        /// ищет и возвращает HTML-текст указанного HTML-тега
        /// </summary>
        /// <param name="strHtml">HTML-текст</param>
        /// <param name="strHtmlLowerCase">HTML-текст приведенный к нижнему регистру</param>
        /// <param name="tagName">HTML-тег, который необходимо найти</param>
        static public string innerHTML(string strHtml, string strHtmlLowerCase, string tagName)
        {
            html = tagName;
            startOffset = strHtmlLowerCase.IndexOf("<" + tagName);
            if (startOffset < 0) { return ""; }
            int i = startOffset + 1 + tagName.Length;
            int j = strHtmlLowerCase.IndexOf('>', i);
            if (j != i)
            {
                if (j - i < 0) { return ""; }
                htmlEl = strHtmlLowerCase.Substring(i, j - i);
            }
            j++;
            strHtmlLowerCase = strHtmlLowerCase.Substring(j);
            strHtml = strHtml.Substring(j);
            //i += j + 1;
            j = strHtmlLowerCase.IndexOf("</" + tagName + ">");
            endOffset = j;
            if (j < 0) { return ""; }
            return (strHtml.Substring(0, endOffset));
        }
        /// <summary>
        /// производит поиск и возвращает HTML-текст указанного HTML-тега
        /// </summary>
        /// <param name="str">HTML-текст</param>
        /// <param name="HTML">HTML-тег, который необходимо найти</param>
        static public string innerHTML(string str, string HTML)
        { return innerHTML(str, str.ToLower(), HTML); }
        /// <summary>
        /// производит поиск и возвращает обрезанный текст после найденного внутри текста тега
        /// </summary>
        static public string getElement(string str)
        {
            string s = str.ToLower();
            startOffset = 0;
            do
            {
                startOffset = s.IndexOf('<', startOffset);
                if (startOffset == s.IndexOf("<!--"))
                {
                    str = str.Substring(s.IndexOf("-->") + 3);
                    s = s.Substring(s.IndexOf("-->") + 3);
                }
                else if (startOffset == s.IndexOf("<!"))
                {
                    str = str.Substring(s.IndexOf('>', startOffset) + 1);
                    s = s.Substring(s.IndexOf('>', startOffset) + 1);
                }
            } while (startOffset == s.IndexOf("<!") && startOffset >= 0);

            endOffset = startOffset;
            if (startOffset < 0) { return ""; }
            int i = startOffset + 1;
            int k = s.IndexOf('>', i);
            int j = s.IndexOf(' ', i);
            if (j < 0 || j > k)
            {
                j = s.IndexOf("/>", i);
                if (j < 0 || j > k)
                { j = s.IndexOf('>', i); }
            }
            if (j - i < 0) { return s; }

            html = s.Substring(i, j - i);
            i = j;
            if (s[i] != '>')
            { j = s.IndexOf('>', i); }
            if (j - i >= 0)
            { htmlEl = str.Substring(i, j - i); }
            if (htmlEl != "" && htmlEl[htmlEl.Length - 1] == '/')
            { htmlEl = htmlEl.Substring(0, htmlEl.Length - 1); }
            return (str.Substring(j + 1));
        }

        /// <summary>
        /// возвращает HTML-текст находящийся в последнем найденном теге
        /// </summary>
        static public string HtmlElement { get { return htmlEl; } }
        /// <summary>
        /// Возвращает HTML-текст последнего поиска
        /// </summary>
        static public string getHtml { get { return html; } }
        /// <summary>
        /// возвращает начало HTML-тега в тексте
        /// </summary>
        static public int BeginText { get { return startOffset; } }
        /// <summary>
        /// Возвращает конец HTML-элемента в тексте
        /// </summary>
        static public int EndText { get { return endOffset; } }
    }

    /// <summary>
    /// Класс для хранения головы HTML (HTML-заголовка,Css-стилей, Колонтитулов)
    /// </summary>
    public class HeadHTML
    {
        /// <summary>
        /// заголовок
        /// </summary>
        private string title = "";
        /// <summary>
        /// верхний калантитул
        /// </summary>
        private HTMLElement header;
        /// <summary>
        /// нижний калантитул
        /// </summary>
        private HTMLElement footer;
        /// <summary>
        /// Css-таблица
        /// </summary>
        private CSS_HTML css = new CSS_HTML();

        /// <summary>
        /// создает класс из HTML-текста
        /// </summary>
        /// <param name="str">HTML-текст</param>
        public HeadHTML(string str)
        {
            string t = str.ToLower();
            css.AddStyles(HTMLFunc.innerHTML(str, t, "style"));
            title = HTMLFunc.innerHTML(str, t, "title");
            t = HTMLFunc.innerHTML(str, "header");
            header = new HTMLElement("header", ref t, "", css.CSS);
            //HTMLFunc.innerHTML(str, t, "header");
            t = HTMLFunc.innerHTML(str, "footer");
            footer = new HTMLElement("footer", ref t, "", css.CSS);
            //HTMLFunc.innerHTML(str, t, "footer");
        }

        /// <summary>
        /// возвращает заголовок строаницы
        /// </summary>
        public string Title { get { return title; } }
        /// <summary>
        /// возвращает верхний калантитул
        /// </summary>
        public HTMLElement Head { get { return header; } }
        /// <summary>
        /// Возвращает нижний калантитул
        /// </summary>
        public HTMLElement Foot { get { return footer; } }
        /// <summary>
        /// возвращает Css-таблицу
        /// </summary>
        public CSS_HTML CSS { get { return css; } }
    }

    /// <summary>
    /// класс HTML-элемента разобранного на данные
    /// </summary>
    public class HTMLElement
    {
        /// <summary>
        /// Css-стиль
        /// </summary>
        private CSS_Class css;
        /// <summary>
        /// имя тега
        /// </summary>
        private string tagName;
        /// <summary>
        /// Dom-структура входящая в тег
        /// </summary>
        private List<HTMLElement> dom = new List<HTMLElement>();
        /// <summary>
        /// Атрибуты тега
        /// </summary>
        private Dictionary<string, string> attributes = new Dictionary<string, string>();
        /// <summary>
        /// облегченный текст тега
        /// </summary>
        private string text = "";
        private int tbegin, tend;

        /// <summary>
        /// разбирает строку на параметры
        /// </summary>
        /// <param name="param">текст с параметрами (атрибутами) HTML-тега</param>
        public void AddParam(string param)
        {
            string[] attributesArray = param.Split(' ');
            foreach (string attribute in attributesArray)
            {
                string[] attrPair = attribute.Trim().Split('=');
                if (attrPair.Length > 1)
                {
                    attrPair[1] = attrPair[1].Trim();
                    String attrValue = attrPair[1];
                    String attrName = attrPair[0].Trim().ToLower();
                    attributes[attrName] = FormatAttributeValue(attrValue);
                }
            }
        }

        private String FormatAttributeValue(String attrValue)
        {
            if (IsAttrValueIsNeedInCorrecting(attrValue))
            {
                attrValue = attrValue.Substring(1, attrValue.Length - 2);
            }
            return attrValue;
        }

        private bool IsAttrValueIsNeedInCorrecting(String attrValue)
        {
            return (attrValue != "" && (
                        (attrValue[0] == '"' && attrValue[attrValue.Length - 1] == '"') ||
                        (attrValue[0] == '\'' && attrValue[attrValue.Length - 1] == '\''))
                        );
        }

        /// <summary>
        /// осуществляет построение обнаружение дочерных элементов html
        /// </summary>
        private void Create(ref string tagInnerHtml, CSS_Table Css)
        {
            int i;
            if ( !CanContainInnerText() )
            { text = ""; }
            else if (tagName == "xmp")
            {
                i = tagInnerHtml.IndexOf("</xmp>");
                if (i >= 0)
                {
                    text = tagInnerHtml.Substring(0, i - 1);
                    tagInnerHtml = tagInnerHtml.Substring(i + 6);
                    tend = tbegin + text.Length;
                }
                else
                {
                    text = tagInnerHtml;
                    tagInnerHtml = "";
                    tend = tbegin + text.Length;
                }
            }
            else
            {
                int j;
                text = "";
                do
                {
                    i = tagInnerHtml.IndexOf('<');
                    if (i >= 0)
                    {
                        j = tagInnerHtml.IndexOf("</" + tagName + ">");
                        if (i == j)
                        {
                            text += tagInnerHtml.Substring(0, j);
                            text = text.Replace("\n", "");
                            tagInnerHtml = tagInnerHtml.Substring(j + 3 + tagName.Length);
                            tend = tbegin + innerText.Length - 1;
                            return;
                        }
                        else
                        {
                            string s = HTMLFunc.getElement(tagInnerHtml);
                            string t = "#$" + dom.Count.ToString() + "$#";
                            text += tagInnerHtml.Substring(0, HTMLFunc.BeginText);
                            tagInnerHtml = s;
                            dom.Add(new HTMLElement(HTMLFunc.getHtml, ref tagInnerHtml, HTMLFunc.HtmlElement, Css, innerText.Length, this));
                            text += t;
                        }
                    }
                } while (i >= 0);
                text += tagInnerHtml;
                tend = tbegin + innerText.Length - 1;
                tagInnerHtml = "";
            }
        }
        /// <summary>
        /// Может ли данный элемент содержать текст внутри тегов открытия и закрытия
        /// </summary>
        /// <returns></returns>
        private bool CanContainInnerText()
        {
            //Те теги, у которых не должно быть текста между открывающимся и закрывающимся тегами
            return !(tagName == "br" || tagName == "input" ||
                           tagName == "hr" || tagName == "page" ||
                           tagName == "img" || tagName == "field");
        }


        public List<HTMLElement> GetElementByTagName(string TagNM)
        {
            TagNM = TagNM.ToLower();
            List<HTMLElement> Tags = new List<HTMLElement>();

            for (int i = 0; i < ChildDOMElement.Count; i++)
            {
                HTMLElement element = ChildDOMElement[i];
                if (element.tagName.ToLower() == TagNM)
                    Tags.Add(element);
                if (element.ChildDOMElement.Count > 0)
                    Tags.AddRange(element.GetElementByTagName(TagNM));
            }
            return Tags;
        }

        public HTMLElement(String tagName, CSS_Class Css)
        {
            tbegin = 0;
            tend = 0;
            css = new CSS_Class("newcss");
            css.CopyFromCss_Class(Css);
            this.tagName = tagName;
        }
        /// <summary>
        /// создает HTML-элемент
        /// </summary>
        public HTMLElement(string tagName, ref string tagInnerHtml, string param, 
            CSS_Table Css, int ps, HTMLElement parHTML)
        {
            tbegin = ps;//HTMLFunc.BeginText + ps;
            tend = ps;// HTMLFunc.EndText + ps;
            AddParam(param);
            css = new CSS_Class(tagName);
            if (Css != null)
            {
                css.CopyFromCss_Class(Css.Find("*"));
                css.CopyFromCss_Class(Css.Find(tagName, RTFFunc.getParm(this, "class"), RTFFunc.getParm(this, "id")));
            }
            css.CopyFromCss_Class(parHTML.css);
            css.StyleHtml(param, tagName, Css);
            this.tagName = tagName;
            Create(ref tagInnerHtml, Css);
        }
        /// <summary>
        /// создает HTML-элемент
        /// </summary>
        public HTMLElement(string tagName, ref string tagInnerHtml, string param, CSS_Table Css)
        {
            tbegin = 0; tend = 0;
            AddParam(param);
            css = new CSS_Class(tagName);
            if (Css != null)
            {
                css.CopyFromCss_Class(Css.Find("*"));
                css.CopyFromCss_Class(Css.Find(tagName, RTFFunc.getParm(this, "class"), RTFFunc.getParm(this, "id")));
            }
            css.StyleHtml(param, tagName, Css);
            this.tagName = tagName;
            Create(ref tagInnerHtml, Css);
        }

        /// <summary>
        /// возвращает текст без HTML-тегов
        /// </summary>
        public string innerText
        {
            get
            {
                string s = text;
                if (dom.Count > 0)
                    for (int i = dom.Count - 1; i >= 0; i--)
                    {
                        s = s.Replace("#$" + i.ToString() + "$#", dom[i].innerText);
                    }
                return s;
            }
        }
        /// <summary>
        /// возвращает HTML-текст
        /// </summary>
        public string innerHTML { get { return text; } }
        /// <summary>
        /// возвращает DOM-структуру
        /// </summary>
        public List<HTMLElement> ChildDOMElement { get { return dom; } }
        /// <summary>
        /// Возвращает имя тега
        /// </summary>
        public string TagName { get { return tagName; } }
        /// <summary>
        /// возвращает Css-стиль
        /// </summary>
        public CSS_Class CSS { get { return css; } }
        /// <summary>
        /// возвращает начальную позицию тега
        /// </summary>
        public int BeginHtml { get { return 0; } }
        /// <summary>
        /// Возвращает конечную позицию тега
        /// </summary>
        public int EndHtml { get { return 0; } }
        /// <summary>
        /// Возвращает конечную позицию тега
        /// </summary>
        public int BeginText { get { return tbegin; } }
        public int EndText { get { return tend; } }
        /// <summary>
        /// возвращает параметры тега
        /// </summary>
        public Dictionary<string, string> Params { get { return attributes; } }
    }

    /// <summary>
    /// класс HTML-таблицы
    /// </summary>
    public class HTMLTable
    {
        /// <summary>
        /// класс для определения псевдо элементов таблицы (раставляет все ячейки в памяти как их нужно отображать)
        /// </summary>
        private class koord
        {
            public int X, Y;
            public bool db = false;
            public koord(int x, int y)
            { X = x; Y = y; }
        }
        /// <summary>
        /// неразрывный заголовок таблици
        /// </summary>
        private HTMLElement h;
        /// <summary>
        /// </summary>
        private int col, row, hrow;
        /// <summary>
        /// HTML-таблица
        /// </summary>
        private List<List<HTMLElement>> cells = new List<List<HTMLElement>>();
        //private List<List<koord>> kd = new List<List<koord>>();
        /// <summary>
        /// разметка внутренней структуры таблицы, для избежания сложных связей
        /// </summary>
        private koord[,] kd;

        private List<int> rowList;
        //private int decrow

        public List<int> RowList { get { return rowList; } }

        /// <summary>
        /// добавляет ячейку в строку
        /// </summary>
        private void addCell(HTMLElement tr)
        {
            List<HTMLElement> l = new List<HTMLElement>();
            //l.Clear();
            if (tr.ChildDOMElement.Count > 0)
                for (int j = 0; j < tr.ChildDOMElement.Count; j++)
                {
                    HTMLElement td = tr.ChildDOMElement[j];
                    if (td.TagName == "td")
                    { l.Add(td); }
                }
            if (l.Count > col)
            { col = l.Count; }
            cells.Add(l);

        }
        /// <summary>
        /// добавляет строку
        /// </summary>
        private void addTrs(HTMLElement html)
        {
            if (html.ChildDOMElement.Count > 0)
            {
                for (int i = 0; i < html.ChildDOMElement.Count; i++)
                {
                    HTMLElement tr = html.ChildDOMElement[i];
                    if (tr.TagName == "tr")
                    {
                        addCell(tr);
                        try
                        {
                            string s = tr.Params["list"];
                            int s_i = int.Parse(s);
                            rowList.Add(s_i);
                        }
                        catch { rowList.Add(-1); }
                    }
                    else if (tr.TagName == "thead")
                    {
                        addTrs(tr);
                        hrow = cells.Count;
                    }
                }
            }
        }

        /// <summary>
        /// создает HTML-таблицу
        /// </summary>
        /// <param name="html">HTML-элемент, являющийся таблицей</param>
        public HTMLTable(HTMLElement html)
        {
            h = html; col = 0; row = 0; hrow = 0;
            rowList = new List<int>();
            addTrs(h);
            row = cells.Count;
            kd = new koord[row, col];
            /*for (int i = 0; i < row; i++)
                for (int j = 0; j < col; j++)
                { kd[i, j] = null; }// */

            int k;
            for (int i = 0; i < row; i++)
            {
                k = 0;
                List<HTMLElement> l = cells[i];
                for (int j = 0; j < l.Count; j++)
                {
                    while (k < col && kd[i, k] != null)
                    { k++; }

                    if (k < col)
                    {
                        int lX, lY;
                        HTMLElement hh = l[j];
                        string s = RTFFunc.getParm(hh, "colspan");
                        if (s == "") { lX = 1; }
                        else { lX = int.Parse(s); }
                        s = RTFFunc.getParm(hh, "rowspan");
                        if (s == "") { lY = 1; }
                        else { lY = int.Parse(s); }

                        if (lX > 1 && lY > 1)
                        {
                            for (int iy = 0; iy < lY; iy++)
                                for (int ix = 0; ix < lX; ix++)
                                {
                                    if (ix + k < col && iy + i < row)
                                    {
                                        kd[iy + i, ix + k] = new koord(j, i);
                                        if (iy > 0 || ix > 0)
                                        { kd[iy + i, ix + k].db = true; }
                                    }
                                }
                        }
                        else if (lX > 1)
                        {
                            for (int ix = 0; ix < lX; ix++)
                            {
                                if (ix + k < col)
                                {
                                    kd[i, ix + k] = new koord(j, i);
                                    if (ix > 0)
                                    { kd[i, ix + k].db = true; }
                                }
                            }
                        }
                        else if (lY > 1)
                        {
                            for (int iy = 0; iy < lY; iy++)
                            {
                                if (iy + i < row)
                                {
                                    kd[iy + i, k] = new koord(j, i);
                                    if (iy > 0)
                                    { kd[iy + i, k].db = true; }
                                }
                            }
                        }
                        else { kd[i, k] = new koord(j, i); }
                    }
                }
            }
        }
        /// <summary>
        /// позволяет извлекать данные из определенной ячейки
        /// </summary>
        /// <param name="Col">графа</param>
        /// <param name="Row">строка</param>
        public HTMLElement Cells(int Col, int Row)
        {
            if (Row < row)
            {
                if (cells[Row].Count > Col)
                { return cells[Row][Col]; }
            }
            return null;
        }
        /// <summary>
        /// позволяет извлекать данные из определенной ячейки, с избежанием обращения к пустоте
        /// </summary>
        public HTMLElement Cell(int X, int Y)
        {
            if (X < col && Y < row && kd[Y, X] != null)
            {
                koord k = kd[Y, X];
                return Cells(k.X, k.Y);
            }
            return null;
        }
        /// <summary>
        /// проверяет является ли ячейка самостоятельной или привязана к другой для заполнения пробелов
        /// </summary>
        public bool IsJoint(int X, int Y)
        {
            if (X < col && Y < row && kd[Y, X] != null)
            { return kd[Y, X].db; }
            return true;
        }
        /// <summary>
        /// возвращает элементы в строке
        /// </summary>
        /// <param name="Row">номер стороки</param>
        public List<HTMLElement> Rows(int Row)
        { if (Row < row) { return cells[Row]; } else { return null; } }
        /// <summary>
        /// возвращает таблицу
        /// </summary>
        public HTMLElement Table { get { return h; } }
        /// <summary>
        /// возвращает максимальное кол-во ячеек в строке
        /// </summary>
        public int ColCount { get { return col; } }
        /// <summary>
        /// возвращает кол-во строк
        /// </summary>
        public int RowCount { get { return row; } }
        /// <summary>
        /// возвращает кол-во заголовочных строк
        /// </summary>
        public int FixedRow { get { return hrow; } }
    }

    /// <summary>
    /// класс для хранения HTML-тела
    /// </summary>
    public class BodyHTML
    {
        /// <summary>
        /// Dom-структура находящаяся внутри тела
        /// </summary>
        private HTMLElement dom;
        /// <summary>
        /// Css-стиль
        /// </summary>
        private CSS_Class css;
        /// <summary>
        /// ссылка на HTML-голову
        /// </summary>
        private HeadHTML head;
        /// <summary>
        /// создание HTML-тела
        /// </summary>
        public BodyHTML(string str, string param, HeadHTML Head)
        {
            head = Head;
            css = new CSS_Class("body");
            css.CopyFromCss_Class(head.CSS.CSS.Find("body", ""));
            css.StyleHtml(param, "body", head.CSS.CSS);
            dom = new HTMLElement("body", ref str, param, head.CSS.CSS);
        }
        /// <summary>
        /// Возвращает Dom-структуру
        /// </summary>
        public HTMLElement DOM { get { return dom; } }
        /// <summary>
        /// возвращает Css-стиль
        /// </summary>
        public CSS_Class Css { get { return css; } }
    }

    /// <summary>
    /// Класс чтения HTML кода, после чего строется его DOM-структура
    /// </summary>
    public class C_HTML
    {
        /// <summary>
        /// хранит Голову HTML-кода (шапку, стили, колантитулы
        /// </summary>
        private HeadHTML head;
        /// <summary>
        /// хранит тело HTML-документа
        /// </summary>
        private BodyHTML body;

        /// <summary>
        /// Разбор HTML-кода
        /// </summary>
        /// <param name="str">строка с HTML-кодом</param>
        public C_HTML(string htmlString)
        {
            string htmlStrLowerCase = htmlString.ToLower();
            head = new HeadHTML(HTMLFunc.innerHTML(htmlString, htmlStrLowerCase, "head"));
            string innerHtml = HTMLFunc.innerHTML(htmlString, htmlStrLowerCase, "body");
            body = new BodyHTML(innerHtml, HTMLFunc.HtmlElement, head);
        }

        /// <summary>
        /// голова HTML-кода
        /// </summary>
        public HeadHTML Head { get { return head; } }
        /// <summary>
        /// тело HTML-кода
        /// </summary>
        public BodyHTML Body { get { return body; } }
    }
}
