﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
//using System.Text.RegularExpressions;
using DW.RtfWriter;

namespace CDNModule
{
    public class RTFFunc
    {
        private RTFFunc() { }
        static public string getProp(CSS_Class css,string s)
        {
            try { return css.Property[s]; }
            catch { return ""; }
        }
        static public string getParm(HTMLElement html, string s)
        {
            try { return html.Params[s]; }
            catch { return ""; }
        }
        static public Margins getMargin(Margins mg, CSS_Class css)
        {
            string s = getProp(css,"margin-bottom");
            if (s != "")
            { mg[Direction.Bottom] = float.Parse(s); }

            s = getProp(css, "margin-top");
            if (s != "")
            { mg[Direction.Top] = float.Parse(s); }

            s = getProp(css, "margin-left");
            if (s != "")
            { mg[Direction.Left] = float.Parse(s); }

            s = getProp(css, "margin-right");
            if (s != "")
            { mg[Direction.Right] = float.Parse(s); }

            return mg;
        }
        static public Align getAlign(CSS_Class css)
        {
            string s = getProp(css,"text-align");
            Align a;
            if (s == "center")
            { a = Align.Center; }
            else if (s == "left")
            { a = Align.Left; }
            else if (s == "right")
            { a = Align.Right; }
            else if (s == "justify")
            { a = Align.FullyJustify; }
            else { a = Align.None; }
            return a;
        }
        static public AlignVertical getVAlign(CSS_Class css)
        {
            string s = getProp(css,"vertical-align");
            AlignVertical a;
            if (s == "bottom")
            { a = AlignVertical.Bottom; }
            else if (s == "top")
            { a = AlignVertical.Top; }
            else { a = AlignVertical.Middle; }
            return a;
        }
        static public BorderStyle getBorderStyle(CSS_Class css,string str)
        {
            string s = getProp(css,"border-"+str+"-style");
            BorderStyle brd;
            if (s == "dotted")
            { brd = BorderStyle.Dotted; }
            else if (s == "dashed")
            { brd = BorderStyle.Dashed; }
            else if (s == "double")
            { brd = BorderStyle.Double; }
            else if (s == "solid")
            { brd = BorderStyle.Single; }
            else { brd = BorderStyle.None; }
            return brd;
        }
        static public Border getBorder(RtfDocument rtf,Border brd,CSS_Class css, string str)
        {
            BorderStyle b = getBorderStyle(css,str);
            if (b != BorderStyle.None)
            { brd.Style = b; }

            string s = getProp(css,"border-" + str + "-width");
            if (s != "")
            { brd.Width = float.Parse(s); }

            s = getProp(css,"border-" + str + "-color");
            if (s != "")
            { brd.Color = rtf.createColor(newColor(s)); }

            return brd;
        }
        static private Color newColor(string s)
        {
            if (s != "")
            {
                if (s[0] == '#')
                { return new Color(s.Substring(1, 6)); }
                else
                {
                    byte r, g, b;
                    s = s.Substring(s.IndexOf('(') + 1);
                    s = s.Replace(')', ' ');
                    string[] t = s.Split(',');
                    if (t.Length != 3)
                    { return null; }
                    r = byte.Parse(t[0]);
                    g = byte.Parse(t[1]);
                    b = byte.Parse(t[2]);
                    return new Color(r, g, b);
                }
            }
            else return new Color();
        }
        static public ColorDescriptor getTextColor(RtfDocument rtf, CSS_Class css)
        { return rtf.createColor(newColor(getProp(css,"color"))); }
        static public ColorDescriptor getBGColor(RtfDocument rtf, CSS_Class css)
        { return rtf.createColor(newColor(getProp(css,"background-color"))); }
        static public ColorDescriptor getBorderColor(RtfDocument rtf, CSS_Class css)
        { return rtf.createColor(newColor(getProp(css,"border-top-color"))); }
        static public FontDescriptor getFont(RtfDocument rtf, CSS_Class css)
        {
            string s = getProp(css,"font-family");
            if (s == "") { s = "Times new Roman"; }
            return rtf.createFont(s);
        }
    }

    /// <summary>
    /// Класс настройки шрифта
    /// </summary>
    public class RTF_CharFmt
    {
        /// <summary>
        /// RTF-настройки
        /// </summary>
        private RtfCharFormat chf;
        /// <summary>
        /// CSS-настройки
        /// </summary>
        private CSS_Class css_;
        /// <summary>
        /// создание шрифта
        /// </summary>
        private void Create(RtfDocument rtf,CSS_Class css)
        {
            string s = RTFFunc.getProp(css,"font-size");
            if (s == "") { s = "14"; }
            try
            { chf.FontSize = float.Parse(s); }
            catch { chf.FontSize = 14; }

            s = RTFFunc.getProp(css,"font-style");
            if (s == "italic")
            { chf.FontStyle.addStyle(FontStyleFlag.Italic); }
            else if (s == "normal")
            { chf.FontStyle.removeStyle(FontStyleFlag.Italic); }

            s = RTFFunc.getProp(css,"font-weight");
            if (s == "bold")
            { chf.FontStyle.addStyle(FontStyleFlag.Bold); }
            else if (s == "normal")
            { chf.FontStyle.removeStyle(FontStyleFlag.Bold); }

            s = RTFFunc.getProp(css,"text-decoration");
            if (s == "line-through")
            { chf.FontStyle.addStyle(FontStyleFlag.Strike); }
            else if (s == "underline")
            { chf.FontStyle.addStyle(FontStyleFlag.Underline); }
            else if (s == "none")
            {
                chf.FontStyle.removeStyle(FontStyleFlag.Strike);
                chf.FontStyle.removeStyle(FontStyleFlag.Underline);
            }

            s = RTFFunc.getProp(css,"vertical-align");
            if (s == "sub")
            { chf.FontStyle.addStyle(FontStyleFlag.Sub); }
            else if (s == "super")
            { chf.FontStyle.addStyle(FontStyleFlag.Super); }
            else if (s == "baseline")
            {
                chf.FontStyle.removeStyle(FontStyleFlag.Sub);
                chf.FontStyle.removeStyle(FontStyleFlag.Super);
            }

            s = RTFFunc.getProp(css,"color");

            chf.BgColor = RTFFunc.getBGColor(rtf, css);
            chf.FgColor = RTFFunc.getTextColor(rtf, css);
            chf.Font = RTFFunc.getFont(rtf, css);
            chf.AnsiFont = chf.Font;
            css_ = css;
        }
        /// <summary>
        /// создание класса шрифта
        /// </summary>
        public RTF_CharFmt(RtfDocument rtf,RtfCharFormat crtf, CSS_Class css)
        {
            chf = crtf;
            if (css != null)
            { Create(rtf, css); }
        }
        /// <summary>
        /// создание класса шрифта
        /// </summary>
        public RTF_CharFmt(RtfDocument rtf, RtfCharFormat crtf, HTMLElement html)
        {
            chf = crtf;

            string s = html.TagName;
            if (s == "i")
            { chf.FontStyle.addStyle(FontStyleFlag.Italic); }
            else if (s == "b")
            { chf.FontStyle.addStyle(FontStyleFlag.Bold); }
            else if (s == "u")
            { chf.FontStyle.addStyle(FontStyleFlag.Underline); }
            else if (s == "s" || s == "strike")
            { chf.FontStyle.addStyle(FontStyleFlag.Strike); }
            else if (s == "sub")
            { chf.FontStyle.addStyle(FontStyleFlag.Sub); }
            else if (s == "sup")
            { chf.FontStyle.addStyle(FontStyleFlag.Super); }
            else if (s == "small")
            { chf.FontStyle.addStyle(FontStyleFlag.Scaps); }

            if (html.CSS != null)
            { Create(rtf, html.CSS); }
        }
        /// <summary>
        /// получить Rtf-настройки
        /// </summary>
        public RtfCharFormat Font { get { return chf; } }
        /// <summary>
        /// Получить Css-настройки
        /// </summary>
        public CSS_Class CSS { get { return css_; } }
    }

    /// <summary>
    /// класс RTF-абзаца
    /// </summary>
    public class RTF_Par
    {
        /// <summary>
        /// класс RTF-абзаца
        /// </summary>
        private RtfParagraph par;
        /// <summary>
        /// шрифт абзаца
        /// </summary>
        private RTF_CharFmt fmt;
        /// <summary>
        /// лист шрифтов
        /// </summary>
        private List<RTF_CharFmt> fmts = new List<RTF_CharFmt>();
        /// <summary>
        /// лист сносок
        /// </summary>
        private List<RtfFootnote> Foot = new List<RtfFootnote>();
        /// <summary>
        /// создание форматирования по HTML-элементу
        /// </summary>
        public void AddFmt(HTMLElement html,RtfDocument rtf)
        {
            if (html.ChildDOMElement.Count > 0)
                for (int i = 0; i < html.ChildDOMElement.Count; i++)
                {
                    HTMLElement SubEl = html.ChildDOMElement[i];
                    if (SubEl.TagName == "page")
                    {
                        string s = RTFFunc.getParm(SubEl,"type");
                        RtfFieldControlWord.FieldType k;
                        if (s == "Data")
                        { k = RtfFieldControlWord.FieldType.Date; }
                        else if (s == "NumPages")
                        { k = RtfFieldControlWord.FieldType.NumPages; }
                        else if (s == "Page")
                        { k = RtfFieldControlWord.FieldType.Page; }
                        else if (s == "Time")
                        { k = RtfFieldControlWord.FieldType.Time; }
                        else { k = RtfFieldControlWord.FieldType.None; }
                        if (k != RtfFieldControlWord.FieldType.None)
                        { par.addControlWord(SubEl.BeginText-1, k); }
                    }
                    else if(SubEl.TagName == "field")
                    {
                        string s = RTFFunc.getParm(SubEl, "val");
                        if (s == "") s = RTFFunc.getParm(SubEl, "value");
                        if (s != "")
                        {
                            if (par.Text.Length == 0) { par.Text = s; }
                            else if (SubEl.BeginText == 0) { par.Text = s + par.Text; }
                            else if (SubEl.BeginText - 1 >= par.Text.Length)
                            { par.Text = par.Text + s; }
                            else par.Text.Insert(SubEl.BeginText - 1, s);
                        }
                    }
                    else
                    {
                        RtfCharFormat frmt = par.addCharFormat(SubEl.BeginText, SubEl.EndText);
                        fmts.Add(new RTF_CharFmt(rtf, frmt, SubEl.CSS));
                        string s = RTFFunc.getParm(SubEl, "title");
                        if (s != "")
                        {
                            RtfFootnote ft = par.addFootnote(SubEl.EndText);
                            ft.addParagraph().Text = s;
                            Foot.Add(ft);
                        }
                        AddFmt(SubEl, rtf);
                    }
                }
        }
        /// <summary>
        /// создание абзаца
        /// </summary>
        private void Create(HTMLElement html, RtfDocument rtf)
        {
            fmt = new RTF_CharFmt(rtf, par.DefaultCharFormat, html);
            par.Text = html.innerText;
            Align a = RTFFunc.getAlign(html.CSS);
            if (a != Align.None)
            { par.Alignment = a; }
            
            string s = RTFFunc.getProp(html.CSS,"letter-spacing");
            if (s != "")
            { par.LineSpacing = float.Parse(s); }

            s = RTFFunc.getProp(html.CSS,"text-indent");
            if (s != "")
            { par.FirstLineIndent = float.Parse(s); }

            RTFFunc.getMargin(par.Margins, html.CSS);
            AddFmt(html, rtf);
        }
        /// <summary>
        /// создание абзаца в самом документе
        /// </summary>
        public RTF_Par(RtfDocument rtf,HTMLElement html)
        {
            par = rtf.addParagraph();
            Create(html, rtf);
        }
        /// <summary>
        /// создание абзаца в калантитуле
        /// </summary>
        public RTF_Par(RtfHeaderFooter rtf, RtfDocument rdoc, HTMLElement html)
        {
            par = rtf.addParagraph();
            Create(html, rdoc);
        }
        /// <summary>
        /// создание абзаца в таблице
        /// </summary>
        public RTF_Par(RtfTableCell rtf, RtfDocument rdoc, HTMLElement html)
        {
            par = rtf.addParagraph();
            Create(html, rdoc);
        }
        /// <summary>
        /// возвращает RTF-абзац
        /// </summary>
        public RtfParagraph Par { get { return par; } }
    }
    /// <summary>
    /// класс для настройки и вставки картинки в RTF
    /// </summary>
    public class RTF_Img
    {
        /// <summary>
        /// класс для хранения информации о RTF-картинки
        /// </summary>
        private RtfImage img;

        /// <summary>
        /// возвращает параметры IMG-тега
        /// </summary>
        private string GetPar(string str, HTMLElement html)
        {
            string s = RTFFunc.getParm(html,str);
            if (s == "")
            { s = RTFFunc.getProp(html.CSS, str); }
            return s;
        }
        /// <summary>
        /// создание класса из HTML-тега
        /// </summary>
        /// <param name="html">HTML-текст</param>
        private void Create(HTMLElement html)
        {
            string s = GetPar("height", html);
            if (s != "")
            { img.Heigth = float.Parse(s); }
            s = GetPar("width", html);
            if (s != "")
            { img.Width = float.Parse(s); }


            Align a = RTFFunc.getAlign(html.CSS);
            if (a != Align.None)
            { img.Alignment = a; }

            RTFFunc.getMargin(img.Margins, html.CSS);
        }
        /// <summary>
        /// создание картинки в RTF-документе
        /// </summary>
        public RTF_Img(RtfDocument rtf,HTMLElement html)
        {
            if (html.TagName == "img")
            {
                string s = RTFFunc.getParm(html,"src");
                if (s != "")
                {
                    img = rtf.addImage(s);
                    Create(html);
                }
            }
        }
        /// <summary>
        /// создание картинки в таблице RTF-документа
        /// </summary>
        public RTF_Img(RtfTableCell rtf,HTMLElement html)
        {
            if (html.TagName == "img")
            {
                string s = RTFFunc.getParm(html,"src");
                if (s != "")
                {
                    img = rtf.addImage(s);
                    Create(html);
                }
            }
        }
    }
    /// <summary>
    /// класс для формирование Rtf-ячейки таблицы
    /// </summary>
    public class RTF_TableCell
    {
        /// <summary>
        /// Rtf-ячейка
        /// </summary>
        private RtfTableCell cell;

        static public RtfTableCell Set(RtfDocument rtf, RtfTableCell CELL, HTMLElement html)
        {
            Align a = RTFFunc.getAlign(html.CSS);
            if (a != Align.None)
            { CELL.Alignment = a; }
            CELL.AlignmentVertical = RTFFunc.getVAlign(html.CSS);

            string s = RTFFunc.getParm(html, "width");
            if (s == "")
            { s = RTFFunc.getProp(html.CSS, "width"); }
            if (s != "")
            { CELL.Width = float.Parse(s); }


            RTFFunc.getBorder(rtf, CELL.Borders[Direction.Bottom],
                              html.CSS, "bottom");
            RTFFunc.getBorder(rtf, CELL.Borders[Direction.Top],
                              html.CSS, "top");
            RTFFunc.getBorder(rtf, CELL.Borders[Direction.Left],
                              html.CSS, "left");
            RTFFunc.getBorder(rtf, CELL.Borders[Direction.Right],
                              html.CSS, "right");                        
            return CELL;
        }

<<<<<<< .mine
        /// <summary>
        /// создание класса Rtf-ячейки
        /// </summary>
        public RTF_TableCell(RtfDocument rtf,RtfTableCell CELL, HTMLElement html,List<TODBC_Array> L_AR)
        {
            cell = RTF_TableCell.Set(rtf,CELL,html);
            if (html.SubDOM.Count > 0)
                for (int i = 0; i < html.SubDOM.Count; i++)
=======
            if (html.ChildDOMElement.Count > 0)
                for (int i = 0; i < html.ChildDOMElement.Count; i++)
>>>>>>> .r483
                {
                    HTMLElement h = html.ChildDOMElement[i];
                    string s = h.TagName;
                    if (s == "p" || s == "span")
                    { RTF_Par p = new RTF_Par(cell, rtf, h); }
                    else if (s == "br")
                    { cell.addParagraph(); }
                    else if (s == "hr")
                    { cell.addParagraph().StartNewPage = true; }
                    else if (s == "table")
                    { RTF_Table tbl = new RTF_Table(rtf, cell, html,L_AR); }
                    else if (s == "img")
                    { RTF_Img img = new RTF_Img(cell, h); }
                    else if (h.innerText != "")
                    { RTF_Par p = new RTF_Par(cell, rtf, h); }
                }
            else if (html.innerText != "") { RTF_Par p = new RTF_Par(cell, rtf, html); }
                //cell.addParagraph().Text = html.innerText; }
        }
    }
    /// <summary>
    /// класс для формирования RTF-таблицы
    /// </summary>
    public class RTF_Table
    {
        /// <summary>
        /// Rtf-таблица
        /// </summary>
        private RtfTable tbl;
        /// <summary>
        /// HTml-таблица
        /// </summary>
        private HTMLTable hTbl;

        private RTF_TableCell AddCells(int i, int j, RtfDocument rtf, HTMLElement h, List<TODBC_Array> L_AR)
        {
            int lX, lY;
            string s = RTFFunc.getParm(h, "colspan");
            if (s == "") { lX = 1; }
            else { lX = int.Parse(s); }
            s = RTFFunc.getParm(h, "rowspan");
            if (s == "") { lY = 1; }
            else { lY = int.Parse(s); }

            if(lY>1 && lX>1){
                for (int i_ = i; i_ < i + lY; i_++)
                {
                    for (int j_ = j; j_ < j + lX; j_++)
                    {
                        RTF_TableCell.Set(rtf, tbl.cell(i_, j_), h);
                    }
                }
            }
            else if (lY > 1)
            {
                for (int i_ = i; i_ < i + lY; i_++)
                {
                        RTF_TableCell.Set(rtf, tbl.cell(i_, j), h);
                }
            }
            else if (lX > 1)
            {
                for (int j_ = j; j_ < j + lX; j_++)
                {
                    RTF_TableCell.Set(rtf, tbl.cell(i, j_), h);
                }
            }

            RtfTableCell bb = tbl.merge(i, j, lY, lX);
            return(new RTF_TableCell(rtf, bb, h, L_AR));
        }

        /// <summary>
        /// создание Rtf-таблици
        /// </summary>
        private void Create(RtfDocument rtf, HTMLElement html, List<TODBC_Array> L_AR)
        {
            RTFFunc.getMargin(tbl.Margins, html.CSS);

            Align a = RTFFunc.getAlign(html.CSS);
            if (a != Align.None)
            { tbl.Alignment = a; }

            string s = RTFFunc.getParm(html, "cellpadding");
            if (s != "")
            { tbl.CellPadding = float.Parse(s); }

            s = RTFFunc.getParm(html, "border");
            if (s == "")
            { s = RTFFunc.getProp(html.CSS, "border-top-width"); }

            BorderStyle brd = RTFFunc.getBorderStyle(html.CSS, "top");

            if (s != "")
            {
                
                ColorDescriptor t = RTFFunc.getBorderColor(rtf, html.CSS);
                tbl.setOuterBorder(brd, float.Parse(s), t);
                tbl.setInnerBorder(brd, float.Parse(s), t);
                /*if (t != null)
                { tbl.setOuterBorder(brd, float.Parse(s), t); }
                else { tbl.setOuterBorder(brd, float.Parse(s)); }*/
            }

            tbl.TitleRowCount = hTbl.FixedRow;


            for (int i = 0; i < hTbl.RowCount; i++)
            {
                int rl = hTbl.RowList[i];
                if (rl > -1)
                {
                    if (L_AR.Count > rl && L_AR[rl].IsSelRecord)
                    {
                        List<HTMLElement> lh = hTbl.Table.GetElementByTagName("field");
                        int res_i = i;
                        TODBC_Array AR_ = L_AR[rl];
                        AR_.First();
                        while (!AR_.EOF())
                        {
                            if (lh.Count > 0) for (int f = 0; f < lh.Count; f++)
                                {
                                    HTMLElement hlh = lh[f];
                                    string slh = RTFFunc.getParm(hlh, "name");

                                    if (slh != "" && AR_.IsField(slh))
                                    { hlh.Params["val"] = AR_.Field_s(slh); }
                                    else hlh.Params["val"] = "";
                                }
                            for (int j = 0; j < hTbl.ColCount; j++)
                            {
                                if (!hTbl.IsJoint(j, res_i) && hTbl.Cell(j, res_i) != null)
                                {
                                    HTMLElement h = hTbl.Cell(j, res_i);
                                    AddCells(i, j, rtf, h, L_AR);
                                }
                            }
                            AR_.Next();
                            i++;
                        }
                    }
                }
                else for (int j = 0; j < hTbl.ColCount; j++)
                        if (!hTbl.IsJoint(j, i) && hTbl.Cell(j, i) != null)
                        {
                            HTMLElement h = hTbl.Cell(j, i);
                            AddCells(i, j, rtf, h, L_AR);
                        }
            }
        }

        private int GetRowCount(List<TODBC_Array> L_AR)
        {
            int result = 0;
            for (int i = 0; i < hTbl.RowList.Count; i++)
            {
                int rl = hTbl.RowList[i];
                if (rl > -1)
                {
                    if (L_AR.Count > rl && L_AR[rl].IsSelRecord)
                        result += L_AR[rl].CountRecord;
                }
                else result++;
            }
            return result;
        }

        /// <summary>
        /// создание класса Rtf-таблици
        /// </summary>
        public RTF_Table(RtfDocument rtf, HTMLElement html, List<TODBC_Array> L_AR)
        {
            hTbl = new HTMLTable(html);
            //tbl = rtf.addTable(hTbl.RowCount, hTbl.ColCount);
            tbl = rtf.addTable(GetRowCount(L_AR), hTbl.ColCount, 0);
            Create(rtf, html,L_AR);
        }
        /// <summary>
        /// создание класса Rtf-таблици
        /// </summary>
        public RTF_Table(RtfDocument rtf,RtfTableCell tb, HTMLElement html,List<TODBC_Array> L_AR)
        {
            hTbl = new HTMLTable(html);
            //tbl = tb.addTable(hTbl.RowCount, hTbl.ColCount,0);
            tbl = tb.addTable(GetRowCount(L_AR), hTbl.ColCount, 0);
            Create(rtf, html,L_AR);
        }
    }

    /// <summary>
    /// класс для формирования RTF-документа из HTML-документа
    /// </summary>
    public class C_RTF
    {
        /// <summary>
        /// не используется, так как класс хранит только статические методы
        /// </summary>
        private C_RTF() { }

        /// <summary>
        /// создание из HTML-текста RTF-документ
        /// </summary>
        /// <param name="str">HTML-текст</param>
        /// <param name="NameFile">имя RTF-файла (путь для сохранения документа)</param>
        /// <param name="PpSz">размер страници (A4, A3)</param>
        /// <param name="PpOr">ориентация страницы (альбомная или книжная)</param>
        /// <param name="Lang">язык документа по умолчанию</param>
        static public C_HTML StrHtmlToRtfFile(string str,string NameFile,List<TODBC_Array> L_AR,PaperSize PpSz,PaperOrientation PpOr,Lcid Lang)
        {
            C_HTML Html = new C_HTML(str);
            if (NameFile != "")
            {
                RtfDocument rtf = new RtfDocument(PpSz, PpOr, Lang);
                
                CSS_Table css = Html.Head.CSS.CSS;
                CSS_Class cssbody = new CSS_Class("body");
                cssbody.CopyFromCss_Class(css.Find("*", ""));
                cssbody.CopyFromCss_Class(css.Find("body", ""));
                cssbody.CopyFromCss_Class(Html.Body.Css);

                RTF_CharFmt body = new RTF_CharFmt(rtf, rtf.DefaultCharFormat, cssbody);
                
                RTF_Par hd, ft;
                if (Html.Head.Foot != null)
                { hd = new RTF_Par(rtf.Footer, rtf, Html.Head.Foot); }
                if (Html.Head.Head != null)
                { ft = new RTF_Par(rtf.Header, rtf, Html.Head.Head); }

                HTMLElement El = Html.Body.DOM;
                if (El.ChildDOMElement.Count > 0)
                    for (int i = 0; i < El.ChildDOMElement.Count; i++)
                    {
                        HTMLElement h = El.ChildDOMElement[i];
                        string s = h.TagName;
                        if (s == "p" || s == "span")
                        { RTF_Par p = new RTF_Par(rtf, h); }
                        else if (s == "br")
                        { rtf.addParagraph(); }
                        else if (s == "hr")
                        { rtf.addParagraph().StartNewPage = true; }
                        else if (s == "table")
                        { RTF_Table tbl = new RTF_Table(rtf, h,L_AR); }
                        else if (s == "img")
                        { RTF_Img img = new RTF_Img(rtf, h); }
                    }
                rtf.save(NameFile);
            }
            return Html;
        }

        /// <summary>
        /// создание из HTML-текста RTF-документ
        /// </summary>
        /// <param name="str">HTML-текст</param>
        /// <param name="NameFile">имя RTF-файла (путь для сохранения документа)</param>
        static public C_HTML StrHtmlToRtfFile(string str, string NameFile)
        { return StrHtmlToRtfFile(str, NameFile, new List<TODBC_Array>(), PaperSize.A4, PaperOrientation.Portrait, Lcid.TraditionalChinese); }
        static public C_HTML StrHtmlToRtfFile(string str, string NameFile, PaperSize PpSz, PaperOrientation PpOr, Lcid Lang)
        { return StrHtmlToRtfFile(str, NameFile, new List<TODBC_Array>(), PpSz, PpOr, Lang); }
        static public C_HTML StrHtmlToRtfFile(string str, string NameFile,List<TODBC_Array> L_AR)
        { return StrHtmlToRtfFile(str, NameFile, L_AR, PaperSize.A4, PaperOrientation.Portrait, Lcid.TraditionalChinese); }
    }
}
