﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CDNModule
{
    /// <summary>
    /// Форма для получения данных.
    /// </summary>
    public enum TArFormNum { PS, VM, ZA }
    /// <summary>
    /// класс который афтоматически запрашивает все данные о указанной форме, указанного предприятия, в указанный период времени
    /// </summary>
    public class TArForm
    {
        /// <summary>
        /// таблица раздела
        /// </summary>
        private TODBC_Array Raz1, Raz2, Raz3;
        //private bool[][] Wr;
        /// <summary>
        /// статический экземпляр класса
        /// </summary>
        private static TArForm itF = new TArForm();
        /// <summary>
        /// создает статический экземпляр
        /// </summary>
        private TArForm() { }
        /// <summary>
        /// значения для определения автоматического изъятия данных при запуске
        /// </summary>
        public static bool AutoRead = false;

        /// <summary>
        /// Возвращает статический экземпляр класса
        /// </summary>
        public static TArForm ItArForm { get { return itF; } }
        /// <summary>
        /// перезапрашивает данные о форме
        /// </summary>
        /// <param name="fr">номер формы</param>
        /// <param name="OKPO">ОКПО предприятия формы</param>
        /// <param name="mm">месяц периода</param>
        /// <param name="year">год периода</param>
        public static TArForm InitForm(TArFormNum fr, string OKPO, int mm, int year)
        {
            switch (fr)
            {
                case TArFormNum.ZA:
                    itF.Raz1 = TODBC.ItOdbc.Execute("Exec spZayav '" +
                        OKPO + "', '1." + mm.ToString() + '.' + year.ToString() + "';"
                        );
                    break;
                case TArFormNum.PS:
                    itF.Raz1 = TODBC.ItOdbc.Execute("Exec spPsRaz1 '" +
                        OKPO + "', '" + year.ToString() + "','" + mm.ToString() + "';"
                        );
                    itF.Raz2 = TODBC.ItOdbc.Execute("Exec spPsRaz2 '" +
                        OKPO + "', '" + year.ToString() + "','" + mm.ToString() + "';"
                        );
                    break;
                case TArFormNum.VM:
                    itF.Raz1 = TODBC.ItOdbc.Execute("Exec spVmRaz1 '" +
                        OKPO + "', '" + year.ToString() + "','" + mm.ToString() + "';"
                        );
                    itF.Raz2 = TODBC.ItOdbc.Execute("Exec spVmRaz2 '" +
                        OKPO + "', '" + year.ToString() + "','" + mm.ToString() + "';"
                        );
                    itF.Raz3 = TODBC.ItOdbc.Execute("Exec spVmRaz3out '" +
                        OKPO + "', '" + year.ToString() + "','" + mm.ToString() + "';"
                        );
                    break;
            }
            return itF;
        }

        /// <summary>
        /// возвращает таблицу первого разддела формы
        /// </summary>
        public TODBC_Array Razdel1 { get { return Raz1; } }
        /// <summary>
        /// возвращает таблицу второго разддела формы
        /// </summary>
        public TODBC_Array Razdel2 { get { return Raz2; } }
        /// <summary>
        /// возвращает таблицу третьего разддела формы
        /// </summary>
        public TODBC_Array Razdel3 { get { return Raz3; } }
    }

    /// <summary>
    /// потомок TextBox-а, для автоматического изъятия информации из загружаемой формы
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:EditForm runat=server AutoRead=\"true\" FieldName=\"\" Razdel=0 NumStr=0></{0}:EditForm>")]
    public class EditForm : TextBox
    {
        /// <summary>
        /// переопределенный метод отрисовки, в котором осуществляется загрузка данных
        /// </summary>
        protected override void Render(HtmlTextWriter writer)
        {
            if (TArForm.AutoRead)
                switch (Razdel)
                {
                    case 1:
                        Text = TArForm.ItArForm.Razdel1.Cells(NumStr, FieldName).ToString();
                        break;
                    case 2:
                        Text = TArForm.ItArForm.Razdel2.Cells(NumStr, FieldName).ToString();
                        break;
                    case 3:
                        Text = TArForm.ItArForm.Razdel3.Cells(NumStr, FieldName).ToString();
                        break;
                }
            base.Render(writer);
        }

        /*[Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Text
        {
            get
            {
                String s = (String)ViewState["Text"];
                return ((s == null) ? String.Empty : s);
            }

            set { ViewState["Text"] = value; }
        }*/

        /// <summary>
        /// имя поля
        /// </summary>
        [Bindable(true)]
        [Category("DataBase")]
        [DefaultValue("")]
        [Localizable(true)]
        public string FieldName
        {
            get
            {
                String s = (String)ViewState["FieldName"];
                return ((s == null) ? String.Empty : s);
            }

            set { ViewState["FieldName"] = value; }
        }

        /// <summary>
        /// номер раздела
        /// </summary>
        [Bindable(true)]
        [Category("DataBase")]
        [DefaultValue("")]
        [Localizable(true)]
        public int Razdel
        {
            get
            {
                object s = ViewState["Razdel"];
                if (s == null)
                { return 0; }
                else
                { return ((int)s); }
            }

            set { ViewState["Razdel"] = value; }
        }

        /// <summary>
        /// номер строки
        /// </summary>
        [Bindable(true)]
        [Category("DataBase")]
        [DefaultValue("")]
        [Localizable(true)]
        public int NumStr
        {
            get
            {
                object s = ViewState["NumStr"];
                if (s == null)
                { return 0; }
                else
                { return ((int)s); }
            }

            set { ViewState["NumStr"] = value; }
        }

    }
}
