﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CDNModule
{      

    

    /// <summary>
    /// Контролл авторизации/выхода пользователя
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:LoginForm runat=server></{0}:LoginForm>")]
    public class LoginForm : CompositeControl//WebControl
    {
        //[Category("")]
        /// <summary>
        /// событие срабатывающее при нажатии на кнопку Входа/Выхода
        /// </summary>
        public event EventHandler Click;

        /// <summary>
        /// Контрол ввода пароля
        /// </summary>
        protected TextBox _Login, _Passw;
        /// <summary>
        /// Кнопка Входа/выхода
        /// </summary>
        protected Button _ret;

        /// <summary>
        /// хранит значение "вошел ли пользователь"
        /// </summary>
        protected bool _login = false;
//        protected Random RND = new Random();

        /// <summary>
        /// Возвращает "True", если Авторизация прошла успешно
        /// </summary>
        public bool LogIn { get { return (_login); } }

        /// <summary>
        /// запуст события нажатия кнопки входа
        /// </summary>
        /// <param name="sender">обьект вызывающий событие</param>
        /// <param name="e">передаваемые данные события</param>
        public void OnClick(object sender, EventArgs e)
        {   
            TODBC ODBC;
            TODBC_Array AR;
            ODBC = TODBC.ItOdbc;
            //ODBC.Conected = true;
            _Login.Text = _Login.Text.Replace('\'', ' ').Replace('\\', ' ');
            AR = ODBC.Execute("Select idPer,PersonLogin,PersonPassword From tuPerson Where PersonLogin = '"+
                              _Login.Text+"';");
            //ODBC.Conected = false;
            if (AR.CountRecord > 0)
                _login = (AR.Cells(0, 2).ToString().Trim() == _Passw.Text);
            else _login = false;
            if (_login)
            {
                TUser.InitUser((int)AR.Cells(0, 0),
                               Page.Request,
                               Page.Session);
                creates(true);
            }
            if (Click != null)
                Click(sender, e);
        }
        /// <summary>
        /// запуст события нажатия кнопки выхода
        /// </summary>
        /// <param name="sender">обьект вызывающий событие</param>
        /// <param name="e">передаваемые данные события</param>
        public void OnClickOut(object sender, EventArgs e)
        {
            TUser.DoneUser(Page.Session);
            creates(false);
            if (Click != null)
                Click(sender, e);
        }

        //public LoginForm(): base(HtmlTextWriterTag.Div)

        public override void RenderBeginTag(HtmlTextWriter writer)
        {
            this.AddAttributesToRender(writer);
            //base.RenderBeginTag(writer);
            writer.RenderBeginTag(HtmlTextWriterTag.Fieldset);
        }

        /// <summary>
        /// создание и определение контрола
        /// </summary>
        private void creates(bool bl)
        {
            //TUser.InitUser(Page.Session);
            if (bl)
            {
                TUser.InitUser(Page.Session);
                bl = TUser.ItUser.LogIn;
            }
            _login = bl;
            if (_login)
            {
                _ret.Click -= OnClick;
                _ret.Text = "Выход";
                _ret.Click += new EventHandler(OnClickOut);
            }
            else
            {
                _ret.Click -= OnClickOut; 
                _ret.Text = "Вход";
                _ret.Click += new EventHandler(OnClick);
            }
        }
        protected override void CreateChildControls()        
        {
            _Login = new TextBox();
            _Login.Text = "";
            //_Login.Attributes.Add("Width", "90%");
            Controls.Add(_Login);

            _Passw = new TextBox();
            _Passw.TextMode = TextBoxMode.Password;
            _Passw.Text = "";
            //_Passw.Attributes.Add("Width", "");
            Controls.Add(_Passw);

            _ret = new Button();
            Controls.Add(_ret);

            try
            { creates(Page.Session["UID"] != null); }
            catch
            { creates(false); }

            this.Style.Add(HtmlTextWriterStyle.VerticalAlign, "center");
            this.Style.Add(HtmlTextWriterStyle.TextAlign, "center");
        }

        /// <summary>
        /// заголовочный текст, отображающийся вверху над полями ввода.
        /// </summary>
        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Text
        {
            get
            {
                String s = (String)ViewState["Text"];
                return ((s == null) ? String.Empty : s);
            }

            set { ViewState["Text"] = value; }
        }
        
        protected override void RenderContents(HtmlTextWriter output)
        {
         //   output.RenderBeginTag(HtmlTextWriterTag.Div);
            //creates(_login);
            output.Write("<Legend align=\"center\">");
            output.Write(Text);
            output.Write("</Legend>");
            if (_login)
            {
                TUser usr = TUser.ItUser;
                string s;
                if (usr == null)
                { s = "ERROR: Пользователь не создан"; }
                else
                {
                    s = @"
<style>
   table.loginform tr>td {text-align:right;padding-right:3;}
   table.loginform td+td{text-align:left;padding-left:3;}
</style>
<center><Table class='loginform' border=0 RULES='none'>
<tr><td>Имя:</td><td>" + usr.FIO.Name + @"</td></tr>
<tr><td>Фамилия:</td><td>" + usr.FIO.Famely + @"</td></tr>
<tr><td>Отчество:</td><td>" + usr.FIO.Otchestvo + @"</td></tr>
<tr><td>Должность:</td><td>" + usr.UserDolz + @"</td></tr>
<tr><td>Предприятие:</td><td>" + usr.Pred.Info("NAME_PT_PS") + @"</td></tr>
</Table></center>";
                }
                output.Write(s);
                _ret.RenderControl(output);
                //output.Write("<br>");
            }
            else
            {
                //output.Write(Text);
                output.Write("<br>Логин: <br>");
                _Login.RenderControl(output);
                output.Write("<br><br>Пароль: <br>");
                _Passw.RenderControl(output);
                output.Write("<br><br>");
                _ret.RenderControl(output);
                output.Write("<br>");
            }
           // output.RenderEndTag();
        }
    }  

}
