﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CDNModule
{
    /// <summary>
    /// Создает скрытый IFrame, который будет служить проводником для Ajax-скриптов
    /// </summary>
    [DefaultProperty("NameAjax")]
    [ToolboxData("<{0}:TAJAX runat=server NameAjax=\"NoName\"></{0}:TAJAX>")]
    public class TAJAX : WebControl
    {
        /// <summary>
        /// Имя IFrame-а, для его поиска через JavaScript
        /// </summary>
        [Bindable(true)]
        [Category("AJAX")]
        [DefaultValue("")]
        [Localizable(true)]
        public string NameAjax
        {
            get
            {
                String s = (String)ViewState["NameAjax"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["NameAjax"] = value;
            }
        }

        /// <summary>
        /// адрес страницы которую следует запустить сразу после формирования страницы
        /// </summary>
        [Bindable(true)]
        [Category("AJAX")]
        [DefaultValue("")]
        [Localizable(true)]
        public string DefaultUrl
        {
            get
            {
                String s = (String)ViewState["DefaultUrl"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["DefaultUrl"] = value;
            }
        }


        public override void RenderBeginTag(HtmlTextWriter writer)
        {
            this.AddAttributesToRender(writer);
            //base.RenderBeginTag(writer);
            //writer.RenderBeginTag(HtmlTextWriterTag.Q);
            writer.RenderBeginTag("k");
        }

        /// <summary>
        /// Создает функцию "AjaxRun(url)" на JavaScript-е для отправки AJAX-запроса. Где "url" это адрес запроса.
        /// </summary>
        public string ScriptFunctionRun()
        { return ("<script>function AjaxRun(url){" + NameAjax + ".location = url;}</script>"); }
        /// <summary>
        /// Создает функцию "AjaxRunDef()" на JavaScript-е для отправки AJAX-запроса. Такую функцию актуально создавать, когда используется только 1 адрес для обработки AJAX-запроса.
        /// </summary>
        /// <param name="defUrl">Адресс запроса по умолчанию</param>
        public string ScriptFunctionRun(string defUrl)
        { return ("<script>function AjaxRunDef(){" + NameAjax + ".location = '" + defUrl + "';}</script>"); }
        /// <summary>
        /// возвращает JavaScript-строку функции "AjaxRun(Url)". Где вместо "url" вставляется указанный параметр.
        /// </summary>
        /// <param name="url">адрес AJAX-скрипта</param>
        public string ScriptRunName(string url)
        { return ("AjaxRun(" + url + ")"); }
        /// <summary>
        /// возвращает JavaScript-строку функции "AjaxRunDef()".
        /// </summary>
        public string ScriptRunName()
        { return ("AjaxRunDef()"); }
        /// <summary>
        /// возвращает запускаемую JavaScript-строку функции "AjaxRun(Url)". Где вместо "url" вставляется указанный параметр.
        /// </summary>
        /// <param name="url">адрес AJAX-скрипта</param>
        public string ScriptRun(string url)
        { return ("<script>" + ScriptRunName(url) + ";</script>"); }
        /// <summary>
        /// возвращает запускаемую JavaScript-строку функции "AjaxRunDef()".
        /// </summary>
        public string ScriptRun()
        { return ("<script>" + ScriptRunName() + ";</script>"); }

        /// <summary>
        /// возвращает строку для внедрения ее в нутрь тегов, текст которой будет сообщать тегу, что запрос следует отправлять внутрь IFrame-а. (для тегов "a", "Form" и т.д.)
        /// </summary>
        public string Target()
        { return (" target='"+NameAjax+"' "); }

        protected override void RenderContents(HtmlTextWriter output)
        {
            if (NameAjax == "") NameAjax = "NoName";
            output.Write("<iframe name=\"" + NameAjax + "\" src=\"" + DefaultUrl + "\" style=\"width:1px;height:1px;display:none;\"></iframe>");
        }
    }

    /// <summary>
    /// Создает элемент на строници которым можно управлять через TAJAX
    /// </summary>
    [DefaultProperty("NameVar")]
    [ToolboxData("<{0}:TAJAX_Var runat=server NameVar=\"VarNoName\"></{0}:TAJAX_Var>")]
    public class TAJAX_Var : Label
    {
        /// <summary>
        /// Имя переменной
        /// </summary>
        [Bindable(true)]
        [Category("AJAX")]
        [DefaultValue("")]
        [Localizable(true)]
        public string NameVar
        {
            get
            {
                String s = (String)ViewState["NameVar"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["NameVar"] = value;
            }
        }

        /// <summary>
        /// начальное значение переменной
        /// </summary>
        [Bindable(true)]
        [Category("AJAX")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Value
        {
            get
            {
                String s = (String)ViewState["Value"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["Value"] = value;
            }
        }

        /// <summary>
        /// Возвращает строку для JavaScript-а, в которой описывается скрипт получения значения из этой переменной
        /// </summary>
        public string ScriptValue()
        { return ("document.getElementById('" + NameVar + "').innerHTML"); }
        /// <summary>
        /// Возвращает строку для JavaScript-а, в которой описывается скрипт получения значения из этой переменной
        /// </summary>
        /// <param name="type">начальный тип преобразования</param>
        public string ScriptValue(string type)
        { return (type + '(' + ScriptValue() + ')'); }
        /// <summary>
        /// Возвращает строку для JavaScript-а, в которой описывается скрипт получения значения из этой переменной
        /// </summary>
        /// <param name="type">Тип, в который следует преобразовать значение переменной</param>
        public string ScriptValue(AJAX_Var_Type type)
        {
            string s = ScriptValue();
            switch (type)
            {
                case AJAX_Var_Type.Integer:
                    s = "parseInt(" + s + ")";
                    break;
                case AJAX_Var_Type.Float:
                    s = "parseFloat(" + s + ")";
                    break;
                case AJAX_Var_Type.Boolean:
                    s = "(" + s + " == 'true')";
                    break;
                case AJAX_Var_Type.intBoolean:
                    s = "Boolean(parseInt(" + s + "))";
                    break;
            }
            return (s);
        }

        protected override void RenderContents(HtmlTextWriter output)
        {
            if (NameVar == "") NameVar = "VarNoName";
            output.Write("<div id=\"" + NameVar + "\">"+Value+"</div>");
        }
    }


    public enum AJAX_Var_Type
    {
        String,
        Integer,
        Float,
        Boolean,
        intBoolean
    }

    public class HAJAX_Var
    {
        /// <summary>
        /// хранит имя переменной
        /// </summary>
        private string nmVar = "VarNoName";
        /// <summary>
        /// Имя AJAX-переменной, которая может быть изменена скриптом
        /// </summary>
        public string NameVar 
        {
            get { return nmVar; }
            set { nmVar = value; }
        }
        /// <summary>
        /// "true"- означает, что переменная находиться в верхнем окне (скрипт выполняется в IFrame-е, т.е. является AJAX-скриптом), в противном случае, переменная находится в данном документе.
        /// </summary>
        public bool Parent = true;
        //public AJAX_Var_Type Type = AJAX_Var_Type.String;

        /// <summary>
        /// Возвращает строку предназначенной для JavaScript, для получения доступа к значению AJAX-переменной
        /// </summary>
        public string ScriptValue()
        { return (((Parent) ? "parent." : "") + "document.getElementById('" + nmVar + "').innerHTML"); }
        /// <summary>
        /// Возвращает строку предназначенной для JavaScript, для получения доступа к значению AJAX-переменной. Эта функция используется только для чтения.
        /// </summary>
        /// <param name="type">тип в который требуется преобразовать переменную</param>
        public string ScriptValue(AJAX_Var_Type type)
        {
            string s = ScriptValue();
            switch (type)
            {
                case AJAX_Var_Type.Integer:
                    s = "parseInt(" + s + ")";
                    break;
                case AJAX_Var_Type.Float:
                    s = "parseFloat(" + s + ")";
                    break;
                case AJAX_Var_Type.Boolean:
                    s = "(" + s + " == 'true')";
                    break;
                case AJAX_Var_Type.intBoolean:
                    s = "Boolean(parseInt(" + s + "))";
                    break;
            }
            return (s); 
        }
        /// <summary>
        /// Изменить значение AJAX-переменной. (возвращает запускаемый JavaScript-код)
        /// </summary>
        public string ScriptSet(object Value,string ravno)
        {
            if(ravno == "") ravno = "=";
            return ("<script>" + ScriptValue() + ' ' + ravno + " '" + Value.ToString() + "';</script>");
        }
        /// <summary>
        /// создает класс доступа к AJAX-переменной
        /// </summary>
        /// <param name="Name">имя AJAX-переменной</param>
        public HAJAX_Var(string Name) { nmVar = Name; }
    }

    public class StringJavaScript
    {
        public static string Ravno = "=";

        public static string WriteS(string s)
        { return ("document.write('" + s + "');"); }
        public static string Write(string str)
        { return ("document.write(" + str + ");"); }
        public static string WriteLnS(string s)
        { return ("document.writeln('" + s + "');"); }
        public static string WriteLn(string str)
        { return ("document.writeln(" + str + ");"); }
        public static string pWriteS(string s)
        { return ("parent.document.write('" + s + "');"); }
        public static string pWrite(string str)
        { return ("parent.document.write('" + str + "');"); }
        public static string pWriteLnS(string s)
        { return ("parent.document.writeln('" + s + "');"); }
        public static string pWriteLn(string str)
        { return ("parent.document.writeln('" + str + "');"); }

        public static string SetVar(string Var, string Value)
        { return (Var + ' ' + Ravno + " '" + Value + "';"); }
        public static string SetVar(string Var, object Value)
        { return (Var + ' ' + Ravno + ' ' + Value.ToString() + ';'); }
        public static string SetVar(HAJAX_Var Var, string Value)
        { return (Var.ScriptValue() + ' ' + Ravno + " '" + Value + "';"); }
        public static string SetVar(HAJAX_Var Var, object Value)
        { return (Var.ScriptValue() + ' ' + Ravno + ' ' + Value.ToString() + ';'); }
        public static string SetVar(HAJAX_Var Var, HAJAX_Var Var2)
        { return (Var.ScriptValue() + ' ' + Ravno + ' ' + Var2.ScriptValue() + ';'); }
        public static string SetVar(HAJAX_Var Var, HAJAX_Var Var2,AJAX_Var_Type AVT)
        { return (Var.ScriptValue() + ' ' + Ravno + ' ' + Var2.ScriptValue(AVT) + ';'); }
        public static string SetVars(HAJAX_Var Var, string Var2)
        { return (Var.ScriptValue() + ' ' + Ravno + ' ' + Var2 + ';'); }
        public static string SetVar(string Var, HAJAX_Var Var2)
        { return (Var + ' ' + Ravno + ' ' + Var2.ScriptValue() + ';'); }
        public static string SetVar(string Var, HAJAX_Var Var2,AJAX_Var_Type AVT)
        { return (Var + ' ' + Ravno + ' ' + Var2.ScriptValue(AVT) + ';'); }
        public static string SetVars(string Var, string Var2)
        { return (Var + ' ' + Ravno + ' ' + Var2 + ';'); }

        public static string random()
        { return "Math.random()"; }
        public static string random(int mul)
        { return ("Math.floor(Math.random()*" + mul.ToString() + ')'); }

        public static string GetId(string id)
        { return ("document.getElementById('" + id + "')"); }
        public static string GetIdS(string id)
        { return (GetId(id) + ".innerHTML"); }
        public static string pGetId(string id)
        { return ("parent." + GetId(id)); }
        public static string pGetIdS(string id)
        { return (pGetId(id) + ".innerHTML"); }

        public static string EkrStr(string str)
        { return (str.Replace("\"", "\\\"").Replace("'", "\\'")); }
    }

    /// <summary>
    /// Класс для формирования JavaScript-кода
    /// </summary>
    [DefaultProperty("")]
    [ToolboxData("<{0}:JavaScript runat=server></{0}:JavaScript>")]
    public class JavaScript : WebControl
    {
        /// <summary>
        /// лист JavaScript-вставок
        /// </summary>
        private List<string> JS = new List<string>();
        /// <summary>
        /// количество вставок
        /// </summary>
        private int ct = 0;
        /// <summary>
        /// Возвращает лист с JavaScript-вставками
        /// </summary>
        public List<string> GetList { get { return JS; } }
        /// <summary>
        /// возвращает кол-во созданных вставок
        /// </summary>
        public int Count { get { return ct; } }

        /// <summary>
        /// добавить строку в последнюю вставку
        /// </summary>
        /// <param name="Str">JavaScript-текст</param>
        public void Add(string Str)
        {
            if (JS.Count > 0)
                JS[ct] += Str+'\n';
        }
        /// <summary>
        /// Добавить новую JavaScript-вставку
        /// </summary>
        /// <param name="Str">JavaScript-текст</param>
        public void Append(string Str)
        {
            JS.Add(Str);
            ct++;
        }

        protected override void RenderContents(HtmlTextWriter output)
        {
            if (JS.Count > 0)
                for (int i = 0; i < JS.Count; i++)
                { output.Write("<script>" + JS[i] + "</script>"); }
        }
    }
}
