﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDNModule
{
    /// <summary>
    /// Класс хранящий ФИО пользователя
    /// </summary>
    public class TFIO
    {
        /// <summary>
        /// Имя
        /// </summary>
        public string Name
        {
            get;
            protected set;
        }
        /// <summary>
        /// Фамилия
        /// </summary>
        public string Famely
        {
            get;
            protected set;
        }
        /// <summary>
        /// Отчество
        /// </summary>
        public string Otchestvo
        {
            get;
            protected set;
        }

        /// <summary>
        /// Создание класса без блокирования изменения данных
        /// </summary>
        public TFIO() { }
        /// <summary>
        /// Создания класса с блокирование изменения данных
        /// </summary>
        /// <param name="name">Имя</param>
        /// <param name="famely">Фамилия</param>
        /// <param name="otch">Отчество</param>
        public TFIO(string name, string famely, string otch)
        {
            Name = name;
            Famely = famely;
            Otchestvo = otch;
        }

        /// <summary>
        /// Возвращает "Фамилия И.О."
        /// </summary>
        public string FamelyNO()
        {
            return (Famely + ' ' + Name[0] + '.' + Otchestvo[0] + '.');
        }
        /// <summary>
        /// возвращает "Фамилия Имя"
        /// </summary>
        public string FamelyN()
        {
            return (Famely + ' ' + Name);
        }
        /// <summary>
        /// Возвращает "Имя Отчество"
        /// </summary>
        public string NameO()
        {
            return (Name + ' ' + Otchestvo);
        }
    }

}
