﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDNModule
{
    /// <summary>
    /// Статический класс хранящий в себе сведения о всех формах, создается только 1 раз
    /// </summary>
    public class TFormNum
    {
        /// <summary>
        /// полученная таблица форм
        /// </summary>
        private TODBC_Array AR;
        /// <summary>
        /// статический класс в одном экземпляре
        /// </summary>
        private static TFormNum _FN = null;
        /// <summary>
        /// Загружает информацию о формах
        /// </summary>
        private TFormNum()
        { AR = TODBC.ItOdbc.Execute("Select * from tuFrmAcc;"); }
        /// <summary>
        /// возвращает единственный экземпляр формы
        /// </summary>
        public static TFormNum ItFormNum
        {
            get
            {
                if (_FN == null)
                    _FN = new TFormNum();
                return _FN;
            }
        }

        /// <summary>
        /// возвращает кол-во существующих форм
        /// </summary>
        public int Count { get { return AR.CountRecord; } }
        /// <summary>
        /// возвращает маску формы по ее номеру
        /// </summary>
        /// <param name="row">номер формы</param>
        public int Mask(int row)
        { return (int)AR.Cells(row, "Mask"); }
        /// <summary>
        /// возвращает маску формы по ее имени или коду
        /// </summary>
        /// <param name="name">имя/код формы</param>
        /// <param name="kod">"true", если искать нужно по коду</param>
        public int Mask(string name, bool kod)
        {
            AR.First();
            string k = ((kod) ? "KodForm" : "NameForm");
            while (!AR.EOF())
            {
                if (AR.Field(k).ToString() == name)
                    return (int)AR.Cells(AR.Position, "Mask");
                AR.Next();
            }
            return -1;
        }
        /// <summary>
        /// фозвращает имя формы
        /// </summary>
        /// <param name="row">номер формы</param>
        public string Name(int row)
        { return AR.Cells(row, "NameForm").ToString(); }
        /// <summary>
        /// код формы
        /// </summary>
        /// <param name="row">номер формы</param>
        public string Kod(int row)
        { return AR.Cells(row, "KodForm").ToString(); }
        /// <summary>
        /// возвращает номер формы по ее имени или коду
        /// </summary>
        /// <param name="name">имя/код формы</param>
        /// <param name="kod">"true", если требуется искать по коду</param>
        public int RowForm(string name, bool kod)
        {
            AR.First();
            string k = ((kod) ? "KodForm" : "NameForm");
            while (!AR.EOF())
            {
                if (AR.Field(k).ToString() == name)
                    return AR.Position;
                AR.Next();
            }
            return -1;
        }
        /// <summary>
        /// возвращает номер формы по ее маске
        /// </summary>
        /// <param name="Mask">маска формы</param>
        public int RowForm(int Mask)
        {
            AR.First();
            while (!AR.EOF())
            {
                if ((int)AR.Field("Mask") == Mask)
                    return AR.Position;
                AR.Next();
            }
            return -1;
        }
        /// <summary>
        /// путь к картинке формы
        /// </summary>
        /// <param name="row">номер формы</param>
        public string ImgPath(int row)
        { return AR.Cells(row, "ImagePath").ToString(); }
        /// <summary>
        /// ссылка на страницу формы
        /// </summary>
        /// <param name="row">номер формы</param>
        public string Link(int row)
        { return AR.Cells(row, "Link").ToString(); }
        /// <summary>
        /// возвращает описание формы
        /// </summary>
        /// <param name="row">номер формы</param>
        public string Description(int row)
        { return AR.Cells(row, "Description").ToString(); }
    }

}
