﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDNModule
{
    /// <summary>
    /// Класс хронящий информацию о группе пользователя,
    /// и о его правах
    /// </summary>
    public class TGroup
    {
        /// <summary>
        /// идентификатор группы
        /// </summary>
        private int id;
        /// <summary>
        /// Наименование группы
        /// </summary>
        private string groupName;
        /// <summary>
        /// Примечание группы
        /// </summary>    
        private string note;
        /// <summary>
        /// битовый массив на разрешения действий
        /// </summary>
        private int readBit, writeBit, logsBit, othBit;
        /// <summary>
        /// хранит состояние уровня просмотра ('true' - можно просматривать сведения о всех предприятиях, иначе только того, под которым зашли)
        /// </summary>
        private bool isOtrasl;

        /// <summary>
        /// получение информации о группе
        /// </summary>
        /// <param name="Id">номер группы</param>
        public TGroup(int Id)
        {
            id = Id;
            TODBC_Array queryResult = TODBC.ItOdbc.Execute(
                "Select * from tuGrpUsers where idGrp = '" +
                Id.ToString() + "';");
            if (queryResult.IsSelRecord)
            {
                groupName = queryResult.Field("NameGrp").ToString();
                note = queryResult.Field("NoteGrp").ToString();
                readBit = (int)queryResult.Field("isRead");
                writeBit = (int)queryResult.Field("isWrite");
                logsBit = (int)queryResult.Field("logs");
                othBit = (int)queryResult.Field("otch");
                isOtrasl = (bool)queryResult.Field("Otrasl");
            }
        }

        /// <summary>
        /// возвращает название группы
        /// </summary>
        public string Name { get { return groupName; } }
        /// <summary>
        /// Возвращает строку примечания круппы
        /// </summary>
        public string Primich { get { return note; } }
        /// <summary>
        /// возвращает состояние бита, опрдляющий доступность соответственной формы для просмотра ее пользователю
        /// </summary>
        /// <param name="num">номер бита</param>
        public bool Read(int num) 
        { 
            return (((readBit >> num) & 1) > 0); 
        }
        /// <summary>
        /// возвращает состояние бита, опрдляющий доступность соответственной формы для изменения ее пользователем
        /// </summary>
        /// <param name="num">номер бита</param>
        public bool Write(int num) 
        { 
            return (((writeBit >> num) & 1) > 0); 
        }
        /// <summary>
        /// возвращает состояние бита, опрдляющий доступность соответственной формы для просмотра ее логов пользователю
        /// </summary>
        /// <param name="num">номер бита</param>
        public bool Logs(int num) { return (((logsBit >> num) & 1) > 0); }
        /// <summary>
        /// возвращает состояние бита, опрдляющий доступность соответственной формы для просмотра отчетов по ней пользователю
        /// </summary>
        /// <param name="num">номер бита</param>
        public bool Otchet(int num) { return (((othBit >> num) & 1) > 0); }
        /// <summary>
        /// Возвращает "true", если данный пользователь имеет права смотреть все предприятия
        /// </summary>
        public bool Otrasl { get { return isOtrasl; } }

        /// <summary>
        /// возвращает состояние битов, опрдляющих доступность соответственной формы для просмотра ее пользователю
        /// </summary>
        /// <param name="Mask">маска битов</param>
        public bool ReadMask(int Mask) { return ((readBit & Mask) > 0); }
        /// <summary>
        /// возвращает состояние битов, опрдляющих доступность соответственной формы для изменения ее пользователем
        /// </summary>
        /// <param name="Mask">маска битов</param>
        public bool WriteMask(int Mask) { return ((writeBit & Mask) > 0); }
        /// <summary>
        /// возвращает состояние битов, опрдляющих доступность соответственной формы для просмотра ее логов пользователю
        /// </summary>
        /// <param name="Mask">маска битов</param>
        public bool LogsMask(int Mask) { return ((logsBit & Mask) > 0); }
        /// <summary>
        /// возвращает состояние битов, опрдляющих доступность соответственной формы для просмотра отчетов по ней пользователю
        /// </summary>
        /// <param name="Mask">маска битов</param>
        public bool OtchetMask(int Mask) { return ((othBit & Mask) > 0); }
    }

}
