﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;

namespace CDNModule
{
    /// <summary>
    /// Делегат для итератора прохода по всем строкам,
    /// полученными при запросе 'Select' или загрузки DBF-файла, в классе TODBC_Array
    /// </summary>
    /// <param name="row">Передает номер строки</param>
    /// <param name="obj">Передает массив значений строки</param>
    public delegate void TODBCArrayEachRow(int row, object[] obj);
    /// <summary>
    /// Делегат для итератора прохода по всей строке,
    /// в классе TODBC_Array. Строка зависит от функций:
    /// First, Last, Next, Prior, Position
    /// </summary>
    /// <param name="Name">Передает имя поля</param>
    /// <param name="value">Передает значение поля</param>
    public delegate void TODBCArrayEachCol(string Name, object value);
    /// <summary>
    /// Делегат для итератора прохода по всем строкам и полям,
    /// в классе TODBC_Array.
    /// </summary>
    /// <param name="row">Передает номер строки</param>
    /// <param name="Name">Передает имя поля</param>
    /// <param name="value">Передает значение поля</param>
    public delegate void TODBCArrayEachRowCol(int row, string Name, object value);

    /// <summary>
    /// Способ отсеивания для фильтра в классе TODBC_Array
    /// </summary>
    public enum SelectAr
    {
        /// <summary>
        /// Поиск слова целиком (отсеины будут только те строки, значения по полям которой будут полностью соответствовать искомому значению).
        /// </summary>
        Equ,
        /// <summary>
        /// Поиск слова находящегося в начаале значения (будут отсеиваться те строки начало значений по полям которых будут совподать с искомыми)
        /// </summary>
        Left,
        /// <summary>
        /// Поиск слова находящегося в конце значения (будут отсеиваться те строки конец значений по полям которых будут совподать с искомыми)
        /// </summary>
        Right,
        /// <summary>
        /// Поиск слова находящегося в середине значения (будут отсеиваться те строки  значений по полям которых будут совподать с искомыми, при этом не находиться в начале и в конце значения)
        /// </summary>
        Center,
        /// <summary>
        /// Используются все способы поиска срозу (т.е. отсеиваться будут те строки в которых часть или значение целиком по полям будут соответствовать искомому)
        /// </summary>
        All
    }
    ////////////////////////////////////////////////////////

   
    /// <summary>
    /// Класс подключения и работой с драйвером ODBC
    /// </summary>
    public class TODBC
    {
        /// <summary>
        /// хранит строку конфигурации подклюцения
        /// </summary>
        private string _connString;
        /// <summary>
        /// хранит статический класс TODBC, других таких классов создать нельзя
        /// </summary>
        private static TODBC itOdbc = null;

        /// <summary>
        /// Возвращает указатель на статический класс ODBC
        /// </summary>
        public static TODBC ItOdbc { get { return itOdbc; } }

        /// <summary>
        /// масив хранящий разпитые пары параметров для подключения
        /// </summary>
        private Dictionary<string, string> d;
        /// <summary>
        /// класс для осуществления подключения
        /// </summary>
        private SqlConnection conn;
        /// <summary>
        /// класс для выполнения SQL-запроса
        /// </summary>
        private SqlCommand comm;
        /// <summary>
        /// хранит состояние ощибки
        /// </summary>
        private string _Err = "";

        public TODBC()
        {
            d = new Dictionary<string, string>();
            _connString = "";
            itOdbc = this;
        }

        /// <summary>
        /// Позволяет задать строку подключения
        /// </summary>
        public string StringConnect
        {
            get
            {
                ParamJoin();
                return (_connString);
            }
            set
            {
                string[] a;
                _connString = value;
                foreach (string s in _connString.Split(';'))
                {
                    a = s.Split('=');
                    d[a[0]] = a[1];
                }
            }
        }

        /// <summary>
        /// функция обьединяющая звенья строки подключения во едино для осуществления самого подключения
        /// </summary>
        private void ParamJoin()
        {
            string _s = "";
            foreach (string s in d.Keys)
            {
                _s += s + '=' + d[s] + ';';
            }
            _connString = _s;
        }

        /// <summary>
        /// Позволяет частично изменять строку подключения
        /// </summary>
        public Dictionary<string, string> Param { get { return d; } }

        /// <summary>
        /// Возвращает true, если была ошибка
        /// </summary>
        public bool IsError { get { return (_Err != ""); } }
        /// <summary>
        /// Возвращает строку ошибки или пустую строку,
        /// в случае если ошибки не было
        /// </summary>
        public string ErrorStr { get { return _Err; } }

        /*
        /// <summary>
        /// подключается (true) или отключается (false) от драйвера ODBC,
        /// а так же позволяет получить состояние подключения
        /// </summary>
        public bool Conected
        {
            get { return (conn != null && conn.State != ConnectionState.Closed); }
            set
            {
                //lock (this)
                //{
                    if (value) // true or false
                    {
                        ParamJoin();
                        conn = new SqlConnection();
                        comm.Connection = conn;
                        conn.ConnectionString = _connString;
                        try { conn.Open(); }
                        catch (SqlException ee)
                        { _Err = ee.Message; }
                    }
                    else
                    {
                        try
                        { conn.Close(); }
                        catch (SqlException ee)
                        { _Err = ee.Message; }
                    }
                //}
            }
        }
         */
        /// <summary>
        /// Выполняет SQL запрос и возвращает класс результата (TODBC_Array)
        /// </summary>
        /// <param name="SQL">Строка запроса</param>
        /// <returns>Возвращает класс результата (TODBC_Array)</returns>
        public TODBC_Array Execute(string SQL)
        {
            //bool resconn = Conected;
            //Conected = true;
            ParamJoin();
            SqlConnection conn_ = new SqlConnection(_connString);
            SqlCommand comm_ = new SqlCommand();
            comm_.Connection = conn_;
            //conn.ConnectionString = _connString;
            try { conn_.Open(); }
            catch (SqlException ee)
            { _Err = ee.Message; }
            bool _isS;//=true;
            TODBC_Array AR;
            comm_.CommandText = SQL;
            string ss = SQL.ToUpper();
            _isS = (ss.IndexOf("SELECT") >= 0) || (ss.IndexOf("EXEC") >= 0);

            try
            {
                if (_isS)
                { AR = new TODBC_Array(comm_.ExecuteReader()); }
                else
                { AR = new TODBC_Array(comm_.ExecuteNonQuery()); }
            }
            catch (SqlException ee)
            { AR = null; }
            //Conected = resconn;
            //Conected = false;
            try
            { conn_.Close(); }
            catch (SqlException ee)
            { _Err = ee.Message; }
            return AR;
        }
    }

}
