﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDNModule
{
    /// <summary>
    /// класс хранищий сведения о предприятии
    /// </summary>
    public class TPred
    {
        /// <summary>
        /// хранит строку с данными о предприятии
        /// </summary>
        private TODBC_Array AR;
        
        /// <summary>
        /// загружает данные об указанном предприятии
        /// </summary>
        /// <param name="okpo">ОКПО предприятия</param>
        public TPred(string okpo)
        {
            AR = TODBC.ItOdbc.Execute(
                "Select * from tsPred where OKPO = '" +
                okpo + "';");
        }

        /// <summary>
        /// Возвращает информацию о предприятию по указанному полю
        /// </summary>
        /// <param name="Field">имя поля из которово следует извлеч данные</param>
        public string Info(string Field)
        { return AR.Field_s(Field); }
    }

}
