﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web;

namespace CDNModule
{
    /// <summary>
    /// Класс хронящий всю информацию о пользователе
    /// </summary>
    public class TUser
    {
        //private int id = -1;
        /// <summary>
        /// </summary>
        private string _Login, _e_mail, _Dolz, _pred;
        /// <summary>
        /// класс хранящий ФИО пользователя
        /// </summary>
        private TFIO _FIO;
        /// <summary>
        /// Класс группы в которую входит пользователь
        /// </summary>
        private TGroup _Group;
        /// <summary>
        /// класс предприятия к которому относится пользователь
        /// </summary>
        private TPred _Pred;
        /// <summary>
        /// дата пользователя
        /// </summary>
        private DateTime _dtRg, _dtDl;
        /// <summary>
        /// удален ли пользователь
        /// </summary>
        private bool _del;
        /// <summary>
        /// осуществил ли пользоватль вход в систему
        /// </summary>
        private bool Login_ = false;

        /// <summary>
        /// статический класс пользователя, который просматривает страницу
        /// </summary>
        private static TUser _user = null;

        /// <summary>
        /// производит вход пользователя (авторизацию)
        /// </summary>
        /// <param name="id">id-пользователя</param>
        /// <param name="HTTP">HTTP-заголовок запроса, для анализа попытки входа/выхода</param>
        /// <param name="Session">сессия для внесения изменения</param>
        public static TUser InitUser(int id, HttpRequest HTTP, HttpSessionState Session)
        {
            //object obj = Session["IP"];            
            //if (obj != null && obj.ToString() != HTTP.UserHostAddress)
            //{
            Session.Timeout = 60;
            Session["UID"] = id;
            Session["IP"] = HTTP.UserHostAddress;
            _user = new TUser(id, HTTP.UserHostAddress, Session.SessionID);
            //}
            //else { _user = null; }

            return _user;
        }
        /// <summary>
        /// производит вход пользователя (авторизацию)
        /// </summary>
        /// <param name="AR">полученный запрос, который нужно только разобрать на данные пользователя</param>
        public static TUser InitUser(TODBC_Array AR)
        {
            _user = new TUser(AR);
            return _user;
        }
        /// <summary>
        /// возвращает пользователя, который дал запрос страницы
        /// </summary>
        public static TUser ItUser { get { return _user; } }
        /// <summary>
        /// производит вход пользователя (авторизацию)
        /// </summary>
        /// <param name="Session">сессия для обновления информации (если вход уже осуществлялся)</param>
        public static TUser InitUser(HttpSessionState Session)
        {
            //_user = new TUser(Session);
            if (Session != null && Session["UID"] != null)
            { _user = new TUser(Session); }
            else { _user = null; }// */
            return _user;
        }

        public static TUser InitUser(string SessID, string UID, string IP, ref bool isLog)
        {
            //_user = new TUser(Session);
            _user = new TUser(SessID, UID, IP, ref isLog);

            return _user;
        }

        /// <summary>
        /// осуществляет принудительный выход пользователя
        /// </summary>
        /// <param name="Session">сессия, для удаления из нее активность пользователя</param>
        public static bool DoneUser(HttpSessionState Session)
        {//_user != null &&
            if (Session["UID"] != null)
            {
                TODBC.ItOdbc.Execute(
                    "Exec IsPersConnect " +
                    Session["UID"].ToString() + ",'0','';");
                Session.Abandon();
                _user = null;
                return true;
            }
            return false;
        }

        public static bool DoneUser(string UID)
        {//_user != null &&

            TODBC.ItOdbc.Execute(
                "Exec IsPersConnect " +
                UID + ",'0','';");
            _user = null;
            return true;
        }


        /// <summary>
        /// производит сбор данных о пользователе
        /// </summary>
        /// <param name="AR">TODBC_Array-результат</param>
        /// <param name="SesID">ID-номер сессии для проверки</param>
        private void Create(TODBC_Array AR, string SesID)
        {
            try
            {
                if (AR.IsSelRecord)
                {
                    object obj;
                    _FIO = new TFIO(AR.Field("PersonIm").ToString(),
                                    AR.Field("PersonFa").ToString(),
                                    AR.Field("PersonOt").ToString());
                    _pred = AR.Field("IdPrOr").ToString();
                    _Pred = new TPred(_pred);
                    _Login = AR.Field("PersonLogin").ToString();
                    obj = AR.Field("PersonEMail");
                    _e_mail = ((obj != null) ? obj.ToString() : "");
                    obj = AR.Field("PersonDolz");
                    _Dolz = ((obj != null) ? obj.ToString() : "");
                    _Group = new TGroup((int)AR.Field("idGrpUs"));
                    obj = AR.Field("DateReg");

                    if (obj != null)
                        try
                        { _dtRg = (DateTime)obj; }
                        catch
                        { _dtRg = DateTime.MinValue; }
                    obj = AR.Field("DateDel");
                    _del = (obj != null);
                    if (_del)
                        try
                        { _dtDl = (DateTime)obj; }
                        catch
                        { _dtDl = DateTime.MinValue; _del = false; }
                    if (SesID != "")
                    { Login_ = AR.Field("SessStr").ToString() == SesID; }
                    else Login_ = true;// */
                    Login_ = (bool)AR.Field("isActive") && Login_;
                }
                else
                {
                    Login_ = false;
                }
            }
            catch { Login_ = false; }
        }

        /// <summary>
        /// создает класс пользователя и сбор данных о нем
        /// </summary>
        /// <param name="AR">разбор готового запроса на данные</param>
        public TUser(TODBC_Array AR) { Create(AR, ""); }
        /// <summary>
        /// создает класс пользователя и сбор данных о нем
        /// </summary>
        /// <param name="id">id-пользователя</param>
        /// <param name="IP">IP-адресс по которому входил пользователь</param>
        /// <param name="sesID">ID-сессии для проверки</param>
        public TUser(int id, string IP, string sesID)
        {
            Create(TODBC.ItOdbc.Execute(
                    "Exec IsPersConnect " +
                    id.ToString() + ",'" +
                    IP + "','" + sesID + "';"), "");
        }
        /// <summary>
        /// создает класс пользователя и сбор данных о нем
        /// </summary>
        /// <param name="Session">проверка входил ли пользователь недавно, на основе этих данных будет собран пользователь</param>
        public TUser(HttpSessionState Session)
        {
            string s = Session.SessionID;
            Create(TODBC.ItOdbc.Execute(
                   "Exec IsPersActive " +
                   Session["UID"].ToString() + ",'" +
                   Session["IP"].ToString() + "','" +
                   Session.SessionID + "';"), s);
            if (!Login_)
                Session.Abandon();
        }

        public TUser(string SessID, string UID, string IP, ref bool isLog)
        {
            Create(TODBC.ItOdbc.Execute(
                   "Exec IsPersActive " +
                   UID + ",'" + IP + "','" +
                   SessID + "';"), SessID);
            isLog = !Login_;
        }

        /// <summary>
        /// Возвращает "true", если пользователь авторизировался
        /// </summary>
        public bool LogIn { get { return Login_; } }
        /// <summary>
        /// возвращает логин пользователя
        /// </summary>
        public string UserLogin { get { return _Login; } }
        /// <summary>
        /// возвращает e-mail пользоввателя
        /// </summary>
        public string UserEMail { get { return _e_mail; } }
        /// <summary>
        /// возвращает код ОКПО предприятия пользователя
        /// </summary>
        public string OKPOPred { get { return _pred; } }
        /// <summary>
        /// возвращает класс ФИО пользователя
        /// </summary>
        public TFIO FIO { get { return _FIO; } }
        /// <summary>
        /// возвращает группу пользователя
        /// </summary>
        public TGroup Group { get { return _Group; } }
        /// <summary>
        /// возвращает дату регистрации пользователя
        /// </summary>
        public DateTime UserReg { get { return _dtRg; } }
        /// <summary>
        /// определяет заблокирован ли пользователь
        /// </summary>
        public bool IdUserBlock { get { return _del; } }
        /// <summary>
        /// возвращает дату удаления пользователя
        /// </summary>
        public DateTime UserDel { get { return _dtDl; } }
        /// <summary>
        /// возвращает должность пользователя
        /// </summary>
        public string UserDolz { get { return _Dolz; } }
        /// <summary>
        /// возвращает предприятие пользователя
        /// </summary>
        public TPred Pred { get { return _Pred; } }
    }
}
