--------------------------------------------------------------------------------
-- GLOBALS
--------------------------------------------------------------------------------
Global( "onEvent", {} )
Global( "PetHP", nil )
Global( "PetRN", nil )
Global("BtUp",nil)
Global("HPPrec",80)
Global( "HPText", "HP: 80%")
--------------------------------------------------------------------------------
-- FUNCTIONS
--------------------------------------------------------------------------------
function RegisterEventHandlers( handlers )
	for event, handler in handlers do
		common.RegisterEventHandler( handler, event )
	end
end

function sqr(n)
  return n*n
end

function playersHPPet()
  local setId = nil
  local HP = 200
  local gr = group.GetMembers()
  --local ids = avatar.GetTarget()
  local bl = avatar.GetNecromancerBloodPool()
  if not bl then bl = 16 else bl = bl.value end
  if bl>3 then
    if gr then
      local ll = true
	  local len = 0
      local pos = object.GetPos(avatar.GetId())
      while ll do
        ll = gr[len]
        if ll then
          local hp_ = unit.GetHealthPercentage(ll.id) -- HP %
          --local kk = object.IsInUsageRange(ll.id)
          local kk = not object.IsFar(ll.id)
          if kk then
            local posLL = object.GetPos(ll.id)
            --kk = (((posLL.posX-pos.posX)^2+(posLL.posY-pos.posY)^2)^0.5) < 40
            if posLL and pos then 
              kk = ((posLL.posX - pos.posX)^2 + (posLL.posY - pos.posY)^2)^0.5 <= 35
            end
          end
	    if hp_ and (HP > hp_)and(hp_>0)and kk then
          HP = hp_
    	  setId = ll.id
	    end
	    len = len +1
        end
      end
    
      if  setId and (HP < HPPrec) then
        avatar.SelectTarget( setId )
      end
    elseif unit.GetHealthPercentage(avatar.GetId()) < HPPrec then
      avatar.SelectTarget( avatar.GetId() )
    end
  end
end

function SendAddon()
	local SetVal = { val = userMods.ToWString(HPText) }
	local params = { header = SetVal, ptype = "button", size = 85 } 
	userMods.SendEvent( "AOPANEL_SEND_ADDON", { name = "AOPanel HealthNekros", sysName = "AOPanelHltNrk", param = params } )
end

---------------------------------------------------------------------------------
function UpdateAddon(params)
	local SetVal = { val = userMods.ToWString(HPText) }
	userMods.SendEvent( "AOPANEL_UPDATE_ADDON", { sysName = "AOPanelHltNrk", header = SetVal } )
end

function UpdateQuest(pl)
  HPPrec = HPPrec +pl
  if HPPrec < 0 then HPPrec = 100 elseif HPPrec > 100 then HPPrec = 0 end
  -- [[
  local section = { }
  section.HP = HPPrec
  userMods.SetGlobalConfigSection( "HPPrec", section )
  --]]
  HPText = "HP: "..HPPrec.."%"
end
--------------------------------------------------------------------------------
-- EVENT HANDLERS
--------------------------------------------------------------------------------
onEvent [ "AOPANEL_START" ] = function( params )    
	SendAddon()
	--UpdateQuest()
	--UpdateAddon(HPText)
end

onEvent  [ "AOPANEL_BUTTON_LEFT_CLICK" ]  = function( params )
if params.sender == "AOPanelHltNrk" then
	UpdateQuest(-10)
	UpdateAddon(HPText)
end
end

onEvent  [ "AOPANEL_BUTTON_RIGHT_CLICK" ]  = function( params )
if params.sender == "AOPanelHltNrk" then
	UpdateQuest(10)
	UpdateAddon(HPText)
end
end

onEvent [ "SCRIPT_TOGGLE_UI" ] = function( params )
	mainForm:Show(params.visible)
end

onEvent [ "U_EVENT_ADDON_MEM_USAGE_REQUEST" ] = function( params )
	userMods.SendEvent("U_EVENT_ADDON_MEM_USAGE_RESPONSE",{sender=common.GetAddonName(),memUsage=gcinfo()})
end

onEvent [ "SCRIPT_ADDON_INFO_REQUEST" ] = function( params )
	if params.target==common.GetAddonName() then
		userMods.SendEvent("SCRIPT_ADDON_INFO_RESPONSE",{sender=common.GetAddonName(),desc="CDN_ForNekroHil"})
	end
end

onEvent [ "EVENT_SECOND_TIMER" ] = function( params )
	--local HealthInfo = unit.GetHealth(avatar.GetId())
	--pet = unit.GetActivePet(avatar.GetId() )
	playersHPPet()
	local id_ = avatar.GetTarget()
    
    local pk = unit.GetRelativeWoundsComplexity( id_ )
    local k = unit.GetWoundsComplexity( id_ )
    local rk = unit.GetRuneWoundsComplexity( id_ )
    local mk = "??"
    if k>0 and pk>0 then
       mk = math.ceil((k / pk)*100)
       if mk>1000 then mk = math.ceil(mk/1000).."k" end
    end
    PetRN:SetVal("CurHP_RN", userMods.ToWString("("..pk.."%)"..k.."/"..mk.."/"..rk.."x"))
    local bl = avatar.GetNecromancerBloodPool()
	if not bl then bl = "" else bl = "("..bl.value..") " end
    PetHP:SetVal("CurHPp", userMods.ToWString(""..bl..unit.GetHealthPercentage( id_ )))
    --[[local hh = unit.GetHealth( id_ )
    if hh then
      if hh.health then
        PetHP:SetVal("CurHP", userMods.ToWString(""..hh.health))
      elseif hh.maxHealth then
        PetHP:SetVal("CurHP", userMods.ToWString("'"..hh.maxHealth.."'")) 
      else
        PetHP:SetVal("CurHP", userMods.ToWString('-"-"-')) 
      end
    end]]
	--unit.GetHealthPercentage( pet )
	--playersHPPet('')
	--PetHP:SetVal("CurrentPetHP", userMods.ToWString(HealthInfo.maxHealth..""))
end

--onEvant [ "UpButtonReaction" ] = function(params)

--end
--------------------------------------------------------------------------------
-- INITIALIZATION
--------------------------------------------------------------------------------
function Init()
	RegisterEventHandlers( onEvent )
	if avatar.IsExist() then onEvent [ "EVENT_AVATAR_CREATED" ]() end
    -- [[
    local section = userMods.GetGlobalConfigSection( "HPPrec")
    if section then 
      HPPrec = section.HP 
      HPText = "HP: "..HPPrec.."%"
    end
    UpdateAddon(HPText)--]]
    PetHP = mainForm:GetChildChecked("PetHP", false)
    PetRN = mainForm:GetChildChecked("PetRN", false)
    --HPPrec = userMods.GetGlobalConfigSection("HPPrec")
    --if not HPPrec then HPPrec = 80 end	
end
--------------------------------------------------------------------------------
Init()
--------------------------------------------------------------------------------