unit ExcelCom;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, variants, ComObj, strutils, LazUTF8;

type

  { TExcel }

  TExcel = class
      private
        E:OleVariant;
        isLoad:boolean;
        function getC(const Cols: variant; Rows: integer ): variant;
        function getCell(x, y : integer): variant;
        function getRg(const Cols: WideString; Rows: integer): variant;
        procedure setC(const Cols: variant; Rows: integer ; AValue: variant);
        procedure setCell(x, y : integer; AValue: variant);
        procedure setRg(const Cols: WideString; Rows: integer; AValue: variant);

      public
        constructor Create;
        destructor Destroy; override;


        Property Excel:OleVariant read E;

        Function Open: boolean;
        Function Close: boolean;

        function OpenBook( const NameFile:WideString): boolean;
        function BookSaveAs(const NameFile:WideString): boolean;
        function BookSave: boolean;
        function AddBook: boolean;
        function CloseBook: boolean;

        function LastRows: integer;

        Property Cell[const Cols: variant; Rows:integer ]: variant read getC write setC;default;

        procedure SetBGColor(x,y,color:integer);
        //Property Cells[x,y : integer]: variant read getCell write setCell;
  end;

  function ColIsNumToStr(col:integer):string;
  function ColIsStrToNum(col:string):integer;

var xl: TExcel;
implementation

const _Col_XL_Str:string='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      _Len_Col_XL_Str=26;

function ColIsNumToStr(col:integer):string;
begin
  dec(col);
//  col:=Byte(col);
  result:='';
  while col>=0 do begin
    result:=_Col_XL_Str[col mod _Len_Col_XL_Str+1] + result;
    col:=(col div _Len_Col_XL_Str)-1;
  end;

//  result:=_Col_XL_Str[col mod _Len_Col_XL_Str+1];
//  IF col>=_Len_Col_XL_Str then result:=_Col_XL_Str[(col div _Len_Col_XL_Str)]+result;
end;

function ColIsStrToNum(col:string):integer;
var i,ps:byte;
begin
  result:=0;
  IF col<>'' then begin
    col:=UpperCase(col);
    for i:=1 to length(col) do begin
      ps := pos(col[i],_Col_XL_Str);
      IF ps>0 then
        result:= (result * _Len_Col_XL_Str) + ps;
    end;
  end;
end;




{ TExcel }


function TExcel.getRg(const Cols: WideString; Rows: integer ): variant;
var a : ansistring;
begin
  try
    a := Cols;
    result := E.Cells[Rows,ColIsStrToNum(a)].Value;
  except result := ''; end;

end;

procedure TExcel.setC(const Cols: variant; Rows: integer ; AValue: variant);
begin
  IF VarIsStr(Cols)
    then setRg(Cols,Rows,AValue)
    else setCell(Cols, Rows, AValue);
end;

function TExcel.getCell(x, y : integer): variant;
begin
  try
    result := E.Cells[y,x].Value;
  except result := ''; end;
end;

function TExcel.getC(const Cols: variant; Rows: integer ): variant;
begin
  IF VarIsStr(Cols)
    then result := getRg(Cols,Rows)
    else result := getCell(Cols, Rows);
end;

procedure TExcel.setCell(x, y : integer; AValue: variant);
begin
  try
    E.Cells[y,x].Value := AValue;
  except  end;
end;

procedure TExcel.setRg(const Cols: WideString; Rows: integer; AValue: variant);
var a : ansistring;
begin
  try
    a := Cols;
    E.Cells[Rows,ColIsStrToNum(a)].Value := AValue;
  except  end;
end;

constructor TExcel.Create;
begin
  isLoad := false;
end;

destructor TExcel.Destroy;
begin
  Close;
  inherited Destroy;
end;

function TExcel.Open: boolean;
begin
  result:= true;
  try
    E := CreateOleObject('Excel.Application');
  except result:=false;end;
end;

function TExcel.Close: boolean;
begin
  result:=true;
  try
    IF isLoad
     then begin
       try E.WorkBooks.Close;except end;
       E := '';
     end;
    isLoad := false;
  except result:=false;end;
end;

function TExcel.OpenBook(const NameFile:WideString): boolean;
var w:widestring;u:utf8string;a:ansistring;
begin
  result:= true;
  u := NameFile;
  a:= utf8toansi(u);
  w:= a;
  try E.WorkBooks.Open(w);
  except
     result := AddBook;
     IF result then
       result := BookSaveAs(NameFile);
  end;
end;

function TExcel.BookSaveAs(const NameFile: WideString): boolean;
var w:widestring;u:utf8string;
    a: ansistring;
begin
  result:=true;
  u := NameFile;
  a:= utf8toansi(u);
  w:= a;
  try
    E.DisplayAlerts:=False;
    E.ActiveWorkbook.SaveAs(w);
    E.DisplayAlerts:=True;
  except result := false; end;
end;

function TExcel.BookSave: boolean;
begin
  result := true;
  try
    E.DisplayAlerts:=False;
    E.ActiveWorkbook.Save();
    E.DisplayAlerts:=True;
  except result:=false; end;
end;

function TExcel.AddBook: boolean;
begin
  result:=true;
  try
    E.WorkBooks.Add;
  except result:=false;end;
end;

function TExcel.CloseBook: boolean;
begin
  result:=true;
  try
    E.DisplayAlerts:=False;
    E.ActiveWorkbook.Close;
    E.DisplayAlerts:=True;
  except result:=false;end;
end;

function TExcel.LastRows: integer;
begin
  try
    result:=E.Cells.SpecialCells($B, EmptyParam).Row;
  Except result := 0; end;
end;

procedure TExcel.SetBGColor(x, y, color: integer);
begin
  try
    E.Cells[y,x].Interior.Color := color;
  except  end;
end;

initialization
  xl := TExcel.Create;
finalization
  xl.Free;

end.

