unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ExtDlgs, IniFiles, ExcelCom, variants, ShellApi, LCLType, ExtCtrls,
  Buttons, ColorBox;

type

  { TForm1 }

  SklInfo = record
    Name,SaveName: WideString;
    Count: Integer;
    serialNum: int64;
    Price: double;
  end;

  sortType = (s_count,s_serial,s_price);

  Proc = Procedure(startListExcel:integer) of object;
  Func = function:string of object;

  TForm1 = class(TForm)
    Button1: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Button15: TButton;
    Button16: TButton;
    Button17: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    CBDate2: TComboBox;
    ClndrDlg: TCalendarDialog;
    CBDate: TComboBox;
    ColorDlg: TColorDialog;
    DateStart: TLabel;
    DateFinish: TLabel;
    Btn: TEdit;
    E_Formula: TEdit;
    E_dirData2: TEdit;
    E_resultRange: TEdit;
    E_planogram: TEdit;
    E_dirData: TEdit;
    E_price: TEdit;
    E_result: TEdit;
    E_resultList: TEdit;
    E_sklad: TEdit;
    Label1: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label2: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    DateOne: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    DateTwo: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    L_Formula: TListBox;
    OpenXls: TOpenDialog;
    PageControl1: TPageControl;
    PB: TProgressBar;
    SaveXls: TSaveDialog;
    DirDlg: TSelectDirectoryDialog;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    procedure BtnClick(Sender: TObject);
    procedure BtnEnter(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure CBDate2Change(Sender: TObject);
    procedure CBDateChange(Sender: TObject);
    procedure DateFinishClick(Sender: TObject);
    procedure DateStartClick(Sender: TObject);
    procedure DateTwoClick(Sender: TObject);
    procedure E_FormulaKeyPress(Sender: TObject; var Key: char);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure DateOneClick(Sender: TObject);
    procedure L_FormulaClick(Sender: TObject);
    procedure L_FormulaMeasureItem(Control: TWinControl; Index: Integer;
      var AHeight: Integer);
  private
    { private declarations }
  public
    log : TextFile;
    St: boolean;
    positionClear: array of record
      cols: integer;
      rows: integer;
      nums: word;
    end;
    ArSkladInfo: Array of SklInfo;

    ArTestSkladInfo: Array of record
      name, lowname: widestring;
      countSt, countFn : integer;
    end;

    ArRangeSklad: Array of record
      serialNum: int64;
      count:array of integer; // кол-во в различные дни периода
      history:array of record // история в дни периода
        //change:integer;    // изменения кол-во на складе
        S:double;          // коэфициэнт от общей суммы на складе
        money: double;     // доход с продажи
      end;
      S: double;     // конечный коэфициэнт от общей суммы на складе
      money: double; // конечная сумма прибыли
      P: double;     // конечный коэфициэнт от общей суммы прибыли
    end;
    MaxRangeCount, PosRange:integer;
    rangeCreate:boolean;

    arColorFormuls:array of TColor;

    procedure loadSklad(const FileName: String; AddArProc: Proc; LenArFunc: Func);
    procedure loadPrice(const FileName: String);
    procedure loadDayRange(const FileName: String);


    function FindArTest(const Nm: wideString): Integer;
    procedure AddArTest(const Nm: wideString; ct: integer);

    function FindArRange(serialNum: int64):integer;
    function AddArRange(serialNum:int64; count: integer):integer;
    procedure MatematikRange;
    procedure clearRange;
    procedure loadRange;


    function FindArInfo(const Nm: WideString): Integer;overload;
    function FindArInfo(serialNum:int64): Integer;overload;
    function FindArInfoPos(const Nm, model: WideString): Integer;
    procedure AddArInfo(const Nm: WideString; Ct:Integer;serialNum:integer);overload;
    procedure AddArInfo(serialNum:int64; price: double);overload;
    procedure SortArInfo(sort: sortType);

    Procedure ArInfoAdd(startListExcel:integer);
    Function LenArInfo: String;

    Procedure ArTestAdd(startListExcel:integer);
    Function LenArTest: String;

    Procedure ArRangeAdd(startListExcel:integer);
    Function LenArRangeAdd: String;

    procedure AddPosClear(c: integer; r: integer; num: word);
    procedure RePasteTovar;

    procedure LogMsg(const Txt: AnsiString);
    procedure Msg(const Txt, TxtLog:AnsiString; tip: TMsgDlgType = mtWarning);
    function IsNotFile(const Path: String; dirs:boolean = false): boolean;

    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.DateOneClick(Sender: TObject);
begin
  ClndrDlg.Date:= StrToDateDef(DateOne.Caption, Date);
  IF ClndrDlg.Execute then DateOne.Caption:= DateToStr(ClndrDlg.Date);
end;

procedure TForm1.L_FormulaClick(Sender: TObject);
begin
  IF L_Formula.ItemIndex >= 0 then begin
    E_Formula.Text := L_Formula.Items[L_Formula.ItemIndex];
    Btn.Color:=  arColorFormuls[L_Formula.ItemIndex];
  end;
end;

procedure TForm1.L_FormulaMeasureItem(Control: TWinControl; Index: Integer;
  var AHeight: Integer);
begin
  Control.Color:= arColorFormuls[Index];
end;

procedure TForm1.loadSklad(const FileName: String; AddArProc: Proc;
  LenArFunc: Func);
var startListExcel: integer;  v: variant;
begin
  IF XL.OpenBook(FileName) then begin
    LogMsg('    Open file "' + FileName + '"');

    startListExcel := 1;
    while (startListExcel < 100) and
          (VarToStrDef(XL[1,startListExcel],'') <> '1')
    do inc(startListExcel);

    IF (startListExcel < 100)and
       (VarToStrDef(XL['D', startListExcel],'') = '2')
    then begin

      inc(startListExcel);
      LogMsg('      Start position list = ' + IntToStr(startListExcel));

      v := XL['D',startListExcel];
      while not(VarIsNull(v) or
                VarIsEmpty(v) or
               (Trim(VarToStrDef(v,'')) = '')
      )do begin
        AddArProc(startListExcel);

        inc(startListExcel);
        v := XL['D', startListExcel];
      end;
      LogMsg('      Count list = ' + LenArFunc());

    end else Msg('Не удалось найти начало листа, возможно  выбран не верный файл',
                 '      Start position not found');

    LogMsg('    Close file "'+ FileName + '"');
    XL.CloseBook;
  end else Msg('Не удалось открыть файл "'+ FileName + '"',
               '    File "' + FileName + '" not open');
end;

procedure TForm1.loadPrice(const FileName: String);
var startListExcel: integer;  v: variant;
  ser: integer;
  p: double;
begin
  IF XL.OpenBook(FileName) then begin
    LogMsg('    Open file "' + FileName + '"');

    startListExcel := 2;

    PB.Position:= 0;
    PB.Max:= XL.LastRows - 2;

    v := XL[1,startListExcel];
    while not(VarIsNull(v) or
              VarIsEmpty(v) or
             (Trim(VarToStrDef(v,'')) = '')
    )do begin
      AddArInfo(StrToIntDef( VarToStrDef(v,'0'), 0),
                StrToFloatDef(
                  VarToStrDef(
                    XL[3,startListExcel],
                    '0'
                  ),0.0
                )
           );

      inc(startListExcel);
      v := XL[1, startListExcel];
      PB.Position := PB.Position + 1;
    end;


    LogMsg('    Close file "'+ FileName + '"');
    XL.CloseBook;
  end else Msg('Не удалось открыть файл "'+ FileName + '"',
               '    File "' + FileName + '" not open');

end;

procedure TForm1.loadDayRange(const FileName: String);
var startListExcel: integer;  v: variant;
  ser: integer;
  p: double;
begin
  IF XL.OpenBook(FileName) then begin
    LogMsg('    Open file "' + FileName + '"');

    startListExcel := 2;

    v := XL[1,startListExcel];
    while not(VarIsNull(v) or
              VarIsEmpty(v) or
             (Trim(VarToStrDef(v,'')) = '')
    )do begin
      AddArRange(StrToIntDef( VarToStrDef(v,'0'), 0),
                StrToIntDef(
                  VarToStrDef(
                    XL[3,startListExcel],
                    '0'
                  ),0
                )
           );

      inc(startListExcel);
      v := XL[1, startListExcel];
    end;
    LogMsg('        load ' + inttostr(startListExcel) + ' element');

    LogMsg('    Close file "'+ FileName + '"');
    XL.CloseBook;
  end else Msg('Не удалось открыть файл "'+ FileName + '"',
               '    File "' + FileName + '" not open');

end;

function TForm1.FindArTest(const Nm: wideString): Integer;
var i: integer; s: WideString;
begin
  result := -1;
  IF Length(ArTestSkladInfo) > 0 then begin
    s := WideLowerCase(Nm);
    for i:= 0 to high(ArTestSkladInfo) do
      IF ArTestSkladInfo[i].LowName = s then begin
        result := i;
        exit;
      end;
  end;
end;

procedure TForm1.AddArTest(const Nm: wideString; ct: integer);
var i: Integer;
begin
  IF Ct = 0 then exit;
  i := FindArTest(Nm);
  IF i < 0 then begin
    i := Length(ArTestSkladInfo);
    SetLength(ArTestSkladInfo, i + 1);
    ArTestSkladInfo[i].Name := Nm;
    ArTestSkladInfo[i].LowName := WideLowerCase(Nm);
    ArTestSkladInfo[i].CountSt := 0;
    ArTestSkladInfo[i].CountFn := 0;
  end;
  IF st
    then ArTestSkladInfo[i].countSt += Ct
    else ArTestSkladInfo[i].countFn += Ct;
end;

function TForm1.FindArRange(serialNum: int64): integer;
var i: integer;
begin
  result := -1;
  IF Length(ArRangeSklad) > 0 then
    for i:= 0 to high(ArRangeSklad) do
      IF ArRangeSklad[i].serialNum = serialNum then begin
        result := i;
        exit;
      end;
end;

function TForm1.AddArRange(serialNum: int64; count: integer): integer;
var i: integer;
begin
  result := FindArRange(serialNum);
  IF result < 0 then begin
    result := Length(ArRangeSklad);
    SetLength(ArRangeSklad, result + 1);
    ArRangeSklad[result].serialNum := serialNum;
    SetLength(ArRangeSklad[result].count,MaxRangeCount);
    IF MaxRangeCount > 1 then
      for i:=0 to MaxRangeCount-2 do
        ArRangeSklad[result].count[i] := 0;
    ArRangeSklad[result].count[PosRange] := count;
    SetLength(ArRangeSklad[result].history,0);
    ArRangeSklad[result].money := 0.0;
    ArRangeSklad[result].P := 0.0;
    ArRangeSklad[result].S := 0.0;
  end else  ArRangeSklad[result].count[PosRange] := count;
end;

procedure TForm1.MatematikRange;
var sum, i, j, pr:integer;
begin
  IF rangeCreate or (MaxRangeCount < 2) then exit;
  sum:= AddArRange(-1,0);
  SetLength(ArRangeSklad[sum].count, MaxRangeCount);
  SetLength(ArRangeSklad[sum].history, MaxRangeCount);
  for i:= 0 to MaxRangeCount-1 do begin
    with ArRangeSklad[sum].history[i] do begin
      S := 1;
      money := 0;
    end;
    ArRangeSklad[sum].count[i] := 0;
  end;
  ArRangeSklad[sum].money := 0;
  ArRangeSklad[sum].S := 1;
  ArRangeSklad[sum].P := 1;

  PB.Position:= 1;
  PB.Max:= 2;

  for i:= 0 to sum do begin  // подсчет изменений склада и формирование кол-ва общих продаж
    IF i < sum then
      Setlength(ArRangeSklad[i].history, MaxRangeCount);
    pr := FindArInfo(ArRangeSklad[i].serialNum);
    for j:= 0 to MaxRangeCount-1 do begin
      IF j=0 then
        ArRangeSklad[i].money:= 0;

      IF i < sum  then begin
        ArRangeSklad[sum].count[j] += ArRangeSklad[i].count[j];
        ArRangeSklad[i].history[j].money := ArRangeSklad[i].count[j] * ArSkladInfo[pr].Price;
        ArRangeSklad[sum].history[j].money += ArRangeSklad[i].history[j].money;
        ArRangeSklad[i].money += ArRangeSklad[i].history[j].money;
      end else ArRangeSklad[i].money += ArRangeSklad[i].history[j].money;
    end;
  end;

  PB.Position := PB.Position + 1;

  IF MaxRangeCount > 1 then
  for i:= 0 to sum-1 do begin // подсчет коэфециэнта суммы
    for j:= 1 to MaxRangeCount - 1 do
      IF ArRangeSklad[sum].count[j] <> 0
        then ArRangeSklad[i].history[j].S:= ArRangeSklad[i].count[j] /
                                            ArRangeSklad[sum].count[j]
        else ArRangeSklad[i].history[j].S:= 0;
    ArRangeSklad[i].S:= ArRangeSklad[i].history[MaxRangeCount-1].S;
    IF ArRangeSklad[sum].money <>0
      then ArRangeSklad[i].P:= ArRangeSklad[i].money / ArRangeSklad[sum].money
      else ArRangeSklad[i].P:= 0;
  end;
  PB.Position := PB.Position + 1;

  rangeCreate := true;
end;

procedure TForm1.clearRange;
var i: integer;
begin
  IF MaxRangeCount = 0 then exit;
  for i:=0 to high(ArRangeSklad)do begin
    SetLength(ArRangeSklad[i].history,0);
    SetLength(ArRangeSklad[i].count,0);
  end;
  SetLength(ArRangeSklad,0);
  rangeCreate:= false;
end;

procedure TForm1.loadRange;
var i, max: double;
   fn: string;
begin
  IF not rangeCreate then begin

     i := StrToDate(DateStart.Caption);
     max := StrToDate(DateFinish.Caption);
     MaxRangeCount:= trunc(max - i) + 1;
     PosRange:= 0;
     PB.Position:= 0;
     PB.Max:= MaxRangeCount - 1;
     while i <= max do begin
       fn := E_dirData2.Text + '\' + DateToStr(i) + CBDate2.Text;
       IF not IsNotFile( fn ) then
         loadDayRange(fn);
         //loadSklad(fn,@ArRangeAdd,@LenArRangeAdd);
       i := i + 1;
       inc(PosRange);
       PB.Position := PB.Position + 1;
     end;
     loadPrice( E_price.Text );
     MatematikRange;
  end;
end;

function TForm1.FindArInfo(const Nm: WideString): Integer;
var i: integer; s: WideString;
begin
  result := -1;
  IF Length(ArSkladInfo) > 0 then begin
    s := WideLowerCase(Nm);
    for i:= 0 to high(ArSkladInfo) do
      IF ArSkladInfo[i].Name = s then begin
        result := i;
        exit;
      end;
  end;
end;

function TForm1.FindArInfo(serialNum: int64): Integer;
var i: integer; s: WideString;
begin
  result := -1;
  IF Length(ArSkladInfo) > 0 then
    for i:= 0 to high(ArSkladInfo) do
      IF ArSkladInfo[i].serialNum = serialNum then begin
        result := i;
        exit;
      end;
end;

function TForm1.FindArInfoPos(const Nm, model: WideString): Integer;
var i: integer; s,m: WideString;
begin
  result := -1;
  IF Length(ArSkladInfo) > 0 then begin
    //s := AnsiLowerCase(Nm);
    m := WideLowerCase(model);
    for i:= 0 to high(ArSkladInfo) do
      IF{(Pos(s,ArSkladInfo[i].Name) > 0)and}(Pos(m,ArSkladInfo[i].Name) > 0) then begin
        result := i;
        exit;
      end;
  end;
end;

procedure TForm1.AddArInfo(const Nm: WideString; Ct: Integer; serialNum: integer);
var i: Integer;
begin
  IF Ct = 0 then exit;
  i := FindArInfo(serialNum);
  IF i < 0 then begin
    i := Length(ArSkladInfo);
    SetLength(ArSkladInfo, i + 1);
    ArSkladInfo[i].SaveName := Copy(Nm,5,length(nm));
    ArSkladInfo[i].Name := WideLowerCase(ArSkladInfo[i].SaveName);
    ArSkladInfo[i].Count := Ct;
    ArSkladInfo[i].serialNum := serialNum;
    ArSkladInfo[i].Price := 0.0;
  end else begin
    ArSkladInfo[i].Count += Ct;
    IF ArSkladInfo[i].Name = '' then begin
      ArSkladInfo[i].SaveName := Copy(Nm,5,length(nm));
      ArSkladInfo[i].Name := WideLowerCase(ArSkladInfo[i].SaveName);
    end;
  end;
end;

procedure TForm1.AddArInfo(serialNum: int64; price: double);
var i: Integer;
begin
  IF price = 0 then exit;
  i := FindArInfo(serialNum);
  IF i < 0 then begin
    i := Length(ArSkladInfo);
    SetLength(ArSkladInfo, i + 1);
    ArSkladInfo[i].SaveName := '';
    ArSkladInfo[i].Name := '';
    ArSkladInfo[i].Count := 0;
    ArSkladInfo[i].serialNum := serialNum;
  end;
  ArSkladInfo[i].Price := price;
end;

procedure TForm1.SortArInfo(sort: sortType);
var
  res: sklInfo;
  i, j : integer;
  function sortFunc(const a1,a2:sklInfo):boolean;
  begin
    case sort of
      s_count: result:= ArSkladInfo[j].Count < ArSkladInfo[i].Count;
      s_price: result:= ArSkladInfo[j].Price < ArSkladInfo[i].Price;
      s_serial: result:= ArSkladInfo[j].serialNum > ArSkladInfo[i].serialNum;
      else result:= false;
    end;
  end;
begin

  IF length(ArSkladInfo) > 1 then
    for i:=0 to high(ArSkladInfo) do
      for j:=0 to high(ArSkladInfo) do
        IF(i <> j)and sortFunc(ArSkladInfo[j],ArSkladInfo[i]) then begin
          res := ArSkladInfo[j];
          ArSkladInfo[j] := ArSkladInfo[i];
          ArSkladInfo[i] := res;
        end;

end;

procedure TForm1.ArInfoAdd(startListExcel: integer);
var v: variant; nm: widestring;
begin
  v := XL['D', startListExcel];
  nm := Trim(VarToStrDef(v,''));
  IF pos(ansistring(#$D2#$E5#$EB'.'),ansistring(nm)) > 0 then
    addArInfo(VarToStrDef(v,''),
              StrToIntDef(
                 VarToStrDef(
                    XL['P',startListExcel],
                    '0'),
                 0),
              StrToIntDef(
                 VarToStrDef(
                    XL['A',startListExcel],
                    '0'),
                 0)
              );
end;

function TForm1.LenArInfo: String;
begin
  result := IntToStr(Length(ArSkladInfo));
end;

procedure TForm1.ArTestAdd(startListExcel: integer);
var v: variant; nm: widestring;
begin
  v := XL['D', startListExcel];
  nm := Trim(VarToStrDef(v,''));
  IF pos(ansistring(#$D2#$E5#$EB'.'),ansistring(nm)) > 0 then
    AddArTest(VarToStrDef(v,''),
              StrToIntDef(
                 VarToStrDef(
                    XL['P',startListExcel],
                    '0'),
                 0)
              );
end;

function TForm1.LenArTest: String;
begin
  result := IntToStr(Length(ArTestSkladInfo));
end;

procedure TForm1.ArRangeAdd(startListExcel: integer);
var v: variant; nm: widestring;
begin
  v := XL['D', startListExcel];
  nm := Trim(VarToStrDef(v,''));
  IF pos(ansistring(#$D2#$E5#$EB'.'),ansistring(nm)) > 0 then
    AddArRange(StrToIntDef(
                 VarToStrDef(
                    XL['A',startListExcel],
                    '0'),
                 0),
               StrToIntDef(
                 VarToStrDef(
                    XL['P',startListExcel],
                    '0'),
                 0)
              );
end;

function TForm1.LenArRangeAdd: String;
begin
  result := IntToStr(Length(ArRangeSklad));
end;

procedure TForm1.AddPosClear(c: integer; r: integer; num: word);
begin
  SetLength(positionClear, Length(positionClear) + 1);
  with positionClear[High(positionClear)] do begin
    rows := r;
    cols := c;
    nums := num;
  end;
end;

procedure TForm1.RePasteTovar;
type rec_cmp = record
       left, right : string;
       op: byte; //0 - <, 1 - <=, 2 - >, 3 - >=, 4 - =, 5 - <>
     end;
  arInt= array of integer;
var ii, ps :integer;
  arFormulPrice:array of record
    el:array of integer;
    step:integer;
    cmp:array of rec_cmp;
    prc : double;
  end;
  frmlNo: byte;

  procedure addCMP(num:integer; const frml:string);
  var i,j_:integer; l:boolean;
  begin
    IF frml <> '' then
    with arFormulPrice[num] do begin
      i := Length(cmp);
      SetLength(cmp, i + 1);
      cmp[i].left:= '';
      cmp[i].right:= '';
      cmp[i].op:= $ff;
      l := true;
      for j_:=1 to length(frml) do case frml[j_] of
        '0'..'9','.','-','S','P','C','R':
          IF l
            then cmp[i].left += frml[j_]
            else cmp[i].right += frml[j_];
        '<':IF l then begin
          IF frml[j_+1] = '='
            then cmp[i].op:= 1
            else IF frml[j_+1] = '>'
              then cmp[i].op:= 5
              else cmp[i].op:= 0;
          l:= false;
        end;
        '>':IF l then begin
          IF frml[j_+1] = '='
            then cmp[i].op:= 3
            else cmp[i].op:= 2;
          l:= false;
        end;
        '=':IF l then begin
          cmp[i].op:= 4;
          l:= false;
        end;
      end;

    end;
  end;

  procedure compileFormuls;
  var i, j:integer; s: String;
  begin
    SetLength(arFormulPrice, L_Formula.Items.Count);
    IF length(arFormulPrice) > 0 then
      for i:= 0 to high(arFormulPrice)do begin
        s := L_Formula.Items[i];
        j:= pos(',',s);
        while  j > 0 do begin
          addCMP(i,LeftStr(s,j-1));
          delete(s,1,j);
          j:= pos(',',s);
        end;
        j:= pos('=>',s);
        addCMP(i,LeftStr(s,j-1));
        delete(s,1,j+1);
        arFormulPrice[i].prc:= 1 + (StrToFloatDef(s,0) / 100);
        SetLength(arFormulPrice[i].el,0);
        arFormulPrice[i].step:= -1;
      end;
  end;

  function getVal(val:string;C:integer;S,P,R:double):double;
  begin
    case val[1] of
      'S': result := s;
      'P': result := p;
      'C': result := c;
      'R': result := r;
      else result := StrToFloatDef(StringReplace(val,'.',',',[]),0);
    end;
  end;

  function IsCmpTrue(cmp:rec_cmp;C:integer;S,P,R:double):boolean;
  var val1,val2:double;
  begin
    val1:= getVal(cmp.left,c,s,p,r);
    val2:= getVal(cmp.right,c,s,p,r);
    case cmp.op of
      0: result := val1 < val2;
      1: result := val1 <= val2;
      2: result := val1 > val2;
      3: result := val1 >= val2;
      4: result := val1 = val2;
      5: result := val1 <> val2;
      else result := false;
    end;
  end;

  function ItIsFormula(psInfo,psRange:integer):boolean;
  var i, j: integer;res:boolean;
  begin
    for i:= 0 to high(arFormulPrice)do begin
      res := true;
      for j:= 0 to high(arFormulPrice[i].cmp) do begin
        res := res and IsCmpTrue(arFormulPrice[i].cmp[j],
                                 ArSkladInfo[psInfo].Count,
                                 ArRangeSklad[psRange].S,
                                 ArRangeSklad[psRange].P,
                                 ArSkladInfo[psInfo].Price);

        IF not res then break;
      end;
      IF res then begin
        j := length(arFormulPrice[i].el);
        SetLength(arFormulPrice[i].el,j + 1);
        arFormulPrice[i].el[j]:= psInfo;
        inc(arFormulPrice[i].step);
        result:= false;
        exit;
      end;
    end;
    result:= true;
  end;

  function __find(ar:arInt;num:integer):boolean;
  var i: integer;
  begin
    result:= false;
    IF length(ar)>0 then
    for i:= 0 to high(ar)do
      IF ar[i] = num then begin
        result := true;
        exit;
      end;
  end;

  procedure __add(var ar:arInt;num:integer);
  begin
    SetLength(ar, Length(ar)+1);
    ar[high(ar)] := num;
  end;

  procedure SetNewMobile(psCl:integer; SaveName: string; Count: integer; Price: double; color:integer=-1);
  begin
    with positionClear[psCl] do begin
      XL[cols,rows] := nums;
      LogMsg('       num[' + IntToStr(nums) + '] as "' +
                             SaveName + '" is count = ' +
                             IntToStr(Count));
      XL[cols,rows + 1] := SaveName;
      XL[cols,rows + 2] := Price;
      IF color > -1 then
        XL.SetBGColor(cols,rows + 2,color);
    end;
  end;

  function findForFrml(num:integer):boolean;
  var i,j:integer;
  begin
    result:= false;
    IF length(arFormulPrice)>0 then
      for i:= 0 to high(arFormulPrice) do
        IF length(arFormulPrice[i].el) > 0 then
          for j:= 0 to high(arFormulPrice[i].el) do
            IF arFormulPrice[i].el[j] = num then begin
              result := true;
              exit;
            end;
  end;

  procedure NextEl( psCl:integer );
  var i:integer;
  begin
    IF frmlNo < Length(arFormulPrice) then begin
      IF arFormulPrice[frmlNo].step > -1 then begin
        i:= arFormulPrice[frmlNo].step;
        i:= arFormulPrice[frmlNo].el[i];
        SetNewMobile(psCl,
          ArSkladInfo[i].SaveName,
          ArSkladInfo[i].Count,
          ArSkladInfo[i].Price * arFormulPrice[frmlNo].prc,
          arColorFormuls[frmlNo]
        );
        dec(arFormulPrice[frmlNo].step)
      end else begin
        inc(frmlNo);
        NextEl(psCl);
      end;
    end else begin
      while(ps < length(ArSkladInfo))and findForFrml(ps) do inc(ps);

      IF ps < length(ArSkladInfo) then
        SetNewMobile(psCl,
                     ArSkladInfo[ps].SaveName,
                     ArSkladInfo[ps].Count,
                     ArSkladInfo[ps].Price);
    end;
  end;

var
  arRed, arYellow:arInt;

begin
  IF(length(ArSkladInfo) > 0)and(length(positionClear) > 0)then begin
    PB.Position:= 0;
    PB.Max:= 7;
    SortArInfo(s_price);
    PB.Position := PB.Position + 1;
    SortArInfo(s_count);
    PB.Position := PB.Position + 1;

    compileFormuls;
    PB.Position := PB.Position + 1;

    for ii:= 0 to high(ArRangeSklad)do IF ArRangeSklad[ii].serialNum > 0 then begin
       ps:= FindArInfo(ArRangeSklad[ii].serialNum);
       ItIsFormula(ps,ii);
    end;

    PB.Position := PB.Position + 1;

    for ii:= 0 to high(positionClear) do
      case positionClear[ii].nums of
        14..16,22..24,41..56,73..75,81..83:__add(arRed,ii);
        11..13,19..21,76..78,84..86:__add(arYellow,ii);
      end;

    PB.Position := PB.Position + 1;
    ps:= 0;
    frmlNo := 0;

    IF length(arRed) > 0 then
      for ii:= 0 to high(arRed) do
        NextEl(arRed[ii]);

    IF length(arYellow) > 0 then
      for ii:= 0 to high(arYellow) do
        NextEl(arYellow[ii]);

    PB.Position := PB.Position + 1;
    frmlNo:= $ff;

    for ii:= 0 to high(positionClear) do begin
      NextEl(ii);
      inc(ps);
      IF ps > high(ArSkladInfo) then exit;
    end;

    PB.Position := PB.Position + 1;
  end;
end;

procedure TForm1.LogMsg(const Txt: AnsiString);
begin
  writeln(log,'[',DateTimeToStr(Date + Time),']: ', Txt);
end;

procedure TForm1.Msg(const Txt, TxtLog: AnsiString; tip: TMsgDlgType);
begin
  LogMsg(TxtLog);
  MessageDlg('Ошибка', Txt, tip, [mbOK],0 );
end;

function TForm1.IsNotFile(const Path: String; dirs: boolean): boolean;
begin
  IF dirs then begin
    result := not DirectoryExistsUTF8( Path );
    IF result
      then Msg('Директория "' + Path + '" не найдена',
               '  Directory "' + Path + '" not found')
      else LogMsg('  Directory "' + Path + '" exists');
  end else begin
    result := not FileExistsUTF8( Path );
    IF result
      then Msg('Файл "' + Path + '" не найден',
               '  File "' + Path + '" not found')
      else LogMsg('  File "' + Path + '" exists');
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  openXls.FileName := ExtractFileName( E_planogram.Text );
  openXls.InitialDir := ExtractFilePath( E_planogram.Text );
  IF openXls.Execute then E_planogram.Text := openXls.FileName;
end;

procedure TForm1.Button12Click(Sender: TObject);
var i, j, indx : integer;
  dt:TDateTime;
  s: string;
begin
  LogMsg('Run operation creating range of changes');
  IF IsNotFile( E_price.Text ) then exit;
  IF trim(E_resultRange.Text) = '' then begin
    Msg('Не указано имя выходного файла!',
        '  result file name is empty');
    exit;
  end;


  try
    IF XL.Open then begin
      LogMsg('  Open programm "MS Excel"');

      loadRange;

      //IF XL.OpenBook(E_resultRange.Text) then begin
      IF XL.AddBook then begin
        LogMsg('    Open file "' + E_result.Text + '"');

        XL[1,1]:= Utf8ToAnsi('Код товара');
        XL[2,1]:= Utf8ToAnsi('Стоимость товара');
        XL[3,1]:= Utf8ToAnsi('Стоимость проданного');
        XL[4,1] := Utf8ToAnsi('Коэффициент продажи') + s;
        dt:= StrToDate(DateStart.Caption);
        for j:= 0 to MaxRangeCount - 1 do begin
          s := DateToStr(dt + j);
          XL[5 + (j*3),1] := Utf8ToAnsi('Изменение на дату ') + s;
          XL[6 + (j*3),1] := Utf8ToAnsi('Стоимость проданного на дату ') + s;
          XL[7 + (j*3),1] := Utf8ToAnsi('Коэффициент кол-ва на дату ') + s;
        end;

        for i:= 0 to high(ArRangeSklad) do IF ArRangeSklad[i].serialNum <> 0 then begin
          IF ArRangeSklad[i].serialNum < 0 then begin
            XL[1,2 + i] := Utf8ToAnsi('Всего');
            XL[2,2 + i] := 0;
          end else begin
            XL[1,2 + i] := ArRangeSklad[i].serialNum;
            XL[2,2 + i] := ArSkladInfo[FindArInfo(ArRangeSklad[i].serialNum)].Price;
          end;
          XL[3,2 + i] := ArRangeSklad[i].money;
          XL[4,2 + i] := ArRangeSklad[i].P;
          for j:= 0 to MaxRangeCount - 1 do begin
            XL[5 + (j*3), 2 + i] := ArRangeSklad[i].count[j];
            XL[6 + (j*3), 2 + i] := ArRangeSklad[i].history[j].money;
            XL[7 + (j*3), 2 + i] := ArRangeSklad[i].history[j].S;
          end;
        end;


        //IF not XL.BookSave then begin;
        IF not XL.BookSaveAs(E_resultRange.Text) then begin
          XL.Excel.Visible := true;
          Msg('Файл не может быть сохранен по указанному пути!'#13#10'Сохраните его вручную, а затем нажмите ОК',
              '    File not save as "' + E_resultRange.Text + '"');
        end else LogMsg('    Save file as "'+ E_resultRange.Text + '"');

        LogMsg('    Close file "'+ E_resultRange.Text + '"');
        XL.CloseBook;

        LogMsg('    Execute file "'+ E_resultRange.Text + '"');
        ShellExecute(0,'open',pchar(E_resultRange.Text),nil,nil,5);
      end else Msg('Не удалось открыть файл "'+ E_resultRange.Text + '"',
                   '    File not open');


      LogMsg('  Close programm "MS Excel"');
      XL.Close;
    end else Msg('Не найденно приложение "MS Excel"',
                 '  "MS Excel" not found');

  Except
    on err:Exception do begin
      Msg('В ходе выполнения произошла ошибка:'#13#10 + err.Message,
          'ERROR!!!  ' + err.Message,  mtError);

      LogMsg('Close programm "MS Excel"');
      XL.Close;
    end;
  end;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
  IF E_Formula.Text <> '' then begin
    L_Formula.Items.Append(E_Formula.Text);
    L_Formula.ItemIndex:= L_Formula.Items.Count - 1;
    SetLength(arColorFormuls,Length(arColorFormuls) + 1);
    arColorFormuls[high(arColorFormuls)] := clYellow;
  end;
end;

procedure TForm1.Button14Click(Sender: TObject);
var i : integer;
begin
  IF L_Formula.ItemIndex >= 0 then begin
    L_Formula.Items.Delete(L_Formula.ItemIndex);

    IF L_Formula.Items.Count = 0
      then Btn.Color := clDefault
      else IF L_Formula.ItemIndex < high(arColorFormuls) then
        for i:=L_Formula.ItemIndex to high(arColorFormuls)-1 do
          arColorFormuls[i] := arColorFormuls[i + 1];
    SetLength(arColorFormuls, High(arColorFormuls));
  end;
end;

procedure TForm1.Button15Click(Sender: TObject);
var i : integer; c:TColor;
begin
  IF L_Formula.ItemIndex > 0 then begin
    i:= L_Formula.ItemIndex;
    L_Formula.Items.Move(i,i - 1);
    c := arColorFormuls[i];
    arColorFormuls[i] := arColorFormuls[i - 1];
    arColorFormuls[i - 1] := c;
    L_Formula.ItemIndex := i - 1;
  end;
end;

procedure TForm1.Button16Click(Sender: TObject);
var i: integer; c:TColor;
begin
  IF L_Formula.ItemIndex < L_Formula.Items.Count - 1 then begin
    i := L_Formula.ItemIndex;
    L_Formula.Items.Move(i,i + 1);
    c := arColorFormuls[i];
    arColorFormuls[i] := arColorFormuls[i + 1];
    arColorFormuls[i + 1] := c;
    L_Formula.ItemIndex := I + 1;
  end;
end;

procedure TForm1.Button17Click(Sender: TObject);
begin
  IF L_Formula.ItemIndex >= 0
    then L_Formula.Items[L_Formula.ItemIndex] := E_Formula.Text
    else begin
      L_Formula.Items.Append( E_Formula.Text );
      L_Formula.ItemIndex := L_Formula.Items.Count - 1;
      SetLength(arColorFormuls, Length(arColorFormuls) + 1);
      arColorFormuls[high(arColorFormuls)] := clYellow;
    end;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  SaveXls.FileName := ExtractFileName( E_resultRange.Text );
  SaveXls.InitialDir := ExtractFilePath( E_resultRange.Text );
  IF SaveXls.Execute then E_resultRange.Text := SaveXls.FileName;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  DirDlg.FileName:= E_dirData2.Text;
  IF DirDlg.Execute then E_dirData2.Text:= DirDlg.FileName;
end;

procedure TForm1.BtnClick(Sender: TObject);
begin
  IF L_Formula.ItemIndex >= 0 then
  IF ColorDlg.Execute then begin
    Btn.Color:= ColorDlg.Color;
    arColorFormuls[L_Formula.ItemIndex] := ColorDlg.Color;
  end;
end;

procedure TForm1.BtnEnter(Sender: TObject);
begin
  L_Formula.SetFocus;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  openXls.FileName := ExtractFileName( E_sklad.Text );
  openXls.InitialDir := ExtractFilePath( E_sklad.Text );
  IF openXls.Execute then E_sklad.Text := openXls.FileName;
end;

procedure TForm1.Button3Click(Sender: TObject);

const
  maxStelaj = 3;
  maxStelajRows = 4;
  stelaj:record
     r:array[1..maxStelajRows] of integer;
     sc:array[1..maxStelaj]of ansistring;
     cc:array[1..maxStelaj]of byte;
  end = (
    r:(8,11,14,17);
    sc:('B','K','T');
    cc:(8,8,8)
  );

  tel: WideString = 'Тел.';

var
  i, j, k, ps, x, y, num: integer;
  //x : ansistring;
  v: variant;
  s: AnsiString;
  nm: widestring;
begin
  LogMsg('Run operation Testing and Deleting');
  IF IsNotFile( E_planogram.Text ) then exit;
  IF IsNotFile( E_sklad.Text ) then exit;
  IF IsNotFile( E_price.Text ) then exit;
  IF trim(E_result.Text) = '' then begin
    Msg('Не указано имя выходного файла!',
        '  result file name is empty');
    exit;
  end;
  SetLength(ArSkladInfo, 0 );
  Setlength(positionClear, 0);
  Button5.Enabled := false;


  try
    IF XL.Open then begin
      LogMsg('  Open programm "MS Excel"');

      loadSklad( E_sklad.Text, @ArInfoAdd, @LenArInfo);
      loadPrice( E_price.Text );

      IF XL.OpenBook(E_planogram.Text) then begin
        LogMsg('    Open file "' + E_planogram.Text + '"');

        nm := '';
        num := 1;
        for i := 1 to maxStelaj do begin
          ps := ColIsStrToNum(stelaj.sc[i]) - 1;
          for j := 1 to maxStelajRows do begin
            y := stelaj.r[j];
            for k := 1 to stelaj.cc[maxStelaj] do begin
              x := ps + k;
              IF(VarToStrDef(XL[x, y],'') <> '') then begin
                s := VarToStrDef(XL[x, y + 1],'');
                IF FindArInfoPos(nm, s) = -1 then begin
                  LogMsg('        is not "'+ s + '"');
                  AddPosClear(x,y,num);
                  XL[x, y] := '';
                  XL[x, y + 1] := '';
                  XL[x, y + 2] := '';
                end;
              end;
              inc(num);
            end;
          end;
        end;

        Button5.Enabled := Length(positionClear) > 0;


        IF not XL.BookSaveAs( E_result.Text ) then begin
          XL.Excel.Visible := true;
          Msg('Файл не может быть сохранен по указанному пути!'#13#10'Сохраните его вручную, а затем нажмите ОК',
              '    File not save as "' + E_result.Text + '"');
        end else LogMsg('    Save file as "'+ E_result.Text + '"');

        LogMsg('    Close file "'+ E_result.Text + '"');
        XL.CloseBook;

        LogMsg('    Execute file "'+ E_result.Text + '"');
        ShellExecute(0,'open',pchar(E_result.Text),nil,nil,5);
      end else Msg('Не удалось открыть файл "'+ E_planogram.Text + '"',
                   '    File not open');


      LogMsg('  Close programm "MS Excel"');
      XL.Close;
    end else Msg('Не найденно приложение "MS Excel"',
                 '  "MS Excel" not found');

  Except
    on err:Exception do begin
      Msg('В ходе выполнения произошла ошибка:'#13#10 + err.Message,
          'ERROR!!!  ' + err.Message,  mtError);

      LogMsg('Close programm "MS Excel"');
      XL.Close;
    end;
  end;


end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  SaveXls.FileName := ExtractFileName( E_result.Text );
  SaveXls.InitialDir := ExtractFilePath( E_result.Text );
  IF SaveXls.Execute then E_result.Text := SaveXls.FileName;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  LogMsg('Run operation add new price');
  IF trim(E_result.Text) = '' then begin
    Msg('Не указано имя выходного файла!',
        '  result file name is empty');
    exit;
  end;

  try
    IF XL.Open then begin
      LogMsg('  Open programm "MS Excel"');

      loadRange;

      IF XL.OpenBook(E_result.Text) then begin
        LogMsg('    Open file "' + E_result.Text + '"');

        RePasteTovar;

        IF not XL.BookSave then begin;
          XL.Excel.Visible := true;
          Msg('Файл не может быть сохранен по указанному пути!'#13#10'Сохраните его вручную, а затем нажмите ОК',
              '    File not save as "' + E_result.Text + '"');
        end else LogMsg('    Save file as "'+ E_result.Text + '"');

        LogMsg('    Close file "'+ E_result.Text + '"');
        XL.CloseBook;

        LogMsg('    Execute file "'+ E_result.Text + '"');
        ShellExecute(0,'open',pchar(E_result.Text),nil,nil,5);
      end else Msg('Не удалось открыть файл "'+ E_result.Text + '"',
                   '    File not open');


      LogMsg('  Close programm "MS Excel"');
      XL.Close;
    end else Msg('Не найденно приложение "MS Excel"',
                 '  "MS Excel" not found');

  Except
    on err:Exception do begin
      Msg('В ходе выполнения произошла ошибка:'#13#10 + err.Message,
          'ERROR!!!  ' + err.Message,  mtError);

      LogMsg('Close programm "MS Excel"');
      XL.Close;
    end;
  end;

  Button5.Enabled:= false;
end;

procedure TForm1.Button6Click(Sender: TObject);
var f1, f2: String;
    i, ps: integer;
begin
  LogMsg('Run operation Testing Sklad');
  IF IsNotFile( E_dirData.Text, true ) then exit;
  f1 := E_dirData.Text + '\' + DateOne.Caption + CBDate.Text;
  f2 := E_dirData.Text + '\' + DateTwo.Caption + CBDate.Text;
  IF IsNotFile( f1 ) then exit;
  IF IsNotFile( f2 ) then exit;
  IF trim(E_resultList.Text) = '' then begin
    Msg('Не указано имя выходного файла!',
        '  result file name is empty');
    exit;
  end;
  SetLength(ArTestSkladInfo, 0 );

  try
    IF XL.Open then begin
      LogMsg('  Open programm "MS Excel"');
      //XL.Excel.Visible := true;
      PB.Position:= 0;
      PB.Max:= 3;
      St := true;  // первый файл
      loadSklad( f1, @ArTestAdd, @LenArTest);

      PB.Position := PB.Position +1;

      St := false; // второй файл
      loadSklad( f2, @ArTestAdd, @LenArTest);

      PB.Position := PB.Position + 1;

      IF Length(ArTestSkladInfo) > 0 then begin
        IF XL.OpenBook( E_resultList.Text ) then begin
          LogMsg('    new file excel');

          XL['A',1] := Utf8ToAnsi('Товар');
          XL['B',1] := Utf8ToAnsi(DateOne.Caption);
          XL['C',1] := Utf8ToAnsi(DateTwo.Caption);
          XL['D',1] := Utf8ToAnsi('Разница');

          ps := 2;

          for i := 0 to high(ArTestSkladInfo)do
            IF ArTestSkladInfo[i].countFn <> ArTestSkladInfo[i].countSt then begin
              XL['A',ps] := ArTestSkladInfo[i].name;
              XL['B',ps] := ArTestSkladInfo[i].countSt;
              XL['C',ps] := ArTestSkladInfo[i].countFn;
              XL['D',ps] := ArTestSkladInfo[i].countFn - ArTestSkladInfo[i].countSt;
              LogMsg('        "' + ArTestSkladInfo[i].name + '" count '
                                 + IntToStr(ArTestSkladInfo[i].countSt) + ' => '
                                 + IntToStr(ArTestSkladInfo[i].countFn));
              inc(ps);
            end;
          PB.Position := PB.Position + 1;

          //IF not XL.BookSaveAs(E_resultList.Text) then begin
          IF not XL.BookSave then begin
            XL.Excel.Visible := true;
            Msg('Файл не может быть сохранен по указанному пути!'#13#10'Сохраните его вручную, а затем нажмите ОК',
                '    File not save as "' + E_resultList.Text + '"');
          end else LogMsg('    Save file as "'+ E_resultList.Text + '"');

          LogMsg('    Close file "'+ E_resultList.Text + '"');
          XL.CloseBook;

          LogMsg('    Execute file "'+ E_resultList.Text + '"');
          ShellExecute(0,'open',pchar(Utf8ToAnsi(E_resultList.Text)),nil,nil,5);
        end else Msg('Не удалось создать новый документ',
                     '    File not create');

      end else Msg('Изменений не зафиксированно','    Files equevalents',mtConfirmation);

      LogMsg('  Close programm "MS Excel"');
      XL.Close;
    end else Msg('Не найденно приложение "MS Excel"',
                 '  "MS Excel" not found');

  Except
    on err:Exception do begin
      Msg('В ходе выполнения произошла ошибка:'#13#10 + err.Message,
          'ERROR!!!  ' + err.Message,  mtError);

      LogMsg('Close programm "MS Excel"');
      XL.Close;
    end;
  end;

end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  DirDlg.FileName:= E_dirData.Text;
  IF DirDlg.Execute then E_dirData.Text:= DirDlg.FileName;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  SaveXls.FileName := ExtractFileName( E_resultList.Text );
  SaveXls.InitialDir := ExtractFilePath( E_resultList.Text );
  IF SaveXls.Execute then E_resultList.Text := SaveXls.FileName;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  openXls.FileName := ExtractFileName( E_price.Text );
  openXls.InitialDir := ExtractFilePath( E_price.Text );
  IF openXls.Execute then E_price.Text := openXls.FileName;
end;

procedure TForm1.CBDate2Change(Sender: TObject);
begin
  CBDate.ItemIndex:= CBDate2.ItemIndex;
end;

procedure TForm1.CBDateChange(Sender: TObject);
begin
  CBDate2.ItemIndex:= CBDate.ItemIndex;
end;

procedure TForm1.DateFinishClick(Sender: TObject);
begin
  ClndrDlg.Date:= StrToDateDef(DateFinish.Caption, Date);
  IF ClndrDlg.Execute then begin
    DateFinish.Caption:= DateToStr(ClndrDlg.Date);
    IF rangeCreate then clearRange;
  end;
end;

procedure TForm1.DateStartClick(Sender: TObject);
begin
  ClndrDlg.Date:= StrToDateDef(DateStart.Caption, Date);
  IF ClndrDlg.Execute then begin
    DateStart.Caption:= DateToStr(ClndrDlg.Date);
    IF rangeCreate then clearRange;
  end;
end;

procedure TForm1.DateTwoClick(Sender: TObject);
begin
  ClndrDlg.Date:= StrToDateDef(DateTwo.Caption, Date);
  IF ClndrDlg.Execute then DateTwo.Caption:= DateToStr(ClndrDlg.Date);
end;

procedure TForm1.E_FormulaKeyPress(Sender: TObject; var Key: char);
begin
  IF key = 's' then key:= 'S' else
  IF key = 'p' then key:= 'P' else
  IF key = 'c' then key:= 'C' else
  IF key = 'r' then key:= 'R' else
  IF not (key in ['S','R','P','C','0'..'9','.',',','>','<','=',#8,'-']) then key:= #0;
end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
var ini: TIniFile; i: integer;
begin
  ini := TIniFile.Create(GetCurrentDir + '/settings.ini');
    ini.WriteString('Open','Planogram', E_planogram.Text);
    ini.WriteString('Open','Sklad', E_sklad.Text);
    ini.WriteString('Open','Dir', E_dirData.Text);
    ini.WriteString('Open','DirReport', E_dirData2.Text);
    ini.WriteString('Open','Price',E_price.Text);
    ini.WriteInteger('Open','DefExtHistory',CBDate.ItemIndex);
    ini.WriteString('Save','ResultPlanogram', E_result.Text);
    ini.WriteString('Save','ResultSklad', E_resultList.Text);
    ini.WriteString('Save','ResultRange', E_resultRange.Text);
    ini.WriteString('Save','DefExt', SaveXls.DefaultExt);
    ini.WriteInteger('Formula','Count',L_Formula.Items.Count);
    for i:=0 to L_Formula.Items.Count - 1 do begin
      ini.WriteString('Formula','Item'+IntToStr(i+1),L_Formula.Items[i]);
      ini.WriteString('Formula','Color'+IntToStr(i+1),IntToHex(arColorFormuls[i],6));
    end;
  ini.Free;

  LogMsg('Close program');
  closeFile(log);
end;

procedure TForm1.FormCreate(Sender: TObject);
var ini: TIniFile;
    s: AnsiString;
    i:integer;
begin
  ini := TIniFile.Create(GetCurrentDir +  '/settings.ini');
    E_planogram.Text := ini.ReadString('Open','Planogram',GetCurrentDir + '\');
    E_sklad.Text := ini.ReadString('Open','Sklad',GetCurrentDir + '\');
    E_price.Text := ini.ReadString('Open','Price',GetCurrentDir + '\');
    SaveXls.DefaultExt := ini.ReadString('Save','DefExt','xlsx');
    E_result.Text := ini.ReadString('Save','ResultPlanogram',
                                    GetCurrentDir + '\ResultPlanogramm' + SaveXls.DefaultExt);
    E_resultList.Text := ini.ReadString('Save','ResultSklad',
                                        GetCurrentDir + '\ResultSklad' + SaveXls.DefaultExt);
    E_resultRange.Text := ini.ReadString('Save','ResultRange',
                                        GetCurrentDir + '\ResultRange' + SaveXls.DefaultExt);

    DateOne.Caption:= DateToStr(date - 1);
    DateTwo.Caption:= DateToStr(date);
    DateStart.Caption:= DateToStr(date - 7);
    DateFinish.Caption:= DateToStr(date);

    E_dirData.Text:= ini.ReadString('Open','Dir',GetCurrentDir);
    E_dirData2.Text:= ini.ReadString('Open','DirReport',GetCurrentDir);
    CBDate.ItemIndex:= ini.ReadInteger('Open','DefExtHistory',1);

    CBDate2.ItemIndex := CBDate.ItemIndex;

    i := ini.ReadInteger('Formula','Count',0);
    SetLength(arColorFormuls, i);
    IF i > 0 then
      for i:= 0 to i - 1 do begin
        L_Formula.Items.Append(ini.ReadString('Formula','Item' + IntToStr(i + 1),''));
        arColorFormuls[i] := StrToIntDef('$' + ini.ReadString('Formula','Color' + IntToStr(i + 1),'00FFFF'),clYellow);
      end;


  ini.Free;


  s := GetCurrentDir + '/processing.log';
  assignFile(log,s);
  IF FileExists(s)
    then Append(log)
    else Rewrite(log);
  rangeCreate:=false;

  LogMsg('Open program');
end;

end.

