unit CoreLanguages;

{$mode objfpc}{$H+}
{$AsmMode INTEL}

interface

uses
  strutils, sysutils;

type

  HandleLang = SmallInt;


   ArStr = array of String;

  FlagsCompilation = {bit}packed record
    LineStart, // начало строки
    LineEnd,   // конец строки
    termWords, // было разделение пробелом, табуляцией и др. системными символами
    isNumeric, // числовая константа, целая или вещественная
    isSymbol,  // является ли символом
    lastSym    // был ли перед этим символ
      :boolean;
    tabs : word; // кол-во пробелов/табов/отступ
  end;

  TOnInitFinalLangCompile = procedure(p: pointer); stdcall;
  TOnCutWordLangCompile = function(words: PChar; Flags: FlagsCompilation; p: pointer): PChar; stdcall;


  LineScriptFlags = bitpacked record
      lsf_start_MODULE,
      lsf_start_FUNCTION,
      lsf_OBJECT_template
      : boolean;
  end;

  PFindScriptCompile = ^FindScriptCompile;
  FindScriptCompile = record
    Script: String;
    ps, len: LongInt;
    oldSym, oldN, oldS: boolean;
  end;

  PULSLanguage = ^ULSLanguage;

  PCompileScriptData = ^CompileScriptData;
  CompileScriptData = record
    FileName: String;
    PS, Line: LongInt;

    numLang: HandleLang;
    GlobalStart: boolean;

    lang: PULSLanguage;

    FSC: FindScriptCompile;
    CS: pointer; // CompileSystem;
  end;




  { ULSLanguage }
  ULSLanguage = object
    private
      NM: String;
      sym: String;
      Ext_: String;
      rect: pointer;

      //function IsNumeric(const s: string): boolean;

    public
      OnInitialization,
      OnFinalization   : TOnInitFinalLangCompile;
      OnNextWord       : TOnCutWordLangCompile;

      procedure Init( const _Name, Syms, _Ext: PChar; p: pointer);

      property Name: String read NM;
      property Ext: String read Ext_;

      procedure SetString( const Script: String);
      function Next(const wordStop: String; out Flags: FlagsCompilation): String;
      function EOF: boolean;
      function GetLastChar: Char;

      procedure Compile(const Script: String);
  end;



  function CountBits(a: longword): word;assembler;

var PCSD: PCompileScriptData;
implementation

function CountBits(a: longword): word;assembler;
asm
  xor eax, eax
  mov edx,eax
  xchg eax,ecx
  mov cl, 32
  @move:
    sal eax, 1 //;move highest bit in EAX to CF
    adc dl, 0
  loop @move
  mov eax, edx
end;


{ ULSLanguage }

{function ULSLanguage.IsNumeric(const s: string): boolean;
var i: integer; tchk, e: boolean;
begin
  IF s = '' then exit(false);
  result := true;
  tchk := false;
  e := false;
  i := 1;
  while result and (i <= length(s))do begin
    case s[i] of
      '0'..'9':;

      '.':
        IF e or tchk
          then result := false
          else tchk := true;

      'e','E':
        IF e
          then result := false
          else e := true;

      '-','+':
        IF (i > 1) and not( e and ( s[i-1] in ['e','E']))
          then result := false;

      else result := false;
    end;
    inc(i);
  end;

end;}


procedure ULSLanguage.Init(const _Name, Syms, _Ext: PChar; p: pointer);
begin
  NM := _Name;
  sym := Syms;
  rect := p;
  Ext_ := _Ext;
  OnInitialization := nil;
  OnFinalization := nil;
  OnNextWord := nil;
end;

procedure ULSLanguage.SetString(const Script: String);
begin
  IF PCSD = nil then exit;
  with PCSD^.FSC do begin
    oldSym := false;
    oldN := false;
    oldS := false;
    //Script := '';
    ps := 0;
  end;
  with PCSD^ do begin
    Line := 0;
    FileName := '';
    GlobalStart := false;
    PS := 1;
    FSC.Script := Script;
    FSC.len := length(Script);
    lang := @self;
  end;
end;

function ULSLanguage.Next(const wordStop: String; out Flags: FlagsCompilation
  ): String;
var
  ps: integer;

  shift,
  tchk,  // была обноружена точка
  e,     // для чисел, была определена мантиса
  num,   // подходит под константное значения числа
  isnum, // числовая константа
  isSym
  :boolean;

  PFSC: PFindScriptCompile;
begin
  result := '';
  IF PCSD = nil then exit;      // использование без запуска компиляции
  PFSC := @PCSD^.FSC;
  IF PFSC^.ps > PFSC^.len then exit;  // если курсор дальше размера текста
  //byte(Flags) := 0;
  int64(Flags) := 0;
  IF wordStop <> '' then begin   // если указано набор стоп-символов
    ps := posex(wordStop, PFSC^.Script, PFSC^.ps);  // ищем ближайшее стоп-слово
    IF ps = 0 then begin        // если его нет, прекращаем работу
      result := copy(PFSC^.Script, PFSC^.ps, PFSC^.len);
      PFSC^.ps := PFSC^.len + 1;
    end else begin  // передаем текст до этого стоп-слова
      ps := ps + length(wordStop) - 1;
      result := copy(PFSC^.Script, PFSC^.ps, ps - PFSC^.ps);
      PFSC^.ps := ps + 1;
    end;
    IF (PFSC^.ps > PFSC^.len) or
       (PFSC^.Script[PFSC^.ps-1] in [#13,#10])
    then Flags.LineEnd := true;
  end else begin   // если стоп-слово неуказано
    IF (PFSC^.ps = 0) then begin  // первый поиск
      Flags.LineStart := true;
      inc(PFSC^.ps);
    end else begin // следующий поиск
      Flags.lastSym := PFSC^.oldSym;
      Flags.termWords := PFSC^.oldS;
      Flags.LineStart := PFSC^.oldN;
    end;

    Flags.tabs := 0;
    // убераем все пробелы и спецсимволы
    IF (PFSC^.ps <= PFSC^.len) and (PFSC^.Script[PFSC^.ps] <= #32) then Flags.termWords := true;
    while (PFSC^.ps <= PFSC^.len) and (PFSC^.Script[PFSC^.ps] <= #32) do begin
      IF PFSC^.Script[PFSC^.ps] in [#13,#10]
       then Flags.tabs := 0
       else inc(Flags.tabs);
      inc(PFSC^.ps);
    end;

    // настройки для поиска
    PFSC^.oldSym := false;
    PFSC^.oldN := false;
    PFSC^.oldS := false;
    shift := true;
    num := true;
    isnum := false;
    tchk := false;
    e := false;
    isSym := false;

    // после удаления непечатываемых символов, проверяем, не вышел ли за пределы курсор парсера
    IF PFSC^.ps <= PFSC^.len then
      for ps := PFSC^.ps to PFSC^.len do begin // бежим посимвольно
        IF (PFSC^.Script[ps] <= #32) then begin // наткнулись на пробел, приостанавливаем парсинг
          PFSC^.ps := ps;
          shift := false;
          break;
        end;

        IF num and (PFSC^.Script[ps] in ['-','+','.','e','E','0'..'9']) then begin // если символ не нарушает числовую константу
          case PFSC^.Script[ps] of
            '0'..'9':isnum := true; // убедились, что это числовая константа

            '.': // точка может быть только одна, и может буть указана, только перед мантисой, и никак иначе
              IF e or tchk
                then num := false // *.*.? or *e*.?
                else tchk := true;

            'e','E':  // мантиса может быть только одна, и только если это числовая константа
              IF e or not isnum
                then num := false //*e*e? or .e? or e?
                else e := true;

            '-','+':  // знак числа, может быть только в начале или строго после символом мантисы
              IF (ps > 1) and not( e and ( PFSC^.Script[ps-1] in ['e','E']))
                then num := false;
          end;
          IF (not num) then begin // парсер понял, что дальше не числовая константа
            IF (result <> '') then begin // однако часть символов уже прошла проверку, и подошла под определение
              IF (length(result)> 1) and (result[length(result)] in ['.','-','+']) // *. или *e+ или *e-
                then SetLength(result, length(result)-1)
                else isSym := pos(result, sym) > 0 ;
              break;
            end else isSym := pos(PFSC^.Script[ps], sym) > 0 ;
          end;
        end else IF num then begin // парсер обнаружил, что следующие символы неподходят под числовую константу
          num := false; // больше не считаем набор символов возможным числовым значением
          IF result <> '' then begin // если результат не пуст, то что-то мы все таки определили как числовую константу
            IF result[length(result)] in ['.','-','+'] then begin // *. или *e+ или *e- или . или + или -
              IF (length(result) = 1) and (result[1] in ['.','-','+']) then begin // . или + или -
                isSym := pos(result, sym) > 0 ; // пользователь просит считать эти символы как символы?
                IF isSym then begin
                  PFSC^.oldSym := true;
                  Flags.isSymbol := true;
                  //inc(PFSC^.ps);
                  shift := false;
                  break;
                end else begin  // пользователь решил использовать их как буквы
                  result += PFSC^.Script[ps];
                  continue;
                end;
              end;
              SetLength(result, length(result)-1); // последний символ к числовой константе не относиться
              isSym := true;
            end;
            IF result <> ''
             then break
             else isSym := pos(PFSC^.Script[ps], sym) > 0 ;  //остановленно символом?
          end else isSym := pos(PFSC^.Script[ps], sym) > 0 ; //остановленно символом?
        end else isSym := pos(PFSC^.Script[ps], sym) > 0 ;   //это символом?

        IF isSym then begin // если символ
          IF result = '' then begin // если до этого был набор с буквами отличными от указанного пользователем набора символов
            PFSC^.oldSym := true;
            result := PFSC^.Script[ps];
            Flags.isSymbol := true;
            inc(PFSC^.ps);
          end else PFSC^.ps := ps; // ???
          shift := false;
          break;
        end else result += PFSC^.Script[ps]; // добовляем следующую букву слова
      end;

    // набор получен
    IF ((result = '.e') or (result = '.E')) and (pos('.', sym) > 0) then begin // если была точка с мантисой, и точка есть в наборе символов, указанных пользователем
      result := '.';
      PFSC^.oldSym := true;
      Flags.isSymbol := true;
      PFSC^.ps := ps - 1;
    end else IF (result = '.') and (pos('.', sym) > 0) then begin
       Flags.isSymbol := true;
       PFSC^.oldSym := true;
       PFSC^.ps += 1;
    end else IF shift then PFSC^.ps += length(result); // двигаем курсор, если это необдходимо

    ps := PFSC^.ps;
    while (ps <= PFSC^.len) and (PFSC^.Script[ps] <= #32) do begin //поиск актуальных данных или конца строки
      IF PFSC^.Script[ps] in [#13,#10]
       then Flags.LineEnd := true // был конец строки
       else PFSC^.oldS := true;   // промежуток между словами
      inc(ps);
    end;
    IF (ps > PFSC^.len) then
      Flags.LineEnd := true; // конец скрипта

    PFSC^.oldN := Flags.LineEnd;
    Flags.isNumeric := isnum;//IsNumeric(result);
  end;
end;

function ULSLanguage.EOF: boolean;
begin
  IF PCSD = nil then exit(true);
  result := PCSD^.FSC.ps > PCSD^.FSC.len;
end;

function ULSLanguage.GetLastChar: Char;
begin
  IF PCSD = nil then exit(#0);
  with PCSD^.FSC do
    IF ps > length(Script)
     then result := #0
     else result := Script[ps];
end;

procedure ULSLanguage.Compile(const Script: String);
var
    t: PChar;
    flags : FlagsCompilation;
    CSD: CompileScriptData;
    SavePCSD: PCompileScriptData;
begin
  IF not assigned(OnNextWord) then raise Exception.Create('Function NextWord it is NULL');

  SavePCSD := PCSD;
  PCSD := @CSD;


  SetString(Script);
  IF assigned(OnInitialization) then
    OnInitialization(rect);

  t := '';
  while not EOF do begin
    t := PChar(Next(t,flags));
    t := OnNextWord(t,flags,rect);
    IF(CSD.FileName = '')and flags.LineEnd then
      inc(CSD.Line);
  end;

  IF assigned(OnFinalization) then
    OnFinalization(rect);

  PCSD := SavePCSD;
end;

end.

