unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, SynHighlighterJScript, SynEdit, IpHtml,
  Ipfilebroker, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Menus, CoreLanguages;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    MenuItemRUN: TMenuItem;
    ODlg: TOpenDialog;
    Panel1: TPanel;
    Memo1: TSynEdit;
    Memo2: TSynEdit;
    PopupMenu1: TPopupMenu;
    SynJScriptSyn1: TSynJScriptSyn;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDropFiles(Sender: TObject; const FileNames: array of String);
  private
    { private declarations }
  public

  end;

type
  pRecData = ^recData;
  recData = record
    r : string;
    strSym: string;
    isStr, isComment, isLoader : boolean;
    result: string;
    back: pRecData;
  end;

var
  Form1: TForm1;
  rec: pRecData;
  resultSTR:string;
  langJS: ULSLanguage;

  procedure jsFileCompile(const filename_in, filename_out: string);
  procedure Init;

implementation

{$R *.lfm}


procedure initJS(p: pointer); stdcall;
var r: pRecData;
begin
  new(r);
  IF rec = nil
   then begin r^.back := nil; resultSTR := ''; end
   else r^.back := rec;
  rec := r;
  rec^.isStr := false;
  rec^.r := '';
  rec^.isComment := false;
  rec^.strSym := '';
  rec^.result := '';
  rec^.isLoader := false;
end;

procedure doneJS(p: pointer); stdcall;
begin
  IF rec^.r <> '' then rec^.result += rec^.r;
  IF rec^.back = nil
   then resultSTR := rec^.result
   else rec^.back^.result += rec^.result;
  p := rec^.back;
  Dispose(rec);
  rec := p;

end;

function NextWordJS(words: PChar; Flags: FlagsCompilation; p: pointer): PChar;
  stdcall;
var s : String;
begin
  result := '';
  s := words;
  IF Flags.LineStart and (Rec^.r <> '') then begin
    Rec^.result += Rec^.r;
    Rec^.r := '';
  end;

  IF Rec^.isLoader then begin
    jsFileCompile(s+'.js','');
    Rec^.result += #13;
    Rec^.isLoader := false;
  end else IF Rec^.isComment then begin
    IF Flags.LineEnd or (rec^.strSym = '*/')
    then Rec^.isComment := false;
  end else IF Rec^.isSTR then begin
    IF rec^.strSym = '/' then begin
      IF s = '' then begin
        rec^.strSym := '';
        Rec^.r := '';
        Rec^.isComment := true;
        Rec^.isSTR := false;
        exit;
      end else IF (Rec^.r <> '') and (s[1] = '*') then begin
        Rec^.isSTR := false;
        Rec^.r := '';
        IF s[length(s)] <> '*' then begin
          Rec^.r := '';
          Rec^.isComment := true;
          rec^.strSym := '*/';
          exit('*/');
        end else exit('');
      end else IF Rec^.r <> '' then begin
        Rec^.r := '';
        Rec^.result += '/';
      end;
    end;

    IF (length(s) > 0) and (s[length(s)] = '\') then begin
      Rec^.result += s + rec^.strSym;
      exit(@rec^.strSym[1]);
    end;
    Rec^.result += s;
    Rec^.isSTR := false;
    Rec^.result += rec^.strSym;
    rec^.strSym := '';
  end else begin
    IF s = '"' then begin
      IF Rec^.r <> '' then begin
        Rec^.result += Rec^.r;
        Rec^.r := '';
      end;
      Rec^.isSTR := true;
      rec^.strSym := '"';
      Rec^.result += '"';
      exit('"');
    end else IF s = '''' then begin
      IF Rec^.r <> '' then begin
        Rec^.result += Rec^.r;
        Rec^.r := '';
      end;
      Rec^.isSTR := true;
      rec^.strSym := '''';
      Rec^.result += '''';
      exit('''');
    end else IF s = '`' then begin
      IF Rec^.r <> '' then begin
        Rec^.result += Rec^.r;
        Rec^.r := '';
      end;
      Rec^.isSTR := true;
      rec^.strSym := '`';
      Rec^.result += '`';
      exit('`');
    end else IF (flags.lastSym or flags.LineStart)
    and((flags.LineStart and (rec^.r = '')) or ((rec^.r <> '') and (rec^.r[length(rec^.r)]<>')')))
    and (s = '/') then begin
      IF Rec^.r = '/' then begin
        if flags.termWords then  Rec^.result += '/';
        rec^.strSym := '';
        Rec^.r := '';
        Rec^.isComment := true;
        exit('');
      end;
      IF Rec^.r <> '' then
        Rec^.result += Rec^.r;
      Rec^.r := '/';
      Rec^.isSTR := true;
      rec^.strSym := '/';
      exit('/');
    end else IF flags.isSymbol then begin
      if(s = '/') and (rec^.r <> '') and (rec^.r[length(rec^.r)]=')') then begin
        Rec^.result += Rec^.r;
        Rec^.r := '/';
      end else Rec^.r += s;
      {IF Rec^.r = '//' then begin
        //Rec.s := '';
        rec^.strSym := '';
        Rec^.r := '';
        Rec^.isComment := true;
      end else}
      IF Rec^.r = '/*' then begin
        Rec^.r := '';
        Rec^.isComment := true;
        rec^.strSym := '*/';
        exit('*/');
      end;
    end else begin
      IF Rec^.r <> '' then begin
        Rec^.result += Rec^.r;
        Rec^.r := '';
      end;
      IF s = '$_INCLUDE_FILE_$' then begin
        //Rec^.result += #13;
        Rec^.isLoader := true;
        exit('');
      end else IF Flags.termWords and (Rec^.result<>'') and (Rec^.result[length(Rec^.result)] <> #13) and not Flags.lastSym then
        Rec^.result += ' ';

      Rec^.result += s;
    end;
  end;

end;

procedure jsFileCompile(const filename_in, filename_out: string);
var f: THandle;
begin
  langJS.Compile(ReadFileToString(filename_in));
  IF rec = nil then begin
    f := FileCreateUTF8(filename_out);
    FileWrite(f,resultSTR[1],length(resultSTR));
    FileClose(f);
  end;
end;

procedure Init;
begin
  langJS.init('JavaScript','()-=+!~%^&*[]{}:;''"\|/?,.<>','.js',nil);
  langJS.OnInitialization := @initJS;
  langJS.OnNextWord := @NextWordJS;
  langJS.OnFinalization := @doneJS;

  rec := nil;
end;


procedure file_go(const f_in: string);
var
  ps: integer;
  f_out: string;
begin
  f_out := f_in;
  ps := Pos('.',f_out);
  IF ps < 1
     then f_out += '.min'
     else Insert('.min',f_out,ps);
  jsFileCompile(f_in, f_out);
end;



{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
end;

procedure TForm1.FormDropFiles(Sender: TObject; const FileNames: array of String
  );
var i: integer;
begin
  IF length(FileNames) > 0 then
    for i:= 0 to high(FileNames) do
      file_go(FileNames[i]);
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  langJS.Compile(Memo1.Text);
  Memo2.Text := resultSTR;
end;

procedure TForm1.Button2Click(Sender: TObject);
var i: integer;
begin
  IF ODlg.Execute then
    for i:= 0 to ODlg.Files.Count-1 do
      file_go( ODlg.Files[i] );
end;


var prI: integer;
initialization
  init;
  IF Paramcount > 0 then begin
    for prI:= 1 to Paramcount do
      file_go(ParamStrUTF8(prI));
    halt;
  end;
end.

