unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, ComCtrls, IniFiles;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    block: TComboBox;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    FileName: TEdit;
    Prc: TLabel;
    SizeCurrent: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    FileList: TListBox;
    FileDlg: TOpenDialog;
    Label5: TLabel;
    SizeMax: TLabel;
    Label7: TLabel;
    SizeOne: TLabel;
    Label9: TLabel;
    PPB: TPanel;
    PathE: TEdit;
    Label1: TLabel;
    DirDlg: TSelectDirectoryDialog;
    PB: TProgressBar;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    CountFor :int64;
  end;

var
  Form1: TForm1;

implementation

const
  c_b512 = 512;
  c_kb1  = c_b512 * 2;
  c_kb2  = c_kb1 * 2;
  c_kb4  = c_kb2 * 2;
  c_kb8  = c_kb4 * 2;  //5
  c_kb12 = c_kb4 * 3;
  c_kb16 = c_kb8 * 2;
  c_kb20 = c_kb4 * 5;
  c_kb24 = c_kb8 * 3;
  c_kb28 = c_kb4 * 7;  //10
  c_kb32 = c_kb16 * 2;
  c_kb48 = c_kb16 * 3;
  c_kb64 = c_kb32 * 2;
  listBytes : array[0..12] of longword = (
    c_b512, c_kb1,  c_kb2,  c_kb4,  c_kb8,
    c_kb12, c_kb16, c_kb20, c_kb24, c_kb28,
    c_kb32, c_kb48, c_kb64
  );


{$R *.lfm}

{ TForm1 }

procedure TForm1.FormResize(Sender: TObject);
begin
  IF Form1.Height < 230 then
     Form1.Height := 230;

  IF Form1.Width < 400 then
     Form1.Width := 400;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  IF DirDlg.Execute then
    PathE.Text := DirDlg.FileName;
end;

procedure TForm1.Button2Click(Sender: TObject);
var i: integer;
begin
  IF FileDlg.Execute  then //and (FileDlg.Files.Count > 0)
    for i := 0 to FileDlg.Files.Count-1 do
      FileList.Items.Append(FileDlg.Files[i]);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  IF FileList.ItemIndex >= 0 then
    FileList.Items.Delete(FileList.ItemIndex);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  fW :THandle;
  buffer :array of byte;
  fList :array of THandle;
  i, len :byte;
  ReadByte :longword;
  temp, finSize :int64;

begin
  len := FileList.Count - 1;
  IF len > 0 then begin
    fW := FileCreate(PathE.Text + '/' + FileName.Text);
    setLength(fList, len+1);
    for i := 0 to len do
      fList[i] := FileOpen(FileList.Items[i],fmOpenRead);

    ReadByte := listBytes[block.ItemIndex];
    setLength(buffer, ReadByte);

    temp := FileSize(FileList.Items[0]);
    CountFor := temp div ReadByte;
    if temp mod ReadByte > 0 then
      CountFor += 1;

    SizeOne.Caption := IntToStr(temp);
    SizeMax.Caption := IntToStr(temp * (len+1));
    SizeCurrent.Caption := '0';
    Prc.Caption := '0%';
    PPB.Visible := true;

    PB.Max := CountFor;
    PB.Position := 0;

    finSize := 0;
    while CountFor > 0 do begin
      for i := 0 to len do begin
        temp := FileRead(fList[i], buffer[0], ReadByte);
        if temp > 0 then
          FileWrite(fW, buffer[0], temp);

        finSize += temp;
      end;



      PB.Position := PB.Position + 1;
      CountFor -= 1;

      IF CountFor and $ff = $ff then begin
        Prc.Caption := Format('%.2f',[PB.Position / PB.Max * 100]) + '%';
        SizeCurrent.Caption := IntToStr(finSize);
        Application.ProcessMessages;
      end;
    end;

    PPB.Visible := false;

    for i := 0 to len do
      FileClose(fList[i]);
    FileClose(fW);

  end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  IF FileList.ItemIndex > 0 then
    FileList.Items.Move(FileList.ItemIndex,FileList.ItemIndex-1);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  IF FileList.ItemIndex < FileList.Count then
    FileList.Items.Move(FileList.ItemIndex,FileList.ItemIndex+1);
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  CountFor := 0;
end;

procedure TForm1.FormCreate(Sender: TObject);
var ini: TIniFile;
  f: string;
begin
  f := GetCurrentDir+'\DiskJoinerSetting.ini';
  IF FileExists(f) then begin
     ini := TIniFile.Create(f);
     PathE.Text := ini.ReadString('Settings','Path','');
     block.ItemIndex := ini.ReadInteger('Settings','Block',4);
     FileName.Text := ini.ReadString('Settings','ResultFileName','Temp.img');
     ini.Free;
  end;

end;

procedure TForm1.FormDestroy(Sender: TObject);
var ini: TIniFile;
  f: string;
begin
  f := GetCurrentDir+'\DiskJoinerSetting.ini';
  ini := TIniFile.Create(f);
  ini.WriteString('Settings','Path',PathE.Text);
  ini.WriteString('Settings','ResultFileName',FileName.Text);
  ini.WriteInteger('Settings','Block',block.ItemIndex);
  ini.Free;
end;

end.

