unit AJAX_CGI;
/// version 1.2
/// ==version 1.2==
///     HeadCGI,     CGI_Data
/// ==version 1.1==
///   +  :
///     * GetTimeStrSTD -        
///     * GetDayOfWeek  -     ( 0  6)
///     * GetMonth      -   
///     * TimeAdd       -     ,    
///   +   HeadCGI
///     * GMT              -  
///     * SessionID        -     (20 )
///     * SessionNew       -  True,     
///     * CreateSessionID  -      
///     * AddCookies       -     Cookie  
///
/// ==version 1.0==
interface
uses variants, sysutils, CGI_Data, unitUtils;

type 
	str2 = string[2];
	TAJAX=object//    
		private
			n      :string;
			numUrl :integer;
			function JS_(t :string) :string;
		public
			///      ,
			///      , 
			///      

			///    IFRAME,
			///     -
			///    
			///
			///  name_ -  iFrame,  
			///     
			function Create(name_ :string) :string;

			///     ,
			///      ( 
			///   , 
			///  AJAX-)
			///
			///  id - id-   ,
			///       
			///    (    
			///        
			///    'id="id-_"')
			///  param -    
			///      (   )
			///  add_ -  , 
			///       (+=,-=,*=,/=...)
			{*}function Run(id :string; param :variant; add_ :str2 = '=') :string;

			///    ()  
			///     AJAX
			///
			///  id - id- 
			///  style - Css-()
			function Vars(id :string; style :string = '') :string;

			///     
			///     iFrame,
			///      ( 
			///   , 
			///  AJAX-)
			///
			///  url - ,    
			///       ,
			///        ('')
			///       
			///     (   iFrame)
			///  tm -   ,  
			///       iFrame
			{*}function Time(url :string; tm :longword):string;

			///     (  id-
			///  ),   .
			///     
			///      
			///    
			///
			///  ON_ -   (: "OnClick",
			///    "OnDblClick","OnMouseDown",...)
			///  id - id-  /
			function Ons(ON_, id :string) :string;

			///   Ons,    
			///     AJAX. (
			///   "RunAjax(Url)")
			///
			///  URL -    
			///    ()   
			///     (   )
			function OnRun(ON_, URL :string) :string; overload;

			///  -"-"- (  "RunAjaxDef()")
			function OnRun(ON_ :string) :string; overload;

			///  -"-"- (  "RunAjax(GetUrl#())")
			///
			///  num -   -
			///    (     ),
			///        , 
			///     
			function OnRun(ON_ :string; num :integer) :string; overload;

			///      iFrame
			///
			///  URl - /
			///  JS -  ,
			///     TRUE,    
			///     "<script>"
			function Locate(URL :string; JS :boolean = true) :string;

			///     iFrame,
			///     AJAX-
			property Name :string read n;

			///    (    )
			///       iFrame
			function Target :string;

			///    JavaScript- "RunAjaxDef()"
			function createRunFunc(URL :string; JS :boolean = true) :string; overload;

			///    JavaScript- "RunAjax#()"
			function createRunFunc(num :integer; JS :boolean = true) :string; overload;

			///    JavaScript- "RunAjax(Url)"
			function createRunFunc(JS :boolean = true) :string; overload;

			///     
			///  "RunAjax(Url)"
			function RunFunc(URL :string; JS :boolean = false) :string; overload;

			///     
			///  "RunAjax(GetUrl#())" (-)
			function RunFunc(num :integer; JS :boolean = false) :string; overload;

			///     
			///  "RunAjaxDef()"
			function RunFunc(JS :boolean = false) :string; overload;

			///    JavaScript- "GetUrl#()"
			///  (-)
			///
			///  URL -  /
			///  arVar -  id- 
			///    (: [] (   get-),
			///    ['var1','var2'])
			function createUrlFunc(URL :string; arVar :array of string; JS :boolean = true) :string;

			///     -
			function IsUrlFunc(Num :longword) :boolean;

			///    -
			function UrlFunc(num :integer =- 1; JS :boolean = false):string;overload;

			///   ,   OnRun
			///  (  "RunAjax#()")
			function UrlFunc(On_ :string; num :integer =- 1; JS :boolean = false):string;overload;
	end;
	///  {*} - ,     
	///        , ..    


	AJAX_Type       = (atFrame, atAjax, atPrototype, atJQuery);
	AJAX_Set_Result = (asrVar, asrJSON);
	AJAX_Method     = (_GET, _POST);
	//AsArrayStr     = array[(__nm,__vl)]of ars;

	CAJAX = class;
	TVarAjax = class
		private
			n, t :string;
			this :CAJAX;
			par  :GrafStrArray;//AsArrayStr;
			function  getP(s:string):string;
			procedure setP(s,v:string);
			Function  par__:string;
		public
			Content :string;
			constructor Create(teg, name :string; c :CAJAX = nil);
			destructor Destroy; override;
			Function HTML :string; virtual;
			Function JS(html :boolean = true) :string; virtual;
			Function Get(html :boolean = true) :string;
			property Name :string read n;
			property Tag :string read t;
			Property Param[i :string] :string read getP write setP; default;
			Function UpDate(url, value :string; setHTML :boolean = true; _js :boolean = false):string; virtual;
	end;
	
	TDataAjax = class(TVarAjax)
		public
			constructor Create(name,value:string);
			Function HTML :string; override;
			Function JS(html :boolean = true) :string; override;
	end;
	
	TFormAjax = class(TVarAjax)
		private
			f :string;
		public
			constructor Create(name, form :string);
			property Form :string read f;
			Function HTML :string; override;
			Function JS(html :boolean = true) :string; override;
	end;

	CForm = class(TVarAjax)
		private
			ar :array of TVarAjax;
			procedure add(v :TVarAjax);
		public
			Constructor Create(name :string);
			Destructor Destroy; override;
			Function HTML :string;override;
			Function NewForm(Name :string; types :string = 'text') :TFormAjax;
			procedure NewText(Value :string);
			Procedure NewBR;
			Procedure AddVar(v :TVarAjax);
	end;

	CAJAX = class
		private
			n  :string;
			tp :AJAX_Type;
			ar :array of TVarAjax;
			function get_E(p :boolean = false) :string;
			function get_CreaterAJAX :string;
		public
			Method   :AJAX_Method;
			UpDateJS :boolean;
			Constructor Create(tip :AJAX_Type; name :string = '');
			Property Names :string read n;
			Property Types :AJAX_Type read tp;
			Function HTML :string;
			Function ForAjaxCGI :string;
			Function UpDate(FuncName, url :string; set_ :array of TVarAjax; style :AJAX_Set_Result; get_ :array of TVarAjax; html :boolean = true) :string;
			function UpDateAll(FuncName, url :string; style :AJAX_Set_Result; html :boolean = true) :string;
			function JSON(get_ :array of TVarAjax) :string;
			function JSONAll :string;
			Function New(Name :string; teg :string = 'span') :TVarAjax;
	end;

//    TQuery_Ajax_Element;
//function CreateAjaxElement(q:TQueryGet;name:


//   AJAX
var AJAX :TAJAX;
implementation

function JS_(t: string): string;
begin
	result:='<script>'+t+'</script>';
end;


{ TAJAX }

function TAJAX.Create(name_: string): string;
begin
	n      := name_;
	numUrl := 0;
	result := '<iframe name="'+n+'" src="" style="width:1px;height:1px;display:none;"></iframe>';
end;

function TAJAX.createRunFunc(JS: boolean): string;
begin
	result := 'function RunAjax(Url){'+n+'.location = Url;}';
	IF JS then result := JS_(result);
end;


function TAJAX.createRunFunc(num: integer; JS: boolean): string;
begin
	IF num < 0 then num := numUrl - 1;
	result := 'function RunAjax'+inttostr(num)+'(){'+n+
			  '.location = GetUrl'+inttostr(num)+'();}';
	IF JS then result := JS_(result);
end;

function TAJAX.createUrlFunc(URL: string; arVar: array of string;
  JS: boolean): string;
var i :integer;
begin
	result := 'function GetUrl'+inttostr(numUrl)+
			  '(){result = "'+URL+'";'#13#10;
	inc(numURL);
	IF length(arVar) > 0 then for i := low(arVar) to high(arVar) do begin
		IF i=0
			then result := result + 'result += "?'
			else result := result + 'result += "&';
		result := result + arVar[i] + '=" + ' +
				  'document.getElementById("'+arVar[i]+'").innerHTML;'#13#10;
	end;
	result := result + 'return result;}';
	IF JS then result := JS_(result);
end;

function TAJAX.IsUrlFunc(Num: longword): boolean;
begin
	result := Num < NumUrl;
end;

function TAJAX.JS_(t: string): string;
begin
	result := '<script>' + t + '</script>';
end;

function TAJAX.createRunFunc(URL: string; JS: boolean): string;
begin
	result := 'function RunAjaxDef(){'+n+'.location = "'+url+'";}';
	IF JS then result := JS_(result);
end;

function TAJAX.Locate(URL: string; JS: boolean): string;
begin
	result := n + '.location = "'+url+'";';
	IF JS then result := JS_(result);
end;

function TAJAX.OnRun(ON_, URL: string): string;
begin
	result := ' ' + ON_ + '="RunAjax('''+URL+''');"';
end;

function TAJAX.OnRun(ON_: string): string;
begin
	result := ' ' + ON_ + '="RunAjaxDef();"';
end;

function TAJAX.Ons(ON_, id: string): string;
begin
	result := ' ' + ON_ + '="document.getElementById('''+id+''').click();"';
end;

function TAJAX.Run(id: string; param: variant; add_: str2 = '='): string;
begin
	result := '<script>parent.document.getElementById("'+id+
			  '").innerHTML '+add_+' "'+VarToStr(param)+'";</script>';
end;

function TAJAX.RunFunc(JS: boolean): string;
begin
	result := 'RunAjaxDef();';
	IF JS then result:=JS_(result);
end;

function TAJAX.RunFunc(num: integer; JS: boolean): string;
begin
	IF num < 0 then num := NumUrl - 1;
	result := 'RunAjax(GetUrl'+inttostr(num)+'());';
	IF JS then result := JS_(result);
end;

function TAJAX.RunFunc(URL: string; JS: boolean): string;
begin
	result := 'RunAjax("'+URL+'");';
	IF JS then result := JS_(result);
end;

function TAJAX.Target: string;
begin
	result := 'target="'+n+'"';
end;

function TAJAX.Time(url: string; tm: longword): string;
begin
	IF url = ''
		then url := 'location'
		else url := '"'+url+'"';
	result := '<script>setTimeout(''location='+url+''','+
			  inttostr(tm * 1000)+');</script>';
end;

function TAJAX.UrlFunc(On_: string; num: integer; JS: boolean): string;
begin
	IF num < 0 then num := numUrl - 1;
	result := ' ' + ON_ + '="RunAjax'+inttostr(num)+'();"';
end;

function TAJAX.UrlFunc(num: integer; JS: boolean): string;
begin
	IF num < 0 then num := NumUrl-1;
	result := 'GetUrl' + inttostr(num) + '();';
	IF JS then result := JS_(result);
end;

function TAJAX.Vars(id, style: string): string;
begin
	result := '<div id="'+id+'" class="'+style+'"></div>';
end;

function TAJAX.OnRun(ON_: string; num: integer): string;
begin
	IF num < 0 then num := numUrl - 1;
	result := ' ' + ON_ + '="RunAjax(GetUrl'+inttostr(num)+'());"';
end;

{ CAJAX }

constructor CAJAX.Create(tip: AJAX_Type; name: string);
begin
	tp := tip;
	UpDateJS := true;
	IF name = '' then n := 'AJAX' else n := name;
end;

function CAJAX.ForAjaxCGI: string;
begin
	result := JS_(get_E(true));
end;

function CAJAX.get_CreaterAJAX: string;
begin
	result := 't.head=function(A){return a.getResponseHeader(A)};' +
			  't.status=[a.status,a.statusText];t.Type=t.head("Content-Type");' +
			  't.Text=a.responseText;switch(this.Type){case "text/xml":t.get=a.responseXML;'+
			  'case "text/json":case "text/javascript":case "application/javascript":case "application/x-javascript":t.get=eval(t.Text);'+
			  'default:t.get=t.Text}';
end;

function CAJAX.get_E(p: boolean): string;
var s :string;
begin
	if p then s := 'parent.' else s := '';
	result := 'function _(n){return '+s+'document.getElementById(n);}'+
			  'function __(f,n){return '+s+'document[f][n];}';
end;

function CAJAX.HTML: string;
var i :integer;
const run_f_b = 't.Run=function(m,u,d){';
      run_f_e = 's=t.status[0];return(s>=200&&s<300)}';
begin
	result := get_E + 'var ' + n + '=new(function(){var t=this';

	case tp of
		atFrame: result := get_E;
		atAjax: result := result + ',a;(function(){var b;' +
						'try{a=new XMLHttpRequest();b=!!a}catch(e){b=false}'+
						'if(!b)try{a=new ActiveXObject("Msxml2.XMLHTTP");b=!!a}catch(e2){b=false}'+
						'if(!b)try{a=new ActiveXObject("Microsoft.XMLHTTP");b=!!a}catch(e3){b=false}'+
						'if(!b)a=false})();if(a){'+run_f_b+
						'if(m.toLowerCase()=="get"){u+="?"+d;d=null}a.open(m,u,false);a.send(d);'+
						get_CreaterAJAX + run_f_e + '}';

		atPrototype: result := result + ';' + run_f_b + 'var x=new Ajax.Request(u,' +
							'{asynchronous:false,method:m,parameters:d,onComplete:function(a){' +
							get_CreaterAJAX + '}});' + run_f_e;

		atJQuery: result := result + ';' + run_f_b +
							'$.ajax({async:false,type:m,url:u,data:d,complete:function(a){' +
							get_CreaterAJAX + '}});' + run_f_e;
	end;
	result := JS_(result + '})();');
	IF tp = atFrame then
		result := '<iframe name="'+n+'" src="" style="width:1px;height:1px;display:none;"></iframe>' + result;
end;

function CAJAX.JSON(get_: array of TVarAjax): string;
var i :integer;
begin
	result := 'buf={';
	for i := low(0) to high(get_) do begin
		result := result + get_[i].n + ':"' + get_[i].Content + '"';
		if(i < high(get_)) then result := result + ',';
	end;
	result := result + '}';
end;

function CAJAX.JSONAll: string;
begin
	result := JSON(ar);
end;

function CAJAX.New(Name, teg: string): TVarAjax;
begin
	result := TVarAjax.Create(teg, name, self);
	SetLength(ar, length(ar) + 1);
	ar[high(ar)] := result;
end;

function CAJAX.UpDate(FuncName,url:string;set_: array of TVarAjax; style: AJAX_Set_Result;
  get_: array of TVarAjax;html:boolean=true): string;
var 
	i   :integer;
	met :string;
begin
	IF Method = _GET
		then met := 'get'
		else met := 'post';
	result := 'buf="Result=';
	case style of
		asrVar  : result := result + 'text';
		asrJSON : result := result + 'json';
	end;
	if(length(set_) > 0)then
		for i := low(0) to high(set_) do //begin
			result := result + '&' + set_[i].n + '="+' + set_[i].JS(html) + '+"';
	//if(i<high(set_)) then result:=result+'&';
	//    end;
	result := result + '";if(AJAX.Run("' + met + '","' + url + '",buf))';
	case style of
		asrVar : result := result + get_[low(get_)].JS(html) + '=AJAX.get;';
		asrJSON: begin
			result := result + 'AJAX.get;';
			if(length(get_) = 0)
				then result := result + 'for(var i in buf){h=_(i);if(h){h.innerHTML=buf[i]}}'
				else for i := low(0) to high(get_) do
					result := result + get_[i].JS(html) + '=buf.' + get_[i].n + ';';
		end;
	end;
	IF FuncName <> '' then
		result := 'function ' + FuncName + '(){' + result + '}';
	IF UpDateJS then result := JS_(result);
end;

function CAJAX.UpDateAll(FuncName, url :string; style : AJAX_Set_Result; html :boolean = true): string;
begin
	result := UpDate(FuncName, url, ar, style, ar, html);
end;

{ TAjaxVar }

constructor TVarAjax.Create(teg, name: string; c: CAJAX=nil);
begin
	t := LowerCase(teg);
	n := name;
	this := c;
	par := GrafStrArray.Create;
	//setLength(par[__nm],0);
	//setLength(par[__vl],0);
end;

destructor TVarAjax.Destroy;
begin
	par.Free;
	inherited;
end;

function TVarAjax.Get(html:boolean=true): string;
begin
	result := n + '="+' + JS(html) + '+"';
end;

function TVarAjax.getP(s: string): string;
//var i :integer;
begin
	result := '';
	s := lowerCase(s);
	result := par[s]; 
	{  IF length(par[__nm]) > 0 then
	for i := 0 to high(par[__nm])do IF s = par[__nm][i] then begin
	  result := par[__vl][i];
	  exit;
	end;//}
end;

function TVarAjax.HTML: string;
//var i :integer;
begin
	result := '<' + t + ' id="' + n + '"' + par__ + '>' + Content + '</' + t + '>';
	{  IF par.Count > 0 then for i := 0 to par.Count - 1 do
	result := result + ' ' + par.Name[i] + '=''' + par[i] + '''';
	{IF length(par[__nm]) > 0 then for i := 0 to high(par[__nm]) do
	result := result + ' ' + par[__nm][i] + '=''' + par[__vl][i] + '''';//}
end;

function TVarAjax.JS(html :boolean = true): string;
begin
	result := '_("' + n + '").inner';
	IF html
		then result := result + 'HTML'
		else result := result + 'Text';
end;

function TVarAjax.par__: string;
var i :integer;
begin
	result := '';
	IF par.Count > 0 then 
		for i := 0 to par.Count - 1 do
			result := result + ' ' + par.Name[i] + '=''' + par[i] + '''';
end;

procedure TVarAjax.setP(s, v: string);
//var i :integer;
begin
  s := lowerCase(s);
  par[s] := v;
{  IF length(par[__nm]) > 0 then
    for i := 0 to high(par[__nm]) do IF s = par[__nm][i] then begin
      par[__vl][i] := v;
      exit;
    end;
  i:=length(par[__nm]);
  setLength(par[__nm], i + 1);
  setLength(par[__vl], i + 1);
  par[__nm][i] := s;
  par[__vl][i] := v;}
end;

function TVarAjax.UpDate(url, value: string; setHTML :boolean = true; _js :boolean = false): string;
var method :string;
begin
	IF this.Method = _GET
		then method := 'get'
		else method := 'post';

	result := 'if(AJAX.Run("' + method + '","' + url + '","' + value + '"))' +
			  JS(setHTML) + '=' + this.n + '.get;';
	IF _js then result := JS_(result);
end;

{ TDataVar }

constructor TDataAjax.Create(name, value: string);
begin
	n := name;
	Content := value;
	t := '';
	this := nil;
	par := GrafStrArray.Create;
	//  setLength(par[__nm],0);
	//  setLength(par[__vl],0);
end;

function TDataAjax.HTML: string;
begin
	result:=Content;
end;

function TDataAjax.JS(html: boolean): string;
begin
	result := '"' + Content + '"';
end;

{ TFormAjax }

constructor TFormAjax.Create(name, form: string);
begin
	inherited Create('input', name);
	f := Form;
	setP('type', 'text');
end;

function TFormAjax.HTML: string;
//var i:integer;
begin
	result := '<' + t + ' name="' + n + '"' + par__ + ' value="' + Content + '">';
	{  IF par.Count > 0 then for i := 0 to par.Count - 1 do
	result := result + ' ' + par.Name[i] + '=''' + par[i] + '''';}
	//  IF length(par[__nm]) > 0 then for i := 0 to high(par[__nm]) do
	//    result := result + ' ' + par[__nm][i] + '=''' + par[__vl][i] + '''';
	//  result := result + ' value="' + Content + '">';
end;

function TFormAjax.JS(html: boolean): string;
begin
	result := '__("' + f + '","' + n + '").value';
end;

{ CForm }

procedure CForm.add(v: TVarAjax);
begin
	SetLength(ar, length(ar) + 1);
	ar[high(ar)] := v;
end;

procedure CForm.AddVar(v: TVarAjax);
begin
	Add(v);
end;

constructor CForm.Create(name: string);
begin
	Inherited Create('form', name);
	SetLength(ar, 0);
end;

destructor CForm.Destroy;
var i :integer;
begin
	IF length(ar) > 0 then
		for i := 0 to high(ar) do ar[i].Free;
	SetLength(ar, 0);
	inherited;
end;

function CForm.HTML: string;
var i :integer;
begin
	result := '<form name="'+n+'"'+par__+'>';
	IF length(ar) > 0 then 
		for i := 0 to high(ar) do
			result := result + ar[i].HTML;
	result := result + '</form>';
end;

procedure CForm.NewBR;
begin
	Add(TDataAjax.Create('--','<br>'));
end;

procedure CForm.NewText(Value: string);
begin
	Add(TDataAjax.Create(IntToStr(length(ar)),Value));
end;

function CForm.NewForm(Name: string; types :string = 'text'): TFormAjax;
begin
	result := TFormAjax.Create(Name, n);
	result['type'] := types;
	Add(result);
end;

end.
