unit CGI_Data;
{$H+}
/// ver: 1.1
/// ==version 1.1==
///    +  - TPostFileSaves,    ,
///               
///    -    ,    
///          :
///        <>.type  - MIME-  
///        <>.name  -     
///        <>.size  -     
///        <>       -    (      ),
///                       "[-]"     
///    *   HeadCGI,     AJAX_CGI
/// ==version 1.0.1==
///    -         Cookie
/// ==version 1.0+==
interface
uses sysUtils, strUtils, unitUtils, variants, classes, windows;


const
	head_html = 'text/html';
	head_css  = 'text/css';
	head_json = 'text/json';
	head_JS   = 'text/javascript';
	head_xml  = 'text/xml';


type
	TPostFileSaves = function(const MimeType : AnsiString; var PathSave, FileName: AnsiString):boolean;

	TQueryGet = class
		private
			ar: GrafStrArray;//AsArs;
			//ps,ct:integer;
			Function  getV(s :string) :string;
			Function  getVV(s :variant) :string;
			Procedure Add(nm :string; const vl :string);
			procedure init(st :string = ''); dynamic;
		public
			Constructor Create; overload;
			Constructor Create(s :string); overload;
			Property Vars[Names :string] :string read getV;
			function Values(Names :string) :ars;
			Property Value[id :variant] :string read getVV; default;
			Function IsVar(Names :string) :boolean;//    
			Function Name(num :integer) :string; //    
			function Count :integer;  //-  
			Destructor Destroy; override;
	end;

	TQueryCookie = class(TQueryGet)
		private
			procedure init(st :string = ''); override;
	end;

	TQueryPost=class(TQueryGet)
		private
			fl     :byte;
			dirdef :string;
			Func   :TPostFileSaves;
			Procedure Init(st :string = ''); override;
		public
			Constructor Create(Dirs :string = ''; isFile :TPostFileSaves = nil);
			Property CountFile :byte read fl;        // -  
			Property DefaultDir :string read dirdef; //  ,     
	end;

	HeadCGI = class
		private
			ses   :string;
			ses_n :boolean;
			ar    :GrafStrArray;
			
			function  getV(i: string): string;
			procedure setV(i: string; const Value: string);

		public
			GMT : ShortInt;
			constructor Create(const tip:string);
			destructor  destroy;override;

			Property  Value[i :string] :string read getV write setV;
			Procedure Writeln;

			property  SessionID :string read ses;
			Property  SessionNew :boolean read ses_n;
			Procedure CreateSessionID(AutoDeleteFromMinute :word = 60; newSes :boolean = false; const nameSessionVar :String = 'CGI.Session');
			Procedure AddCookies(const Nm, Val : String; AutoDeleteFromMinute: word = 0);
	end;

	function  GetTimeStrSTD(T :TDateTime; add :longword; GMT :ShortInt = 3) :string;
	Function  GetDayOfWeek(dw :byte; Ru, Max :boolean) :string;
	Function  GetMonth(m :byte; Ru, Max :boolean) :string;
	function  TimeAdd(T :TDateTime; add :longword) :TDateTime; overload;
	procedure TimeAdd(var ST :TSystemTime; add :longword); overload;


	Function  UrlToRus(const s :string) :string;
	//    (     )

	Function  GetVarArs :ars;
	Function  GetVar(s :string) :string;
	Function  GetVarCount :integer;
	Function  GetVarName(i :integer) :string;
	
var  //GetVar:Function(s:string):string; //   
	QueryGet: TQueryGet;               //    GET
	QueryCookie: TQueryCookie;         //    Cookie
	EnvVar: GrafStrArray;
{     POST  
    TQueryPost:

  var Post :TQueryPost;
  begin
    Post := TQueryPost.Create('LoadFile');
    ...
    Post.Free;
  end
}
implementation

function TimeAdd(T :TDateTime; add :longword) :TDateTime; overload;
var st: TSystemTime;
begin
	DateTimeToSystemTime(T, st);
	TimeAdd(st, add);
	result := SystemTimeToDateTime(st);
end;

procedure TimeAdd(var ST :TSystemTime; add :longword); overload;
var i: byte;
begin
	st.wMinute := st.wMinute + add;
	IF st.wMinute > 59 then begin
		st.wHour := st.wHour + st.wMinute div 60;
		st.wMinute := st.wMinute mod 60;
		IF st.wHour > 23 then begin
			st.wDay := st.wDay + st.wHour div 24;
			st.wHour := st.wHour mod 24;
			case st.wMonth of
				1,3,5,7,8,10,12: i := 31;
				4,6,9,11: i := 30;
				2: IF st.wYear mod 4 = 0 then i := 29 else i := 28;
			end;
			IF st.wDay>i then begin
				st.wMonth := st.wMonth + (st.wDay - 1) div i;
				st.wDay := ((st.wDay - 1)mod i) + 1;
				IF st.wMonth>12 then begin
					st.wYear := st.wYear + (st.wMonth - 1)div 12;
					st.wMonth := ((st.wMonth - 1)mod 12) + 1;
				end;
			end;
		end;
	end;
end;

Function GetMonth(m :byte; Ru, Max :boolean) :string;
type Lang = array[0..11]of string;
const
	_RU_1 :Lang = ('','','','','','','','','','','','');
	_RU_2 :Lang = ('','','','','','','','','','','','');
	_EN_1 :Lang = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	_En_2 :Lang = ('January','February','March','April','May','June','July','August','September','Octember','November','December');
begin
	IF Max then begin
		IF Ru
			then result := _RU_2[m mod 12]
			else result := _EN_2[m mod 12];
	end else 
		IF Ru
			then result := _RU_1[m mod 12]
			else result := _EN_1[m mod 12];
end;

function GetDayOfWeek(dw :byte; Ru, Max :boolean) :string;
type Lang = array[0..6]of string;
const
	_RU_1 :Lang = ('','','','','','','');
	_EN_1 :Lang = ('Mon','Tue','Wed','Thu','Fri','Sat','Sun');
	_RU_2 :Lang = ('','','','','','','');
	_EN_2 :Lang = ('Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday');
begin
	IF Max then begin
		IF Ru
			then result := _RU_2[dw and 7]
			else result := _EN_2[dw and 7];
	end else 
		IF Ru
			then result := _RU_1[dw and 7]
			else result := _EN_1[dw and 7];
end;

function GetTimeStrSTD(T :TDateTime; add :longword; GMT :ShortInt) :string;
var st :TSystemTime;
begin
	DateTimeToSystemTime(Date + Time,st);
	TimeAdd(st, add);
	result := GetDayOfWeek( (trunc(SystemTimeToDateTime(st) - 2)mod 7)
							,false,false) + ', ' +
			  IntToStr(st.wDay) + '-' + GetMonth(st.wMonth - 1,false,false) +
			  '-' + To_s(st.wYear,4) + ' ' + To_s(st.wHour,2) + ':' +
			  To_s(st.wMinute,2) + ':' + To_s(st.wSecond,2) + ' GMT';

	IF GMT > 0 then result := result + '+';
	result := result + To_s(GMT, 0);
end;

Function GetVar(s: string):string;
begin
	result := EnvVar[s];//AdrToStr(EnvVar[s]);
end;

Function GetVarCount:integer;
begin
	result := EnvVar.Count;
end;

Function GetVarName(i:integer):string;
begin
	result := EnvVar.Name[i];
	IF EnvVar.Errors then result := '-"-"-';
end;

Function GetVarArs:ars;
var p: pchar;
begin
	//  result:=String(GetEnvironmentStrings);
	SetLength(result,0);
	p := GetEnvironmentStrings;
	while p^ <> #0 do begin
		AppendArs(result,string(p));
		inc(p, lStrLen(p) + 1);
	end;
end;

function HexInt(c:char;h:boolean=false):byte;
const _hex: string[16] = '0123456789ABCDEF';
begin
	c := UpCase(c);
	result := pos(c, _hex) - 1;
	IF h then result := result shl 4;
end;

Function UrlToRus(const s:string):string;
var i: longword;//b:byte;
begin
	result := ''; 
	i := 1;
	While i <= length(s) do begin
		case s[i] of
			'%':begin
				//t:='$'+ s[i+1] +s[i+2];
				//b:=StrToIntDef('$'+ s[i+1] +s[i+2],0);
				//b:=HexInt(s[i+1],true)or HexInt(s[i+2]);
				result := result + char(HexInt(s[i + 1], true) or HexInt(s[i + 2]));
				inc(i, 2);
			end;
			'+': result := result + ' ';
			//'_':result := result + '_';
			else result := result + s[i];
		end;
		inc(i);
	end;
end;



{ HeadCGI }

procedure HeadCGI.AddCookies(const Nm, Val: String; AutoDeleteFromMinute: word);
var s: string;
begin
	IF AutoDeleteFromMinute = 0
		then s := ''
		else s := '; expires=' + GetTimeStrSTD(Date + Time, AutoDeleteFromMinute, GMT);

	ar.Add('Set-Cookie', nm + '=' + val + s );
end;

constructor HeadCGI.Create(const tip:string);
begin
	ar := GrafStrArray.Create;
	ar['Content-Type'] := tip;//@tip[1];
	ses := '';
	ses_n := false;
	GMT := 3;
end;

procedure HeadCGI.CreateSessionID(AutoDeleteFromMinute:word; newSes:boolean; const nameSessionVar:String);
var
	i  : longword; 
	s  : string;
	//ini:TIniFile;ls:TStringList;
	dt : tDatetime;

	function _RND :char; 
	CONST r:string= '0123456789AbCdEfGhIjKlMnOpQrStUvWxYz_~`@#$^''[]{}'+
							'aBcDeFgHiJkLmNoPqRsTuVwXyZ' ;
	begin
		result := r[random(Length(r)) + 1];
	end;

	function _RND_(n:byte):string;
	begin
		result:='';
		IF n > 0 then
			for n := 1 to n do 
				result := result + _RND;
	end;
begin
	ses := '';
	ses_n := newSes or not QueryCookie.IsVar(nameSessionVar);

	IF ses_n
		then ses := _RND_(20)
		else ses := QueryCookie[nameSessionVar];

	AddCookies(nameSessionVar, ses, AutoDeleteFromMinute);
end;

destructor HeadCGI.destroy;
begin
	ar.Free;
	inherited;
end;

function HeadCGI.getV(i: string): string;
begin
	result := ar[i];//AdrToStr(ar[i]);
end;

procedure HeadCGI.setV(i: string; const Value: string);
begin
	IF value <> '' then ar[i] := Value else ar[i] := '';//@Value[1] else ar[i]:=pchar('');
end;

procedure HeadCGI.Writeln;
var i: integer;
begin
	for i := 0 to ar.Count - 1 do
		system.writeln(ar.Name[i], ': ', ar[i]);//AdrToStr(ar[i]));
	system.writeln;
end;


{ TQueryGet }

procedure TQueryGet.Add(nm:string; const vl:string);
begin
	ar.Add(nm, vl);
end;

constructor TQueryGet.Create;
begin
	ar := GrafStrArray.Create;
	Init;
end;

function TQueryGet.Count: integer;
begin
	result := ar.Count;
end;

constructor TQueryGet.Create(s: string);
begin
	ar := GrafStrArray.Create;
	Init(s);
end;

destructor TQueryGet.Destroy;
begin
	ar.Free;
	inherited;
end;

function TQueryGet.getV(s: string): string;
begin
	IF ar.IsName(s) then result := ar.Str else result := '';
end;

function TQueryGet.getVV(s: variant): string;
begin
	result := ar[s];
end;

function TQueryGet.Values(Names: string): ars;
var i: integer; a: ArInt;
begin
	a := ar.IndexNameAll(Names);
	Setlength(result, length(a));
	IF length(a) > 0 then
	for i := 0 to high(a) do result[i] := ar.Name[a[i]];
	SetLength(a, 0);
end;

procedure TQueryGet.init(st:string='');
var s, t: string; a:ars; i, j: integer;
begin
	IF st = '' then s := GetVar('QUERY_STRING') else s := st;
	IF s <> '' then begin
		a := Split(s, '&');
		for i := 0 to high(a) do begin
			j := pos('=', a[i]);
			IF j > 0 then begin
				t := copy(a[i], 1, j - 1);
				s := copy(a[i], j + 1, length(a[i]));
			end else begin t := a[i]; s := t; end;
			Add(UrlToRus(t), UrlToRus(s));
		end;
	end;
end;

function TQueryGet.IsVar(Names: string): boolean;
begin
	result := ar.IsName(names);
end;

function TQueryGet.Name(num: integer): string;
begin
	result := ar.Name[num];
end;

{ TQueryCookie }
procedure TQueryCookie.init(st:string='');
var s: string; a: ars; i: integer;
begin
	IF st = '' then s := GetVar('HTTP_COOKIE') else s := st;
	IF s <> '' then begin
		a := Split(s, '; ');
		for i := 0 to high(a) do 
			Inherited Init(a[i]);
	end;
end;

{ TQueryPost }


constructor TQueryPost.Create(Dirs: string='';isFile:TPostFileSaves=nil);
begin
	dirdef := Dirs;
	fl := 0;
	Func := isFile;
	inherited Create;
end;

procedure TQueryPost.Init(st: string);
var s, t, tt :string; 
	i        : integer; 
	c        : char;

    Stream   : THandleStream;

    ii       : int64;
    dStart, 
	dFSave, 
	ln, 
	EndDataIs: boolean;

    a        : ars;
    fname, 
	varname  : string;
    f        : file of byte;


	procedure __addChar(cc: char);
	begin
		IF fname = ''
			then s := s + cc
			else IF dFSave
				then write(f, byte(cc));
	end;

begin
	IF st = '' then begin
		s := GetVar('REQUEST_METHOD');
		IF s = 'POST' then begin
			s := GetVar('CONTENT_LENGTH');
			tt := LowerCase(GetVar('CONTENT_TYPE'));
			IF pos('multipart/form-data; boundary=', tt) > 0 then begin
				tt := GetVar('CONTENT_TYPE');
				delete(tt, 1, 30);
				tt := '--' + tt;
				t := '';
				dStart := false;
				dFSave := false;
				EndDataIs := false;
				SetLength(a,1);
				ii := StrToInt64Def(s,0) - 1;
				s := '';
				Stream := THandleStream.Create(GetStdHandle(STD_INPUT_HANDLE));
				try 
					while ii > 0 do begin
						Stream.Read(c, 1);
						IF dStart then begin
							IF EndDataIs then begin
								t := t + c;
								IF t = #13 then begin
									EndDataIs := false;
									__addChar(#13);
									__addChar(#10);
									ln := true;
									t := '';
								end else IF tt = t then begin
									EndDataIs := false;
									dStart := false;
									IF fname = '' then begin
										Add(varname, s);
										s := '';
									end else begin
										Add(varname + '.size', IntToStr(FileSize(f)));
										CloseFile(f);
									end;
									t := '';
									Stream.Read(c,1);
									Stream.Read(c,1);
									dec(ii,2);
									SetLength(a,2);
									a[1] := '';
								end else IF LeftStr(tt, Length(t)) <> t then begin
									__addChar(#13);
									__addChar(#10);
									for i:= 1 to length(t) do
										__addChar(t[i]);
									EndDataIs := false;
									t := '';
								end;
							end else IF c = #13 then begin
								IF ln
									then __addChar(#13)
									else ln := true;
							end else IF c = #10 then begin
								IF ln
									then EndDataIs := true
									else __addChar(#10);
								ln := false;
							end else begin
								IF ln then begin
									__addChar(#13);
									ln := false;
								end;
								__addChar(c);
							end;
						end else begin
							IF ln and(c = #10) then begin
								IF a[high(a)] = '' then begin
									dStart := true;
									delete(a[1],1,38);
									varname := copy(a[1], 1, pos('"',a[1]) - 1);
									delete(a[1], 1, Length(varname) + 1);

									dFSave := pos('filename',a[1]) > 0;
									IF dFSave then begin
										delete(a[1], 1, pos('"', a[1]));
										fname := ExtractFileName( copy(a[1], 1, pos('"', a[1]) - 1));
										t := AnsiLowerCase(copy(a[2], 15, Length(a[2])));
										s := StringReplace(dirdef, '\', '/', [rfReplaceAll]) + '/';
										Add(varname + '.type', t);
										IF(not Assigned(Func))or Func(t, s, fname)
										then begin
											Add(varname, s + fname);
											Add(varname + '.name',fname);
											assignfile(f, s + fname);
											rewrite(f);
											inc(fl);
										end else begin
											dFSave := false;
											Add(varname, '[-]');
											Add(varname + '.name', fname);
										end;
									end else fname := '';
								end else begin
									SetLength(a, Length(a) + 1);
									a[high(a)] := '';
								end;
								ln := false;
								t := '';
								s := '';
							end else
								IF c = #13
									then ln := true
									else a[high(a)] := a[high(a)] + c;
						end;
						dec(ii);
					end;
				except end;
				Stream.Free;
			end else begin
				t := '';
				for i := 1 to strtointdef(s,0) do begin
					read(c);
					t := t + c;
				end;
				Inherited Init(t);
			end;
		end;
	end else inherited Init(st);
end;

var 
	_a_ : ars; 
	i   : integer; 
	s   : string;
initialization
	//@GetVar := @GetEnvironmentVariable;
	EnvVar := GrafStrArray.Create;
	_a_ := GetVarArs;
	IF length(_a_) > 0 then
		for i := 0 to high(_a_) do begin
			s := copy(_a_[i], 1, pos('=', _a_[i]) - 1);
			delete(_a_[i], 1, length(s) + 1);
			EnvVar[s] := _a_[i];
		end;
	QueryGet := TQueryGet.Create;
	QueryCookie := TQueryCookie.Create;

finalization
	QueryGet.Free;
	QueryCookie.Free;
	EnvVar.Free;
end.

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
ver 1.0+
+     
