unit ClipWord;
interface
uses windows, clipbrd, sysUtils;
/// version 1.1.1_1
/// ==version 1.1.1_1==
/// - Replace, ToEndNum -  ,        
///
/// ==version 1.1.1==
/// * Replace    -      
/// * CopyBuf    -   add_buf
/// ==version 1.1==
/// *  
///   + StrToRtf  -    Rtf- (      16- )
/// *   CW
///   + CopyBuf   -     ,   
///   + ToEndNum  -    
///   + Replace   -     ,      Rtf-
/// ==version 1.0==
///   
type
	tt = string;

type 
	ClipWords=Class
	private
		MemHandle :THandle;
		ar        :array of tt;
		max,
		num,
		bnum      :byte;
		procedure setMax(b :byte);
		procedure setNum(b :byte);
		procedure setBNum(b :byte);
		function  getAr(n :byte) :tt;
		procedure setAr(n :byte; s :tt);
	public
		property  Count :byte read max write setMax;
		property  Index :byte read num write setNum;
		property  BackIndex :byte read bnum write setbnum;
		property  Buffer[n :byte] :tt read getAr write setAr; default;
		function  Empty :boolean;
		procedure AddBuf;
		procedure Buf;
		procedure Clear;
		procedure Next;
		procedure Prev;
		procedure Back;
		function  ActiveNum :tt;

		procedure CopyBuf(numIn :byte; add_Buf :boolean = false; numOut :byte = 255);
		procedure ToEndNum;
		procedure Replace(OldStr, NewStr :string; nums :byte = 255); overload;
		procedure Replace(arRep :array of string; nums :byte = 255); overload;

		Constructor Create;
		Destructor destroy; override;

	end;

	function StrToRtf(const s :string) :string;

var CF_RTF :word;
    CW     :ClipWords;
implementation

function strToRtf(const s :string) :string;
{      ,    RTF- }
var i :integer;
begin
	result := '';
	IF s <> '' then
		for i := 1 to length(s) do case s[i] of
			''..'',''..'','','': result := result + '\''' + lowercase(intToHex(byte(s[i]), 2));
			else result := result + s[i];
		end;
end;

{======================}

function ClipWords.Empty;
begin
	result := max = 0;
end;

procedure ClipWords.AddBuf;
var i :longword; s :Pointer;
begin
	with Clipboard do begin
		if HasFormat(CF_RTF) then begin
			MemHandle := GetAsHandle(CF_RTF);
			IF MemHandle = 0 then exit;
			inc(max);
			setlength(ar, max);
			ar[max-1] := strpas(GlobalLock(MemHandle));
			GlobalUnlock(MemHandle);
		end;
	end;
end;

procedure ClipWords.Buf;
begin
	with Clipboard do begin
		MemHandle := GlobalAlloc(GHND or GMEM_SHARE, Length(ar[num]) + 1);
		if MemHandle <> 0 then begin
			StrCopy(GlobalLock(MemHandle), pchar(ar[num]));
			GlobalUnlock(MemHandle);
			Open;
			try
				SetAsHandle(CF_RTF, MemHandle);
			finally
				Close;
			end;
		end;
	end;
end;

procedure ClipWords.setMax;
begin
	setLength(ar, b);
	max := b;
end;

procedure ClipWords.setNum;
begin
	IF(max > 0) and (b < max) then begin
		bnum := num;
		num := b;
		buf;
	end else num := 0;
end;

procedure ClipWords.ToEndNum;
begin
	IF(max > 0) and (num < max) then begin
		bnum := num;
		num := max - 1;
	end else num:=0;
end;

procedure ClipWords.setBNum;
begin
	IF(max > 0) and (b < max)then bnum := b;
end;

procedure ClipWords.Clear;
begin
	setlength(ar, 0);
	max  := 0;
	num  := 0;
	bnum := 0;
end;

procedure ClipWords.CopyBuf(numIn :byte; add_Buf :boolean = false; numOut :byte = 255);
var
	s :string;
	i :byte;
const t :string = '_+?#%0123456789';
begin
	s := StringReplace(CW[numIn], #13#10'\''', '\''', [rfReplaceAll]);
	i := 1;
	for i := 1 to length(t) do
		s := StringReplace(StringReplace(
							s, #13#10 + t[i], t[i], [rfReplaceAll]),
							t[i] + #13#10, t[i], [rfReplaceAll]);

	IF numOut = 255 then numOut := num;
	IF add_Buf
		then CW[numOut] := CW[numOut] + s
		else CW[numOut] := s;
end;

constructor ClipWords.Create;
begin
	clear;
end;

destructor ClipWords.destroy;
begin
	clear;
	inherited;
end;

procedure ClipWords.Next;
begin
	IF(max > 0) and (num + 1 < max) then begin
		bnum := num;
		inc(num);
		buf;
	end;
end;

procedure ClipWords.Prev;
begin
	IF(max > 0) and (num > 0) then begin
		bnum := num;
		dec(num);
		buf;
	end;
end;

procedure ClipWords.Replace(arRep: array of string; nums: byte);
var i :byte;
begin
	IF nums = 255 then nums := num;
	IF(max > 0) and (nums < max) and (Length(arRep) and 1 = 0) then begin
		i := 0;
		while i < length(arRep) do begin
			ar[nums] := StringReplace(ar[nums], strToRtf(arRep[i]), strToRtf(arRep[i + 1]),[]);
			inc(i, 2);
		end;
	end;
end;

procedure ClipWords.Replace(OldStr, NewStr: string; nums: byte=255);
begin
	IF nums = 255 then nums:=num;
	IF(max > 0) and (nums < max)then
		ar[nums] := StringReplace(ar[nums], strToRtf(OldStr), strToRtf(NewStr), []);
end;

procedure ClipWords.Back;
var b :byte;
begin
	b := num;
	num := bnum;
	bnum := b;
	buf;
end;

procedure ClipWords.setAr;
begin
	IF(max > 0) and (n < max) then ar[n] := s;
end;

function ClipWords.getAr;
begin
	IF(max > 0) and (n < max)then result := ar[n];
end;

function ClipWords.ActiveNum;
begin
	IF max > 0 then result := ar[num] else result := '';
end;

initialization
	CF_RTF := RegisterClipboardFormat('Rich Text Format');
	if CF_RTF = 0 then halt;
	CW := ClipWords.Create;
finalization
	CW.Free;
end.
