﻿unit ExcelTool;
///version 1.3
/// === version 1.3 ===
///  * Начало адаптации под office 2007
///  * Добавление возможности интеграции объекта Excel
///    из других программных продуктов
///  * исправлинаа проблема связана с визуальным переключение на книгу или лист
///  * изменение функциональности некоторых функций, а именно
///    * ColIsNumToStr  - снятие ограничения (было 256)
///    * ColIsStrToNum  - снятие ограничения (было 2 символа)
///  + Добавление новой функциональности в TExcelTools, а именно:
///    * AddChart      - создание новой диаграммы
///    * CountShapes   - количество диаграмм/обектов на листе
///    * ShapesAsChart - получить встроенный объект как диаграмму
///    * SetFixedCells - Фиксирование ячеек с право и сверху указанной ячейки
///    * Version       - возвращает номер версии
///  + Новый тип TExcelChartFormat
///    * ChartType         - Изменение типа диаграммы
///    * SetSourceData     - установка области данных
///    * Name              - имя диаграммы
///    * Legend            - отображать легенду или нет
///    * LegendPositions   - расположение легенты, с автоматическим распределением размера
///    * LegendPosition    - изменить позицию легенды диаграммы
///    * LegendSize        - изменить размер легенды диаграммы
///    * LegendShadow      - тень легенды
///    * LegendIncludeInLayout - включен ли мокет
///    * LegendFormat      - настройка формата легенды
///    * Title             - отображать заголовок или нет
///    * TitlePosition     - изменить позицию заголовка диаграммы
///    * TitleFormat       - настройка формата заголовка диаграммы
///    * PlotAreaPosition  - изменить позицию изображения диаграммы
///    * PlotAreaSize      - изменить размер изображения диаграммы
///    * PlotAreaFormat    - настройка формата изображения диаграммы
///    * ChartAreaFormat   - настройка формата диаграммы
///    * CreateDataLabels  - Функция для зоздания отображающихся значения
///                          диаграммы рядом с соответствующими долями
///  + Новый тип TExcelChartFormatStyle
///    * OneColorGradient  - установка одноцветного (хотя почемуто он там делает больше 2 цветов) градиента
///    * TwoColorGradient  - установка двухцветного градиента
///    * Solid             - Сплошная заливка
///    * ColorBack         - первый цвет (задний цвет)
///    * ColorFore         - второй цвет (передний цвет)
///    * TransparensyBackGround - прозрачность фона
/// === version 1.2.1 ===
///  * исправленно изменение размера окна коментарий (был ввод "см" теперь "мм")
///  * исправленно ловля исключения(ошибки) при присвоении формул создающих ошибку
///  * устранина ситуация зависания, при изменении ячейки, которая вызывает диалоговое окно
///  * устранена ошибка функции ColIsNumToStr, при указании числа более 256.
///      Теперь при подопной ситуации будет происходить повторный круг
///      (т.е.: 257 => 1;  266 => 10)
/// === version 1.2 ===
/// + Добавлены слудующие функции
///   для TExcelTools:
///     * AddComment
///     * DeleteComment
///     * Comment
///     * CommentCell
///     * CommentRange
///     * CommentCells
///     * CommentVisible
///     * CommentVisibleCell
///     * CommentVisibleRange
///     * CommentVisibleCells
///     * CommentFormat
///     * CommentSize
/// + добавлен TExcelFontFormat как родитель TExcelFormat:
/// === version 1.1 ===
/// + Добавлены слудующие функции
///   для TExcelTools:
///     * Cut            - вырезать
///     * Copy           - копировать
///     * Paste          - вставить
///     * ClearContents  - очистить
///     * Makros         - запустить макрос
///   для TExcelFormat:
///     * Merge          - Обьеденить/разоединить ячейки
///===
interface
uses windows,Sysutils,variants;

type
  TExcelFontFormat=class;
  TExcelFormat=class;
  TExcelChartFormat=class;
  TExcelChartFormatStyle = class;

  ExcelBorderType=(ex_DiagDown,ex_DiagUp,ex_Bottom,ex_Left,ex_Right,ex_Top,
                   ex_Horizontal,ex_Vertical);
  ExcelBorderStyle=(ex_None,ex_Single,ex_Dash,ex_DashDot,ex_DashDotDot,ex_Dot,
                    ex_Double,ex_SlantDashDot);
  ExcelBorderWeight=(ex_Hairline,ex_Medium,ex_Thick,ex_Thin);
  ExcelHorizontalAlign=(ex_h_Left,ex_h_Right,ex_h_Center);
  ExcelVerticalAlign=(ex_v_Top,ex_v_Bottom,ex_v_Center);
  ExcelUnderLine=(ex_us_None,ex_us_Double,ex_us_DoubleAccounting,
                             ex_us_Single,ex_us_SingleAccounting);

  ExcelChartType = (
    xl3DArea, xl3DAreaStacked, xl3DAreaStacked100,
    xl3DBarClustered, xl3DBarStacked, xl3DBarStacked100,
    xl3DColumn, xl3DColumnClustered, xl3DColumnStacked, xl3DColumnStacked100,
    xl3DLine,
    xl3DPie, xl3DPieExploded,
    xlArea, xlAreaStacked, xlAreaStacked100,
    xlBarClustered, xlBarOfPie, xlBarStacked, xlBarStacked100,
    xlBubble, xlBubble3DEffect,
    xlColumnClustered, xlColumnStacked, xlColumnStacked100,
    xlConeBarClustered, xlConeBarStacked, xlConeBarStacked100,
    xlConeCol, xlConeColClustered, xlConeColStacked, xlConeColStacked100,
    xlCylinderBarClustered, xlCylinderBarStacked, xlCylinderBarStacked100,
    xlCylinderCol, xlCylinderColClustered, xlCylinderColStacked, xlCylinderColStacked100,
    xlDoughnut, xlDoughnutExploded,
    xlLine,
    xlLineMarkers, xlLineMarkersStacked, xlLineMarkersStacked100,
    xlLineStacked, xlLineStacked100,
    xlPie, xlPieExploded, xlPieOfPie,
    xlPyramidBarClustered, xlPyramidBarStacked, xlPyramidBarStacked100,
    xlPyramidCol, xlPyramidColClustered, xlPyramidColStacked, xlPyramidColStacked100,
    xlRadar, xlRadarFilled, xlRadarMarkers,
    xlStockHLC, xlStockOHLC, xlStockVHLC, xlStockVOHLC,
    xlSurface, xlSurfaceTopView, xlSurfaceTopViewWireframe, xlSurfaceWireframe,
    xlXYScatter, xlXYScatterLines, xlXYScatterLinesNoMarkers,
      xlXYScatterSmooth, xlXYScatterSmoothNoMarkers
  );
  ExcelChartBarShape = (
    xlBox, xlConeToMax, xlConeToPoint, xlCylinder, xlPyramidToMax, xlPyramidToPoint
  );

  ExcelChartLegendPosition = (
    xlLegendPositionBottom, xlLegendPositionCorner, xlLegendPositionCustom,
    xlLegendPositionLeft, xlLegendPositionRight, xlLegendPositionTop
  );

  ExcelChartFormatGradientStyle = (
    xlGradientDiagonalDown, xlGradientDiagonalUp, xlGradientFromCenter,
    xlGradientFromCorner, xlGradientFromTitle, xlGradientHorizontal,
    xlGradientMixed, xlGradientVertical
  );

  TExcelTools=class
       private
         E,B,S_,r:OLEVariant;
         BRes,_v,nn,isLoad:boolean;
          procedure setRange(const rg:string);overload;
          procedure setRange(const rg1,rg2:string);overload;
          procedure setRange(x,y:integer);overload;


         Procedure setV(v:boolean);
          Function getW:double;
         Procedure setW(i:double);
          Function getH:double;
         Procedure setH(i:double);
          Function getL:double;
         Procedure setL(i:double);
          Function getT:double;
         Procedure setT(i:double);

          Function getCell(x,y:integer):variant;
         Procedure setCell(x,y:integer;v:variant);
          Function getRg(rg:string):variant;
         Procedure setRg(rg:string;v:variant);
          Function getRng(rgst,rgfn:string):variant;
         Procedure setRng(rgst,rgfn:string;v:variant);

          Function getShNm(num:integer):string;
         Procedure setShNm(num:integer;s:string);
          Function getBkNm(num:integer):string;
         Procedure setBkNm(num:integer;s:string);
          Function getBkFNm(num:integer):string;
         Procedure setBkFNm(num:integer;s:string);

          Function getNm(num:integer):string;
         Procedure setNm(num:integer;s:string);
          Function getNames:string;
          procedure setNames(s:string);

          Function getFl(nm:variant):TExcelTools;

          function getCmt(rg: string): string;
          function getCmtC(x, y: integer): string;
          function getCmtR(rg1, rg2: string): string;
          function getCmtV(rg: string): boolean;
          function getCmtVC(x, y: integer): boolean;
          function getCmtVR(rg1, rg2: string): boolean;
          procedure setCmt(rg: string; const V: string);
          procedure setCmtC(x, y: integer; const V: string);
          procedure setCmtR(rg1, rg2: string; const V: string);
          procedure setCmtV(rg: string; const V: boolean);
          procedure setCmtVC(x, y: integer; const V: boolean);
          procedure setCmtVR(rg1, rg2: string; const V: boolean);
          function getCmts: string;
          function getCmtsV: boolean;
          procedure setCmts(const V: string);
          procedure setCmtsV(const V: boolean);
       public
         wRect:TRect;
         Constructor Create;
         Procedure Clear;

         property Excel:OleVariant read E;
         property aBook:OLEVariant read B;
         property aSheild:OLEVariant read S_;
         property aRange:OLEVariant read r;
         property Visible:boolean read _v write setv;
         Function Version:String;


         Procedure getRect;
         Procedure setRect;
          property Width:double read getW write setW;
          property Height:double read getH write setH;
          property Left:double read getL write setL;
          property Top:double read getT write setT;

          Function BookOpen(NameFile:string):boolean;
          Function BookAdd:boolean;
          Function BookClose:boolean;
          Function BooksClose:boolean;
          Function BookSaveAs(NameFile:string):boolean;
          Function BookSave:boolean;
          Function BookActive(nm:variant):boolean;
          Property BookName[nm:integer]:string read getBkNm write setBkNm;
          Property BookFullName[nm:integer]:string read getBkFNm write setBkFNm;
          Function BookCount:integer;

          Function SheildAdd(nm:string):boolean;
          Function SheildDel(nm:variant):boolean;
          Function SheildCount:integer;
          Property SheildName[nm:integer]:string read getShNm write setShNm;
          Function SheildSelect(num:variant):boolean;

          Property Cells[x,y:integer]:variant read getCell write setCell;
          Property Cell[Rg:string]:variant read getRg write setRg;
          Property Range[RgBgn,RgEnd:string]:variant read getRng write setRng;

          Property From[nm:variant]:TExcelTools read getFl;default;
          Property Name[num:integer]:string read getNm write setNm;

          Property Names:string read getNames write setNames;
          Function FullName:string;

          function Book(nm:variant):TExcelTools;
          function Sheild(nm:variant):TExcelTools;
          function Activate:TExcelTools;
          Property Act:TExcelTools read Activate;
          function Select:TExcelTools;
          Property Sel:TExcelTools read Select;

          Function Format(rg:string):TExcelFormat;overload;
          Function Format(rg1,rg2:string):TExcelFormat;overload;
          Function Format(x,y:integer):TExcelFormat;overload;

          Function AddChart:TExcelTools;overload;
          Function AddChart(_Left, _Top:Integer):TExcelTools;overload;
          Function AddChart(_Left, _Top, _Width, _Height: Integer):TExcelTools;overload;
          Function CountShapes:integer;
          Function ShapesAsChart(Num:integer = 0):TExcelChartFormat;overload;
          Function ShapesAsChart(Names: String):TExcelChartFormat;overload;

          function synBook:TExcelTools;
          function synSheild:TExcelTools;

          function ActiveBook:OLEVariant;
          function ActiveSheild:OLEVariant;

          function Cut(const rg:string):TExcelTools;overload;
          function Cut(const rg1,rg2:string):TExcelTools;overload;
          function Cut(x,y:integer):TExcelTools;overload;

          function Paste(const rg:string):TExcelTools;overload;
          function Paste(const rg1,rg2:string):TExcelTools;overload;
          function Paste(x,y:integer):TExcelTools;overload;

          function Copy(const rg:string):TExcelTools;overload;
          function Copy(const rg1,rg2:string):TExcelTools;overload;
          function Copy(x,y:integer):TExcelTools;overload;

          function AddComment(const rg:string):TExcelTools;overload;
          function AddComment(const rg1,rg2:string):TExcelTools;overload;
          function AddComment(x,y:integer):TExcelTools;overload;

          function DeleteComment(const rg:string):TExcelTools;overload;
          function DeleteComment(const rg1,rg2:string):TExcelTools;overload;
          function DeleteComment(x,y:integer):TExcelTools;overload;

          Property Comment:string read getCmts write setCmts;
          Property CommentCell[rg:string]:string read getCmt write setCmt;
          Property CommentRange[rg1,rg2:string]:string read getCmtR write setCmtR;
          Property CommentCells[x,y:integer]:string read getCmtC write setCmtC;

          Property CommentVisible:boolean read getCmtsV write setCmtsV;
          Property CommentVisibleCell[rg:string]:boolean read getCmtV write setCmtV;
          Property CommentVisibleRange[rg1,rg2:string]:boolean read getCmtVR write setCmtVR;
          Property CommentVisibleCells[x,y:integer]:boolean read getCmtVC write setCmtVC;

          Function CommentFormat(start,len:integer):TExcelFontFormat;overload;
          Function CommentFormat(const rg:string;start,len:integer):TExcelFontFormat;overload;
          Function CommentFormat(const rg1,rg2:string;start,len:integer):TExcelFontFormat;overload;
          Function CommentFormat(x,y,start,len:integer):TExcelFontFormat;overload;

          Function CommentSize(W,H:integer):TExcelTools;overload;
          Function CommentSize(const rg:string;W,H:integer):TExcelTools;overload;
          Function CommentSize(const rg1,rg2:string;W,H:integer):TExcelTools;overload;
          Function CommentSize(x,y,W,H:integer):TExcelTools;overload;

          Function ClearContents(const rg:string):TExcelTools;overload;
          function ClearContents(const rg1,rg2:string):TExcelTools;overload;
          function ClearContents(x,y:integer):TExcelTools;overload;

          Function SetFixedCells(const rg:string):boolean;overload;
          Function SetFixedCells(x,y:integer):boolean;overload;

          function LastRow:integer;
          function LastCol:integer;

          Function Open:boolean;
          Function Load(fromWordsExcel:OleVariant):boolean;
          Function Close:boolean;

          Function Makros(const s:string):TExcelTools;
     end;


  TExcelChartFormat = class
    private
      th:TExcelTools;
      chrt:OleVariant;
      function getCT: ExcelChartType;
      procedure setCT(const Value: ExcelChartType);
      function getNm: String;
      procedure setNm(const Value: String);
      function getLH: Boolean;
      procedure setLH(const Value: Boolean);
      function getLIL: Boolean;
      procedure setLIL(const Value: Boolean);
      function getL: Boolean;
      procedure setL(const Value: Boolean);
      function getT: Boolean;
      procedure setT(const Value: Boolean);
      function getR: Variant;
      procedure setR(const Value: Variant);
      function getBS: ExcelChartBarShape;
      procedure setBS(const Value: ExcelChartBarShape);
      function getLP: ExcelChartLegendPosition;
      procedure setLP(const Value: ExcelChartLegendPosition);
    public
      Constructor Create(E:TExcelTools);
      Property This:TExcelTools read th;
      Property Chart:OleVariant read chrt;

      Property ChartType:ExcelChartType read getCT write setCT;
      Property BarShape:ExcelChartBarShape read getBS write setBS;

      Function SetSourceData(const rg:string):boolean;overload;
      Function SetSourceData(const rg1,rg2:string):boolean;overload;
      Function SetSourceData(x,y:integer):boolean;overload;

//      Function TitlePosition(Left, Top : Integer):boolean;

      Function LegendPosition(Left, Top : Integer):boolean;
      Function LegendSize(Width, Height : Integer):boolean;
      Property LegendShadow:Boolean read getLH write setLH;
      Property LegendIncludeInLayout:Boolean read getLIL write setLIL;
      //Function LegendDelete:Boolean; //неактуальна
      Property Legend:Boolean read getL write setL;
      Function LegendFormat:TExcelChartFormatStyle;
      Property LegendPositions: ExcelChartLegendPosition read getLP write setLP;

      Function PlotAreaPosition(Left, Top : Integer):boolean;
      Function PlotAreaSize(Width, Height : Integer):boolean;
      Function PlotAreaFormat:TExcelChartFormatStyle;

      Function ChartAreaFormat:TExcelChartFormatStyle;

      Function CreateDataLabels(
        ShowCategoryName: boolean = true;
        ShowPercentage: boolean = true;
        ShowValue: boolean = false;
        Separator: String = '; ';
        LegendKey: boolean = true;
        HasLeaderLines: boolean = false
      ):boolean;

      Function TitlePosition(Left, Top : Integer):boolean;
      Property Title:Boolean read getT write setT;
      Function TitleFormat:TExcelChartFormatStyle;

      Property Rotation:Variant read getR write setR;
      Property Name:String read getNm write setNm;
  end;

  TExcelChartFormatStyle = class
    private
      th:TExcelChartFormat;
      fmt:OleVariant;

      function GradientStyleToNum( Style : ExcelChartFormatGradientStyle): Integer;
      function getCB: Integer;
      function getCF: Integer;
      procedure setCB(const Value: Integer);
      procedure setCF(const Value: Integer);
      function getTBG: Single;
      procedure setTBG(const Value: Single);
    public
      Constructor Create(E:TExcelChartFormat);
      Property This:TExcelChartFormat read th;
      Property Format:OleVariant read fmt;

      function OneColorGradient(Style:ExcelChartFormatGradientStyle;
           Variant_: LongWord; Degree : Single
         ):boolean;
      function TwoColorGradient(Style:ExcelChartFormatGradientStyle;
           Variant_: LongWord
         ):boolean;
      function Solid:boolean;

      Property ColorBack: Integer read getCB write setCB;
      Property ColorFore: Integer read getCF write setCF;
      Property TransparensyBackGround: Single read getTBG write setTBG;

  end;


  TExcelFontFormat=class
    private
      th:TExcelTools;
      rg:OleVariant;
      l:longword;
      function gerIt: boolean;
      function getBold: boolean;
      function getUl: ExcelUnderLine;
      procedure setBold(const Value: boolean);
      procedure setIt(const Value: boolean);
      procedure setUl(const Value: ExcelUnderLine);
      function getFC: LongWord;
      function getFN: string;
      function getFS: integer;
      function getSl: boolean;
      procedure setFC(const Value: LongWord);
      procedure setFN(const Value: string);
      procedure setFS(const Value: integer);
      procedure setSl(const Value: boolean);
    public
      Constructor Create(E:TExcelTools);
      Property This:TExcelTools read th;
      Property Range:OleVariant read rg;

      // свойства шрифта
      Property Bold:boolean read getBold write setBold;
      Property Italic:boolean read gerIt write setIt;
      Property UnderLine:ExcelUnderLine read getUl write setUl;
      Property StrikeLine:boolean read getSl write setSl;
      Property Familly:string read getFN write setFN;
      Property FontSize:integer read getFS write setFS;
      Property FontColor:LongWord read getFC write setFC;
  end;
  TExcelFormat=class(TExcelFontFormat)
    private
      brd:OleVariant;
      function getB(i: ExcelBorderType): TExcelFormat;
      function getLS: ExcelBorderStyle;
      procedure setLS(const Value: ExcelBorderStyle);
      function gerW: ExcelBorderWeight;
      procedure setW(const Value: ExcelBorderWeight);
      function getC: Longword;
      procedure setC(const Value: Longword);
      //function getBG: TExcelFormat;
      function getBGC: longword;
      procedure setBGC(const Value: longword);
      function getHA: ExcelHorizontalAlign;
      function getVA: ExcelVerticalAlign;
      procedure setHA(const Value: ExcelHorizontalAlign);
      procedure setVA(const Value: ExcelVerticalAlign);

      function getV: variant;
      procedure setV(const Value: variant);
    public
      Constructor Create(E:TExcelTools);
      procedure clear;
      Property Border:OleVariant read brd;
      Property Values:variant read getV write setV;

      //свойства бордюра
      Property Borders[i:ExcelBorderType]:TExcelFormat read getB;default;
      Property LineStyle:ExcelBorderStyle read getLS write setLS;
      Property Weight:ExcelBorderWeight read gerW write setW;
      Property Color:Longword read getC write setC;

      // свойства фона
      //Property Background:TExcelFormat read getBG;
      Property BackGroundColor:longword read getBGC write setBGC;

      // свойства ячейки
      Property Align:ExcelHorizontalAlign read getHA write setHA;
      Property VAlign:ExcelVerticalAlign read getVA write setVA;

      // свойства шрифта

      Function Merge(m:boolean):TExcelFormat;
  end;

const
  ex_Automatic=$FFFFEFF7;
  //0..40
  ex_Black=1;
  ex_White=2;
  ex_Red=3;
  ex_Green=4;
  ex_Blue=5;
  ex_Yellow=6;
  ex_Purpure=7;
  ex_Aqua=8;
  ex_DarkRed=9;
  ex_DarkGreen=10;
  ex_DarkBlue=11;
  ex_Olive=12;
  ex_DarkPunk=13;
  ex_Teal=14;
  ex_LightGray=15;
  ex_Gray=16;

  function ColIsNumToStr(col:integer):string;
  function ColIsStrToNum(col:string):integer;

var E:TExcelTools;
implementation
uses ComObj;

const _Col_XL_Str:string='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      _Len_Col_XL_Str=26;

function ColIsNumToStr(col:integer):string;
begin
  dec(col);
//  col:=Byte(col);
  result:='';
  while col>=0 do begin
    result:=_Col_XL_Str[col mod _Len_Col_XL_Str+1] + result;
    col:=(col div _Len_Col_XL_Str)-1;
  end;

//  result:=_Col_XL_Str[col mod _Len_Col_XL_Str+1];
//  IF col>=_Len_Col_XL_Str then result:=_Col_XL_Str[(col div _Len_Col_XL_Str)]+result;
end;

function ColIsStrToNum(col:string):integer;
var i,ps:byte;
begin
  result:=0;
  IF col<>'' then begin
    col:=UpperCase(col);
    for i:=1 to length(col) do begin
      ps := pos(col[i],_Col_XL_Str);
      IF ps>0 then
        result:= (result * _Len_Col_XL_Str) + ps;
    end;
  end;
end;


{ TExcelTools }

function TExcelTools.Activate: TExcelTools;
begin
  IF not varIsStr(B) then B.Activate;
  result:=self;
end;

function TExcelTools.ActiveBook: OLEVariant;
begin
  result:=E.ActiveWorkbook;
end;

function TExcelTools.ActiveSheild: OLEVariant;
begin
  IF not VarIsStr(B)
   then result:=B.ActiveSheet
   else IF isLoad
     then result:=E.ActiveSheet
     else result:=E.ActiveWorkbook.ActiveSheet;
end;

function TExcelTools.AddComment(const rg: string): TExcelTools;
begin
  setRange(rg);
  IF BRes then r.AddComment;
  result:=self;
end;

function TExcelTools.AddComment(const rg1, rg2: string): TExcelTools;
begin
  setRange(rg1,rg2);
  IF BRes then r.AddComment;
  result:=self;
end;

function TExcelTools.AddChart: TExcelTools;
begin
  BRes := true;
  try
    ActiveSheild.Shapes.AddChart;
  except BRes := false; end;
  result:= self;
end;

function TExcelTools.AddChart(_Left, _Top: Integer): TExcelTools;
begin
  BRes := true;
  try
    ActiveSheild.Shapes.AddChart(5, _Left, _Top);
  except BRes := false; end;
  result:= self;
end;

function TExcelTools.AddChart(_Left, _Top, _Width,
  _Height: Integer): TExcelTools;
begin
  BRes := true;
  try
    ActiveSheild.Shapes.AddChart(5, _Left, _Top, _Width, _Height);
  except BRes := false; end;
  result:= self;
end;

function TExcelTools.AddComment(x, y: integer): TExcelTools;
begin
  setRange(x,y);
  IF BRes then r.AddComment;
  result:=self;
end;

function TExcelTools.Book(nm: variant): TExcelTools;
begin
  clear;
  B:=E.Workbooks[nm];
  result:=self;
end;

function TExcelTools.BookActive(nm: variant): boolean;
begin
  BRes:=true;
  try
    E.Workbooks[nm].Activate;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.BookAdd: boolean;
begin
  BRes:=true;
  try
    E.WorkBooks.Add;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.BookClose: boolean;
begin
  BRes:=true;
  try
    E.DisplayAlerts:=False;
    IF varIsStr(B)
     then E.ActiveWorkbook.Close
     else B.Close;
    E.DisplayAlerts:=True;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.BookCount: integer;
begin
  BRes:=true;
  try
    result:=E.Workbooks.Count;
  except
    BRes:=false;
    result:=-1;
  end;
  Clear;
end;

function TExcelTools.SheildAdd(nm:string): boolean;
begin
  BRes:=true;
  try
    IF varIsStr(B)
      then r:=E.Sheets.Add
      else r:=B.Sheets.Add;
    r.Name:=nm;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

procedure TExcelTools.Clear;
begin
  VarClear(B);
  VarClear(S_);
  B:='str';
  S_:='str';
end;

function TExcelTools.ClearContents(const rg: string): TExcelTools;
begin
  setRange(rg);
  IF BRes then begin
    r.Select;
    E.Selection.ClearContents;
  end;
  result:=self;
end;

function TExcelTools.ClearContents(const rg1, rg2: string): TExcelTools;
begin
  setRange(rg1,rg2);
  IF BRes then begin
    r.Select;
    E.Selection.ClearContents;
  end;
  result:=self;
end;

function TExcelTools.ClearContents(x, y: integer): TExcelTools;
begin
  setRange(x,y);
  IF BRes then begin
    r.Select;
    E.Selection.ClearContents;
  end;
  result:=self;
end;

function TExcelTools.Close: boolean;
begin
  BRes:=true;
  try
    IF isLoad
     then begin
       try E.WorkBooks.Close;except end;
       //E.Close;
       E := '';
     end else begin
      E.DisplayAlerts:=False;
      E.Quit;
    end;
    isLoad := false;
  except BRes:=false;end;
  result:=BRes;
end;

function TExcelTools.Copy(const rg: string): TExcelTools;
begin
  setRange(rg);
  IF BRes then begin
    r.Select;
    E.Selection.Copy;
  end;
  result:=self;
end;

function TExcelTools.Copy(const rg1, rg2: string): TExcelTools;
begin
  setRange(rg1,rg2);
  IF BRes then begin
    r.Select;
    E.Selection.Copy;
  end;
  result:=self;
end;

function TExcelTools.CommentFormat(const rg: string; start,
  len: integer): TExcelFontFormat;
begin
  setRange(rg);
  result:=CommentFormat(start,len);
end;

function TExcelTools.CommentFormat(start, len: integer): TExcelFontFormat;
begin
  result:=TExcelFontFormat.Create(Self);
  try
    r.Comment.Shape.Select(true);
    result.rg:=E.Selection.Characters(start,len);
  except BRes:=false;end;
end;

function TExcelTools.CommentFormat(x, y, start, len: integer): TExcelFontFormat;
begin
  setRange(x,y);
  result:=CommentFormat(start,len);
end;

function TExcelTools.CommentSize(const rg: string; W, H: integer): TExcelTools;
begin
  setRange(rg);
  result:=CommentSize(W,H);
end;

function TExcelTools.CommentSize(W, H: integer): TExcelTools;
begin
  result:=self;
  try
    r.Comment.Shape.Select(true);
    E.Selection.ShapeRange.ScaleWidth(W/35.4,0);
    E.Selection.ShapeRange.ScaleHeight(H/35.4,0);
  except BRes:=false;end;
end;

function TExcelTools.CommentSize(x, y, W, H: integer): TExcelTools;
begin
  setRange(x,y);
  result:=CommentSize(W,H);
end;

function TExcelTools.CommentSize(const rg1, rg2: string; W,
  H: integer): TExcelTools;
begin
  setRange(rg1,rg2);
  result:=CommentSize(W,H);
end;

function TExcelTools.CommentFormat(const rg1, rg2: string; start,
  len: integer): TExcelFontFormat;
begin
  setRange(rg1,rg2);
  result:=CommentFormat(start,len);
end;

function TExcelTools.Copy(x, y: integer): TExcelTools;
begin
  setRange(x,y);
  IF BRes then begin
    r.Select;
    E.Selection.Copy;
  end;
  result:=self;
end;

function TExcelTools.CountShapes: integer;
begin
  IF isLoad
    then result := ActiveBook.Charts.Count
    else result := ActiveSheild.Shapes.Count;
end;

constructor TExcelTools.Create;
begin
  _v:=false;
  nn:=false;
  isLoad := false;
  VarClear(E);
  E:=Null;
  clear;
end;

function TExcelTools.Cut(const rg: string): TExcelTools;
begin
  setRange(rg);
  IF BRes then begin
    r.Select;
    E.Selection.Cut;
  end;
  result:=self;
end;

function TExcelTools.Cut(const rg1, rg2: string): TExcelTools;
begin
  setRange(rg1,rg2);
  IF BRes then begin
    r.Select;
    E.Selection.Cut;
  end;
  result:=self;
end;

function TExcelTools.Cut(x, y: integer): TExcelTools;
begin
  setRange(x,y);
  IF BRes then begin
    r.Select;
    E.Selection.Cut;
  end;
  result:=self;
end;

function TExcelTools.DeleteComment(x, y: integer): TExcelTools;
begin
  setRange(x,y);
  IF BRes then r.ClearComments;
  result:=self;
end;

function TExcelTools.DeleteComment(const rg: string): TExcelTools;
begin
  setRange(rg);
  IF BRes then r.ClearComments;
  result:=self;
end;

function TExcelTools.DeleteComment(const rg1, rg2: string): TExcelTools;
begin
  setRange(rg1,rg2);
  IF BRes then r.ClearComments;
  result:=self;
end;

function TExcelTools.Format(x, y: integer): TExcelFormat;
begin
  BRes:=true;
  try
    setRange(x,y);
    result:=TExcelFormat.Create(self);
    result.rg:=r;
  except BRes:=false;result:=nil;end;
  nn:=true;
end;

function TExcelTools.FullName: string;
begin
  IF varIsStr(B)
    then result:=''
    else result:=B.FullName;
  Clear;
end;

function TExcelTools.BooksClose: boolean;
begin
  BRes:=true;
  try
    E.DisplayAlerts:=False;
    E.WorkBooks.Close;
    E.DisplayAlerts:=True;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.Format(rg: string): TExcelFormat;
begin
  BRes:=true;
  try
    setRange(rg);
    result:=TExcelFormat.Create(self);
    result.rg:=r;
  except BRes:=false;result:=nil;end;
  nn:=true;
end;

function TExcelTools.Format(rg1, rg2: string): TExcelFormat;
begin
  BRes:=true;
  try
    setRange(rg1,rg2);
    result:=TExcelFormat.Create(self);
    result.rg:=r;
  except BRes:=false;result:=nil;end;
  nn:=true;
end;

function TExcelTools.SheildCount: integer;
begin
  BRes:=true;
  try
    IF varIsStr(B)
     then r:=E.Sheets
     else r:=B.Sheets;
    result:=r.Count;
  except
    BRes:=false;
    result:=-1;
  end;
  Clear;
end;

function TExcelTools.SheildDel(nm: variant): boolean;
begin
  BRes:=true;
  try
    E.DisplayAlerts:=False;
    IF varIsStr(B)
     then r:=E.Sheets[nm]
     else r:=B.Sheets[nm];
    r.Delete;
    E.DisplayAlerts:=true;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.getCell(x, y: integer): variant;
begin
  setRange(x,y);
  IF BRes then result:=r.Value else result:=0;
end;

function TExcelTools.getCmt(rg: string): string;
begin
  setRange(rg);
  IF BRes then result:=r.Comment.Text else result:='';
end;

function TExcelTools.getCmtC(x, y: integer): string;
begin
  setRange(x,y);
  IF BRes then result:=r.Comment.Text else result:='';
end;

function TExcelTools.getCmtR(rg1, rg2: string): string;
begin
  setRange(rg1,rg2);
  IF BRes then result:=r.Comment.Text else result:='';
end;

function TExcelTools.getCmts: string;
begin
  BRes:=true;
  result:='';
  try
    result:=r.Comment.Text;
  except BRes:=false;end;
  nn:=true;
end;

function TExcelTools.getCmtsV: boolean;
begin
  BRes:=true;
  result:=false;
  try
    result:=r.Comment.Visible;
  except BRes:=false;end;
  nn:=true;
end;

function TExcelTools.getCmtV(rg: string): boolean;
begin
  setRange(rg);
  IF BRes then result:=r.Comment.Visible else result:=false;
end;

function TExcelTools.getCmtVC(x, y: integer): boolean;
begin
  setRange(x,y);
  IF BRes then result:=r.Comment.Visible else result:=false;
end;

function TExcelTools.getCmtVR(rg1, rg2: string): boolean;
begin
  setRange(rg1,rg2);
  IF BRes then result:=r.Comment.Visible else result:=false;
end;

function TExcelTools.LastCol: integer;
begin
  IF not varIsStr(S_)
   then r:=S_.Cells
   else IF varIsStr(B)
    then r:=E.Cells
    else r:=B.Cells;
  result:=r.SpecialCells($B, EmptyParam).Column;
end;

function TExcelTools.getFl(nm: variant): TExcelTools;
begin
  IF nn then begin
    nn:=false;
    clear;
  end;
  IF varIsStr(B){and not isLoad} then result:=Book(nm) else
  IF varIsStr(S_) then result:=Sheild(nm) else result:=self;
end;

function TExcelTools.getH: double;
begin
  result:=E.Application.Height;
end;

function TExcelTools.getL: double;
begin
 result:=E.Application.Left;
end;

function TExcelTools.getNm(num: integer): string;
begin
  IF varIsStr(B)
   then result:=getBkNm(num)
   else result:=getShNm(num);
  Clear;
end;

procedure TExcelTools.getRect;
begin
  wRect.left:=E.Application.Left;
  wRect.top:=E.Application.top;
  wRect.Right:=E.Application.Width;
  wRect.Bottom:=E.Application.Height;
end;

function TExcelTools.getRg(rg: string): variant;
begin
  setRange(rg);
  IF BRes then result:=r.Value else result:=0;
end;

function TExcelTools.getRng(rgst, rgfn: string): variant;
begin
  setRange(rgst,rgfn);
  IF BRes then result:=r.Value else result:=0;
end;

function TExcelTools.LastRow: integer;
begin
  IF not varIsStr(S_)
   then r:=S_.Cells
   else IF varIsStr(B)
    then r:=E.Cells
    else r:=B.Cells;
  result:=r.SpecialCells($B, EmptyParam).Row;
end;

function TExcelTools.Load(fromWordsExcel: OleVariant): boolean;
begin
  BRes:=true;
  try
    E := fromWordsExcel;
    isLoad := true;
  except BRes:=false;end;
  result:=BRes;
end;

function TExcelTools.Makros(const s: string): TExcelTools;
begin
  E.Application.Run(synBook.Names+'!'+s);
  result:=self;
end;

function TExcelTools.getShNm(num:integer): string;
begin
  BRes:=true;
  try
    IF varIsStr(B)
     then r:=E.ActiveWorkbook.Sheets
     else r:=B.Sheets;
    result:=r.Item[num].Name;
  except
    BRes:=false;
    result:='';
  end;
  nn:=true;
end;

function TExcelTools.getT: double;
begin
  result:=E.Application.Top;
end;

function TExcelTools.getW: double;
begin
  result:=E.Application.Width;
end;

function TExcelTools.getNames: string;
begin
  IF not varIsStr(S_)
   then result:=S_.Name
   else IF varIsStr(B)
    then result:=''
    else result:=B.Name;
  Clear;
end;

function TExcelTools.SheildSelect(num: variant): boolean;
begin
  BRes:=true;
  try
    BRes:=true;
    IF varIsStr(B)
     then r:=E.ActiveWorkbook.Sheets
     else r:=B.Sheets;
    r.Item[num].Select;
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.synBook: TExcelTools;
begin
  clear;
  try  B:=E.ActiveWorkbook;  except end;
  result:=self;
end;

function TExcelTools.synSheild: TExcelTools;
begin
  IF not VarIsStr(B)
    then S_:=B.ActiveSheet
    else IF isLoad
      then S_:=E.ActiveSheet
      else S_:=E.ActiveWorkbook.ActiveSheet;
  result:=self;
end;

function TExcelTools.Version: String;
begin
  BRes:=true;
  try
    result:= E.Version;
  except BRes:=false; end;
end;

function TExcelTools.ShapesAsChart(Num: integer = 0): TExcelChartFormat;
begin
  BRes := true;
  try
    result:= TExcelChartFormat.Create(self);
    result.chrt := ActiveSheild;
    IF Num = 0
      then begin
        result.chrt := ActiveBook.Charts[1];
        {try
          result.chrt.ChartObjects('Диаграмма 1').Activate;
        except
          result.chrt.ChartObjects('Äèàãðàììà 1').Activate;
        end;
        result.chrt := result.chrt.ActiveChart;}
      end else result.chrt := result.chrt.Shapes.Item(num).Chart;
  except BRes := false; end;
end;

function TExcelTools.ShapesAsChart(Names: String): TExcelChartFormat;
begin
  BRes := true;
  try
    result:= TExcelChartFormat.Create(self);
    result.chrt := ActiveSheild;
    result.chrt := result.chrt.Shapes.Item(Names).Chart;
  except BRes := false; end;
end;

function TExcelTools.Sheild(nm: variant): TExcelTools;
begin
  IF not VarIsStr(B)
   then S_:=B.Sheets.Item[nm]
   else {IF isLoad
     then S_:=E.Sheets.Item[nm]
     else} S_:=E.ActiveWorkbook.Sheets.Item[nm];
  result:=self;
end;

function TExcelTools.Select: TExcelTools;
begin
  IF not varIsStr(S_) then S_.Select;
  result:=self;
end;

function TExcelTools.Open:boolean;
begin
  BRes:=true;
  try
    E := CreateOleObject('Excel.Application');
    isLoad := false;
  except BRes:=false;end;
  result:=BRes;
end;

function TExcelTools.Paste(const rg: string): TExcelTools;
begin
  setRange(rg);
  IF BRes then begin
    r.Select;
    E.ActiveSheet.Paste;
  end;
  result:=self;
end;

function TExcelTools.Paste(const rg1, rg2: string): TExcelTools;
begin
  setRange(rg1,rg2);
  IF BRes then begin
    r.Select;
    E.ActiveSheet.Paste;
  end;
  result:=self;
end;

function TExcelTools.Paste(x, y: integer): TExcelTools;
begin
  setRange(x,y);
  IF BRes then begin
    r.Select;
    E.ActiveSheet.Paste;
  end;
  result:=self;
end;

function TExcelTools.getBkFNm(num: integer): string;
begin
  BRes:=true;
  try
    result:=E.Workbooks[num].FullName;
  except
    BRes:=false;
    result:='';
  end;
  nn:=true;
end;

function TExcelTools.GetBkNm(num: integer): string;
begin
  BRes:=true;
  try
    result:=E.Workbooks[num].Name;
  except
    BRes:=false;
    result:='';
  end;
  nn:=true;
end;

function TExcelTools.BookOpen(NameFile: string): boolean;
begin
  BRes:=true;
  try E.WorkBooks.Open(NameFile);
  except BRes:=false;end;
  result:=BRes;
  Clear;
end;

function TExcelTools.BookSave: boolean;
begin
  BRes:=true;
  try
    E.DisplayAlerts:=False;
    IF varIsStr(B)
     then E.ActiveWorkbook.Save
     else B.Save;
    E.DisplayAlerts:=True;
  except BRes:=false;end;
  result:=BRes;
  clear;
end;

function TExcelTools.BookSaveAs(NameFile: string): boolean;
begin
  BRes:=true;
  try
    E.DisplayAlerts:=False;
    IF varIsStr(B)
     then E.ActiveWorkbook.SaveAs(NameFile)
     else B.SaveAs(NameFile);
    E.DisplayAlerts:=True;
  except BRes:=false;end;
  result:=BRes;
  clear;
end;

procedure TExcelTools.setBkFNm(num: integer; s: string);
begin
  BRes:=true;
  try
    E.Workbooks[num].FullName:=s;
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setBkNm(num: integer; s: string);
begin
  BRes:=true;
  try
    E.Workbooks[num].Name:=s;
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setCell(x, y: integer; v: variant);
begin
  setRange(x,y);
  try
    E.DisplayAlerts:=False;
    IF BRes then r.Value:=v;
    E.DisplayAlerts:=true;
  except BRes:=false;end;
end;

procedure TExcelTools.setCmt(rg: string; const V: string);
begin
  setRange(rg);
  IF BRes then r.Comment.Text(v);
end;

procedure TExcelTools.setCmtC(x, y: integer; const V: string);
begin
  setRange(x,y);
  IF BRes then r.Comment.Text(v);
end;

procedure TExcelTools.setCmtR(rg1, rg2: string; const V: string);
begin
  setRange(rg1,rg2);
  IF BRes then r.Comment.Text(v);
end;

procedure TExcelTools.setCmts(const V: string);
begin
  BRes:=true;
  try
    r.Comment.Text(V);
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setCmtsV(const V: boolean);
begin
  BRes:=true;
  try
    r.Comment.Visible:=V;
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setCmtV(rg: string; const V: boolean);
begin
  setRange(rg);
  IF BRes then r.Comment.Visible:=v;
end;

procedure TExcelTools.setCmtVC(x, y: integer; const V: boolean);
begin
  setRange(x,y);
  IF BRes then r.Comment.Visible:=v;
end;

procedure TExcelTools.setCmtVR(rg1, rg2: string; const V: boolean);
begin
  setRange(rg1,rg2);
  IF BRes then r.Comment.Visible:=v;
end;

function TExcelTools.SetFixedCells(const rg: string): boolean;
begin
  setRange(rg);
  result:= BRes;
  IF BRes then Try
    r.Select;
    E.ActiveWindow.FreezePanes := True;
  except BRes:=false;result:=false end;
end;

function TExcelTools.SetFixedCells(x, y: integer): boolean;
begin
  setRange(x,y);
  result:= BRes;
  IF BRes then Try
    r.Select;
    E.ActiveWindow.FreezePanes := True;
  except BRes:=false;result:=false end;
end;

procedure TExcelTools.setH(i: double);
begin
  E.Application.Height:=i;
end;

procedure TExcelTools.setL(i: double);
begin
  E.Application.Left:=i;
end;

procedure TExcelTools.setNames(s: string);
begin
  IF not varIsStr(S_)
   then S_.Name:=s
   else IF not varIsStr(B)
    then B.Name:=s;
  Clear;
end;

procedure TExcelTools.setNm(num: integer; s: string);
begin
  IF varIsStr(B)
   then setBkNm(num,s)
   else setShNm(num,s);
  Clear;
end;

procedure TExcelTools.setRange(const rg: string);
begin
  BRes:=true;
  try
    IF not varIsStr(S_)
     then r:=S_.Range[rg]
     else IF varIsStr(B)
      then r:=E.Range[rg]
      else r:=B.Range[rg];
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setRange(const rg1, rg2: string);
begin
  BRes:=true;
  try
    IF not varIsStr(S_)
     then r:=S_.Range[rg1,rg2]
     else IF varIsStr(B)
      then r:=E.Range[rg1,rg2]
      else r:=B.Range[rg1,rg2];
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setRange(x, y: integer);
begin
  BRes:=true;
  try
    IF not varIsStr(S_)
     then r:=S_.Cells[y,x]
     else IF varIsStr(B)
      then r:=E.Cells[y,x]
      else r:=B.Cells[y,x];
  except BRes:=false;end;
//  result:=BRes;
  nn:=true;
end;

procedure TExcelTools.setRect;
begin
  E.Application.Left:=wRect.left;
  E.Application.top:=wRect.top;
  E.Application.Width:=wRect.Right;
  E.Application.Height:=wRect.Bottom;
end;

procedure TExcelTools.SetRg(rg: string; v: variant);
begin
  setRange(rg);
  try
    IF not isLoad then E.DisplayAlerts:=False;
    IF BRes then r.Value:=v;
    IF not isLoad  then E.DisplayAlerts:=true;
  except BRes:=false;end;
end;

procedure TExcelTools.setRng(rgst, rgfn: string; v: variant);
begin
  setRange(rgst,rgfn);
  try
    IF not isLoad then E.DisplayAlerts:=False;
    IF BRes then r.Value:=v;
    IF not isLoad then E.DisplayAlerts:=true;
  except BRes:=false;end;
end;

procedure TExcelTools.setShNm(num:integer;s: string);
begin
  BRes:=true;
  try
    IF varIsStr(B)
     then r:=E.ActiveWorkbook.Sheets
     else r:=B.Sheets;
    r.Item[num].Name:=s;
  except BRes:=false;end;
  nn:=true;
end;

procedure TExcelTools.setT(i: double);
begin
  E.Application.Top:=i;
end;

procedure TExcelTools.setV(v: boolean);
begin
  BRes:=true;
  try E.visible:= v;_v:=v;
  except BRes:=false;end;
end;

procedure TExcelTools.setW(i: double);
begin
  E.Application.Width:=i;
end;

{ TExcelBorder }

procedure TExcelFormat.clear;
begin
  brd:='str';
//  bg:='str';
end;

constructor TExcelFormat.Create(E: TExcelTools);
begin
  Inherited Create(E);
  clear;
end;

constructor TExcelFontFormat.Create(E: TExcelTools);
begin
  th:=E;
  rg:='str';
end;

function TExcelFontFormat.gerIt: boolean;
begin
  IF VarIsStr(rg)
   then result:=false
   else result:=rg.Font.Italic;
end;

function TExcelFormat.gerW: ExcelBorderWeight;
begin
  IF VarIsStr(brd) then result:=ex_Hairline else begin
    l:=brd.Weight;
    case l of
      1:result:=ex_Hairline;
      $FFFFEFD6:result:=ex_Medium;
      4:result:=ex_Thick;
      2:result:=ex_Thin;
    end;
  end;
end;

function TExcelFormat.getB(i: ExcelBorderType): TExcelFormat;
begin
  clear;
  IF VarIsStr(rg) then rg:=th.Excel.Selection;
  case i of
    ex_DiagDown:brd:=rg.Borders[5];
    ex_DiagUp:brd:=rg.Borders[6];
    ex_Bottom:brd:=rg.Borders[9];
    ex_Left:brd:=rg.Borders[7];
    ex_Right:brd:=rg.Borders[$A];
    ex_Top:brd:=rg.Borders[8];
    ex_Horizontal:brd:=rg.Borders[$C];
    ex_Vertical:brd:=rg.Borders[$B];
  end;
  result:=self;
end;

{function TExcelFormat.getBG: TExcelFormat;
begin
  clear;
  IF VarIsStr(rg) then rg:=th.Excel.Selection;
  bg:=rg.Interior;
end;//}

function TExcelFormat.getBGC: longword;
begin
  IF VarIsStr(rg)
   then result:=$FFFFEFF7
   else result:=rg.Interior.ColorIndex;
end;

function TExcelFontFormat.getBold: boolean;
begin
  IF VarIsStr(rg)
   then result:=false
   else result:=rg.Font.Bold;
end;

function TExcelFormat.getC: Longword;
var _v:olevariant;
begin
  IF not VarIsStr(brd) then _v:=brd else
//  IF not VarIsStr(bg) then _v:=bg else
    begin result:=$FFFFEFF7;exit;end;
  result:=_v.ColorIndex;//brd.ColorIndex;
end;

function TExcelFontFormat.getFC: LongWord;
begin
  IF VarIsStr(rg)
   then result:=$FFFFEFF7
   else result:=rg.Font.ColorIndex;
end;

function TExcelFontFormat.getFN: string;
begin
  IF VarIsStr(rg)
   then result:=''
   else result:=rg.Font.Name;
end;

function TExcelFontFormat.getFS: integer;
begin
  IF VarIsStr(rg)
   then result:=0
   else result:=rg.Font.Size;
end;

function TExcelFormat.getHA: ExcelHorizontalAlign;
begin
  IF VarIsStr(rg) then result:=ex_h_Center else begin
    l:=rg.HorizontalAlignment;
    case l of
      $FFFFEFDD:result:=ex_h_Left;
      $FFFFEFC8:result:=ex_h_Right;
      else result:=ex_h_Center;
    end;
  end;
end;

function TExcelFormat.getLS: ExcelBorderStyle;
begin
  IF VarIsStr(brd) then result:=ex_None else begin
    l:=brd.LineStyle;
    case l of
      1:result:=ex_Single;
      $FFFFEFED:result:=ex_Dash;
      4:result:=ex_DashDot;
      5:result:=ex_DashDotDot;
      $FFFFEFEA:result:=ex_Dot;
      $FFFFEFE9:result:=ex_Double;
      $D:result:=ex_SlantDashDot;
      else result:=ex_None;
    end;
  end;
end;

function TExcelFontFormat.getSl: boolean;
begin
  IF VarIsStr(rg)
   then result:=false
   else result:=rg.Font.Strikethrough;
end;

function TExcelFontFormat.getUl: ExcelUnderLine;
begin
  IF VarIsStr(rg) then result:=ex_us_None else begin
    l:=rg.Font.Underline;
    case l of
      $FFFFEFE9:result:=ex_us_Double;
      5:result:=ex_us_DoubleAccounting;
      2:result:=ex_us_Single;
      4:result:=ex_us_SingleAccounting;
      else result:=ex_us_None;
    end;
  end;
end;

function TExcelFormat.getV: variant;
begin
  IF VarIsStr(rg)
   then result:=0
   else result:=rg.Value;
end;

function TExcelFormat.getVA: ExcelVerticalAlign;
begin
  IF VarIsStr(rg) then result:=ex_v_Center else begin
    l:=rg.VerticalAlignment;
    case l of
      $FFFFEFF5:result:=ex_v_Bottom;
      $FFFFEFC0:result:=ex_v_Top;
      else result:=ex_v_Center;
    end;
  end;
end;

function TExcelFormat.Merge(m: boolean): TExcelFormat;
begin
  th.E.DisplayAlerts:=False;
  IF not VarIsStr(rg) then begin
    IF m
     then rg.Merge
     else rg.UnMerge;
  end;
  th.E.DisplayAlerts:=true;
  result:=self;
end;

procedure TExcelFormat.setBGC(const Value: longword);
begin
  IF not VarIsStr(rg) then rg.Interior.ColorIndex:=Value;
end;

procedure TExcelFontFormat.setBold(const Value: boolean);
begin
  IF not VarIsStr(rg) then rg.Font.Bold := Value;
end;

procedure TExcelFormat.setC(const Value: Longword);
var _v:olevariant;
begin
  IF not VarIsStr(brd) then _v:=brd else
//  IF not VarIsStr(bg) then _v:=bg else
     exit;
  _v.ColorIndex:=Value;
//  IF not VarIsStr(brd) then brd.ColorIndex:=Value;
end;

procedure TExcelFontFormat.setFC(const Value: LongWord);
begin
  IF not VarIsStr(rg) then rg.Font.ColorIndex:=Value;
end;

procedure TExcelFontFormat.setFN(const Value: string);
begin
  IF not VarIsStr(rg) then rg.Font.Name:=Value;
end;

procedure TExcelFontFormat.setFS(const Value: integer);
begin
  IF not VarIsStr(rg) then rg.Font.Size:=Value;
end;

procedure TExcelFormat.setHA(const Value: ExcelHorizontalAlign);
begin
  IF not VarIsStr(rg) then case Value of
    ex_h_Left:rg.HorizontalAlignment:=$FFFFEFDD;
    ex_h_Right:rg.HorizontalAlignment:=$FFFFEFC8;
    ex_h_Center:rg.HorizontalAlignment:=$FFFFEFF4;
  end;
end;

procedure TExcelFontFormat.setIt(const Value: boolean);
begin
  IF not VarIsStr(rg) then rg.Font.Italic:=Value;
end;

procedure TExcelFormat.setLS(const Value: ExcelBorderStyle);
begin
  IF not VarIsStr(brd) then case Value of
      ex_Single:brd.LineStyle:=1;
      ex_Dash:brd.LineStyle:=$FFFFEFED;
      ex_DashDot:brd.LineStyle:=4;
      ex_DashDotDot:brd.LineStyle:=5;
      ex_Dot:brd.LineStyle:=$FFFFEFEA;
      ex_Double:brd.LineStyle:=$FFFFEFE9;
      ex_SlantDashDot:brd.LineStyle:=$D;
      ex_None:brd.LineStyle:=$FFFFEFD2;
  end;
end;

procedure TExcelFontFormat.setSl(const Value: boolean);
begin
  IF not VarIsStr(rg) then rg.Font.Strikethrough:=Value;
end;

procedure TExcelFontFormat.setUl(const Value: ExcelUnderLine);
begin
  IF not VarIsStr(rg) then case Value of
      ex_us_None:rg.Font.Underline:=$FFFFEFD2;
      ex_us_Double:rg.Font.Underline:=$FFFFEFE9;
      ex_us_DoubleAccounting:rg.Font.Underline:=5;
      ex_us_Single:rg.Font.Underline:=2;
      ex_us_SingleAccounting:rg.Font.Underline:=4;
    end;
end;

procedure TExcelFormat.setV(const Value: variant);
begin
  IF not VarIsStr(rg) then rg.Value:=Value;
end;

procedure TExcelFormat.setVA(const Value: ExcelVerticalAlign);
begin
  IF not VarIsStr(rg) then case Value of
    ex_v_Bottom:rg.VerticalAlignment:=$FFFFEFF5;
    ex_v_Top:rg.VerticalAlignment:=$FFFFEFC0;
    ex_v_Center:rg.VerticalAlignment:=$FFFFEFF4;
  end;
end;

procedure TExcelFormat.setW(const Value: ExcelBorderWeight);
begin
  IF not VarIsStr(brd) then case Value of
    ex_Hairline:brd.Weight:=1;
    ex_Medium:brd.Weight:=$FFFFEFD6;
    ex_Thick:brd.Weight:=4;
    ex_Thin:brd.Weight:=2;
  end;
end;

{ TExcelChartFormat }

function TExcelChartFormat.ChartAreaFormat: TExcelChartFormatStyle;
begin
  try
    result:= TExcelChartFormatStyle.Create(self);
    result.fmt := chrt.ChartArea.Format;
  except end;
end;

constructor TExcelChartFormat.Create(E: TExcelTools);
begin
  th:=E;
  chrt:='str';
end;

function TExcelChartFormat.CreateDataLabels(ShowCategoryName, ShowPercentage,
  ShowValue: boolean; Separator: String; LegendKey,
  HasLeaderLines: boolean): boolean;
begin
  try
    Chrt.ApplyDataLabels(2,LegendKey, true, HasLeaderLines, false,
       ShowCategoryName, ShowValue, ShowPercentage, false, Separator);
    result:= true;
  except result:=false; end;
end;

function TExcelChartFormat.getBS: ExcelChartBarShape;
var i:integer;
begin
  try
    i:= chrt.BarShape;
  except i:=5; end;
  case i of
    0: result := xlBox;
    5: result := xlConeToMax;
    4: result := xlConeToPoint;
    3: result := xlCylinder;
    2: result := xlPyramidToMax;
    1: result := xlPyramidToPoint;
  end;
end;

function TExcelChartFormat.getCT: ExcelChartType;
var i:integer;
begin
  try
    i:= chrt.ChartType;
  except i:=5; end;
  case i of
    $FFFFEFFE : result := xl3DArea;
          $4E : result := xl3DAreaStacked;
          $4F : result := xl3DAreaStacked100;

          $3C : result := xl3DBarClustered;
          $3D : result := xl3DBarStacked;
          $3E : result := xl3DBarStacked100;

    $FFFFEFFC : result := xl3DColumn;
          $36 : result := xl3DColumnClustered;
          $37 : result := xl3DColumnStacked;
          $38 : result := xl3DColumnStacked100;

    $FFFFEFFB : result := xl3DLine;
    $FFFFEFFA : result := xl3DPie;
          $46 : result := xl3DPieExploded;

            1 : result := xlArea;
          $4C : result := xlAreaStacked;
          $4D : result := xlAreaStacked100;

          $39 : result := xlBarClustered;
          $47 : result := xlBarOfPie;
          $3A : result := xlBarStacked;
          $3B : result := xlBarStacked100;

           $F : result := xlBubble;
          $57 : result := xlBubble3DEffect;

          $33 : result := xlColumnClustered;
          $34 : result := xlColumnStacked;
          $35 : result := xlColumnStacked100;

          $66 : result := xlConeBarClustered;
          $67 : result := xlConeBarStacked;
          $68 : result := xlConeBarStacked100;

          $69 : result := xlConeCol;
          $63 : result := xlConeColClustered;
          $64 : result := xlConeColStacked;
          $65 : result := xlConeColStacked100;

          $5F : result := xlCylinderBarClustered;
          $60 : result := xlCylinderBarStacked;
          $61 : result := xlCylinderBarStacked100;

          $62 : result := xlCylinderCol;
          $5C : result := xlCylinderColClustered;
          $5D : result := xlCylinderColStacked;
          $5E : result := xlCylinderColStacked100;

    $FFFFEFE8 : result := xlDoughnut;
          $50 : result := xlDoughnutExploded;

            4 : result := xlLine;

          $41 : result := xlLineMarkers;
          $42 : result := xlLineMarkersStacked;
          $43 : result := xlLineMarkersStacked100;

          $3F : result := xlLineStacked;
          $40 : result := xlLineStacked100;

            5 : result := xlPie;
          $45 : result := xlPieExploded;
          $44 : result := xlPieOfPie;

          $6D : result := xlPyramidBarClustered;
          $6E : result := xlPyramidBarStacked;
          $6F : result := xlPyramidBarStacked100;

          $70 : result := xlPyramidCol;
          $6A : result := xlPyramidColClustered;
          $6B : result := xlPyramidColStacked;
          $6C : result := xlPyramidColStacked100;

    $FFFFEFC9 : result := xlRadar;
          $52 : result := xlRadarFilled;
          $51 : result := xlRadarMarkers;

          $58 : result := xlStockHLC;
          $59 : result := xlStockOHLC;
          $5A : result := xlStockVHLC;
          $5B : result := xlStockVOHLC;

          $53 : result := xlSurface;
          $55 : result := xlSurfaceTopView;
          $56 : result := xlSurfaceTopViewWireframe;
          $54 : result := xlSurfaceWireframe;

    $FFFFEFB7 : result := xlXYScatter;
          $4A : result := xlXYScatterLines;
          $4B : result := xlXYScatterLinesNoMarkers;
          $48 : result := xlXYScatterSmooth;
          $49 : result := xlXYScatterSmoothNoMarkers;

    else result := xlPie;
  end;
end;

function TExcelChartFormat.getL: Boolean;
begin
  try
    result := chrt.HasLegend;
  Except result:=false; end;
end;

function TExcelChartFormat.getLH: Boolean;
begin
  try
    result := chrt.Legend.Shadow;
  except result:=false; end;
end;

function TExcelChartFormat.getLIL: Boolean;
begin
  try
    result := chrt.Legend.IncludeInLayout;
  except result:=false; end;
end;

function TExcelChartFormat.getLP: ExcelChartLegendPosition;
var i:integer;
begin
  try
    i:= chrt.Legend.Position;
  except i:=2; end;
  case i of
    $FFFFEFF5: result := xlLegendPositionBottom;
            2: result := xlLegendPositionCorner;
    $FFFFEFBF: result := xlLegendPositionCustom;
    $FFFFEFDD: result := xlLegendPositionLeft;
    $FFFFEFC8: result := xlLegendPositionRight;
    $FFFFEFC0: result := xlLegendPositionTop;
  end;
end;

function TExcelChartFormat.getNm: String;
begin
  try
    result := chrt.Name;
  except result:=''; end;
end;

function TExcelChartFormat.getR: Variant;
begin
  try
    result := chrt.Rotation;
  Except result:=false; end;
end;

function TExcelChartFormat.getT: Boolean;
begin
  try
    result := chrt.HasTitle;
  Except result:=false; end;
end;

{function TExcelChartFormat.LegendDelete: Boolean;
begin
  try
    chrt.Legend.Delete;
    result := true;
  Except result:=false; end;
end;}

function TExcelChartFormat.LegendFormat: TExcelChartFormatStyle;
begin
  try
    result:= TExcelChartFormatStyle.Create(self);
    result.fmt := chrt.Legend.Format;
  except end;
end;

function TExcelChartFormat.LegendPosition(Left, Top: Integer): boolean;
begin
  try
    chrt.Legend.Left := Left;
    chrt.Legend.Top := Top;
    result := true;
  Except result:=false; end;
end;

function TExcelChartFormat.LegendSize(Width, Height: Integer): boolean;
begin
  try
    chrt.Legend.Width := Width;
    chrt.Legend.Height := Height;
    result := true;
  Except result:=false; end;
end;

function TExcelChartFormat.PlotAreaFormat: TExcelChartFormatStyle;
begin
  try
    result:= TExcelChartFormatStyle.Create(self);
    result.fmt := chrt.PlotArea.Format;
  except end;
end;

function TExcelChartFormat.PlotAreaPosition(Left, Top: Integer): boolean;
begin
  try
    chrt.PlotArea.Left := Left;
    chrt.PlotArea.Top := Top;
    result := true;
  Except result:=false; end;
end;

function TExcelChartFormat.PlotAreaSize(Width, Height: Integer): boolean;
begin
  try
    chrt.PlotArea.Width := Width;
    chrt.PlotArea.Height := Height;
    result := true;
  Except result:=false; end;
end;

procedure TExcelChartFormat.setBS(const Value: ExcelChartBarShape);
var i:integer;
begin
  case Value of
    xlBox            : i := 0;
    xlConeToMax      : i := 5;
    xlConeToPoint    : i := 4;
    xlCylinder       : i := 3;
    xlPyramidToMax   : i := 2;
    xlPyramidToPoint : i := 1;
  end;
  try
    chrt.BarShape := i;
  except end;
end;

procedure TExcelChartFormat.setCT(const Value: ExcelChartType);
var i: integer;
begin
  case Value of
              xl3DArea : i := $FFFFEFFE;
       xl3DAreaStacked : i := $4E;
    xl3DAreaStacked100 : i := $4F;

      xl3DBarClustered : i := $3C;
        xl3DBarStacked : i := $3D;
     xl3DBarStacked100 : i := $3E;

              xl3DColumn : i := $FFFFEFFC;
     xl3DColumnClustered : i := $36;
       xl3DColumnStacked : i := $37;
    xl3DColumnStacked100 : i := $38;

           xl3DLine : i := $FFFFEFFB;
            xl3DPie : i := $FFFFEFFA;
    xl3DPieExploded : i := $46;

              xlArea : i := 1;
       xlAreaStacked : i := $4C;
    xlAreaStacked100 : i := $4D;

     xlBarClustered : i := $39;
         xlBarOfPie : i := $47;
       xlBarStacked : i := $3A;
    xlBarStacked100 : i := $3B;

            xlBubble : i := $F;
    xlBubble3DEffect : i := $57;

     xlColumnClustered : i := $33;
       xlColumnStacked : i := $34;
    xlColumnStacked100 : i := $35;

     xlConeBarClustered : i := $66;
       xlConeBarStacked : i := $67;
    xlConeBarStacked100 : i := $68;

              xlConeCol : i := $69;
     xlConeColClustered : i := $63;
       xlConeColStacked : i := $64;
    xlConeColStacked100 : i := $65;

     xlCylinderBarClustered : i := $5F;
       xlCylinderBarStacked : i := $60;
    xlCylinderBarStacked100 : i := $61;

              xlCylinderCol : i := $62;
     xlCylinderColClustered : i := $5C;
       xlCylinderColStacked : i := $5D;
    xlCylinderColStacked100 : i := $5E;

            xlDoughnut : i := $FFFFEFE8;
    xlDoughnutExploded : i := $50;

    xlLine : i := 4;

              xlLineMarkers : i := $41;
       xlLineMarkersStacked : i := $42;
    xlLineMarkersStacked100 : i := $43;

       xlLineStacked : i := $3F;
    xlLineStacked100 : i := $40;

            xlPie : i := 5;
    xlPieExploded : i := $45;
       xlPieOfPie : i := $44;

     xlPyramidBarClustered : i := $6D;
       xlPyramidBarStacked : i := $6E;
    xlPyramidBarStacked100 : i := $6F;

              xlPyramidCol : i := $70;
     xlPyramidColClustered : i := $6A;
       xlPyramidColStacked : i := $6B;
    xlPyramidColStacked100 : i := $6C;

           xlRadar : i := $FFFFEFC9;
     xlRadarFilled : i := $52;
    xlRadarMarkers : i := $51;

      xlStockHLC : i := $58;
     xlStockOHLC : i := $59;
     xlStockVHLC : i := $5A;
    xlStockVOHLC : i := $5B;

                    xlSurface : i := $53;
             xlSurfaceTopView : i := $55;
    xlSurfaceTopViewWireframe : i := $56;
           xlSurfaceWireframe : i := $54;

                   xlXYScatter : i := $FFFFEFB7;
              xlXYScatterLines : i := $4A;
     xlXYScatterLinesNoMarkers : i := $4B;
             xlXYScatterSmooth : i := $48;
    xlXYScatterSmoothNoMarkers : i := $49;

  end;
  try
    chrt.ChartType := i;
  except end;
end;

procedure TExcelChartFormat.setL(const Value: Boolean);
begin
  try
    chrt.HasLegend := Value;
  except end;
end;

procedure TExcelChartFormat.setLH(const Value: Boolean);
begin
  try
    chrt.Legend.Shadow := Value;
  except end;
end;

procedure TExcelChartFormat.setLIL(const Value: Boolean);
begin
  try
    chrt.Legend.IncludeInLayout := Value;
  except end;
end;

procedure TExcelChartFormat.setLP(const Value: ExcelChartLegendPosition);
var i:integer;
begin
  case Value of
    xlLegendPositionBottom : i := $FFFFEFF5;
    xlLegendPositionCorner : i := 2;
    xlLegendPositionCustom : i := $FFFFEFBF;
    xlLegendPositionLeft   : i := $FFFFEFDD;
    xlLegendPositionRight  : i := $FFFFEFC8;
    xlLegendPositionTop    : i := $FFFFEFC0;
  end;
  try
    chrt.Legend.Position := i;
  except end;
end;

procedure TExcelChartFormat.setNm(const Value: String);
begin
  try
    chrt.Name := Value;
  except end;
end;

procedure TExcelChartFormat.setR(const Value: Variant);
begin
  try
    chrt.Rotation := Value;
  except end;
end;

function TExcelChartFormat.SetSourceData(const rg: string): boolean;
begin
  th.setRange(rg);
  try
    chrt.SetSourceData( th.r );
    result := true;
  Except result:=false; end;
end;

function TExcelChartFormat.SetSourceData(const rg1, rg2: string): boolean;
begin
  th.setRange(rg1,rg2);
  try
    chrt.SetSourceData( th.r );
    result := true;
  Except result:=false; end;
end;

function TExcelChartFormat.SetSourceData(x, y: integer): boolean;
begin
  th.setRange(x,y);
  try
    chrt.SetSourceData( th.r );
    result := true;
  Except result:=false; end;
end;

procedure TExcelChartFormat.setT(const Value: Boolean);
begin
  try
    chrt.HasTitle := Value;
  except end;
end;

function TExcelChartFormat.TitleFormat: TExcelChartFormatStyle;
begin
  try
    result:= TExcelChartFormatStyle.Create(self);
    result.fmt := chrt.ChartTitle.Format;
  except end;
end;

function TExcelChartFormat.TitlePosition(Left, Top: Integer): boolean;
begin
  try
    chrt.ChartTitle.Left := Left;
    chrt.ChartTitle.Top := Top;
    result := true;
  Except result:=false; end;
end;

{function TExcelChartFormat.TitlePosition(Left, Top: Integer): boolean;
begin
  try
    chrt.ChartTitle.Left := Left;
    chrt.ChartTitle.Top := Top;
    result := true;
  Except result:=false; end;
end;}

{ TExcelChartFormatStyle }

constructor TExcelChartFormatStyle.Create(E: TExcelChartFormat);
begin
  th:=E;
  fmt:='str';
end;

function TExcelChartFormatStyle.getCB: Integer;
begin
  try
    result := Format.Fill.BackColor.RGB;
  except end;
end;

function TExcelChartFormatStyle.getCF: Integer;
begin
  try
    result := Format.Fill.ForeColor.RGB;
  except end;
end;

function TExcelChartFormatStyle.getTBG: Single;
begin
  try
    result := Format.Fill.Transparency;
  except end;
end;

function TExcelChartFormatStyle.GradientStyleToNum(
  Style: ExcelChartFormatGradientStyle): Integer;
begin
   case Style of
     xlGradientDiagonalDown : result := 4;
     xlGradientDiagonalUp   : result := 3;
     xlGradientFromCenter   : result := 7;
     xlGradientFromCorner   : result := 5;
     xlGradientFromTitle    : result := 6;
     xlGradientHorizontal   : result := 1;
     xlGradientMixed        : result := $FFFFFFFE;
     xlGradientVertical     : result := 2;
   end;
end;

function TExcelChartFormatStyle.OneColorGradient(
  Style: ExcelChartFormatGradientStyle; Variant_: LongWord;
  Degree: Single): boolean;
begin
  result:= false;
  IF not (style in [xlGradientFromTitle, xlGradientMixed])then
  try
    IF Variant_ > 4 then Variant_:=4 else
    IF Variant_ < 1 then Variant_:=1;
    fmt.Fill.OneColorGradient(
      GradientStyleToNum(Style), Variant_, Degree
    );
    result:=true;
  except result:= false; end;
end;

procedure TExcelChartFormatStyle.setCB(const Value: Integer);
begin
  try
    Format.Fill.BackColor.RGB := Value;
  except end;
end;

procedure TExcelChartFormatStyle.setCF(const Value: Integer);
begin
  try
    Format.Fill.ForeColor.RGB := Value;
  except end;
end;

procedure TExcelChartFormatStyle.setTBG(const Value: Single);
begin
  try
    Format.Fill.Transparency := Value;
  except end;
end;

function TExcelChartFormatStyle.Solid: boolean;
begin
  try
    fmt.Fill.Solid;
    result:=true;
  except result:= false; end;
end;

function TExcelChartFormatStyle.TwoColorGradient(
  Style: ExcelChartFormatGradientStyle; Variant_: LongWord): boolean;
begin
  IF not (style in [xlGradientFromTitle, xlGradientMixed])then
  try
    IF Variant_ > 4 then Variant_:=4 else
    IF Variant_ < 1 then Variant_:=1;
    fmt.Fill.TwoColorGradient(
      GradientStyleToNum(Style), Variant_
    );
    result:=true;
  except result:= false; end;
end;

Initialization
  E:=TExcelTools.Create;
finalization
  E.Free;
end.
