unit WordTool;

interface
uses windows,Sysutils,ClipWord,ConstOffice;
///  version: 1.2
///  ===ver:1.2===
///   *    office 2007
///   *   
///     + AddShapesExcel
///     + ActivateDocShapesExcel
///  ===ver:1.1.1===
///  * TWordTools
///    + Find         -  
///    + SelCol       -   
///    + SelCell      -   
///    - SelStory     -  , =>  SelAll
///    + SelAll       -  
///    + MoveLeft     -  
///    + MoveRight    -  
///    + Move         -  
///    * AddTOC       -  ,        
///    + PastEnter    -     
///  ===ver:1.1===
///  + TWordParagraphFormat  -    
///  + TWordFontFormat       -    
///  * TWordTools
///    + SelFormatParagraph  -      
///    + SelFormatFont       -      
///    + AddTOC              -   
///    + UpDateTOC           -   
///  ===ver:1.0===


type
   TWordFormat = class
     private
       _o:OleVariant;
     public
       Constructor Create(o:OleVariant);
       property Format:OleVariant read _o;
   end;

   TWordParagraphFormat = class(TWordFormat)
     private
       function GetOLL: WdOutlineLevel;
       procedure SetOLL(const Value: WdOutlineLevel);
       function getAl: WdParagraphAlignment;
       function getLSR: WdLineSpacing;
       function getSA: integer;
       function getSAA: boolean;
       function getSB: integer;
       function getSBA: boolean;
       procedure SetAl(const Value: WdParagraphAlignment);
       procedure setLSR(const Value: WdLineSpacing);
       procedure setSA(const Value: integer);
       procedure setSAA(const Value: boolean);
       procedure setSB(const Value: integer);
       procedure setSBA(const Value: boolean);

     public
       Property OutlineLevel:WdOutlineLevel read GetOLL write SetOLL;
       Property SpaceBefore:integer read getSB write setSB;
       Property SpaceBeforeAuto:boolean read getSBA write setSBA;
       Property SpaceAfter:integer read getSA write setSA;
       Property SpaceAfterAuto:boolean read getSAA write setSAA;
       Property LineSpacingRule:WdLineSpacing read getLSR write setLSR;
       Property Align:WdParagraphAlignment read getAl write SetAl;
   end;

   TWordFontFormat = class(TWordFormat)
     private
       function getA: WdAnimation;
       function getAC: Boolean;
       function getB: boolean;
       function getC: DWord;
       function getDS: Boolean;
       function getE: Boolean;
       function getEn: Boolean;
       function getH: Boolean;
       function getI: boolean;
       function getKr: Double;
       function getNm: String;
       function getOL: Boolean;
       function getS: Boolean;
       function getSb: Boolean;
       function getSC: Boolean;
       function getSd: Boolean;
       function getSl: Double;
       function getSp: Boolean;
       function getSz: Double;
       function getUL: DWord;
       function getULC: DWord;
       procedure setA(const Value: WdAnimation);
       procedure setAC(const Value: Boolean);
       procedure setB(const Value: boolean);
       procedure setC(const Value: DWord);
       procedure setDS(const Value: Boolean);
       procedure setE(const Value: Boolean);
       procedure setEn(const Value: Boolean);
       procedure setH(const Value: Boolean);
       procedure setI(const Value: boolean);
       procedure setKr(const Value: Double);
       procedure setNm(const Value: String);
       procedure setOL(const Value: Boolean);
       procedure setS(const Value: Boolean);
       procedure setSb(const Value: Boolean);
       procedure setSC(const Value: Boolean);
       procedure setSd(const Value: Boolean);
       procedure setSl(const Value: Double);
       procedure setSp(const Value: Boolean);
       procedure setSz(const Value: Double);
       procedure SetUL(const Value: DWord);
       procedure setULC(const Value: DWord);

     public
       Property Family:String read getNm write setNm;
       Property Size:Double read getSz write setSz;
       Property Bold:boolean read getB write setB;
       Property Italic:boolean read getI write setI;
       Property Underline:DWord read getUL write SetUL;
       Property UnderlineColor:DWord read getULC write setULC;
       Property Strike:Boolean read getS write setS;
       Property DoubleStrike:Boolean read getDS write setDS;
       Property Outline:Boolean read getOL write setOL;
       Property Emboss:Boolean read getE write setE;
       Property Shadow:Boolean read getSd write setSd;
       Property Hidden:Boolean read getH write setH;
       Property SmallCaps:Boolean read getSC write setSC;
       Property AllCaps:Boolean read getAC write setAC;
       Property Color:DWord read getC write setC;
       Property Engrave:Boolean read getEn write setEn;
       Property Super:Boolean read getSp write setSp;
       Property Sub:Boolean read getSb write setSb;
       Property Scaling:Double read getSl write setSl;
       Property Kerning:Double read getKr write setKr;
       Property Animation:WdAnimation read getA write setA;
   end;


   TWordTools=class
       private
         W,P,R:OLEvariant;
         BRes,_v,defForw:boolean;
         Procedure setv(v:boolean);
          Function getW:double;
         Procedure setW(i:double);
          Function getH:double;
         Procedure setH(i:double);
          Function getL:double;
         Procedure setL(i:double);
          Function getT:double;
         Procedure setT(i:double);
          Function getS:integer;
         Procedure setS(i:integer);
          Function getP:double;
         Procedure setP(i:double);
       public
         wRect:TRect;

         Constructor Create;
          property Word:olevariant read W;
          property NoErr:boolean read BRes;
          property Visible:boolean read _v write setv;
          property DefaultForward:boolean read defForw write defForw;

         Procedure SpeedDraw(b:boolean=true);
         Procedure getRect;
         Procedure setRect;
          property Width:double read getW write setW;
          property Height:double read getH write setH;
          property Left:double read getL write setL;
          property Top:double read getT write setT;
          property WinState:integer read getS write setS;
          property Procentage:double read getP write setP;
         Procedure GotoNext(a:integer);

          Function AddDoc:boolean;
          Function OpenDoc(NameFile:string):boolean;
          Function SaveDocAs(NameFile:string):boolean;
          Function SaveDoc:boolean;
          Function CloseDoc:boolean;
          Function Open:boolean;
          Function Close:boolean;



         Function Find(txt:string;forf:boolean):boolean;overload;
         Function Find(txt:string):boolean;overload;
         Procedure Replase(old,new:string;forf:boolean);overload;
         Procedure Replase(old,new:string);overload;
         function Paste(s:string;SelectLenNext:boolean=true):boolean;

         Procedure PastPageNext;
         Procedure PastEnter(count:word=1);
         Procedure PasteAndReplace(numBuf:byte;arRep:array of string;b:boolean=true);
          Function Clip(past:boolean=true):boolean;
          Function NumPage:word;

         Procedure Select(start,ends:longint);overload;
         Procedure SelectMove(Start,ends:longint);
         Function Select(start:boolean):integer;overload;
         function SelAll:boolean;
         function SelDelete:boolean;
         function SelRow:boolean;
         function SelCol:boolean;
         function SelCell:boolean;
         Function TextSel:string;


         function SelFormatParagraph:TWordParagraphFormat;
         function SelFormatFont:TWordFontFormat;

         function AddTOC(maxLevel:byte=3;style_TOC:WdTocFormat=wdTOCTemplate;
                  style_DOT:WdTabLeader=wdTabLeaderDots):boolean;
         function UpDateTOC:boolean;


         Function DocShapesCount:longint;
         Function DeActivateDocShapes:boolean;

         //   2003,   GRAPHS
         Function ActiveDocShapes(num:longint):boolean;
         Function ParRange(s,val: string):boolean;overload;
         Function ParRange(s: string;val:double):boolean;overload;
         Function ParRange(s:string):string;overload;

         //    Excel 
         Function AddShapesExcel: TWordTools;
         Function ActivateDocShapesExcel(num:longint; sizeX: integer = 0; sizeY: integer = 0):OleVariant;


         Procedure MoveDown(units:WdUnits=wdLine;count:integer=1;_select:boolean=true);
         Procedure MoveUP(units:WdUnits=wdLine;count:integer=1;_select:boolean=true);
         Procedure MoveLeft(units:WdUnits=wdLine;count:integer=1;_select:boolean=true);
         Procedure MoveRight(units:WdUnits=wdLine;count:integer=1;_select:boolean=true);
         Procedure Move(units:WdUnits=wdLine;count:integer=1);

         Procedure ESCKey;
         procedure HomeKey;
         Procedure EndKey;
     end;


//  Procedure ReplaseW(old,new:string);

var W:TWordTools;
implementation
uses ComObj;

{ TWordTools }

procedure TWordTools.Replase(old, new: string);
begin
  Replase(old,new,defForw);
end;

Procedure TWordTools.Replase(old,new:string;forf:boolean);
begin
  W.Selection.Find.Forward:=forf;
  W.Selection.Find.Text:= old;
  if W.Selection.Find.Execute then begin
    W.Selection.Delete;
    W.Selection.InsertAfter (new);
    W.Selection.Start:=W.Selection.End;
  end;
end;

function TWordTools.SaveDoc: boolean;
begin
  BRes:=true;
  try
    W.DisplayAlerts:=False;
    W.ActiveDocument.Save;
    W.DisplayAlerts:=true;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.SaveDocAs(NameFile: string): boolean;
begin
  BRes:=true;
  try
    W.DisplayAlerts:=false;
    W.ActiveDocument.SaveAs(NameFile);
    W.DisplayAlerts:=true;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.SelDelete:boolean;
begin
  BRes:=true;
  try W.Selection.Delete;
  except BRes:=false;end;
  result:=BRes;
end;

procedure TWordTools.Select(start, ends: Integer);
begin
  IF ends>=0 then W.Selection.End:=ends;
  IF start>=0 then W.Selection.Start:=start;
end;

function TWordTools.Select(start: boolean): integer;
begin
  IF start
   then result:=W.Selection.start
   else result:=W.Selection.End;
end;

procedure TWordTools.SelectMove(Start, ends: Integer);
begin
  IF ends<>0 then W.Selection.End:=W.Selection.End+ends;
  IF start<>0 then W.Selection.Start:=W.Selection.Start+start;
end;

function TWordTools.SelFormatFont: TWordFontFormat;
begin
  result:=TWordFontFormat.Create(W.Selection.Font);
end;

function TWordTools.SelFormatParagraph: TWordParagraphFormat;
begin
  result:=TWordParagraphFormat.Create(W.Selection.ParagraphFormat);
end;

function TWordTools.SelRow:boolean;
begin
  BRes:=true;
  try  w.Selection.SelectRow;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.SelAll:boolean;
begin
  BRes:=true;
  try
    W.Selection.WholeStory;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.SelCell:boolean;
begin
  BRes:=true;
  try  w.Selection.SelectCell;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.SelCol:boolean;
begin
  BRes:=true;
  try  w.Selection.SelectColumn;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.ActiveDocShapes(num: Integer): boolean;
begin
  BRes:=true;
  try
    P:=W.ActiveDocument.InlineShapes.Item(num);
    try
      P.Activate;
    Except
      P.Select;
    end;
    R:=P.OleFormat.Object.Application.DataSheet;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.AddDoc: boolean;
// Var Doc_:variant;
begin
  BRes:=true;
  try
    W.Documents.Add;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.ActivateDocShapesExcel(num: Integer; sizeX: integer = 0; sizeY: integer = 0): OleVariant;
begin
  BRes:=true;
  result:= '';
  try
    result := W.ActiveDocument.InlineShapes.Item(num);
    IF SizeX <> 0 then result.Width := 400;
    IF SizeY <> 0 then result.Height := 400;
    result.Select;
    result:= result.OleFormat.Object.Application;
//    result.Width := 400;
//    result.Height := 400;
  Except BRes:=false;end;

end;

function TWordTools.AddShapesExcel: TWordTools;
//var vv:OleVariant;
begin
  BRes:=true;
  try
    W.Selection.InlineShapes.AddOLEObject(
      'Excel.Chart.8','', False, False
    );
  Except BRes:=false;end;

  result := self;
end;

function TWordTools.AddTOC(maxLevel:byte;style_toc:WdTocFormat; style_dot:WdTabLeader): boolean;
var _act:OleVariant;
begin
  BRes:=true;
  try
    W.DisplayAlerts:=false;
    _act:=W.ActiveDocument;
    _act.TablesOfContents.Add(W.Selection.Range, True, 1, maxLevel, false,
         'TOC_Num', True, True, '', True, True, True );
    //, True,
      //  '', True, True, True);
    _act.TablesOfContents.Item(1).TabLeader:= Byte(style_dot);
    _act.TablesOfContents.Format := Byte(style_toc);
    W.DisplayAlerts:=true;
  except BRes:=false;end;
  result:=BRes;
{
Selection.MoveUp Unit:=wdLine, Count:=6
    With ActiveDocument
        .TablesOfContents.Add
            Range := Selection.Range,
            RightAlignPageNumbers := True,
            UseHeadingStyles := True,
            UpperHeadingLevel := 1,
            LowerHeadingLevel := 3,
            IncludePageNumbers := True,
            AddedStyles := "",
            UseHyperlinks := True,
            HidePageNumbersInWeb := True,
            UseOutlineLevels:= True

Add(Range As Range,
    [UseHeadingStyles],
    [UpperHeadingLevel],
    [LowerHeadingLevel],
    [UseFields],
    [TableID],
    [RightAlignPageNumbers],
    [IncludePageNumbers],
    [AddedStyles],
    [UseHyperlinks],
    [HidePageNumbersInWeb],
    [UseOutlineLevels])

        .TablesOfContents(1).TabLeader = wdTabLeaderDots
        .TablesOfContents.Format = wdIndexIndent
    End With}
end;

function TWordTools.Clip(past: boolean):boolean;
begin
  BRes:=true;
  try
    IF past
     then W.Selection.Paste
     else W.Selection.Copy;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.Close: boolean;
begin
  BRes:=true;
  try
    W.DisplayAlerts:=False;
    W.Quit(false);
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.CloseDoc: boolean;
begin
  BRes:=true;
  try
    W.DisplayAlerts:=false;
    W.ActiveDocument.Close(false);
    W.DisplayAlerts:=true;
  except BRes:=false;end;
  result:=BRes;
end;

constructor TWordTools.Create;
begin
  defForw:=true;
end;

function TWordTools.DeActivateDocShapes: boolean;
begin
  BRes:=true;
  try
    W.Activate;
    Select(0,0);
  except
    try
      W.Select;
      Select(0,0);
    Except BRes:=false;end;
  end;
  result:=BRes;
end;

function TWordTools.DocShapesCount: longint;
begin
  result:=W.ActiveDocument.InlineShapes.Count;
end;

procedure TWordTools.EndKey;
begin
  try  w.Selection.EndKey(6);  except end;
end;

procedure TWordTools.ESCKey;
begin
  w.Selection.EscapeKey;
end;

function TWordTools.Find(txt: string; forf: boolean): boolean;
begin
  BRes:=true;
  try
    W.Selection.Find.Forward:=forf;
    W.Selection.Find.Text:= txt;
    result:=W.Selection.Find.Execute
  except BRes:=false;result:=false; end;
end;

function TWordTools.Find(txt: string): boolean;
begin
  result:=Find(txt,defForw);
end;

function TWordTools.getH: double;
begin
  result:=W.Application.Height;
end;

function TWordTools.getL: double;
begin
 result:=W.Application.Left;
end;

function TWordTools.getP: double;
begin
  result:=W.ActiveWindow.ActivePane.View.Zoom.Percentage;
end;

procedure TWordTools.getRect;
begin
  wRect.left:=W.Application.Left;
  wRect.top:=W.Application.top;
  wRect.Right:=W.Application.Width;
  wRect.Bottom:=W.Application.Height;
end;

function TWordTools.getS: integer;
begin
  result:=W.Application.WindowState;
end;

function TWordTools.getT: double;
begin
  result:=W.Application.Top;
end;

function TWordTools.getW: double;
begin
  result:=W.Application.Width;
end;

procedure TWordTools.GotoNext(a: integer);
begin
  try W.Selection.GoToNext(a); except end;
end;

procedure TWordTools.HomeKey;
begin
  try w.Selection.HomeKey(6);except end;
end;

procedure TWordTools.Move(units: WdUnits; count: integer);
begin
  try w.Selection.Move(byte(units), count);except end;
end;

procedure TWordTools.MoveDown(units:WdUnits;count: integer;_select:boolean);
begin
  try w.Selection.MoveDown(byte(units), count,byte(_select));except end;//1
end;

procedure TWordTools.MoveLeft(units: WdUnits; count: integer; _select: boolean);
begin
  try w.Selection.MoveLeft(byte(units), count,byte(_select));except end;//1
end;

procedure TWordTools.MoveRight(units: WdUnits; count: integer;
  _select: boolean);
begin
  try w.Selection.MoveRight(byte(units), count,byte(_select));except end;//1
end;

procedure TWordTools.MoveUp(units:WdUnits;count: integer;_select:boolean);
begin
  try w.Selection.MoveUp(byte(units), count,byte(_select));except end;//1
end;

function TWordTools.NumPage: word;
begin
  result:=w.ActiveDocument.Range.Information[1];
end;

function TWordTools.Open: boolean;
begin
  BRes:=true;
  try W:=CreateOleObject('Word.Application');
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.OpenDoc(NameFile: string): boolean;
begin
  BRes:=true;
  try W.Documents.Open(NameFile);
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.ParRange(s,val: string): boolean;
begin
  BRes:=true;
  try
    R.Range[s].Value:=widestring(val); 
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.ParRange(s: string): string;
var R:oleVariant;
begin
  BRes:=true;
  try result:=P.Range[s].Value;
  except BRes:=false;end;
end;

function TWordTools.ParRange(s: string; val: double): boolean;
begin
  BRes:=true;
  try
    R.Range[s].Value:=val;
  except BRes:=false;end;
  result:=BRes;
end;

function TWordTools.Paste(s: string;SelectLenNext:boolean=true):boolean;
begin
  BRes:=true;
  try
    W.Selection.InsertAfter(s);
    IF SelectLenNext then
      W.Selection.Start:=W.Selection.Start+length(s);
  except BRes:=false;end;
  result:=BRes;
end;

procedure TWordTools.PasteAndReplace(numBuf: byte; arRep: array of string;
  b: boolean);
var i:byte;
begin
  CW.Index:=numBuf;
  Clip;
  i:=0;
  while i<length(arRep) do begin
    Replase(arRep[i],arRep[i+1]);
    inc(i,2);
  end;
  IF b
   then w.Selection.EndKey(6)
   else w.Selection.move(12,10000);
end;

procedure TWordTools.PastEnter(count: word);
var s_:string;i_:system.word;
begin
  s_:='';
  for i_:=count downto 0 do s_:=s_+#13;
  W.Selection.InsertAfter(s_);
end;

procedure TWordTools.PastPageNext;
begin
  W.Selection.insertBreak(7);
end;

procedure TWordTools.setH(i: double);
begin
  W.Application.Height:=i;
end;

procedure TWordTools.setL(i: double);
begin
  W.Application.Left:=i;
end;

procedure TWordTools.setP(i: double);
begin
  W.ActiveWindow.ActivePane.View.Zoom.Percentage:=i;
end;

procedure TWordTools.setRect;
begin
  W.Application.Left:=wRect.left;
  W.Application.top:=wRect.top;
  W.Application.Width:=wRect.Right;
  W.Application.Height:=wRect.Bottom;
end;

procedure TWordTools.setS(i: integer);
begin
  W.Application.WindowState:=i;
end;

procedure TWordTools.setT(i: double);
begin
  W.Application.Top:=i;
end;

procedure TWordTools.setv(v: boolean);
begin
  BRes:=true;
  try W.visible:= v;_v:=v;
  except BRes:=false;end;
end;

procedure TWordTools.setW(i: double);
begin
  W.Application.Width:=i;
end;

procedure TWordTools.SpeedDraw(b: boolean);
begin
  b:=not b;
//  W.Application.ScreenUpDating:=b;
  W.options.CheckSpellingAsYouType:=b;
  W.options.CheckGrammarAsYouType:=b;
end;

function TWordTools.TextSel: string;
begin
  try result:=W.Selection.Text;except result:='';end;
end;

function TWordTools.UpDateTOC: boolean;
begin
  BRes:=true;
  try
    W.DisplayAlerts:=false;
    W.ActiveDocument.TablesOfContents.Item(1).Update;
    W.DisplayAlerts:=true;
  except BRes:=false;end;
  result:=BRes;
end;

{ TWordFormat }

constructor TWordFormat.Create(o: OleVariant);
begin
  _o:=o;
end;

{ TWordParagraphFormaat }

function TWordParagraphFormat.getAl: WdParagraphAlignment;
begin
  try result:=WdParagraphAlignment(_o.Alignment);
  except result:=wdAlignParagraphLeft;end;
end;

function TWordParagraphFormat.getLSR: WdLineSpacing;
begin
  try result:=WdLineSpacing(_o.LineSpacingRule);
  except result:=wdLineSpaceSingle;end;
end;

function TWordParagraphFormat.GetOLL: WdOutlineLevel;
begin
  try result:=_o.OutlineLevel;except result:=10;end;
end;

function TWordParagraphFormat.getSA: integer;
begin
  try result:=_o.SpaceAfter;except result:=0;end;
end;

function TWordParagraphFormat.getSAA: boolean;
begin
try result:=_o.SpaceAfterAuto;except result:=false;end;
end;

function TWordParagraphFormat.getSB: integer;
begin
  try result:=_o.SpaceBefore;except result:=0;end;
end;

function TWordParagraphFormat.getSBA: boolean;
begin
  try result:=_o.SpaceBeforeAuto;except result:=false;end;
end;

procedure TWordParagraphFormat.SetAl(const Value: WdParagraphAlignment);
begin
  try _o.Alignment:=Byte(Value);except end;
end;

procedure TWordParagraphFormat.setLSR(const Value: WdLineSpacing);
begin
  try _o.LineSpacingRule:=Byte(Value);except end;
end;

procedure TWordParagraphFormat.SetOLL(const Value: WdOutlineLevel);
begin
  try _o.OutlineLevel:=Value;except end;
end;

procedure TWordParagraphFormat.setSA(const Value: integer);
begin
  try _o.SpaceAfter:=Value;except end;
end;

procedure TWordParagraphFormat.setSAA(const Value: boolean);
begin
  try _o.SpaceAfterAuto:=Value;except end;
end;

procedure TWordParagraphFormat.setSB(const Value: integer);
begin
  try _o.SpaceBefore:=Value;except end;
end;

procedure TWordParagraphFormat.setSBA(const Value: boolean);
begin
  try _o.SpaceBeforeAuto:=Value;except end;
end;

{ TWordFontFormat }

function TWordFontFormat.getA: WdAnimation;
begin
  try result:=WdAnimation(_o.Animation);except result:=wdAnimationNone;end;
end;

function TWordFontFormat.getAC: Boolean;
begin
  try result:=_o.AllCaps;except result:=false;end;
end;

function TWordFontFormat.getB: boolean;
begin
  try result:=_o.Bold;except result:=false;end;
end;

function TWordFontFormat.getC: DWord;
begin
  try result:=_o.Color;except result:=0;end;
end;

function TWordFontFormat.getDS: Boolean;
begin
  try result:=_o.DoubleStrikeThrough;except result:=false;end;
end;

function TWordFontFormat.getE: Boolean;
begin
  try result:=_o.Emboss;except result:=false;end;
end;

function TWordFontFormat.getEn: Boolean;
begin
  try result:=_o.Engrave;except result:=false;end;
end;

function TWordFontFormat.getH: Boolean;
begin
  try result:=_o.Hidden;except result:=false;end;
end;

function TWordFontFormat.getI: boolean;
begin
  try result:=_o.Italic;except result:=false;end;
end;

function TWordFontFormat.getKr: Double;
begin
  try result:=_o.Kerning;except result:=0;end;
end;

function TWordFontFormat.getNm: String;
begin
  try result:=_o.Name;except result:='';end;
end;

function TWordFontFormat.getOL: Boolean;
begin
  try result:=_o.Outline;except result:=false;end;
end;

function TWordFontFormat.getS: Boolean;
begin
  try result:=_o.StrikeThrough;except result:=false;end;
end;

function TWordFontFormat.getSb: Boolean;
begin
  try result:=_o.Subscript;except result:=false;end;
end;

function TWordFontFormat.getSC: Boolean;
begin
  try result:=_o.SmallCaps;except result:=false;end;
end;

function TWordFontFormat.getSd: Boolean;
begin
  try result:=_o.Shadow;except result:=false;end;
end;

function TWordFontFormat.getSl: Double;
begin
  try result:=_o.Scaling;except result:=0;end;
end;

function TWordFontFormat.getSp: Boolean;
begin
  try result:=_o.Superscript;except result:=false;end;
end;

function TWordFontFormat.getSz: Double;
begin
  try result:=_o.Size;except result:=0;end;
end;

function TWordFontFormat.getUL: DWord;
begin
  try result:=_o.Underline;except result:=0;end;
end;

function TWordFontFormat.getULC: DWord;
begin
  try result:=_o.UnderlineColor;except result:=0;end;
end;

procedure TWordFontFormat.setA(const Value: WdAnimation);
begin
  try _o.Animation:=Byte(Value);except end;
end;

procedure TWordFontFormat.setAC(const Value: Boolean);
begin
  try _o.AllCaps:=Value;except end;
end;

procedure TWordFontFormat.setB(const Value: boolean);
begin
  try _o.Bold:=Value;except end;
end;

procedure TWordFontFormat.setC(const Value: DWord);
begin
  try _o.Color:=Value;except end;
end;

procedure TWordFontFormat.setDS(const Value: Boolean);
begin
  try _o.DoubleStrikeThrough:=Value;except end;
end;

procedure TWordFontFormat.setE(const Value: Boolean);
begin
  try _o.Emboss:=Value;except end;
end;

procedure TWordFontFormat.setEn(const Value: Boolean);
begin
  try _o.Engrave:=Value;except end;
end;

procedure TWordFontFormat.setH(const Value: Boolean);
begin
  try _o.Hidden:=Value;except end;
end;

procedure TWordFontFormat.setI(const Value: boolean);
begin
  try _o.Italic:=Value;except end;
end;

procedure TWordFontFormat.setKr(const Value: Double);
begin
  try _o.Kerning:=Value;except end;
end;

procedure TWordFontFormat.setNm(const Value: String);
begin
  try _o.Name:=Value;except end;
end;

procedure TWordFontFormat.setOL(const Value: Boolean);
begin
  try _o.OutLine:=Value;except end;
end;

procedure TWordFontFormat.setS(const Value: Boolean);
begin
  try _o.StrikeThrough:=Value;except end;
end;

procedure TWordFontFormat.setSb(const Value: Boolean);
begin
  try _o.Subscript:=Value;except end;
end;

procedure TWordFontFormat.setSC(const Value: Boolean);
begin
  try _o.SmallCaps:=Value;except end;
end;

procedure TWordFontFormat.setSd(const Value: Boolean);
begin
  try _o.Shadow:=Value;except end;
end;

procedure TWordFontFormat.setSl(const Value: Double);
begin
  try _o.Scaling:=Value;except end;
end;

procedure TWordFontFormat.setSp(const Value: Boolean);
begin
  try _o.Superscript:=Value;except end;
end;

procedure TWordFontFormat.setSz(const Value: Double);
begin
  try _o.Size:=Value;except end;
end;

procedure TWordFontFormat.SetUL(const Value: DWord);
begin
  try _o.Underline:=Value;except end;
end;

procedure TWordFontFormat.setULC(const Value: DWord);
begin
  try _o.UnderlineColor:=Value;except end;
end;

Initialization
  W:=TWordTools.Create;
finalization
  W.Free;
end.
