unit DBF_File;
//Version: 1.8
//:  
//     :
//    Delphi 5-7,2006+
//    Lazarus 0.9+
//    FreePascal 2.1+
//
////////////////////////////////////////////////////////////////////////////////
//  "dBase III" 
//   ""
//      
//   
{
==== ver 1.8 ====
*  
  + GetDBFTable  -    DBF
  + SetDBFTable  -    DBF-    

*     AutoCreateLogs   false,
   ,          

==== ver 1.7 ====
+   ,
            ,    ".log"
+     
    <dbf>.DopDataLog
+ AutoCreateLogs - /     

==== ver 1.6.2 ====
+  
  * LocateNoDel
  * LocateNoContext

-   "LowerCase"  "AnsiLowerCase"
-   "UpperCase"  "AnsiUpperCase"

==== oldver ====
*   "DBF_HEAD" ( DBF-)
*   "DBF_Field_Rec" (   )
*   "TRec_DBF_Field" (   )
*   "TDBF_Fields" ( )
  * /// 
  *      
*   "TDBF_Data" ( dBase (DBF))
  *   
  *   
  * / DBF-
  *   -
  *    
  *   
  * // 
  *  
  *     
  *   

*    
  * ArConstToFl    -   DBF- ("TDBF_Fields")
  * CreateDBFFile  -   DBF-
  * RenameDBFFile  - / DBF-    -
  * DeleteDBFFile  -  DBF-    -
  * PackDBF        -  DBF- (     )
  * PackDBT        -  - (      DBF-)
  * CopyDBFRecData -          
  * ReFieldDBF     -    DBF- (   )
  * GetFieldsDBF   -   DBF-  
  * CompactDBF     -    DBF- ("dBase III"  "")
  * TestDBF        -  DBF-   ,   
  * TestResult     -   

*  :
  * LocateDefault
*  
  * DBF_Data
  * TermFl
  * TermStr
  * DefaultDeCoding
}

{$H+}
interface
uses sysUtils,Variants,classes,unitUtils;
type
     TLocate_option = (loContext, loTrim, loCase, loNoDel, loNext);
     TLocateoption  = set of TLocate_option;
const
     LocateDefault   = [loContext .. loNoDel];
     LocateNoDel     = [loNoDel];
     LocateNoContext = [loTrim .. loNoDel];

type
    DBF_HEAD = record                     //  DBF-
		dbf_id      :byte;                // ,    :
									      //  $03 -   -
									      //  $83 -    ,     DBT-
		last_update :array[0..2]of byte;  //  , 
									      //  0  -    (  2 )
									      //  1  -  
									      //  2  -  
		last_rec    :Longword;            //   
		data_offset :word;                //    
		rec_size    :word;                //     + 1 
		filler      :array[0..19]of char; // 20  ,     32 
	end;
	TF_DBF_Head = file of DBF_HEAD;       //     DBF-
	DBF_Field_Rec = record                //   
		FieldName :array[0..10]of char;   // ,    
									      //         "0D",
									      //       
		FieldType :byte;                  // ,     :
									      //  C ($43) - 
									      //  D ($44) - 
									      //  L ($4C) - 
									      //  M ($4D) -  
									      //  N ($4E) - 
		Dummy     :array[0..3] of char;   //     
		LenInfo   :record case byte of    //   
			0: (Size     :word);          //   
			1: (Len, Dec :byte);          //   ,  
		end;
		filler :array[0..13]of char;      //   32 
	end;
	TF_DBF_FRec = file of DBF_Field_Rec;  //       DBF-



	TRec_DBF_Field = packed record        //     
		Name:string[10];                  // 
		tip:byte;                         // 
		ps:word;
		count:byte;                       //$7f type
		case byte of                      // 
			0: (size     :word);          // 
			1: (len, dec :byte);          //   
	end;
	ar_buf = array of byte;
	PDBF_Fields = ^TDBF_Fields;

	pLog = ^TLog;
	TLog = packed record
		f   :TextFile;
		txt :string;
	end;

 { TDBF_Fields }

	TDBF_Fields = Object
		private
			ar  :array of TRec_DBF_Field;       // 
			max :byte;                          //- 
			function  GetFL(i :byte) :TRec_DBF_Field;
			procedure SetFL(i :byte; r :TRec_DBF_Field);
			procedure setCount(ft :char; len, dec :byte);
		public
			property  Field[index :byte] :TRec_DBF_Field read GetFl write SetFL;
			property  Count :byte read max;     //- 
			procedure clear;                    //   
			procedure Add(Name_ :string; tp :char; sz :word = 0; Dec_ :byte = 0; _c :boolean = false); overload;
			procedure Add(fl :DBF_Field_Rec; _c :boolean = false); overload;
			procedure Add(fl :TRec_DBF_Field); overload;
			function  IndexByName(Name :string) :byte;
			function  NameByIndex(Index :byte) :string;
			procedure DelField(index :byte);
			procedure DelFieldName(Name :string);
			procedure Compact;
	end;
	TDBF_Data = class                  //    DBF 
		private                        // 
			ps :record                 //    
			  Name  :string;           //   
			  Index :byte;             //   
			end;
			fl        :PDBF_Fields;    // 
			_w        :boolean;        // 
			locStart  :boolean;        //     
			_c        :boolean;        // ,    
			rp        :longword;       //  
			HNDF      :TFileHandle;    //  dbf
			HNDT      :TFileHandle;    //  dbt
			VH        :DBF_HEAD;       //  
			VR        :DBF_Field_Rec;  //  / 
			Buffer    :ar_buf;         //
			MemBuffer :array of record // ()
				num :longword;
				ar  :ar_Buf;
			end;   
			Log       :pLog;
			
			function  _getMem(num :longword) :longint;
			procedure _getRec(num :longword; var buf; NoSet_ :boolean = true);
			procedure _setRec(num :longword; const buf);

			function  loc_Gets(s :array of string; j :word; option :TLocateOption) :string;
			function  loc_pos(s1, s2:string; option :TLocateOption) :boolean;

			function  GetFL(i :byte) :TRec_DBF_Field;
			procedure Sets(v :variant; ar_ :TRec_DBF_Field);
			function  Gets(ar_ :TRec_DBF_Field) :variant;
			function  VToS(v :variant; i :char; sz :word) :string;  //    
										  
			function  SToV(s :string; i :char; sz :word) :variant;  //   
			procedure New_;                                         // ,   
										                            //  (..      11.1,
										                            //      = "         0.0")
			procedure SetRP(w :longword);                           //   
			procedure SetRP2(w :longword);
			function  GetRP :longword;
			procedure FSetS(FieldName :string; v :variant);         //   ,  
			function  FGetS(FieldName :string) :variant;            //   ,  
			procedure FSetT(FieldName :string; v :variant);         //   ,   c Trim
			function  FGetT(FieldName :string) :variant;            //   ,   c Trim

			procedure FSetI(Index :byte; v :variant);               //   ,  
			function  FGetI(Index :byte) :variant;                  //   ,  
			function  FGetD(Index :variant) :variant;
			Procedure FSetD(Index, v :variant);
			function  GetDel :boolean;
			procedure SetDel(b :boolean);
			{ , ()  }
			procedure init;
		public                            // 
			StringResult :boolean;        //        
			DeCoding     :byte;           //    :
										  //
										  // 0 -  
										  // 1 - () ANCII <=> ANSI ()
										  // 2 - () ANSI <=> ANCII ()
			TimeOut :record
				times :longword;          // 
				Outs  :longword;          // 
			end;
			MemRec       :word;           //   ( )
			DopDataLog   :string;         //   

			Constructor Create; overload;
			Constructor Create(Name :string; RW :string = 'rw';
							style :byte = 0; CreateBuffer :boolean = true;
							LoadFields :boolean = true); overload;
			Destructor  Destroy; override;
			property  InfoField[index :byte] :TRec_DBF_Field read GetFl;
			function  AllField :TDBF_Fields; // read fl;
			function  FileDBF :boolean;      // read HNDF;// ,       dbf
			function  FileDBT :boolean;      // read HNDT;// ,       dbt
			function  Count :byte;           //- 
			function  Head :DBF_HEAD;        //read VH;   //   
			procedure clear;                 //   
			procedure Add(Name_ :string; tp :char; sz :word = 0; Dec_ :byte = 0);
										     // 
			procedure CreateFile(Name :string; Compact :boolean = false); // DBF 
										     //  Name -  ,   
			//      DBT 
			function  TRead(num :longword) :string;               //  -   num
			function  TWrite(num :longword; s :string) :longword; //  -   num
			//      DBF 
			function  FOpen(Name :string; RW :string = 'rw';
					   style :byte = 0; CreateBuffer :boolean = true;
					   LoadFields :boolean = true) :boolean;
										  // ,      false
										  //  Name         -    
										  //  RW           -   
										  //      ('r' -   ,
										  //       'rw' -    ,
										  //       'w' -   )
										  //  style        -  
										  //      (0 -   (1  )
										  //       1 -    
										  //       2 -      
										  //       3 -     
										  //       4 - -"-"-,       )
										  //  CreateBuffer -    
										  //      ( ,    )
										  //  LoadFields   -      ,   ,
										  //                         
			function  Ends :boolean;      //   
			procedure FRead(var buf; NoNext :boolean = True);
										  //      
										  //  buf    - /       
										  //  NoNext -         ,  false,       
			procedure FWrite(const buf; NoNext :boolean = True);
										  //      
			property FRecPos :longword read getRP write SetRP;
			property RecPos :longword read getRP write SetRP2;
										                //  
			function  LenRec :word;                     //- 
			procedure FClose;                           // DBF 
			procedure FNext(ReadBuf :boolean = true);   //   
														//    ,   ReadBuf 
														//  ReadBuf -      ,  
			procedure FPrior(ReadBuf :boolean = true);  //   
			procedure FFirst(ReadBuf :boolean = true);  //   
			procedure FLast(ReadBuf :boolean = true);   //   
			procedure FInsert(New :boolean = true);     //  
													    //    ,   New 
													    //  New -      
			function  IndexByName(Name :string) :byte;  //  ,   
			function  NameByIndex(Index :byte) :string; //  ,   
			procedure SaveHead(NewData :boolean = true; AutoClose :boolean = false);
													    // 
													    //  NewData   -     
													    //  AutoClose -      
			//     ,    
			property  Deleted :boolean read GetDel write SetDel;
										                                            //  /  
			function  BufferEmpty :boolean;                                         //  
			procedure FReadBuf(NoNext :boolean = true; DelRead :boolean = false);   //     
									//  DelRead -    ,      ,   
			procedure FWriteBuf(NoNext :boolean = true; DelWrite :boolean = false); //     
									//  DelWrite -     
			procedure SetBuf(const Buf);     										//        
			procedure GetBuf(var Buf);        										//        
			property  Fields[Name :string] :variant read FGetS write FSetS;         ///   ,  
			property  Fieldt[Name :string] :variant read FGetT write FSetT;         ///   ,    Trim
			property  Fieldi[Index :byte] :variant read FGetI write FSetI;          ///   ,  
			property  FieldD[Index :variant] :variant read FGetD write FSetD; default;
			procedure NullBuf(nils :boolean = false);                               // 
																					//  nils -   
			function Locate(FieldNames :string; Values :string; _next :longword = 0; Option :TLocateOption = LocateDefault) :boolean; overload;
			function Locate(FieldNames :array of string; Values :string{Variant}; _next :LongWord = 0; Option :TLocateOption = LocateDefault) :boolean; overload;
			function Locate(FieldNames, Values :array of string; _next :LongWord = 0; Option :TLocateOption = LocateDefault) :boolean; overload;
				 // 
				 //  FieldNames -     
				 //    (  ,      ";",
				 //          ,      '')
				 //  Values     -  ,
				 //           ,
				 //           
				 //    (   "VarArrayOf",  "Variants")
				 //  Option     -  :
				 //    loContext    -  ,  ,    
				 //    loTrim       -    ,  ,    
				 //    loNext       -         ,  
				 //                       
				 //                          
	end;

	Function  ArConstToFl(Fields :array of const; Compact :boolean = false) :TDBF_Fields;
	procedure CreateDBFFile(Name :string; Fields :array of const; Compact :boolean = false); overload;
										   //  DBF
										   //  Name   -  ,   
										   //  Fields -  
	procedure CreateDBFFile(Name :string; Fields :TDBF_Fields; Compact :boolean = false);overload;
	procedure RenameDBFFile(OldName, NewName :string);
	procedure DeleteDBFFile(Name :string);

	function  PackDBF(Name :string) :longword;
	function  PackDBT(Name :string) :longint;
	procedure CopyDBFRecData(NameA, NameB :string);
	procedure ReFieldDBF(Name :string; NewFl :TDBF_Fields);
	Function  GetFieldsDBF(Name :string) :TDBF_Fields;
	Procedure CompactDBF(Name :string; Compact :boolean = true);

	function  TestDBF(Name :String; restory :boolean = false) :boolean;
	function  TestResult :string;

	Function  GetDBFTable(const Name :String; Fields :String = ''; LoadDelFields :boolean = false) :TableArray;
	Function  SetDBFTable(const Name :String; Tbl :TableArray; writeAll :boolean = false) :boolean;


var DBF_Data        :TDBF_Data;    //    DBF 
    TermFl          :byte    = 10; //32;
    TermStr         :byte    = 32; //32;
    DefaultDeCoding :byte    = 1;
    AutoCreateLogs  :boolean = false;
implementation
var testData :packed record
		Error     :boolean;//set of (erRec);
		CountRec  :longword;
		FeildRec  :byte;
		FeildSize :word;
		Offset    :word;
		Nm        :String;
	end;
    DBF, NDBF :TDBF_Data;
    ll        :TextFile;
    r_l       :boolean;



function TestResult :string;
begin
 result := 'Test Result:'#10#13' File:' + testData.Nm +
		   #10#13' Error:' + booltostr(testdata.Error, true) +
           #10#13' Count rec:' + inttostr(testData.CountRec)

end;

////////////////////////////////////////////////////////////////////////////////
function TestDBF(Name :String; restory :boolean = false) :boolean;
//var f:file of byte;
//var f:TFileHandle;
begin
	testData.Nm := Name;
	//Assign(f, Name + '.dbf'); reset(f);
	//testData.CountRec := FileSize(f);
	//close(f);
	testData.CountRec := TFileHandle.Size(Name + '.dbf');

	DBF := TDBF_Data.Create(Name, 'r');
	testData.CountRec := (testData.CountRec - DBF.VH.data_offset) div DBF.VH.rec_size;
	testData.FeildRec := DBF.fl^.max;
	testData.FeildSize := DBF.VH.rec_size;
	testData.Offset := DBF.VH.data_offset;

	testData.Error := (testData.CountRec <>DBF.VH.last_rec)
				  //or(testData.FeildRec>128)
				  //or(testData.FeildSize>4000)
				  //or(testData.Offset mod 32>1)
				  ;
	result := testData.Error;
	DBF.FClose;
	IF restory then begin
		DBF.FOpen(testData.Nm);
		DBF.VH.last_rec := testData.CountRec;
		DBF.savehead(true, true);
	end;
	DBF.Free;
end;

function PackDBT(Name :string) :longint;
var
	ar        :array of array of string;
	arb       :array of byte;
	i, mm, kk :longword;
	T         :TFileHandle;
	// f:file;
begin
	IF not TFileHandle.Exists(name + '.dbt') then begin result := 0; exit; end;
	//assignfile(f,name+'.dbt');
	//reset(f);
	result := TFileHandle.Size(name + '.dbt');//FileSize(f);
	//closefile(f);

	DBF := TDBF_Data.Create(name, 'r', 1);
	Setlength(arb, 0);
	mm := 0;
	for i := 0 to DBF.fl^.max - 1 do
		IF DBF.fl^.ar[i].tip = byte('M') then begin
			SetLength(arb, mm + 1);
			arb[mm] := i;
			inc(mm);
		end;
	IF mm = 0 then begin DBF.FClose; exit; end;
	SetLength(ar, DBF.VH.Last_rec, mm);
	i := 0;
	DBF.FFirst;
	while not DBF.Ends do begin
		for kk := 0 to mm - 1 do
			ar[i, kk] := DBF.Fieldi[arb[kk]];
		inc(i);
		DBF.FNext;
	end;
	DBF.FClose;

	T := TFileHandle.New;
	T.Creates(name + '.dbt');
	T.Write(dub(#0#0#0#0, 128)[1], 512);
	T.Free;
	// i := FileCreate(name + '.dbt');
	// FileWrite(i, dub(#0#0#0#0, 128)[1], 512);
	// FileClose(i);
	DBF.FOpen(name);
	DBF.FFirst;
	i := 0;
	while not DBF.Ends do begin
		for kk := 0 to mm - 1 do
			DBF.Fieldi[arb[kk]] := ar[i,kk];
		inc(i);
		DBF.FWriteBuf(false);
		DBF.FReadBuf;
	end;
	DBF.FClose;
	DBF.Free;
	SetLength(ar, 0);
	SetLength(arb, 0);

	result := result - TFileHandle.Size(name + '.dbt');
	IF FileExists(Name + '.log') then begin
		assignFile(ll, Name + '.log');
		append(ll);
		writeln(ll, DateTimeToStr(Date + Time), ' Memo Pack, deletes for ', result, ' bytes');
		CloseFile(ll);
	end;
	// reset(f);
	// result:=result-FileSize(f);
	// closefile(f);
end;

function PackDBF(Name :string) :longword;
var buf :array of byte;
begin
	DBF  := TDBF_Data.Create(name, 'r', 1);
	NDBF := TDBF_Data.Create;

	NDBF.fl^.ar  := DBF.fl^.ar;
	NDBF.fl^.max := DBF.fl^.max;

	r_l := AutoCreateLogs;
	AutoCreateLogs := false;
	NDBF.CreateFile(name + '_tmp', DBF._c);
	AutoCreateLogs := r_l;

	NDBF.FOpen(name + '_tmp');
	SetLength(buf, DBF.VH.rec_size + 1);
	result := 0;
	while not DBF.Ends do begin
		DBF.FRead(buf[0], false);
		IF buf[0] <> $2a
			then NDBF.FWrite(buf[0], false)
			else inc(result);
	end;
	DBF.FClose;
	NDBF.FClose;
	DBF.Free;
	NDBF.Free;
	TFileHandle.Delete(name + '.dbf');
	TFileHandle.Rename(name + '_tmp.dbf', name + '.dbf');
	IF TFileHandle.Exists(name + '.dbt') then
		TFileHandle.Delete(name + '_tmp.dbt');

	IF(result > 0) and FileExists(Name + '.log') then begin
		assignFile(ll, Name + '.log');
		Append(ll);
		writeln(ll, DateTimeToStr(Date + Time), ' Rec Pack, deletes for ', result, ' record');
		CloseFile(ll);
	end;

	SetLength(buf, 0);
end;

Function ArConstToFl(Fields :array of const; Compact :boolean = false) :TDBF_Fields;
var 
	i    :word; 
	Name :string; 
	t    :char; 
	sz   :word; 
	d    :byte;
begin
	result.clear;
	IF length(Fields) > 0 then begin
		i := 0;
		while i < length(Fields) do begin
			Name := string(Fields[i].VPChar);
			inc(i);
			t := Fields[i].VChar;
			inc(i);
			IF t = 'N' then begin
				sz := Fields[i].VInteger;
				inc(i);
				D := Fields[i].VInteger;
				inc(i);
			end else IF t = 'C' then begin
				Sz := Fields[i].VInteger;
				inc(i);
				d := 0;
			end else begin 
				Sz := 0;
				d  := 0;
			end;
			result.Add(Name, t, sz, d, Compact);
		end;
	end;
end;

procedure CreateDBFFile(Name :string; Fields:array of const; Compact:boolean = false);
begin
  CreateDBFFile(Name, ArConstToFl(Fields, Compact), Compact);
end;

procedure CreateDBFFile(Name :string; Fields :TDBF_Fields; Compact :boolean = false);
var
// FH:TFileHandle;//TF_DBF_Head;
	FR, T          :TFileHandle;//TF_DBF_FRec;
	VH             :DBF_HEAD;
	VR             :DBF_Field_Rec;
	day, year, mes :word;
	k              :boolean;
	Null           :string;
begin
	//  
	//assign(FH, Name + '.dbf');
	//assign(FR, Name + '.dbf');
	FR := TFileHandle.New;
	FR.Creates(Name+'.dbf');
	//rewrite(FR);   // 
	Null:=dub(#0#0#0#0,8);  // 
	move(Null[1],VR,32);    //   
	move(Null[1],VH,32);
	IF Compact then Fields.Compact;
	with VH do begin        // 
		IF Compact
			then dbf_id := $7F
			else dbf_id := 03;
		DecodeDate(Date, year, mes, day);
		last_update[0] := year mod 100;
		last_update[1] := mes;
		last_update[2] := day;
		last_rec    := 0;
		data_offset := (Fields.max + 1) * 32 + 1; //   
		rec_size    := 1;
		filler[19]  := char(TermFL);
	end;
	//    
	FR.Write(VR, 32);
	//write(FR,VR);
	//   
	day := 0;
	k   := true;
	IF FileExists(name + '.log') or AutoCreateLogs then begin
		assignFile(ll, name + '.log');
		IF FileExists(name + '.log') 
			then append(ll) 
			else rewrite(ll);
		writeln(ll, DateTimeToStr(Date + Time), ' Create New Base');
		CloseFile(ll);
	end;

	while day < Fields.max do with VR do begin
		StrCopy(@FieldName[0], @Fields.ar[day].Name[1]);
		FieldType := Fields.ar[day].tip;
		IF k and (FieldType in [$4D, byte('B')])then begin
			VH.dbf_id := VH.dbf_id or $80;
			T := TFileHandle.New;
			T.Creates(Name + '.dbt');
			T.Write(dub(#0#0#0#0, 128)[1],512);
			T.Free;
			//year := FileCreate(name + '.dbt');
			//FileWrite(year, dub(#0#0#0#0, 128)[1],512);
			//FileClose(year);
			k := false;
		end;
		
		IF FieldType = $4E then begin
			LenInfo.Len := Fields.ar[day].len;
			LenInfo.Dec := Fields.ar[day].dec;
		end else LenInfo.Size := Fields.ar[day].size;
		
		IF Compact
			then VH.rec_size:=VH.rec_size+Fields.ar[day].count
			else VH.rec_size:=VH.rec_size+LenInfo.Len;
			
		move(dub(' ',13)[1], filler[0], 13);
		move(dub(' ', 4)[1], Dummy[0],  4);
		filler[13] := char(TermFL);
		inc(day);
		FR.Write(VR, 32);
		//write(FR,VR);
	end;
	//  
	Null[1] := #$0D;
	Null[2] := #$1A;
	move(Null[1], VR, 32);
	FR.Write(VR, 32);
	//write(FR,VR);
	FR.Seek;
	FR.Write(VH, 32);
	FR.Free;
	//close(FR);
	//   
	//reset(FH);
	//write(FH,VH);
	//close(FH);
end;

procedure RenameDBFFile(OldName, NewName :string);
begin
	IF TFileHandle.Exists(OldName + '.dbf') then begin
		TFileHandle.Rename(oldName + '.dbf', NewName + '.dbf');
		IF FileExists(OldName + '.log') then begin
			assignFile(ll, OldName + '.log');
			append(ll);
			writeln(ll, DateTimeToStr(Date + Time), ' ReName {[', OldName, ']} => {[', NewName, ']}');
			CloseFile(ll);
			TFileHandle.Rename(oldName + '.log', NewName + '.log');
		end;
		IF TFileHandle.Exists(OldName + '.dbt') then
			TFileHandle.Rename(OldName + '.dbt', NewName + '.dbt');
	end;
end;

procedure DeleteDBFFile(Name :string);
begin
	IF TFileHandle.Exists(Name + '.dbf') then begin
		TFileHandle.Delete(Name + '.dbf');
		IF FileExists(Name + '.log') then begin
			assignFile(ll,Name+'.log');
			append(ll);
			writeln(ll,DateTimeToStr(Date+Time),' Delete Base {[',Name,']}');
			CloseFile(ll);
		end;
		IF TFileHandle.Exists(Name+'.dbt')then
			TFileHandle.Delete(Name+'.dbt');
	end;
end;

procedure CopyDBFRecData(NameA, NameB :string);
var i :byte;
begin
	DBF := TDBF_Data.Create(NameA, 'r');
	IF(DBF.fl^.max > 0)then begin
		NDBF := TDBF_Data.Create(NameB);
		IF(NDBF.fl^.max > 0)then begin
			IF FileExists(NameB + '.log') then begin
				assignFile(ll, NameB + '.log');
				append(ll);
				writeln(ll, DateTimeToStr(Date + Time), ' Copy Records Data {[', NameA, ']} => {[', NameB,']}');
				CloseFile(ll);
			end;
			DBF.FFirst;
			while not DBF.Ends do begin
				NDBF.FInsert;
				for i := 0 to high(DBF.fl^.ar) do
					NDBF.Fields[DBF.fl^.ar[i].Name] := DBF.Fieldi[i];
				NDBF.Deleted := DBF.Deleted;
				NDBF.FWriteBuf;
				DBF.FNext;
			end;
		end;
		NDBF.FClose;
		NDBF.Free;
	end;
	DBF.FClose;
	DBF.Free;
end;

procedure ReFieldDBF(Name :string; NewFl :TDBF_Fields);
var i:word;
begin
	RenameDBFFile(name, name + '_olddbf');
	r_l := AutoCreateLogs;
	AutoCreateLogs := false;
	CreateDBFFile(Name, NewFl);
	AutoCreateLogs := r_l;
	IF FileExists(Name + '.log') then begin
		assignFile(ll, Name + '.log');
		append(ll);
		write(ll, DateTimeToStr(Date + Time),' ReField {[');
		IF NewFl.Count > 0 then
			for i:=0 to High(NewFl.ar) do 
				write(ll, Trim(NewFl.ar[i].Name), ',');
		writeln(ll,']}');
		CloseFile(ll);
	end;
	CopyDBFRecData(Name + '_olddbf', Name);
	DeleteDBFFile(name + '_olddbf');
end;

Function GetFieldsDBF(Name :string) :TDBF_Fields;
begin
	DBF := TDBF_Data.Create(Name, 'r');
	result := DBF.fl^;
	DBF.FClose;
	DBF.Free;
end;

Procedure CompactDBF(Name :string; Compact :boolean = true);
var fl :TDBF_Fields;
begin
	RenameDBFFile(Name, Name + '_old');
	fl := GetFieldsDBF(Name + '_old');
	IF Compact then fl.Compact;
	
	CreateDBFFile(Name, fl, Compact);
	CopyDBFRecData(Name + '_old',Name);
	DeleteDBFFile(Name + '_old');
end;

//============================================================================//
//============================================================================//
//============================================================================//

Function GetDBFTable(const Name :String; Fields :String = ''; LoadDelFields :boolean = false) :TableArray;

	function GetFlType(c: Byte; dec:boolean):FieldType;
	begin
		case char(c) of
			'C','M','P','B' : result := ft_AnsiString;
			'L' : result := ft_Boolean;
			'N' :
				IF dec
				  then result := ft_Float
				  else result := ft_Int;
			'F' : result := ft_Float;
			'I' : result := ft_Int;
			'D','T','d' : result := ft_Date;
		end;
	end;

var
	i, j : Integer;
	DBF  : TDBF_Data;
	ar_s : ArS;
	ar_i : ArInt;
begin
	Fields := Trim(Fields);
	DBF := TDBF_Data.Create(Name, 'r', 1);
	IF DBF.FileDBF then begin
		SetLength( ar_i, 0);
		IF Fields <> '' then begin
			ar_s := Split(Fields,';');
			for i := 0 to high(ar_s) do begin
				j := DBF.IndexByName(trim(ar_s[i]));
				IF j = 255 then
					j := StrToIntDef(trim(ar_s[i]), 255);

				IF j <> 255 then AppendArInt(ar_i,j);
			end;
			Setlength(ar_s,0);
		end else
			for i := 0 to DBF.Count - 1 do
				AppendArInt(ar_i, i);

		IF Length(ar_i) > 0 then begin
			result := TableArray.Create;

			for i := 0 to high(ar_i)do
				with DBF.InfoField[ar_i[i]] do
					result.AddField(Trim(Name),
			GetFlType(tip,dec > 0));

			DBF.FFirst;
			while not DBF.Ends do begin
				IF LoadDelFields or not DBF.Deleted then begin
					Result.AddRow(DBF.RecPos);
					Result.Delete(DBF.Deleted);
					for i := 0 to high(ar_i) do
						Result[i + 1] := DBF[ar_i[i]];
				end;
				DBF.FNext;
			end;

			result.FixedData;
		end else result := nil;
		DBF.FClose;
	end else result := nil;
	DBF.Free;
end;

function SetDBFTable(const Name: String; Tbl: TableArray; writeAll: boolean = false): boolean;
var 
	i, j :integer;
	DBF  :TDBF_Data;
	str  :boolean;
begin
	IF not(Tbl.Modifikation or writeAll) then exit;
	DBF := TDBF_Data.Create(Name,'rw',1);
	result := DBF.FileDBF;
	IF result then begin
		tbl.First;
		while not tbl.EOF do begin
			j := tbl.GetNumRecord;
			IF(j = 0)or( j > DBF.Head.last_rec)then begin
				DBF.FInsert;
				for i := 1 to tbl.CountCol do
					DBF[tbl.NameField(i)] := tbl[i];
				DBF.Deleted := Tbl.IsDelete;
				DBF.FWriteBuf;
			end else begin
				DBF.RecPos := j;
				str:= false;

				for i := 1 to tbl.CountCol do
					IF writeAll or tbl.IsWriteField(i)then begin
						str := true;
						DBF[tbl.NameField(i)] := tbl[i];
					end;

				IF DBF.Deleted <> Tbl.IsDelete then begin
					DBF.Deleted := Tbl.IsDelete;
					str := true;
				end;
				IF str then DBF.FWriteBuf;
			end;

			tbl.Next;
		end;

		DBF.FClose;
	end;
	DBF.Free;
end;

//============================================================================//
//============================================================================//
//============================================================================//
function TDBF_Fields.GetFL(i :byte) :TRec_DBF_Field;
begin
	IF i < max
		then result:=ar[i]
		else FillChar(result,sizeof(TRec_DBF_Field),#0);
end;

procedure TDBF_Fields.SetFL(i :byte; r :TRec_DBF_Field);
begin
	IF i < max then ar[i] := r else Add(r);
end;

procedure TDBF_Fields.clear;
begin
	max := 0;
	setlength(ar, 0);
end;

procedure TDBF_Fields.DelField(index :byte);
var i :byte; tk :word;
begin
	IF(max > 0) and (index < max)then begin
		dec(max);
		IF index < max then begin
			tk := ar[index + 1].ps - ar[index].ps;
			for i := index to max - 1 do begin
				ar[i] := ar[i + 1];
				ar[i].ps := ar[i].ps - tk;
			end;
		end;

		SetLength(ar, max);
	end;
end;

procedure TDBF_Fields.DelFieldName(Name :string);
begin
	DelField(IndexByName(Name));
end;

procedure TDBF_Fields.Compact;
var i :byte;
begin
	IF max > 0 then
		for i := 1 to max do begin
			max := i;
			with ar[i-1]do
				setCount(char(tip),len,dec);
		end;
end;

procedure TDBF_Fields.Add(Name_ :string; tp :char; sz :word = 0; Dec_ :byte = 0; _c :boolean = false);
begin
	inc(max);
	SetLength(ar,max);
	with ar[max-1] do begin
		Name := Name_;
		tip := byte(tp);
		IF sz <> 0 then begin
			IF tp = 'N' then begin
				dec := dec_;
				len := sz;
			end else size := sz;
		end else case tp of                      // 
			'C': size := 10;                     // Char
			'N': begin len := 11; dec := 1; end; // Numeric(len, dec)
			'L': size := 1;                      // Logic
			'D': size := 8;                      // Date
			'M': size := 10;                     // Memo-string
			//$7f - type  //   ,     (   )
			'P': size := 10;                     //Password
			'F': begin len := 15; dec := 4;end;  //Float
			'I': begin len := 10; dec := 0;end;  //Int
			'T': size := 4;                      //Time
			'd': size := 8;                      //DateTime
			'B': size := 10;                     //Binary
		end;
		IF _c
			then SetCount(tp, len, Dec)
			else IF max > 1
				then ps := ar[max - 2].ps + ar[max - 2].len
				else ps := 1;
	end;
end;

procedure TDBF_Fields.Add(fl :DBF_Field_Rec; _c :boolean = false);
begin
	inc(max);
	SetLength(ar,max);
	with ar[max-1] do begin
		Name:=fl.FieldName;
		tip:=fl.FieldType;
		size:=fl.LenInfo.Size;
		IF _c
		then SetCount(char(fl.FieldType), fl.LenInfo.Len, fl.LenInfo.Dec)
		else IF max > 1
			then ps := ar[max - 2].ps + ar[max - 2].len
			else ps := 1;
	end;
end;

procedure TDBF_Fields.Add(fl :TRec_DBF_Field);
begin
	inc(max);
	SetLength(ar, max);
	ar[max-1] := fl;
end;

function TDBF_Fields.IndexByName(Name :string) :byte;
var i :byte;
begin
	result := 255;
	IF length(ar) > 0 then
		for i := 0 to high(ar) do 
			IF UpperCase(ar[i].Name) = UpperCase(Name) then begin
				result:=i;
				exit;
			end;
end;

function TDBF_Fields.NameByIndex(Index :byte) :string;
begin
	IF Index < max
		then result := ar[Index].Name
		else result := '';
end;

procedure TDBF_Fields.setCount(ft :char; len, dec :byte);
begin
	with ar[max - 1] do begin
		case ft of
			'M','B': count := 4;
			'I':IF Len <  3 then count := 1 else
				IF Len <  5 then count := 2 else
				IF Len <  8 then count := 3 else
				IF Len < 10 then count := 4 else
				IF Len < 13 then count := 5 else
				IF Len < 15 then count := 6 else
				IF Len < 17 then count := 7 
							else count := 8;
				
			'F':IF Len <  8 then count := 4 else
				IF Len < 12 then count := 6 else
				IF Len < 16 then count := 8 
							else count := 10;
				
			'N':IF Dec > 0 then begin
				IF Len <  8 then count := 4 else
				IF Len < 12 then count := 6 else
				IF Len < 16 then count := 8 
							else count := 10;
			end else begin
				IF Len <  3 then count := 1 else
				IF Len <  5 then count := 2 else
				IF Len <  8 then count := 3 else
				IF Len < 10 then count := 4 else
				IF Len < 13 then count := 5 else
				IF Len < 15 then count := 6 else
				IF Len < 17 then count := 7 
							else count := 8;
			end;
			'L': count := 1;
			'd': count := 8;
			'T','D': count := 4;
			'P': count := Len + 1;
			else count := Len;
		end;
		IF max > 1
			then ps := ar[max - 2].ps + ar[max - 2].count
			else ps := 1;
	end;
end;

//============================================================================//
//============================================================================//
//============================================================================//

procedure TDBF_Data.clear;
begin
	fl^.clear;
	ps.Name := '';
	ps.Index := 255;
	HNDF.Close;
	HNDT.Close;
	SetLength(MemBuffer, 0);
	//  IF HNDF > 0 then fclose;
	//  HNDF := 0;
end;

procedure TDBF_Data.Add(Name_ :string; tp :char; sz :word = 0; Dec_ :byte = 0);
begin
	Fl^.Add(Name_, tp, sz, Dec_);
end;

procedure TDBF_Data.CreateFile(Name :string; Compact :boolean = false);
begin
	IF Compact then fl^.Compact;
	CreateDBFFile(Name, fl^, Compact);
end;

function TDBF_Data.FOpen(Name :string; RW :string = 'rw';
                         style :byte = 0; CreateBuffer :boolean = true;
                         LoadFields :boolean = true) :boolean;
var 
	s       :string;
	ktm, ko :longword;
	i       :byte;
	
	function Mode(s:string):byte;
	begin
		s:=AnsiLowerCase(s);
		IF(s = 'rw') or (s = 'wr')then result := 2 else
		IF s = 'w' then result := 1 else result := 0;
		_w := result > 0;
	end;
	
	function tm :longword;
	begin
		result := DateTimeToTimeStamp(Time).Time;
	end;
begin
	locStart := false;
	clear;
	//  HNDF.Close;
	//  HNDT.Close;
	IF not TFileHandle.Exists(name + '.dbf')then begin result := false; exit; end;
	i := Mode(RW);
	IF _w and FileExists(name + '.log') then begin
		new(Log);
		Log^.txt := '';
		AssignFile(Log^.f,name + '.log');
		Append(Log^.f);
	end;
	//  HNDF:=0;
	case style of
		1: while not HNDF.Open(Name+'.dbf',i) do;
		//      HNDF:=FileOpen(Name+'.dbf',Mode(RW));
		2: begin
			ktm := tm + timeOut.times;
			while(not HNDF.Open(Name + '.dbf', i)) and (ktm > tm)do;
			//       HNDF:=FileOpen(Name+'.dbf',Mode(RW));
		end;
		3:begin
			ko := timeout.Outs;
			while(not HNDF.Open(Name + '.dbf', i)) and (ko > 0) do //begin
			//      HNDF:=FileOpen(Name+'.dbf',Mode(RW));
				dec(ko);
			//     end;
		end;
		4:begin
			ko := timeout.Outs;
			ktm := tm + timeOut.times;
			while(not HNDF.IsOpen) and (ko > 0)do
				if ktm <= tm then begin
					HNDF.Open(Name + '.dbf',i);
					dec(ko);
					ktm := tm + timeOut.times;
				end;
		end;
		else HNDF.Open(Name + '.dbf', i);//:=FileOpen(Name+'.dbf',Mode(RW));
	end;
	//  result := HNDF>0;       //    
	result := HNDF.IsOpen;
	//  HNDT := FileOpen(Name + '.dbt',Mode(RW));
	IF result then begin
		IF TFileHandle.Exists(Name + '.dbt')then
			HNDT.Open(Name + '.dbt', i);
		HNDF.Read(VH, 32);
		//FileRead(HNDF,VH,32);    // 
		_c := (VH.dbf_id and $7F) = $7F;
		IF LoadFields then begin //    
			Fl^.clear;
			VR.FieldName := '';
			while VR.FieldName[0] <> #13 do begin //     
				HNDF.Read(VR, 32);
				//FileRead(HNDF,VR,32);
				if VR.FieldName[0] = #13 then continue;
				Fl^.Add(VR, _c);
			end;
		end;
		HNDF.Seek(VH.data_offset);
		//FileSeek(HNDF,VH.data_offset,0);  //    
		rp:=1;
		IF CreateBuffer then begin  //  
			SetLength(Buffer, VH.rec_size + 1);
			s := dub(' ', VH.rec_size);
			move(s[1], Buffer[1], VH.rec_size);
			Buffer[0] := TermStr;
			FReadBuf;
		end;
	end;
end;

function TDBF_Data.LenRec :word;
begin
	result := VH.rec_size;
end;

procedure TDBF_Data.FClose;
begin
	SaveHead(_w, true);
end;

procedure TDBF_Data.SetRP(w :longword);
begin
	IF(w > 0) and (w <= VH.last_rec) then begin
		rp := w;
		HNDF.Seek(VH.data_offset + (rp - 1) * (VH.rec_size));
		//FileSeek(HNDF, VH.data_offset + (rp - 1) * (VH.rec_size),0);
	end;
end;

procedure TDBF_Data.SetRP2(w :longword);
begin
	IF(w > 0) and (w <= VH.last_rec)then begin
		rp := w;
		HNDF.Seek(VH.data_offset + (rp - 1) * (VH.rec_size));
		//FileSeek(HNDF, VH.data_offset + (rp - 1) * (VH.rec_size),0);
		IF length(Buffer) > 0 then FReadBuf;
	end;
end;

function TDBF_Data._getMem(num :longword) :longint;
var i :longword;
begin
	result := -1;
	IF length(MemBuffer) > 0 then
		for i := 0 to high(MemBuffer) do IF MemBuffer[i].num = num then begin
			result := i;
			exit;
		end;
end;

procedure TDBF_Data._getRec(num :longword; var buf; NoSet_ :boolean = true);
var 
	i, l      :longint;
	Buf_      :array of byte;
	ps_, ps_2 :longword;
begin
	i := _getMem(num);
	IF i = -1 then begin
		l := VH.rec_size * MemRec;
		IF (length(Buf_) <> l) then 
			SetLength(Buf_,l);
			
		ps_ := (num div MemRec) * MemRec;
		HNDF.Seek(VH.data_offset + ps_ * VH.rec_size);
		HNDF.Read(Buf_[0], l);
		ps_2 := Length(MemBuffer);
		SetLength(MemBuffer, ps_2 + MemRec);

		for i := 0 to MemRec - 1 do begin
			l := i * VH.rec_size;
			SetLength(MemBuffer[ps_2 + i].ar, VH.rec_size);
			move(Buf_[l], MemBuffer[ps_2 + i].ar[0], VH.rec_size);
			memBuffer[ps_2 + i].num := ps_ + i;
			IF(ps_+i=num)and NoSet_ then 
				move(buf_[l],buf,VH.rec_size);
		end;
	end else IF NoSet_ then 
		move(MemBuffer[i].ar[0], buf,VH.rec_size);
end;

procedure TDBF_Data._setRec(num :longword; const buf);
var i :longint;
begin
	i := _getMem(num);
	IF i = -1 then begin
		_getrec(num, i, false);
		i := _getMem(num);
	end;
	IF i > -1 then begin
		move(buf, MemBuffer[i].ar[0], VH.rec_size);
		HNDF.Seek(VH.data_offset + num * VH.rec_size);
		HNDF.Write(buf, VH.rec_size);
	end;
end;

procedure TDBF_Data.FRead(var buf; NoNext :boolean = True);
var i :integer;
begin
	//i:=FileRead(HNDF,Buf,VH.rec_size);
	IF memrec = 0 then begin
		i := HNDF.Read(Buf, VH.rec_size);
		IF byte(pointer(@Buf)^) = $1a then 
			byte(pointer(@Buf)^) := TermStr;
		IF NoNext
			then HNDF.Seek(-i, 1)//FileSeek(HNDF,-i,1)
			else inc(rp);
	end else begin
		_getRec(rp - 1, buf);
		IF not NoNext then inc(rp);
	end;
	IF(Log <> nil) and (Log^.txt <> '')then 
		Log^.txt := '';
end;

procedure TDBF_Data.FWrite(const buf; NoNext:boolean = True);
var w :byte;
begin
	IF _w then begin
		IF memrec = 0 then begin
			HNDF.Write(Buf, VH.rec_size);
			//FileWrite(HNDF,Buf,VH.rec_size);
			IF rp > VH.last_rec then begin //    
				inc(VH.last_rec);
				w := $1A;
				HNDF.Write(w, 1);
				HNDF.Seek(-1, 1);
				//FileWrite(HNDF,w,1);
				//FileSeek(HNDF,-1,1);
			end;
			IF NoNext
				then HNDF.Seek(-VH.rec_size, 1) //FileSeek(HNDF,-VH.rec_size,1)
				else inc(rp);
		end else begin
			_setRec(rp - 1, buf);
			IF rp > VH.last_rec then begin //    
				inc(VH.last_rec);
				w := $1A;
				HNDF.Seek(0, 2);
				HNDF.Write(w, 1);
				//      HNDF.Seek(-1,1);
			end;
			IF not NoNext then inc(rp);
		end;
		
		IF(Log <> nil) and (Log^.txt <> '')then begin
			write(Log^.f, Log^.txt);
			write(Log^.f, DateTimeToStr(Date + Time), ' ', rp, '|||');
			IF DopDataLog <> '' then 
				write(Log^.f, DopDataLog, '|||');
			writeln(Log^.f, 'Write Data');
			Log^.txt := '';
		end;
	end;
end;

procedure TDBF_Data.FNext(ReadBuf :boolean = true);
begin
	IF rp <= VH.last_rec + 1 then begin
		IF memrec = 0 then
			HNDF.Seek(VH.rec_size, 1);
		//FileSeek(HNDF,VH.rec_size,1);
		IF ReadBuf and (length(Buffer) > 0) then
			FReadBuf;
		inc(rp);
	end;
end;

procedure TDBF_Data.FPrior(ReadBuf :boolean = true);
begin
	IF rp>1 then begin
		IF memrec=0 then
			HNDF.Seek(-VH.rec_size,1);
		//FileSeek(HNDF,-VH.rec_size,1);
		IF ReadBuf and (length(Buffer) > 0) then 
			FReadBuf;
		dec(rp);
	end;
end;

procedure TDBF_Data.FFirst(ReadBuf :boolean = true);
begin
	locStart := false;
	IF memrec = 0 then
		HNDF.Seek(VH.data_offset, 0);
	//FileSeek(HNDF,VH.data_offset,0);
	rp := 1;
	IF ReadBuf and (length(Buffer) > 0)then 
		FReadBuf;
end;

procedure TDBF_Data.FLast(ReadBuf :boolean = true);
begin
	IF (rp < VH.last_rec) and (VH.last_rec > 0)then begin
		IF memrec = 0 then
			HNDF.Seek(VH.data_offset + (VH.last_rec - 1) * VH.rec_size, 0);
		//FileSeek(HNDF,VH.data_offset+(VH.last_rec-1)*VH.rec_size,0);
		IF ReadBuf and (length(Buffer) > 0)then 
			FReadBuf;
		rp := VH.last_rec;
	end;
end;

procedure TDBF_Data.FInsert(New :boolean = true);
begin
	IF _w then begin
		IF memrec = 0 then
		HNDF.Seek(VH.data_offset + VH.last_rec * VH.rec_size, 0);
		//FileSeek(HNDF,VH.data_offset+VH.last_rec*VH.rec_size,0);
		rp := VH.last_rec + 1;
		IF Log <> nil then begin
			Log^.txt := Log^.txt + DateTimeToStr(Date + Time) + ' ' + IntToStr(rp) + '|||';
			IF DopDataLog<>'' then 
				Log^.txt := Log^.txt + DopDataLog + '|||';
			Log^.txt := Log^.txt + 'Insert'#13#10;
		end;
		IF New and (length(Buffer) > 0)then New_;
	end;
end;

Constructor TDBF_Data.Create;
begin
	HNDF := TFileHandle.New;
	HNDT := TFileHandle.New;
	init;
end;

Constructor TDBF_Data.Create(Name :string; RW :string = 'rw';
    style :byte = 0; CreateBuffer :boolean = true; LoadFields :boolean = true);
begin
	HNDF := TFileHandle.New;
	HNDT := TFileHandle.New;
	init;
	FOpen(Name, RW, style, CreateBuffer, LoadFields);
end;

Destructor TDBF_Data.Destroy;
begin
	SetLength(Buffer, 0);
	clear;
	IF fl <> nil then dispose(fl);
	HNDF.Free;
	HNDT.Free;
	IF Log <> nil then begin
		CloseFile(Log^.f);
		Log^.txt := '';
		dispose(log);
		log := nil;
	end;
end;

procedure TDBF_Data.init;
begin
	SetLength(Buffer, 0);
	DeCoding := DefaultDeCoding;
	IF fl = nil then new(fl);
	//  fl^.clear;
	//  HNDF.Close;
	//  HNDT.Close;
	StringResult := false;
	clear;
	TimeOut.times := 0;
	TimeOut.Outs := 0;
	DopDataLog := '';
	Log := nil;
end;

function TDBF_Data.AllField: TDBF_Fields;
begin
	result:=fl^;
end;

function TDBF_Data.BufferEmpty :boolean;
begin
	result := length(Buffer) > 0;
end;

procedure TDBF_Data.FReadBuf(NoNext :boolean = true; DelRead :boolean = false);
begin
	IF length(Buffer) > 0 then begin
		FRead(Buffer[0], NoNext);
		IF(DelRead) and (Buffer[0] = $2a)then New_;
	end;
end;

procedure TDBF_Data.FWriteBuf(NoNext :boolean = true; DelWrite :boolean = false);
begin
	IF _w and (length(Buffer) > 0)then begin
		IF DelWrite then 
			Buffer[0] :=$2a;
		FWrite(Buffer[0], NoNext);
	end;
end;

procedure TDBF_Data.SetBuf(const Buf);
begin
	IF _w and (length(Buffer) > 0)then
		move(Buf, Buffer[0], VH.rec_size + 1);
end;

procedure TDBF_Data.GetBuf(var Buf);
begin
	IF length(Buffer) > 0 then
		move(Buffer[0], Buf, VH.rec_size + 1);
end;

procedure TDBF_data.Sets(v :variant; ar_ :TRec_DBF_Field);
var 
	t :string[255];
	j :longword;
	s :string;
	b :boolean;
	
	procedure MVInt;
	var i :int64;
	begin
		i := strtointdef(vartostr(v), 0);
		move(i, Buffer[ar_.ps], ar_.count);
	end;
	
	{$IFDEF fpc}
	function d_to_r(d :double) : real48;
	var
		res      : array[0..7] of byte;
		exponent : word;
	begin
		move(d, res, 8);
		{ copy mantissa }
		result[1] := (res[1]shr 5) or (res[2]shl 3);
		result[2] := (res[2]shr 5) or (res[3]shl 3);
		result[3] := (res[3]shr 5) or (res[4]shl 3);
		result[4] := (res[4]shr 5) or (res[5]shl 3);
		result[5] := (res[5]shr 5) or ((res[6] shl 3) and $7f) or (res[7]and $80);

		{ copy exponent }
		{ correct exponent: }
		exponent := (word(res[7])shl 4) or (res[6] shr 4);
		result[0] := byte(exponent - (1023 - 129));
	end;
	{$ENDIF}
	
	procedure MVFloat;
	var fe:extended;fd:double;fr:real48;fs:single;
	begin
		case ar_.count of
			4:begin
				fs := strtofloatdef(vartostr(v), 0);
				move(fs, Buffer[ar_.ps], 4);
			end;
			6:begin
				{$IFDEF fpc}
				fr := d_to_r(strtofloatdef(vartostr(v), 0));
				{$ELSE}
				fr := strtofloatdef(vartostr(v), 0);
				{$ENDIF}
				move(fr, Buffer[ar_.ps], 6);
			end;
			8:begin
				fd := strtofloatdef(vartostr(v), 0);
				move(fd, Buffer[ar_.ps], 8);
			end;
			10:begin
				fe := strtofloatdef(vartostr(v), 0);
				move(fe,Buffer[ar_.ps], 10);
			end;
		end;
	end;
	
	procedure MVdt(bb:byte);
	var dt :TDateTime; ts :TTimeStamp;
	begin
		case bb of
			0: dt := date + time;
			1: dt := date;
			2: dt := time;
		end;
		dt := strtodatetimedef(vartostr(v), dt);
		IF bb = 0 then move(dt,Buffer[ar_.ps],8) 
		else begin
			ts := DateTimeToTimeStamp(dt);
			IF bb = 1
				then move(ts.Date,Buffer[ar_.ps],4)
				else move(ts.Time,Buffer[ar_.ps],4)
		end;
	end;
	
	function V_S(v :variant) :string;
	var ss :string;
	begin
		ss := trim(vartostr(v));
		case DeCoding of
			1: ss := AnsiToAscii(ss);
			2: ss := AsciiToAnsi(ss);
		end;
		result:=ss;
	end;
begin
	t := '';
	IF _c then begin
		case char(ar_.tip) of
			'I': MVInt;
			'F': MVFloat;
			'N': IF ar_.dec > 0 then MVFloat else MVInt;
			'C': begin
				s := v_s(v);
				IF s <> ''
					then move(s[1], Buffer[ar_.ps] ,ar_.count)
					else move(dub(#0,ar_.count)[1], Buffer[ar_.ps], ar_.count);
			end;
			'P': begin
				t := v_s(v);
				for j := 1 to byte(t[0]) do
					t[j] := char(byte(t[j]) xor byte(t[0]));
				move(t[0], Buffer[ar_.ps], ar_.count);
			end;
			'L':begin
				b := v = true;
				move(b, Buffer[ar_.ps], 1);
			end;
			'd': MVdt(0);
			'D': MVdt(1);
			'T': MVdt(2);
			'M': begin
				move(buffer[ar_.ps], j, 4);
				s := v_s(v);
				IF s = ''
					then j := 0
					else j := TWrite(j, s);
				move(j, Buffer[ar_.ps], 4);
			end;
			'B': begin
				move(buffer[ar_.ps], j, 4);
				IF s = ''
					then j := 0
					else j := TWrite(j, s);
				move(j, Buffer[ar_.ps], 4);
			end;
		end;
	end else begin
		s := VToS(v, char(ar_.tip), ar_.size);
		if ar_.tip = $4D then begin
			move(buffer[ar_.ps], t, ar_.len);
			j := strtointdef(trim(t), 0);
			//    s:=TRead(j);
		end;
		IF Log <> nil then begin
			Log^.txt := Log^.txt + DateTimeToStr(Date + Time) + ' ' + IntToStr(rp) + '|||';
			IF DopDataLog <> '' then 
				Log^.txt := Log^.txt + DopDataLog + '|||';
			move(buffer[ar_.ps], t, ar_.len);
			Log^.txt := Log^.txt + 'Edit ' + ar_.Name + '{[' + Trim(s) + ']} => {[' + Trim(t) + ']}'#13#10;
		end;

		case DeCoding of
			1: s := AnsiToAscii(s);
			2: s := AsciiToAnsi(s);
		end;

		if ar_.tip = $4D then begin
			IF s = ''
				then s:=dub(' ',10)
				else begin
					j := TWrite(j,s);
					IF j=0 then s := dub(' ', 10) 
					else begin
						s:=inttostr(j);
						while length(s) < 10 do 
							s := ' ' + s;
					end;
				end;
		end else IF ar_.tip = $4E
			then while ar_.len > length(s) do s := ' ' + s
			else while ar_.len > length(s) do s := s + ' ';
		move(s[1],Buffer[ar_.ps],ar_.len);
	end;
end;

function TDBF_Data.GetRP: longword;
begin
	result:=rp;
end;

function TDBF_Data.Gets(ar_ :TRec_DBF_Field) :variant;
var 
	s :string;
	t :array[byte]of char;
	j :longword;

	procedure MVInt;
	var i :int64;
	begin
		i := 0;
		move(Buffer[ar_.ps], i, ar_.count);
		result := i;
	end;

	procedure MVFloat;
	var fe :extended; fd :double; fr :real48; fs :single;
	begin
		case ar_.count of
			4:begin
				move(Buffer[ar_.ps], fs, 4);
				result := fs;
			end;
			6:begin
				move(Buffer[ar_.ps], fr, 6);
				{$IFDEF fpc}
				result := double(fr);
				{$ELSE}
				result := fr;
				{$ENDIF}
			end;
			8:begin
				move(Buffer[ar_.ps], fd, 8);
				result := fd;
			end;
			10:begin
				move(Buffer[ar_.ps], fe, 10);
				result := fe;
			end;
		end;
	end;

	procedure MVdt(bb :byte);
	var dt :TDateTime; ts :TTimeStamp;
	begin
		ts.Time:=0;
		ts.Date:=0;
		IF bb=0 then move(Buffer[ar_.ps], dt, 8) else begin
			IF bb = 1
				then move(Buffer[ar_.ps], ts.Date, 4)
				else move(Buffer[ar_.ps], ts.Time, 4);
			dt := TimeStampToDateTime(ts);
		end;
		result := dt;
	end;

	procedure S_S(ss :string);
	begin
		case DeCoding of
			1: result := AsciiToAnsi(ss);
			2: result := AnsiToAscii(ss);
		end;
		result := trim(ss);
	end;
  
var sst :string[255]; b :boolean;
begin
	t := '';
	IF _c then begin
		case char(ar_.tip)of
			'I': MVInt;
			'F': MVFloat;
			'N': IF ar_.dec > 0 then MVFloat else MVInt;
			'C': begin
				move(Buffer[ar_.ps], t[0], ar_.count);
				S_S(t);
			end;
			'P': begin
				move(Buffer[ar_.ps], sst[0], ar_.count);
				for j:=1 to byte(sst[0]) do
					sst[j] := char(byte(sst[j]) xor byte(sst[0]));
				S_S(sst);
			end;
			'L': begin
				move(Buffer[ar_.ps],b,1);
				result:=b;
			end;
			'd': MVdt(0);
			'D': MVdt(1);
			'T': MVdt(2);
			'M': begin
				move(Buffer[ar_.ps], j, 4);
				IF j=0 then result := '' else begin
					string(pointer(@s)^) := TRead(j);
					S_S(s);
				end;
			end;
			'B': begin
				move(Buffer[ar_.ps], j, 4);
				IF j = 0 then result := '' else string(pointer(@s)^) := TRead(j);
			end;
		end;
		IF StringResult then result := vartostr(result);
	end else begin
		move(buffer[ar_.ps], t, ar_.len);
		s := t;
		if(ar_.tip = $4D) and (trim(s) <> '')then begin
			j := strtointdef(trim(s), 0);
			string(pointer(@s)^) := TRead(j);
		end;
		IF StringResult
			then result := s
			else result := SToV(s,char(ar_.tip), ar_.size);
		if VarIsStr(result) then case DeCoding of
			1: result := AsciiToAnsi(result);
			2: result := AnsiToAscii(result);
		end;
	end;
end;

function TDBF_Data.Head: DBF_HEAD;
begin
	result := VH;
end;

procedure TDBF_Data.FSetS(FieldName :string; v :variant);
var i :byte;
begin
	With fl^ do IF _w and  (length(Buffer)> 0)then begin
		FieldName := AnsiUpperCase(FieldName);
		IF ps.Name <> FieldName then begin
			IF length(ar) > 0 then
				for i := 0 to high(ar) do
					IF AnsiUpperCase(ar[i].Name) = FieldName then begin
						sets(v, ar[i]);
						ps.Name := FieldName;
						ps.Index := i;
						exit;
					end;
		end else Sets(v,ar[ps.Index]);
	end;
end;

function TDBF_Data.FGetS(FieldName :string) :variant;
var i :byte;
begin
	result := '';
	With fl^ do IF (length(Buffer) > 0)then begin
		FieldName := AnsiUpperCase(FieldName);
		IF ps.Name <> FieldName then begin
			IF length(ar) > 0 then for i := 0 to high(ar) do
				IF AnsiUpperCase(ar[i].Name) = FieldName then begin
					result := gets(ar[i]);
					ps.Name := FieldName;
					ps.Index := i;
					exit;
				end;
		end else result := gets(ar[ps.Index]);
	end;
end;

procedure TDBF_Data.FSetI(Index :byte; v :variant);
begin
	With fl^ do
		IF _w and (length(Buffer) > 0) and (Index < max)then begin
			sets(v, ar[Index]);
			ps.Name := AnsiUpperCase(ar[Index].Name);
			ps.Index := Index;
		end;
end;

function TDBF_Data.FGetI(Index :byte) :variant;
begin
	result := '';
	With fl^ do
		IF(length(Buffer) > 0) and (Index < max)then begin
			result := gets(ar[Index]);
			ps.Name := AnsiUpperCase(ar[Index].Name);
			ps.Index := Index;
		end;
end;

procedure TDBF_Data.FSetD(Index: Variant; v: Variant);
begin
	IF VarIsStr(Index) then FSetS(Index,v) else FSetI(Index,v);
end;

Function TDBF_Data.FGetD(Index: Variant) :variant;
begin
	IF VarIsStr(Index) then result := FGetS(Index) else result := FGetI(Index);
end;

function TDBF_Data.IndexByName(Name :string) :byte;
begin
	result := Fl^.IndexByName(Name);
end;

function TDBF_Data.NameByIndex(Index :byte) :string;
begin
	result := Fl^.NameByIndex(Index);
end;

function TDBF_Data.VToS(v :variant; i :char; sz :word) :string;
type k = packed record len, dec :byte; end;
var t :record case byte of
		//0:(i:integer);
		1:(r  :real);
		//2:(s:String);
		3:(d  :TDateTime);
		4:(b  :boolean);
		5:(Db :array[0..7]of byte);
		6:(Dw :array[0..3]of word);
	end;
	s :string;
begin
	case VarType(v) of //   
		varString,varOleStr: s := v;
		varSmallint,varInteger,varShortInt,varByte,varWord,varLongWord,varInt64,
		varSingle,varDouble,varCurrency: s := VarToStr(v);{}
		$B: IF v then s := 'T' else s := 'F';
		varDate: begin
			DecodeDate(v, t.DW[0], t.Dw[1], t.Dw[2]);
			s := To_s(t.Dw[0], 4) + To_s(t.Dw[1], 2) + To_s(t.Dw[2], 2);
		end;
		else s := dub(' ',sz);
	end;

	case i of //       
		//'C': result := s;
		'N': begin
			t.r := S_To_F(s);
			if k(sz).dec = 0
				then result := F_To_S(t.r, k(sz).len, 0)
				else result := F_To_S(t.r, k(sz).len - k(sz).dec - 1, k(sz).dec);
			while length(result) < k(sz).len do result := ' ' + result;
		end;
		'L': IF s[1]in['T','t','Y','y','1'] then result := 'T' else result := 'F';
		'D': begin
			t.Dw[0] := StrToInt(copy(s, 1, 4));
			t.Dw[1] := StrToInt(copy(s, 5, 2));
			t.Dw[2] := StrToInt(copy(s, 7, 2));
			t.d := EncodeDate(t.Dw[0], t.Dw[1], t.Dw[2]);
			DecodeDate(t.d, t.DW[0], t.Dw[1], t.Dw[2]);
			result := To_s(t.Dw[0], 4) + To_s(t.Dw[1], 2) + To_s(t.Dw[2], 2);
		end;
		else result := s;
	end;
end;

function TDBF_Data.SToV(s :string; i :char; sz :word) :variant;
type k=packed record len,dec:byte;end;
var t:record case byte of
		//0:(i :integer);
		1:(r  :real);
		//2:(s :String);
		3:(d  :TDateTime);
		4:(b  :boolean);
		5:(Db :array[0..7]of byte);
		6:(Dw :array[0..3]of word);
	end;
begin
	case i of     //    
		//'C':Result:=s;
		'N':result:=S_To_F(s);
		'L':result:=s[1]in['T','t','Y','y','1'];
		'D':begin
			t.Dw[0] := StrToIntDef(copy(s,1,4), 1900);
			t.Dw[1] := StrToIntDef(copy(s,5,2), 1);
			t.Dw[2] := StrToIntDef(copy(s,7,2), 1);
			result  := EncodeDate(t.Dw[0], t.Dw[1], t.Dw[2]);
		end;
		else result := s;
	end;
end;

procedure TDBF_Data.New_;
var 
	buf_ :string;
	i    :byte;
	l    :word;
begin
	buf_ := dub(#0,256);
	move(dub(' ', VH.rec_size)[1], Buffer[1], VH.rec_size);
	Buffer[0] := TermStr;
	i := 0;//k:=1;
	while i < fl^.max do begin
		with fl^.ar[i] do begin
			IF tip = $4E then l := len else l := size;
			IF not _c then case char(tip) of
				//'C':
				'N': move(F_To_S(0.0,len,dec)[1], Buffer[ps], l);
				'D': move(VToS(Date,'C',8)[1], Buffer[ps], l);
				'L': Buffer[ps] := byte('F');
			end else IF char(tip) = 'C'
				then move(dub(' ',Count)[1], Buffer[ps], count)
				else move(buf_[1], Buffer[ps], count);
		end;
		inc(i);
	end;
end;

procedure TDBF_Data.NullBuf(nils :boolean = false);
var c :char;
begin
	IF length(Buffer) > 0 then begin
		IF nils then begin
			IF _c then c := #0 else c := ' ';
			move(dub(c, VH.rec_size)[1], Buffer[1], VH.rec_size);
			Buffer[0] := TermStr;
		end else New_;
	end;
end;

function TDBF_Data.loc_Gets(s: array of string; j: Word; option: TLocateoption) :string;
begin
	IF loTrim in Option
		then result := Trim(FGetS(s[j]))
		else result := FGetS(s[j]);
	IF loCase in Option then result := AnsiUpperCase(result);
end;
function TDBF_Data.loc_pos(s1: string; s2: string; option: TLocateoption) :boolean;
begin
	IF loContext in Option
		then result := pos(s1,s2) > 0
		else result := s1 = s2;
end;

function TDBF_Data.Locate(FieldNames :string; Values :string; _next :longword; Option :TLocateOption) :boolean;
var 
	t      :string;
	k, rRS :boolean;
	{i      :word;}
	s, tt  :string;
label nx;
begin
	result := false;
	IF(length(Buffer) > 0)then begin
		s := FieldNames;
		t := Trim(VToS(Values, 'C', 1));
		IF loCase in option then t := AnsiUpperCase(t);
		// 
		IF _next = 0 then begin
			IF(rp = 1) and (not locStart) then begin
				locStart := true;
				FReadBuf;
			end else FReadBuf(false);
		end else RecPos := _next;
		FReadBuf(false);

		rRS := StringResult;
		StringResult := true;  //  
		while rp - 1 <= VH.last_rec do begin
			IF(loNoDel in option) and (Buffer[0] = $2a)then goto nx;
			//      k:=false;
			tt := loc_getS([s], 0, option);
			k  := loc_pos(t, tt, option);

			IF k then begin
				result := true;
				StringResult := rRS;  //   
				IF not(loNext in Option)then begin
					IF memrec = 0 then
						HNDF.Seek( -VH.rec_size, 1);
					//FileSeek(HNDF,-VH.rec_size,1);
					dec(rp);
				end;
				exit;
			end;
nx:			FReadBuf(false);
		end;
		IF not result then FInsert;
		StringResult := rRS;  //   
	end;
end;

function TDBF_Data.Locate(FieldNames :array of string; Values:string; _next :LongWord; Option :TLocateOption) :boolean;
var s          :array of string;
	k, kg, rRS :boolean;
	i, l       :word;
    tt, t      :string;
label nx;
begin
	result := false;
	IF(length(Buffer) > 0)then begin
		SetLength(s, length(FieldNames));
		for i := 0 to high(s) do
			s[i] := FieldNames[i];
		t := Trim(Values);
		IF loCase in Option then t := AnsiUpperCase(t);
		// 

		IF _next = 0 then begin
			IF(rp = 1) and (not locStart) then begin
				locStart := true;
				FReadBuf;
			end else FReadBuf(false);
		end else RecPos := _next;
		FReadBuf(false);

		rRS := StringResult;
		StringResult := true;  //  
		while rp - 1 <= VH.last_rec do begin
			IF(loNoDel in option) and (Buffer[0] = $2a)then goto nx;
			kg := false;
			for l := 0 to high(s) do begin
				//k := false;
				tt := loc_getS(s, l, option);
				k  := loc_pos(t, tt, option);
				kg := kg or k;
			end;

			IF kg then begin
				result := true;
				StringResult := rRS;  //   
				IF not(loNext in Option) then begin
					IF memrec = 0 then
						HNDF.Seek( -VH.rec_size, 1);
					//FileSeek(HNDF, -VH.rec_size, 1);
					dec(rp);
				end;
				exit;
			end;
nx:         FReadBuf(false);
		end;
		IF not result then FInsert;
		StringResult := rRS;  //   
	end;
end;

function TDBF_Data.Locate(FieldNames, Values :array of string; _next :LongWord; Option :TLocateOption) :boolean;
var 
	s, t       :array of string;
	k, kg, rRS :boolean;
	i, l       :word;
	tt         :string;
label nx;
begin
	result := false;
	IF(length(Buffer) > 0)then begin
		SetLength(s, length(FieldNames));
		for i := 0 to high(s) do
			s[i] := FieldNames[i];
		i := length(values);
		IF length(s) < i then exit;
		SetLength(t, i);
		for i := 0 to i - 1 do begin
			t[i] := Trim(Values[i]);
			IF loCase in option then t[i] := AnsiUpperCase(t[i]);
		end;
		// 

		IF _next = 0 then begin
			IF(rp = 1) and (not locStart)then begin
				locStart := true;
				FReadBuf;
			end else FReadBuf(false);
		end else RecPos := _next;
		FReadBuf(false);

		rRS := StringResult;StringResult:=true;  //  
		while rp - 1 <= VH.last_rec do begin
			IF(loNoDel in option) and (Buffer[0] = $2a)then goto nx;
			kg := true;
			for l := 0 to high(s) do IF kg then begin
				//k := false;
				tt := loc_getS(s, l, option);
				k := loc_pos(t[l], tt, option);
				kg := kg and k;
			end;


			IF kg then begin
				result := true;
				StringResult := rRS;  //   
				IF not(loNext in Option) then begin
					IF memrec = 0 then
						HNDF.Seek( -VH.rec_size, 1);
					//FileSeek(HNDF, -VH.rec_size, 1);
					dec(rp);
				end;
				exit;
			end;
nx:   		FReadBuf(false);
		end;
		IF not result then FInsert;
		StringResult := rRS;  //   
	end;
end;

procedure TDBF_Data.SaveHead(NewData :boolean = true; AutoClose :boolean = false);
var year, mes, day :word;
begin
	IF _w then begin
		IF NewData then begin
			DecodeDate(Date, year, mes, day);
			VH.last_update[0] := year mod 100;
			VH.last_update[1] := mes;
			VH.last_update[2] := day;
		end;
		HNDF.Seek(0, 0);
		HNDF.Write(VH, 32);
		//FileSeek(HNDF, 0, 0);
		//FileWrite(HNDF, VH, 32);
	end;
	IF AutoClose then begin
		HNDF.Close;
		HNDT.Close;
		IF Log <> nil then begin
			CloseFile(Log^.f);
			Log^.txt := '';
			dispose(Log);
			log := nil;
		end;
		//IF HNDF > 0 then FileClose(HNDF);
		//if HNDT > 0 then FileClose(HNDT);
		//HNDF := 0;
		//HNDT := 0;
		IF length(Buffer) > 0 then SetLength(Buffer, 0);
	end else IF _w then FRecPos := rp;
end;

function TDBF_Data.Ends:boolean;
begin
	result := rp > VH.last_rec;
end;

function TDBF_Data.TRead(num: Cardinal) :string;
var k   :longword;
    buf :record case byte of
		1:(a :array[1..512]of char;);
		2:(b :array[1..508]of char; next :longword);
	end;
begin
	IF HNDT.IsOpen then begin
		HNDT.Seek;
		HNDT.Read(k, 4);
		//FileSeek(HNDT, 0, 0);
		//FileRead(HNDT, k, 4);
		result := '';
		if k < num then exit;
		if(k = 0) or (num = 0)then num := k + 1;
		HNDT.Seek((num shl 9));
		//FileSeek(HNDT, (num shl 9), 0);
		repeat
			{_max:=}HNDT.Read(buf, 512);
			//FileRead(HNDT, buf, 512);
			IF _c then begin
				result := result + buf.b;
				IF(buf.next = 0) or (buf.next > k)
					then result := result + #$1A
					else HNDT.Seek(buf.next shl 9);//FileSeek(HNDT,buf.next shl 9,0);
			end else result := result + buf.a;
		until pos(#$1A, result) > 0;
		delete(result, pos(#$1A, result), 512);
	end else result := inttostr(num);
end;

function TDBF_Data.TWrite(num: Cardinal; s: string) :longword;
var k, l :longword;
    buf  :record case byte of
		1:(a :array[1..512]of char;);
		2:(b :array[1..508]of char; next :longword);
	end;
    _max :word;
    mx   :smallint;
begin
	//result:=0;
	IF HNDT.IsOpen then begin
		move(dub(#0#0#0#0,128)[1], buf, 512);
		HNDT.Seek;
		HNDT.Read(k, 4);
		//FileSeek(HNDT, 0, 0);
		//FileRead(HNDT, k, 4);
		if(k = 0) then num := 1 else
		if(k < num) or (num = 0) then num := k + 1;

		IF Log <> nil then begin
			write(Log^.f, DateTimeToStr(Date() + Time()), ' ', rp, '|||');
			IF DopDataLog <> '' then write(Log^.f, DopDataLog, '|||');
			writeln(Log^.f, 'MemoWrite :> {[', s, ']}');
		end;

		HNDT.Seek(num shl 9);
		//FileSeek(HNDT, num shl 9, 0);
		IF _c then begin
			//     mx := 0;
			//result := num;
			IF(k < num) then inc(k);
			repeat
				buf.next := 0;
				_max := HNDT.Read(buf, 512); //FileRead(HNDT, buf, 512);
				HNDT.Seek(-_max, 1);
				//FileSeek(HNDT, -_max, 1);
				IF length(s) > 508 then begin
					move(s[1], buf, 508);
					delete(s, 1, 508);
					IF buf.next = 0 then begin
						inc(k);
						buf.next := k;
					end;
				end else begin
					s := s + #$1A;
					move(s[1], buf, length(s));
					_max := 508 - length(s);
					move(dub(#0, _max)[1], buf.b[length(s) + 1], _max);
					buf.next := 0;
					s := '';
				end;
				HNDT.Write(buf, 512);
				//FileWrite(HNDT, buf, 512);
				IF buf.next > 0 then
					HNDT.Seek(buf.next shl 9);
				//FileSeek(HNDT,buf.next shl 9, 0);
			until s = '';
			result := num;
		end else begin
			mx := 0;
			repeat
				HNDT.Read(buf, 512);
				//FileRead(HNDT, buf, 512);
				inc(mx);
			until(pos(#$1A, string(buf.a)) > 0) or (buf.a[1] = #0);
			s := s + #$1A;
			l := length(s);
			if (mx shl 9) > l then begin
				HNDT.Seek(num shl 9);
				HNDT.Write(s[1], l);
				//FileSeek(HNDT, num shl 9, 0);
				//FileWrite(HNDT, s[1], l);
				result := num;
				IF num > k then k := k + (l shr 9) + 1 else
				IF(num + mx - 1 > k)then k := num + mx - 1;
			end else begin
				HNDT.Seek(512 + (k shl 9));
				//FileSeek(HNDT, 512 + (k shl 9), 0);
				if num >= k then begin
					_max := length(s);
					mx := (_max shr 9) - mx + 1;
					if (_max and 511) > 0 then inc(mx);
					if mx < 0 then begin
						result := 0;
						exit;
					end;
					HNDT.Write(s[1], length(s));
					//FileWrite(HNDT, s[1], length(s));
					result := num;
					k := k + mx;
				end else begin
					HNDT.Read(buf, 512);
					HNDT.Seek(k shl 9);
					HNDT.Write(buf, 512);
					HNDT.Write(s[1], length(s));
					//FileRead(HNDT, buf, 512);
					//FileSeek(HNDT, k shl 9, 0);
					//FileWrite(HNDT, buf, 512);
					//FileWrite(HNDT, s[1], length(s));
					result := k + 1;
					_max := length(s);
					k := k + (_max shr 9);
					if (_max and 511) > 0 then inc(k);
				end;
			end;
		end;
		HNDT.Seek;
		HNDT.Write(k, 4);
		//FileSeek(HNDT, 0, 0);
		//FileWrite(HNDT, k, 4);
	end else result := num;
end;

function TDBF_Data.FGetT(FieldName: string) :variant;
begin
	result := FGetS(FieldName);
	if StringResult or VarIsStr(result) then
		result := Trim(result);
end;

function TDBF_Data.FileDBF: boolean;
begin
	result := HNDF.IsOpen;
end;

function TDBF_Data.FileDBT: boolean;
begin
	result := HNDT.IsOpen;
end;

procedure TDBF_Data.FSetT(FieldName: string; v: Variant);
begin
	if StringResult and varisstr(v) then v := Trim(v);
	FSetS(FieldName, v);
end;

function TDBF_Data.GetDel :boolean;
begin
	result := Buffer[0] = $2a;
end;

procedure TDBF_Data.SetDel(b: Boolean);
begin
	if b
		then Buffer[0] := $2a
		else Buffer[0] := TermStr;
	IF Log <> nil then begin
		Log^.txt := Log^.txt + DateTimeToStr(Date + Time) + ' ' + IntToStr(rp) + '|||';
		IF DopDataLog <> '' then Log^.txt := Log^.txt + DopDataLog + '|||';
		IF b
			then Log^.txt := Log^.txt + 'Del'#13#10
			else Log^.txt := Log^.txt + 'ReDel'#13#10
	end;
end;

function TDBF_Data.GetFL(i :byte) :TRec_DBF_Field;
begin
	result := Fl^.Field[i];
end;

function TDBF_Data.Count :byte;
begin
	result := Fl^.max;
end;

end.
