unit ODBC_cmd;
{$H+}
// version 1.0
interface
uses odbcsqldyn, sysUtils, variants, IniFiles, classes{,db{};

type
	TFieldType = (ftUnknown, ftString, ftSmallint, ftInteger, ftWord, // 0..4
		ftBoolean, ftFloat, ftCurrency, ftBCD, ftDate, ftTime, ftDateTime, // 5..11
		ftBytes, ftVarBytes, ftAutoInc, ftBlob, ftMemo, ftGraphic, ftFmtMemo, // 12..18
		ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor, ftFixedChar, ftWideString, // 19..24
		ftLargeint, ftADT, ftArray, ftReference, ftDataSet, ftOraBlob, ftOraClob, // 25..31
		ftVariant, ftInterface, ftIDispatch, ftGuid, ftTimeStamp, ftFMTBcd, // 32..37
		ftFixedWideChar, ftWideMemo, ftOraTimeStamp, ftOraInterval); // 38..41
	Largeint = Int64;


const
	dsMaxStringSize = 8192; { Maximum string field size }
	FieldTypeNames: array[TFieldType] of string = (
		'Unknown', 'String', 'SmallInt', 'Integer', 'Word', 'Boolean', 'Float',
		'Currency', 'BCD', 'Date', 'Time', 'DateTime', 'Bytes', 'VarBytes',
		'AutoInc', 'Blob', 'Memo', 'Graphic', 'FmtMemo', 'ParadoxOle',
		'dBaseOle', 'TypedBinary', 'Cursor', 'FixedChar', 'WideString',
		'LargeInt', 'ADT', 'Array', 'Reference', 'DataSet', 'HugeBlob', 'HugeClob',
		'Variant', 'Interface', 'Dispatch', 'Guid', 'SQLTimeStamp', 'FMTBcdField',
		'FixedWideChar', 'WideMemo', 'SQLTimeStamp', 'String');

type
	TSTMTRec = record p :SQLHSTMT; Q :string;{BS:TList;} end;
	PBlobBuffer = ^TBlobBuffer;
	TBlobBuffer = record
		FieldNo  :integer;
		OrgBufID :integer;
		Buffer   :pointer;
		Size     :Longint;
	end;
	
	PBufBlobField = ^TBufBlobField;
	TBufBlobField = record
		ConnBlobBuffer :array[0..11]of byte;
		BlobBuffer     :PBlobBuffer;
	end;
	{ TSchemaType=(stNoSchems,stTables,stSysTables,stProcedures,stColumns,
		stProcedureParams,stIndexes,stPackages);//}
	TBufferArray = ^pchar;
	PODBC = ^TODBC;
	TField_ = record
		TypeField :TFieldType;
		DateType  :SQLSMALLINT;
		Name      :string;
		FieldNo   :integer;
		Size, Len :Longint;
		buf       :array of byte;
		null      :boolean;
	end;
	TTypeRead = (trNone, trNext, trFirst, trLast, trPrior, trAbsolute, trRelative);
	TFields_ = array of TField_;
	TODBC_Array = class;

	TODBC = object
		private
			STMT              :array of TSTMTRec;
			ENV               :{array of} SQLHENV;
			DBC               :SQLHDBC;
			con, dllrun       :boolean;

			_Ret              :SQLRETURN;
			//Id_sred           :SQLHANDLE;
			_Parm             :array of record NM, ZN :string; end;

			FBOF, FEOF        :boolean;
			FFieldDefs        :TFields_;//Defs;
			FBlobBuffer,
			FUpdateBlobBuffer :Array of PBlobBuffer;
			fps               :longint;
			_num              :longword;
			_countRow         :longint;

			//    STMT
			function  STMTCreate(q :string) :integer;
			procedure STMTDestroy(num :integer); overload;
			procedure STMTDestroy; overload;

			Procedure PrepareS(num :integer; buf :string);
			//Procedure UnPrepareS(num :integer);
			Procedure Execute(num :integer);
			//     ENV
			//function ENVCreate :integer;
			procedure ENVCreate;
			//procedure ENVDestroy(num :integer); overload;
			procedure ENVDestroy; overload;
			//    Result retrieving
			procedure ADDFieldDefs(num :integer; FieldDefs :TFields_{Defs});
			function  Fetch(num, ps :integer; TR :TTypeRead) :boolean;
			function  LoadField(num :integer; FieldDef :TField_{Def; Buf :pointer}; out CrBl :boolean) :boolean;
			function  SafeField(num :integer; FieldDef :TField_{Def; Buf :pointer}; out CrBl :boolean) :boolean;
			procedure LoadBlobIntoBuffer(FieldDef :TField_{Def}; ABlBuf :PBufBlobField; num :integer);
			procedure FreeFldBuffers(num :integer);

			//procedure UpdateIndexDefs(IndexDefs:TIndexDefs;TblNm:string);
			procedure LoadsFl(num :integer);
			function  GetFieldSize(FL :TField_) :longint;
			procedure _RowCount_(num :integer);

			function  GetNewBlobBuffer :PBlobBuffer;
			//         procedure ClearFields;

			//    ODBC
			function  GetNumParam(s :string) :integer;
			function  GetParamStr :string;

			Function  GetParam(s :string) :string;
			Procedure SetParam(s, t :string);

			procedure SetRecNO(l :longint);
			procedure SetFieldDefs(fl :TFields_);
			procedure SetNum(i :longword);
			function  GetValues(s :string) :variant;
			procedure SetValues(s :string; v :variant);
			//    hide
			//Procedure ConectODBC(i :integer); overload;
			//Procedure DisConectODBC(i :integer); overload;
		public
			procedure Init(IniFile :string = '');
			procedure Done;
			property  Return :SQLRETURN read _Ret;
			Procedure ConectODBC; overload;
			Procedure DisConectODBC; overload;
			Property  Param[i :string] :string read GetParam write SetParam;
			Procedure ClearParam;
			function  ExecuteDirect(sql :string) :integer;
			procedure EndExecute;

			Function  ExecuteSQL(sql :string) :TODBC_Array;

			property  Fields :TFields_ read FFieldDefs write SetFieldDefs;
			procedure ClearFields;
			function  FieldCount :longint;
			property  RecNo :longint read fps write SetRecNO;
			property  NumSTMT :longword read _num write SetNum;
			Function  FieldByName(s :string) :TField_;
			Function  FieldByIndex(i :integer) :TField_;
			property  FieldValues[s :string] :variant read GetValues;// write SetVvalues;

			procedure Next;
			//         procedure Prior;
			procedure First;
			//         procedure Last;

			//         procedure Post;

			function  GetSQLRowCount :integer;
			property  RecordCount :longint read _countRow;
	end;

	TODBC_Array = class
		private
			_fl  :TFields_;
			_fld :array of array of variant;
			ps   :longword;
			function  GetAr(col, row :longword) :variant;
			function  getFl(s :variant) :variant;
		public
			Constructor Create(Odbc :TODBC); overload;
			Destructor Destroy; override;
			Function  FieldName(num :Longword) :string;
			Function  FieldIndex(s :string) :longint;
			Function  FieldType(num :Longword) :string;
			Function  FieldByName(s :string) :TField_;
			Function  FieldByIndex(num :Longword) :TField_;
			Function  CountRow :Longword;
			Function  CountCol :Longword;
			property  Cells[col, row :longword] :variant read GetAR;

			property  Field[s :variant] :variant read getFl;default;
			procedure First;
			procedure Next;
			procedure Last;
			procedure Prior;
			property  Position :LongWord read ps write ps;
			function  Ends :boolean;
	end;

implementation


{ TODCB }

procedure TODBC.ADDFieldDefs(num: integer; FieldDefs: TFields_{Defs});
const ColNmDefLen = 40;
      TpNmDefLen  = 80;
var
	ColCount :SQLSMALLINT;
	i        :integer;
	ColNmLen,
	TpNmLen,
	DtTp,
	DecDig,
	Null_    :SQLSMALLINT;
	ColSz    :SQLUINTEGER;
	ColNM,
	TpNM     :string;
	FlTp     :TFieldType;
	FlSz     :word;
begin
	IF num >= Length(STMT) then exit;
	ClearFields;
	_Ret := SQLNumResultCols(STMT[num].p, ColCount);

	for i := 1 to ColCount do begin
		SetLength(ColNm, ColNmDefLen);

		_Ret:=SQLDescribeCol(STMT[num].p, i,
			@(ColNm[1]), ColNmDefLen + 1,
			ColNmLen, DtTp,
			ColSz, DecDig, Null_);
		SetLength(ColNm,ColNmLen);
		IF ColNmLen > ColNmDefLen then
		_Ret := SQLColAttribute(STMT[num].p, i, SQL_DESC_NAME,
							   @(ColNm[1]), ColNmLen + 1,
							   @ColNmLen, nil);
		case DtTp of
			SQL_CHAR:         begin FlTp := ftFixedChar; FlSz := ColSz + 1; end;
			SQL_VARCHAR:      begin FlTp := ftString;    FlSz := ColSz + 1; end;
			SQL_LONGVARCHAR:  begin FlTp := ftMemo;      FlSz := 0; end;
			SQl_DECIMAL:      begin FlTp := ftFloat;     FlSz := 0; end;
			SQL_NUMERIC:      begin FlTp := ftFloat;     FlSz := 0; end;
			SQL_SMALLINT:     begin FlTp := ftSmallint;  FlSz := 0; end;
			SQL_INTEGER:      begin FlTp := ftINTEGER;   FlSz := 0; end;
			SQL_REAL:         begin FlTp := ftFloat;     FlSz := 0; end;
			SQL_DOUBLE,
			SQL_FLOAT:        begin FlTp := ftFloat;     FlSz := 0; end;
			SQL_BIT:          begin FlTp := ftBoolean;   FlSz := 0; end;
			SQL_TINYINT:      begin FlTp := ftSmallint;  FlSz := 0; end;
			SQL_BIGINT:       begin FlTp := ftLargeint;  FlSz := 0; end;
			SQL_BINARY:       begin FlTp := ftBytes;     FlSz := ColSz; end;
			SQL_VARBINARY:    begin FlTp := ftVarBytes;  FlSz := ColSz; end;
		SQL_LONGVARBINARY:    begin FlTp := ftBlob;      FlSz := 0; end;
			SQL_TYPE_DATE:    begin FlTp := ftDate;      FlSz := 0; end;
			SQL_TYPE_TIME:    begin FlTp := ftTime;      FlSz := 0; end;
		SQL_TYPE_TIMESTAMP:   begin FlTp := ftDateTime;  FlSz := 0; end;
			SQL_WCHAR:        begin FlTp := ftWideString;FlSz := ColSz + 1; end;
			SQL_WVARCHAR:     begin FlTp := ftWideString;FlSz := ColSz + 1; end;
			SQL_WLONGVARCHAR: begin FlTp := ftWideMemo;  FlSz := 0; end;
			SQL_GUID:         begin FlTp := ftGuid;      FlSz := ColSz + 1; end;
			else begin FlTp := ftUnknown; FlSz := ColSz; end;
		end;

		if(FlTp in[ftString, ftFixedChar]) and (FlSz >= dsMaxStringSize)then
			FlSz := dsMaxStringSize - 1;

		if FlTp = ftUnknown then begin
			SetLength(TpNm, TpNmDefLen);
			_Ret := SQLColAttribute(STMT[num].p, i, SQL_DESC_TYPE_NAME,
									@(TpNm[1]), TpNmDefLen + 1,
									@TpNmLen, nil);
			Setlength(TpNm,TpNmLen);
			if TpNmLen>TpNmDefLen then
				_Ret := SQLColAttribute(STMT[num].p, i, SQL_DESC_TYPE_NAME,
										@(TpNm[1]), TpNmLen + 1,
										@TpNmLen, nil);
		end;
		SetLength(FFieldDefs,Length(FFieldDefs)+1);
		With FFieldDefs[high(FFieldDefs)] do begin
			TypeField := FlTp;
			Name := ColNm;
			FieldNo := i;
			Size := FlSz;
			DateType := DtTp;
			Len := GetFieldSize(FFieldDefs[high(FFieldDefs)]);
			SetLength(buf, Len);
		end;
		//   TFieldDef.Create(FieldDefs,ColNm,FlTp,FlSz,false,i);
	end;
end;

procedure TODBC.ClearFields;
var i :integer;
begin
	IF length(FFieldDefs) > 0 then
		for i := 0 to high(FFieldDefs)do
			SetLength(FFieldDefs[i].buf, 0);
	SetLength(FFieldDefs, 0);
end;

procedure TODBC.ClearParam;
begin
	SetLength(_Parm, 0);
end;

{procedure TODCB.ConectODBC;
begin
	ConectODBC(0);
end;}

procedure TODBC.ConectODBC;//(i: integer);
var CnSTR, OutSTR :string;
    ALen          :SQLSMALLINT;
begin
	_Ret := SQLAllocHandle(SQL_HANDLE_DBC, ENV{[i]}, DBC);
	CnSTR := GetParamStr;
	SetLength(OutSTR, 1023);
	_Ret := SQLDriverConnect(DBC, nil,
							PChar(CnSTR), Length(CnSTR),
							@OutSTR[1], 1024,
							ALen, SQL_DRIVER_NOPROMPT);
	IF _Ret = SQL_ERROR
		then SQLFreeHandle(SQL_HANDLE_DBC, DBC)
		else con := true;
end;

procedure TODBC.DisConectODBC;//(i: integer);
begin
	IF con then begin
		_ret := SQLDisconnect(DBC);
		_ret := SQLFreeHandle(SQL_HANDLE_DBC, DBC);
		con  := false;
	end;
end;

{procedure TODCB.DisConectODBC;
begin
	DisConectODBC(0);
end;}

procedure TODBC.Done;
begin
	//IF Assigned(FFieldDefs) then FFieldDefs.Free;
	IF dllrun then begin
		ClearFields;
		ClearParam;
		ENVDestroy;
		DisConectODBC;
		ReleaseODBC;
		dllrun := false;
	end;
end;

//function TODCB.ENVCreate:integer;
procedure TODBC.EndExecute;
begin
	STMTDestroy(_num);
	fps := 0;
end;

procedure TODBC.ENVCreate;
begin
	// result:=Length(ENV);
	// SetLength(ENV,result+1);
	IF SQLAllocHandle(SQL_Handle_ENV, SQL_NULL_HANDLE, ENV{[result]}) = SQL_Error then begin
	//  SetLength(ENV,result);
		raise Exception.Create('Could not allocate ODBC Environment handle');
	end;
	_ret := SQLSetEnvAttr(ENV{[result]}, SQL_ATTR_ODBC_VERSION, SQLPOINTER(SQL_OV_ODBC3), 0);
end;

procedure TODBC.ENVDestroy;
//var i :integer;
begin
	IF ENV=nil then exit;
	// for i := 0 to high(ENV) do
	_ret := SQLFreeHandle(SQL_HANDLE_ENV, ENV{[i]});
	// SetLength(ENV,0);
end;

procedure TODBC.Execute(num: integer);
begin
	IF num >= length(STMT) then exit;
	_Ret := SQLExecute(STMT[num].p);
end;

function TODBC.ExecuteDirect(sql: string) :integer;
//var i :integer;
begin
	IF not Con then exit;
	SQL := TrimRight(SQL);
	IF SQL = '' then exit;

	result := STMTCreate(SQl);
	PrepareS(result, sql);
	Execute(result);

	SetNum(result);

	// STMTDestroy(i);
end;

function TODBC.ExecuteSQL(sql: string): TODBC_Array;
begin
  ConectODBC;
  ExecuteDirect(sql);
  result := TODBC_Array.Create(self);
  EndExecute;
  DisConectODBC;
end;

function TODBC.Fetch(num,ps: integer;TR:TTypeRead): boolean;
	function trint :integer;
	begin
		IF TR = trAbsolute then result := 0 else result := ps;
	end;
	
	function trAbs :byte;
	begin
		IF TR in[trAbsolute, trFirst]then result := byte(trNext) else
		IF TR = trLast then result := byte(trPrior) else result := byte(TR);
	end;
begin
	result := false;
	IF num >= Length(STMT) then exit;
	// _Ret := SQLFetch(STMT[num].p);
	_Ret := SQLFetchScroll(STMT[num].p, byte(TR), trint);
	//_Ret := SQLFetchScroll(STMT[num].p, SQL_FETCH_ABSOLUTE, ps);
	while//(_Ret <> SQL_ROW_SUCCESS)and
	//(_Ret <> SQL_ROW_SUCCESS_WITH_INFO) and
	((_ret = SQL_SUCCESS_WITH_INFO) or
	(_ret = SQL_ROW_SUCCESS_WITH_INFO)) and
	(_ret <> SQL_NO_DATA) do
	//   _Ret:=SQLFetch(STMT[num].p);
		_Ret := SQLFetchScroll(STMT[num].p,trAbs,0);
	{ until//((_Ret <> SQL_SUCCESS_WITH_INFO)and(_ret <> SQL_ERROR))
	(_Ret = SQL_ROW_SUCCESS) or (_Ret = SQL_ROW_SUCCESS_WITH_INFO)
	or(_ret = SQL_NO_DATA);//}
	// if _Ret<>SQL_NO_DATA then
	result := _Ret{ >=0;//} <> SQL_NO_DATA;
end;

procedure TODBC.FreeFldBuffers(num: integer);
var i :integer;
begin
	IF num >= Length(STMT) then exit;

	{ for i := 0 to STMT[num].BS.Count - 1 do
	TObject(STMT[num].BS[i]).Free;
	STMT[num].BS.Clear;//}
	_Ret := SQLFreeStmt(STMT[num].p, SQL_CLOSE);
end;

{procedure TODBC.ENVDestroy(num: integer);
var i :integer;
begin
	IF num >= Length(ENV) then exit;
	_ret := SQLFreeHandle(SQL_HANDLE_ENV, ENV[num]);
	IF num < high(ENV) then
		for i := num to high(ENV) - 1 do
			ENV[i] := ENV[i + 1];
	SetLength(ENV, High(ENV));
end;}

function TODBC.FieldByIndex(i: integer): TField_;
begin
	result := FFieldDefs[i];
end;

function TODBC.FieldByName(s: string): TField_;
var i :integer;
begin
	s := lowercase(s);
	For i := 0 to high(FFieldDefs) do
		IF lowercase(FFieldDefs[i].Name) = s then begin
			result := FFieldDefs[i];
			exit;
		end;
end;

function TODBC.FieldCount: longint;
begin
	result := length(FFieldDefs);
end;

procedure TODBC.First;
begin
	_Ret := SQLFetch(STMT[_num].p);
	IF Fetch(_num, 0, trFirst)
		then LoadsFl(_num)
		else fps :=-1;
end;

function TODBC.GetFieldSize(FL: TField_): longint;
begin
	case FL.TypeField of
		ftString,ftGuid,ftFixedChar:  result := Fl.Size + 1;
		ftFixedWideChar,ftWideString: result := (Fl.Size + 1) * 2;
		ftSmallint,ftInteger,ftword:  result := sizeof(longint);
		ftBoolean:                    result := sizeof(wordbool);
		ftBCD:                        result := sizeof(currency);
		ftFloat,ftCurrency:           result := sizeof(double);
		ftLargeInt:                   result := sizeof(largeint);
		ftTime,ftDate,ftDateTime:     result := sizeof(TDateTime);
		ftBlob,ftMemo,ftGraphic,
		ftFmtMemo,ftParadoxOle,
		ftDBaseOle,ftTypedBinary,
		ftOraBlob,ftOraClob,
		ftWideMemo:                 result := SizeOf(TBufBlobField);
		else result := 10;
	end;
end;

function TODBC.GetNewBlobBuffer: PBlobBuffer;
var Ablb :PBlobBuffer;
begin
	SetLength(FBlobBuffer, Length(FBlobBuffer) + 1);
	new(Ablb);
	fillchar(ABlb^, sizeof(ABlb^), 0);
	Ablb^.OrgBufID := High(FUpDateBlobBuffer);
	FBlobBuffer[high(FBlobBuffer)] := Ablb;
	result := Ablb;
end;

function TODBC.GetNumParam(s: string): integer;
var i :integer;
begin
	result := -1;
	IF length(_Parm) > 0 then begin
		s := lowercase(s);
		for i := 0 to high(_Parm) do
			IF lowercase(_Parm[i].NM) = s then begin
				result := i;
				exit;
			end;
	end;
end;

function TODBC.GetParam(s: string): string;
var i :integer;
begin
	i := GetNumParam(s);
	IF i < 0
		then result := ''
		else result := _Parm[i].ZN;
end;

function TODBC.GetParamStr: string;
	function Res_(s :string) :string;
	var j :integer;
	begin
		s := trim(s);
		IF s <> '' then
			for j := 1 to length(s) do
				IF s[j] in ['[',']','{','}','(',')',',','*','=','!','@',' '] then begin
					Result := '{' + s + '}';
					exit;
				end;
		Result := s;
	end;
var i :integer;
begin
	result := '';//'DRIVER={MSSQL};';//'MSSQL;';
	IF Length(_Parm) > 0 then
		For i := 0 to High(_Parm) do
			result := result + Res_(_Parm[i].NM) + '=' + Res_(_Parm[i].ZN) + ';';
end;

function TODBC.GetSQLRowCount: integer;
begin
	_ret := SQLRowCount(STMT[_num].p, result);
end;

function TODBC.GetValues(s: string): variant;
var f :TField_;
begin
	f := FieldByName(s);
	IF f.null then result := '' else
	case f.TypeField of
		ftString,ftGuid,ftFixedChar:  result := trim(string(f.buf));

		ftFixedWideChar,ftWideString: result := trim(WideString(f.buf));
		ftSmallint,ftInteger,ftword:  result := longint(pointer(@f.buf[0])^);
		ftBoolean:                    result := wordbool(pointer(@f.buf[0])^);
		ftBCD:                        result := currency(pointer(@f.buf[0])^);
		ftFloat,ftCurrency:           result := double(pointer(@f.buf[0])^);
		ftLargeInt:                   result := largeint(pointer(@f.buf[0])^);
		ftTime,ftDate,ftDateTime:     result := TDateTime(pointer(@f.buf[0])^);
		{  ftBlob,ftMemo,ftGraphic,
		ftFmtMemo,ftParadoxOle,
		ftDBaseOle,ftTypedBinary,
		ftOraBlob,ftOraClob,
		ftWideMemo:                 result := TBufBlobField(pointer(@f.buf[0])^);//}
		else result := '';
	end;
end;

procedure TODBC.Init(IniFile :string = '');
var 
	i :TIniFile;
	L :TStringList;
	j :integer;
begin
	InitialiseODBC;
	ENVCreate;
	dllrun := true;
	//SetLength(_Parm,5);
	{_Parm[0].NM := 'DSN';
	_Parm[0].ZN := '';
	_Parm[1].NM := 'DRIVER';
	_Parm[1].ZN := '';
	_Parm[2].NM := 'UID';
	_Parm[2].ZN := '';
	_Parm[3].NM := 'PWD';
	_Parm[3].ZN := '';
	_Parm[4].NM := 'FILEDSN';
	_Parm[4].ZN := '';//}
	con := false;
	IF IniFile <> '' then begin
		i := TIniFile.Create(IniFile);
		L := TStringList.Create;
		i.ReadSection('DEF', L);
		IF L.Count > 0 then
			for j := 0 to L.Count - 1 do
				Param[L[j]] := i.ReadString('DEF', L[j], '');
		L.Free;
		i.Free;
	end;
	ClearFields;
end;

{procedure TODBC.Last;
begin
	IF Fetch(_num, 0, trLast)
		then LoadsFl(_num)
		else fps := -1;
end;//}

procedure TODBC.LoadBlobIntoBuffer(FieldDef: TField_{Def}; ABlBuf: PBufBlobField;
  num: integer);
var
	StrLenOrInd  :SQLINTEGER;
	BlBuf        :pointer;
	BlBufSz, BtR :SQLINTEGER;
	BlMem        :TMemoryStream;
	//buf          :pointer;
begin
	IF num >= Length(STMT) then exit;
	_ret := SQLGetData(STMT[num].p, FieldDef.FieldNo, SQL_C_BINARY, @BlBuf, 0, @StrLenOrInd);
	IF StrLenOrInd <> SQL_NULL_DATA then begin
		IF StrLenOrInd <> SQL_NO_TOTAL then begin
			BlBufSz := StrLenOrInd;
			ABlBuf^.BlobBuffer^.Size := BlBufSz;
			ReAllocMem(ABlBuf^.BlobBuffer^.Buffer, BlBufSz);
			IF BlBufSz > 0 then
				_Ret := SQLGetData(STMT[num].p, FieldDef.FieldNo, SQL_C_BINARY, ABlBuf^.BlobBuffer^.Buffer, BlBufSz, @StrLenOrInd);
		end else begin
			BlBuf := nil;
			BlMem := nil;
			try
				Blbuf := System.GetMemory(BlBufSz);
				BlMem := TMemoryStream.Create;
				repeat
					_ret := SQLGetData(STMT[num].p, FieldDef.FieldNo, SQL_C_BINARY, BlBuf, BlBufSz, @StrLenOrInd);
					IF(StrLenOrInd = SQL_NO_TOTAL) or (StrLenOrInd > BlBufSz)
						then BtR := BlBufSz
						else BtR := StrLenOrInd;
					BlMem.Write(BlBuf^,BtR);
				until _ret = SQL_SUCCESS;
				BlBufSz := BlMem.Size;

				ABlBuf^.BlobBuffer^.Size := BlBufSz;
				ReAllocMem(ABlBuf^.BlobBuffer^.Buffer, BlBufSz);

				BlMem.Position := 0;
				BlMem.Read(ABlBuf^.BlobBuffer^.Buffer^, BlBufSz);
			finally
				BlMem.Free;
				IF BlBuf <> nil then
					FreeMem(BlBuf, BlBufSz);
			end;
		end;
	end;
end;

function TODBC.LoadField(num: integer; FieldDef: TField_{Def; Buf: pointer};
  out CrBl: boolean): boolean;
var
	StrLenorInd :SQLINTEGER;
	ODBC_Dt     :SQL_DATE_STRUCT;
	ODBC_Tm     :SQL_TIME_STRUCT;
	ODBC_TmSp   :SQL_TIMESTAMP_STRUCT;
	DtTm        :TDateTime;
	buf         :pointer;
	procedure Set_(s :SQLSMALLINT; sz :integer; buf_ :pointer);
	begin
		//s := FieldDef.DateType;
		_ret := SQLGetData(STMT[num].p, FieldDef.FieldNo, s, buf_,sz, @StrLenOrInd);
	end;
begin
	CrBl := false;
	IF num >= Length(STMT) then exit;
	buf := @FieldDef.buf[0];
	Case FieldDef.TypeField of
		ftGuid,ftWideString,ftFixedWideChar,
		ftFixedChar:          Set_(FieldDef.DateType{SQL_C_CHAR},FieldDef.Len{Size},buf);
		ftString:             Set_(SQL_C_CHAR,FieldDef.Len{Size},buf);
		ftSmallint:           Set_(SQL_C_SSHORT,SizeOf(Smallint),buf);
		ftInteger,ftWord:     Set_(SQl_C_SLONG,SizeOf(Longint),buf);
		ftLargeInt:           Set_(SQL_C_SBIGINT,SizeOf(Largeint),buf);
		ftFloat:              Set_(SQL_C_DOUBLE,SizeOf(Double),buf);
		ftTime: begin
			Set_(SQL_C_TYPE_TIME, SizeOf(SQL_TIME_STRUCT), @ODBC_Tm);
			IF StrLenOrInd <> SQL_NULL_DATA then begin
				try DtTm := TimeStructToDateTime(@ODBC_Tm);
				except end;
				Move(DtTm,buf^,SizeOf(TDAteTime));
			end;
		end;
		ftDate: begin
			Set_(SQL_C_TYPE_DATE, SizeOf(SQL_DATE_STRUCT), @ODBC_Dt);
			IF StrLenOrInd <> SQL_NULL_DATA then begin
				try DtTm := DateStructToDateTime(@ODBC_Dt);
				except end;
				Move(DtTm, buf^, SizeOf(TDAteTime));
			end;
		end;
		ftDateTime: begin
			Set_(SQL_C_TYPE_TIMESTAMP, SizeOf(SQL_TIMESTAMP_STRUCT), @ODBC_TmSp);
			IF StrLenOrInd <> SQL_NULL_DATA then begin
				try DtTm := TIMESTAMPStructToDateTime(@ODBC_TmSp);
				except end;
				Move(DtTm, buf^, SizeOf(TDAteTime));
			end;
		end;
		ftBoolean:          Set_(SQL_BIT,SizeOf(WordBool),buf);
		ftBytes,ftVarBytes: Set_(SQL_C_BINARY,FieldDef.Size,buf);
		ftWideMemo,ftBlob,ftMemo: begin
			Set_(SQL_C_BINARY, 0, buf);
			IF StrLenOrInd <> SQL_NULL_DATA then
				CrBl := true;
		end;
		else ;//raise Exception.CreateFmt('Tried to load field of unsupported field type %s',[Fieldtypenames[fieldDef.TypeField]]);
	End;
	Result := StrLenOrInd <> SQL_NULL_DATA;
end;

procedure TODBC.LoadsFl(num: integer);
var
	j     :integer;
	crb   :boolean;
	index :integer;
	BBl   :PBufBlobField;
begin
	IF num >= Length(STMT) then exit;
	index := 0;
	IF Length(FFieldDefs) > 0 then
		for j := 0 to high(FFieldDefs) do begin
			FFieldDefs[j].null := false;
			IF LoadField(num, FFieldDefs[j], crb)then begin
				IF crb then begin
					bbl := PBufBlobField(@FFieldDefs[j].buf[0]);
					Bbl^.BlobBuffer := GetNewBlobBuffer;
					LoadBlobIntoBuffer(FFieldDefs[j], bbl, num);
				end;
			end else FFieldDefs[j].null := true;
			inc(index, FFieldDefs[j].Size);
		end;
end;


procedure TODBC.Next;
begin
	IF Fetch(_num, 0, trNext)
		then LoadsFl(_num)
		else fps := -1;
end;

{procedure TODBC.Post;
begin
	_Ret := SQLSetPos(STMT[_num].p, fps, SQL_POSITION, 0);
	//_Ret := SQLPutData(
end;}

procedure TODBC.PrepareS(num: integer; buf: string);
begin
	IF num >= length(STMT) then exit;
	_Ret := SQLPrepare(STMT[num].p, pChar(buf), Length(buf));
	STMT[num].Q := buf;
end;


{procedure TODBC.Prior;
begin
	IF Fetch(_num, 0, trPrior)
		then LoadsFl(_num)
		else fps := -1;
end;//}

function TODBC.SafeField(num: integer; FieldDef: TField_;
  out CrBl: boolean): boolean;
var
	StrLenorInd :SQLINTEGER;
	ODBC_Dt     :SQL_DATE_STRUCT;
	ODBC_Tm     :SQL_TIME_STRUCT;
	ODBC_TmSp   :SQL_TIMESTAMP_STRUCT;
	DtTm        :TDateTime;
	buf         :pointer;
	procedure Set_(s :SQLSMALLINT; sz :integer; buf_ :pointer);
	begin
		//s:=FieldDef.DateType;
		//_ret:=SQLSetPos(
		//_ret:=SQLPutData(STMT[num].p,FieldDef.FieldNo,s,buf_,sz,@StrLenOrInd);
	end;
begin
	CrBl := false;
	IF num >= Length(STMT) then exit;
	buf := @FieldDef.buf[0];
	Case FieldDef.TypeField of
		ftGuid,ftWideString,ftFixedWideChar,
		ftFixedChar,ftString: Set_(FieldDef.DateType{SQL_C_CHAR}, FieldDef.Len{Size}, buf);
		ftSmallint:           Set_(SQL_C_SSHORT, SizeOf(Smallint), buf);
		ftInteger,ftWord:     Set_(SQl_C_SLONG, SizeOf(Longint), buf);
		ftLargeInt:           Set_(SQL_C_SBIGINT, SizeOf(Largeint), buf);
		ftFloat:              Set_(SQL_C_DOUBLE, SizeOf(Double), buf);
		ftTime:begin
			Set_(SQL_C_TYPE_TIME, SizeOf(SQL_TIME_STRUCT), @ODBC_Tm);
			IF StrLenOrInd <> SQL_NULL_DATA then begin
				try DtTm := TimeStructToDateTime(@ODBC_Tm);
				except end;
				Move(DtTm, buf^, SizeOf(TDAteTime));
			end;
		end;
		ftDate: begin
			Set_(SQL_C_TYPE_DATE,SizeOf(SQL_DATE_STRUCT), @ODBC_Dt);
			IF StrLenOrInd <> SQL_NULL_DATA then begin
				try DtTm := DateStructToDateTime(@ODBC_Dt);
				except end;
				Move(DtTm,buf^,SizeOf(TDAteTime));
			end;
		end;
		ftDateTime: begin
			Set_(SQL_C_TYPE_TIMESTAMP, SizeOf(SQL_TIMESTAMP_STRUCT), @ODBC_TmSp);
			IF StrLenOrInd <> SQL_NULL_DATA then begin
				try DtTm := TIMESTAMPStructToDateTime(@ODBC_TmSp);
				except end;
				Move(DtTm, buf^, SizeOf(TDAteTime));
			end;
		end;
		ftBoolean:          Set_(SQL_BIT,SizeOf(WordBool),buf);
		ftBytes,ftVarBytes: Set_(SQL_C_BINARY,FieldDef.Size,buf);
		ftWideMemo,ftBlob,ftMemo: begin
			Set_(SQL_C_BINARY, 0, buf);
			IF StrLenOrInd <> SQL_NULL_DATA then
				CrBl:=true;
		end;
		else raise Exception.CreateFmt('Tried to load field of unsupported field type %s',[Fieldtypenames[fieldDef.TypeField]]);
	End;
	Result := StrLenOrInd <> SQL_NULL_DATA;
end;

procedure TODBC.SetFieldDefs(fl: TFields_{Defs});
begin
	FFieldDefs := fl;
	// FFieldDefs.Assign(fl);
end;

procedure TODBC.SetNum(i: longword);
begin
	IF I >= Length(STMT) then exit;
	// _Ret := SQLFetch(STMT[i].p);
	ADDFieldDefs(i, FFieldDefs);
	// _RowCount_(i);
	// _Ret := SQLFetch(STMT[i].p);
	_num := i;
	First;
	// fps := 1;
end;

procedure TODBC.SetParam(s, t: string);
var i :integer;
begin
	i := GetNumParam(s);
	IF i < 0 then begin
		i := length(_Parm);
		SetLength(_Parm, i + 1);
		_Parm[i].NM := s;
	end;
	_Parm[i].ZN := t;
end;

procedure TODBC.SetRecNO(l: Integer);
begin
	IF Fetch(_num, l, trAbsolute) then LoadsFl(_num) else fps := -1;
end;

procedure TODBC.SetValues(s: string; v: variant);
var 
	f  :TField_;
	t  :string;
	wt :widestring;
	function adr(b :byte) :pointer;
	begin
		case b of
			0: begin
				t := vartostr(v);
				while length(t) < f.Len do t := t + #0;
				result := @t[1];
			end;
			1: begin
				wt := vartostr(v);
				while length(wt) < (f.Len div 2) do wt := wt + #0;
				result := @wt[1];
			end;
			else result := nil;
		end;
	end;
begin
	f := FieldByName(s);
	case f.TypeField of
		ftString,ftGuid,ftFixedChar:  move(adr(0)^, f.buf[0], f.Len);

		ftFixedWideChar,ftWideString: move(adr(1)^, f.buf[0], f.Len);
		ftSmallint,ftInteger,ftword:  longint(pointer(@f.buf[0])^) := v;
		ftBoolean:                    wordbool(pointer(@f.buf[0])^) := v;
		ftBCD:                        currency(pointer(@f.buf[0])^) := v;
		ftFloat,ftCurrency:           double(pointer(@f.buf[0])^) := v;
		ftLargeInt:                   largeint(pointer(@f.buf[0])^) := v;
		ftTime,ftDate,ftDateTime:     TDateTime(pointer(@f.buf[0])^) := v;
		{  ftBlob,ftMemo,ftGraphic,
		ftFmtMemo,ftParadoxOle,
		ftDBaseOle,ftTypedBinary,
		ftOraBlob,ftOraClob,
		ftWideMemo:                 result:=TBufBlobField(pointer(@f.buf[0])^);//}
	end;
end;

function TODBC.STMTCreate(q: string): integer;
begin
	result := Length(STMT);
	SetLength(STMT, result + 1);
	STMT[result].Q := q;
	//STMT[result].BS := TList.Create;
	_Ret := SQLAllocHandle(SQL_HANDLE_STMT, DBC, STMT[result].p);
end;

procedure TODBC.STMTDestroy(num: integer);
var i :integer;
begin
	IF num > high(STMT) then exit;
	IF STMT[num].p <> SQL_NULL_HSTMT then
	_Ret := SQLFreeHandle(SQL_HANDLE_STMT, STMT[num].p);
	// STMT[num].BS.Free;
	IF num < high(STMT) then
	for i := num to high(STMT)-1 do
		STMT[i] := STMT[i + 1];
	SetLength(STMT, High(STMT));
end;

procedure TODBC.STMTDestroy;
var i :integer;
begin
	IF length(STMT) = 0 then exit;
	for i := 0 to high(STMT) do begin
		IF STMT[i].p <> SQL_NULL_HSTMT then
			_Ret := SQLFreeHandle(SQL_HANDLE_STMT, STMT[i].p);
		//STMT[i].BS.Free;
	end;
	SetLength(STMT, 0);
end;

{procedure TODBC.UpdateIndexDefs(IndexDefs: TIndexDefs; TblNm: string);
var 
	StmtH             :SQLHSTMT;
	indxD             :TIndexDef;
	KeyFl, KeyNm      :string;
	NonUn             :SQLSMALLINT; 
	NonUnIndOrLen     :SQLINTEGER;
	IndxNm            :string;     
	IndxNmIndOrLen    :SQLINTEGER;
	Tp                :SQLSMALLINT;    
	TpIndOrLen        :SQLINTEGER;
	OrdPos            :SQLSMALLINT;
	OrdPosIndOrLen    :SQLINTEGER;
	ColNm             :string;      
	ColNmIndOrLen     :SQLINTEGER;
	AscOrDesc         :SQLCHAR; 
	AscOrDescIndOrLen :SQLINTEGER;
	PKNm              :string;       
	PKNmIndOrLen      :SQLINTEGER;
const
	Def_Nm_Len = 255;
	function _RES_:boolean;
	begin
		result:=(_Ret=SQL_SUCCESS)or(_Ret=SQL_SUCCESS_WITH_INFO)
	end;

begin
	StmtH := SQL_NULL_HANDLE;
	_Ret := SQLAllocHandle(SQL_HANDLE_STMT, DBC, StmtH);
	try
		SetLength(ColNm, Def_Nm_Len);
		SetLength(PKNm, Def_Nm_Len);
		SetLength(IndxNm, Def_Nm_Len);

		_Ret := SQLPrimaryKeys(StmtH, nil, 0, nil, 0, PChar(TblNm), Length(TblNm));
		KeyNm := '';
		KeyFl := '';
		try
			_Ret := SQLBindCol(StmtH, 4, SQL_C_CHAR, @ColNm[1], Length(ColNm) + 1, @ColNmIndOrLen);
			_Ret := SQLBindCol(StmtH, 5, SQL_C_SSHORT, @OrdPos, 0, @OrdPosIndOrLen);
			_Ret := SQLBindCol(StmtH, 6, SQL_C_CHAR, @PKNm[1], Length(PKNm) + 1, @PKNmIndOrLen);
			repeat
				_Ret := SQLFetch(StmtH);
				IF _Ret = SQL_NO_DATA then break;
				IF _RES_ then begin
					IF OrdPos = 1 then begin
						KeyNm := PChar(@PKNm[1]);
						KeyFl := PChar(@ColNm[1]);
					end else KeyFl := KeyFl + ';' + PChar(@ColNm[1]);
				end;// else
			until false;
		finally
			_Ret := SQLFreeStmt(StmtH, SQL_UNBIND);
			_Ret := SQLFreeStmt(StmtH, SQL_CLOSE);
		end;

		_Ret := SQLStatistics(StmtH, nil, 0, nil, 0,
							   PChar(TblNm), Length(TblNm),
							   SQL_INDEX_ALL, SQL_QUICK);
		try
			_Ret := SQLBindCol(StmtH,  4, SQL_C_SSHORT, @nonUn, 0, @NonUnIndOrLen);
			_Ret := SQlBindCol(StmtH,  6, SQL_C_CHAR, @IndxNm[1], Length(IndxNm) + 1, @IndxNmIndOrLen);
			_Ret := SQLBindCol(StmtH,  7, SQL_C_SSHORT, @Tp, 0, @TpIndOrLen);
			_Ret := SQLBindCol(StmtH,  8, SQL_C_SSHORT, @OrdPos, 0, @OrdPosIndOrLen);
			_Ret := SQLBindCol(StmtH,  9, SQL_C_CHAR, @ColNm[1], Length(ColNm) + 1, @ColNmIndOrLen);
			_Ret := SQLBindCol(StmtH, 10, SQL_C_CHAR, @AscOrDesc, 1, @AscOrDescIndOrLen);

			IndxD := nil;
			repeat
				_Ret := SQLFetch(StmtH);
				IF _Ret = SQL_NO_DATA then break;
				IF _RES_ then begin
					IF Tp <> SQL_TABLE_STAT then begin
						IF (OrdPos = 1)or not Assigned(IndxD) then begin
							IndxD := IndexDefs.AddIndexDef;
							IndxD.Name := PChar(@IndxNm[1]);
							IndxD.Fields := PChar(@ColNm[1]);
							IF NonUn = SQL_FALSE then
								IndxD.Options := IndxD.Options + [ixUnique];
							IF(AscOrDescIndOrLen <> SQL_NULL_DATA) and (AscOrDesc = 'D')then
								IndxD.Options := IndxD.Options + [ixDescending];
							IF IndxD.Name = KeyNm then
								IndxD.Options := IndxD.Options + [ixPrimary];
						end else IndxD.Fields := IndxD.Fields + ';' + PChar(@ColNm[1]);
					end;//else
				end;
			until false;
		finally
			_Ret := SQLFreeStmt(StmtH, SQL_UNBIND);
			_Ret := SQLFreeStmt(StmtH, SQL_CLOSE);
		end;
	finally
		IF StmtH <> SQL_NULL_HANDLE then
		_Ret := SQLFreeHandle(SQL_HANDLE_STMT, StmtH);
	end;

end;   }

procedure TODBC._RowCount_(num: integer);
begin
	IF num >= Length(STMT) then exit;
	_countRow := 0;
	IF Fetch(num, 0, trFirst) then
		repeat
			inc(_countRow);
		until not Fetch(num, 0,trNext);
	Fetch(num, 0, trFirst);
end;

{ TODBS_Array }

function TODBC_Array.GetAr(col, row :longword) :variant;
begin
	IF(Length(_fld) > 0) and (Length(_fld[0]) > 0) and (row < length(_fld)) and (col < Length(_fld[0]))
		then result := _fld[row,col]
		else result := varnull;
end;

function TODBC_Array.getFl(s: variant): variant;
begin
	IF VarIsNumeric(s)
		then result := GetAr(s,ps)
		else result := GetAr(FieldIndex(s),ps);
end;

Function TODBC_Array.FieldName(num :Longword) :string;
begin
	IF length(_fl) > num then result := _fl[num].Name else result := 'ERROR: Not number of Field';
end;

Function TODBC_Array.FieldIndex(s :string) :longint;
var i :integer;
begin
	result := -1;
	IF length(_fl )= 0 then exit;
	s := lowercase(trim(s));
	for i:=0 to high(_fl) do 
		IF lowercase(_fl[i].Name) = s then begin
			result := i;
			exit;
		end;
end;

Function TODBC_Array.FieldType(num :Longword) :string;
var s :string; //i :int64;
begin
	IF length(_fl) <= num then begin
		result := 'ERROR: Not number of Field';
		exit;
	end;
	s := '(Size=' + IntToStr(_fl[num].Size) + ')';
	case _fl[num].DateType of
		SQL_CHAR:       result := 'Char ' + s;
		SQL_VARCHAR:    result := 'VarChar ' + s;
		SQL_LONGVARCHAR:result := 'LongVarChar';
		SQl_DECIMAL:    result := 'Decimal';
		SQL_NUMERIC:    result := 'Numeric';
		SQL_SMALLINT:   result := 'SmallInt';
		SQL_INTEGER:    result := 'Integer';
		SQL_REAL:       result := 'Real';
		SQL_DOUBLE:     result := 'Double';
		SQL_FLOAT:      result := 'Float';
		SQL_BIT:        result := 'Bit';
		SQL_TINYINT:    result := 'TinyInt';
		SQL_BIGINT:     result := 'BigInt';
		SQL_BINARY:     result := 'Binary ' + s;
		SQL_VARBINARY:  result := 'VarBinary ' + s;
	SQL_LONGVARBINARY:  result := 'LongVarBinary';
		SQL_TYPE_DATE:  result := 'Date';
		SQL_TYPE_TIME:  result := 'Time';
	SQL_TYPE_TIMESTAMP: result := 'TimeStamp';
		SQL_WCHAR:      result := 'WideChar ' + s;
		SQL_WVARCHAR:   result := 'WideVarChar ' + s;
	SQL_WLONGVARCHAR:   result := 'WideLongVarChar';
		SQL_GUID:       result := 'Guid ' + s;
		else            result := 'UnKnown ' + s + '(Len=' + IntToStr(_fl[num].Len) + ')';
	end;
end;

Function TODBC_Array.FieldByName(s :string) :TField_;
var i :integer;
begin
	//result := -1;
	IF length(_fl) = 0 then exit;
	s := lowercase(trim(s));
	for i := 0 to high(_fl) do 
		IF lowercase(_fl[i].Name) = s then begin
			result := _fl[i];
			exit;
		end;
end;

Function TODBC_Array.FieldByIndex(num :Longword) :TField_;
begin
	IF length(_fl) > num then result := _fl[num];// else result := 'ERROR: Not number of Field';
end;

Function TODBC_Array.CountRow :Longword;
begin
	result := Length(_fld);
end;

constructor TODBC_Array.Create(ODBC :TODBC);
var i, j :integer;
	k    :longint;
    f_   :TFields_;
begin
	SetLength(_fld, 0, 0);
	SetLength(_fl, 0);
	k := ODBC.FieldCount;
	IF k > 0 then begin
		SetLength(_fl, k);
		f_ := ODBC.Fields;
		for i := 0 to high(f_) do
			_fl[i] := f_[i];
	end else exit;
	//ODBC.First;
	i := 0;
	SetLength(_fld, 1, k);
	while ODBC.RecNo >= 0 do begin
		for j := 0 to k - 1 do
			_fld[i,j] := ODBC.FieldValues[_fl[j].Name];
		inc(i);
		SetLength(_fld, i + 1, k);
		ODBC.Next;
	end;
	SetLength(_fld, i, k);
end;

destructor TODBC_Array.Destroy;
begin
	SetLength(_fld, 0, 0);
	SetLength(_fl, 0);
	inherited;
end;

Function TODBC_Array.CountCol :Longword;
begin
	result := Length(_fl);
end;

procedure TODBC_Array.First;
begin
	ps := 0;
end;

procedure TODBC_Array.Next;
begin
	inc(ps);
end;

procedure TODBC_Array.Last;
begin
	ps := high(_fld);
end;

procedure TODBC_Array.Prior;
begin
	dec(ps);
end;

function TODBC_Array.Ends :boolean;
begin
	result := ps >= length(_fld);
end;

end.
