unit odbcLite;

interface
uses odbcsqldyn, IniFiles, UnitUtils, classes, sysutils, strUtils;


///  === ver: 1.0 ===
///  = 
///  * 
///    + LoadParamFromIniFiles -      
///    + InitODBC -      ODBC
///    + DoneODBC -      ODBC
///    + ExecuteSQL -  SQL-    
///    + ExecuteSQLNoTable -  SQL-,
///                              ,
///                             
///    + ErrorSQL - ,    ,   

  Function  LoadParamFromIniFiles(IniName: AnsiString) :AnsiString;
  Procedure InitODBC(const Server, User, PassWord: AnsiString); overload;
  Function  InitODBC(const Param : AnsiString):AnsiString; overload;
  Procedure DoneODBC;

  function  ExecuteSQL(const SQL: AnsiString): TableArray;
  function  ExecuteSQLNoTable(const SQL: AnsiString): Integer;


var ErrorSQL : byte;
{
  1 -    ODBC
  2 -     3  ODBC
  3 -    
  4 -     
  5 -      
  6 -   SQL-
  7 -      ODBC
  8 -     
  9 -        
}

implementation

var
	hENV   : SQLHENV;
	hDBC   : SQLHDBC;
	hSTMT  : SQLHSTMT;
	retSql : SQLRETURN;


Function LoadParamFromIniFiles(IniName: AnsiString) :AnsiString;
var ini : TIniFile; L :TStringList; i: integer;

	function Res_(s :string) :string;
	var j: integer;
	begin
		s := trim(s);
		IF s <> '' then
			for j := 1 to length(s) do
				IF s[j] in ['[',']','{','}','(',')',',','*','=','!','@',' '] then begin
					Result := '{' + s + '}';
					exit;
				end;
		Result := s;
	end;
begin
	result := '';
	IF IniName <> '' then begin
		ini := TIniFile.Create(IniName);
		L := TStringList.Create;
		ini.ReadSection('DEF',L);
		IF L.Count > 0 then
			for i := 0 to L.Count - 1 do
				result := result +
						Res_(L[i]) + '=' +
						Res_(ini.ReadString('DEF',L[i],'')) + ';';
		L.Free;
		ini.Free;
	end;
end;

function __init: boolean;
begin
	ErrorSQL := 0;
	result := false;
	retSql := SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, hENV);
	IF retSql = SQL_ERROR then begin ErrorSQL := 1; result := true; exit; end;
	retSql := SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, SQLPOINTER(SQL_OV_ODBC3), SQL_IS_INTEGER);
	IF retSql = SQL_ERROR then begin ErrorSQL := 2; result := true; exit; end;
	retSql := SQLAllocHandle(SQL_HANDLE_DBC, hENV, hDBC);
	IF retSql = SQL_ERROR then begin ErrorSQL := 7; result := true; exit; end;
end;

function __initDB: boolean;
begin
	retSql := SQLAllocHandle(SQL_HANDLE_STMT, hDBC, hSTMT);
	IF retSql = SQL_ERROR then begin
		ErrorSQL := 5; 
		result := true;
		exit;
	end;
end;


Procedure InitODBC(const Server, User, PassWord: AnsiString); overload;
begin
	IF (Trim(Server) = '') or ( Trim(User) = '') then begin
		ErrorSQL := 3;
		exit;
	end;
	IF __init then exit;

	retSQL := SQLConnect(hDBC,
					   @Server[1], Length(Server),
					   @User[1], Length(User),
					   @passWord[1], Length(PassWord)
			  );
	IF retSql = SQL_ERROR then begin ErrorSQL := 4; exit; end;

	IF __initDB then exit;
end;

Function InitODBC(const Param : AnsiString) :AnsiString; overload;
var ALen: Smallint;
begin
	IF Trim(Param) = '' then begin
		ErrorSQL := 3;
		result := '';
		exit;
	end;
	IF __init then exit;

	Setlength(result, 1024);
	retSQL := SQLDriverConnect(hDBC, nil, @Param[1], length(Param),
								@result[1], 1024, ALen, SQL_DRIVER_NOPROMPT );
	IF retSql = SQL_ERROR then begin ErrorSQL := 4; exit; end;
	result := LeftStr(result, ALen);

	IF __initDB then exit;

end;

Procedure DoneODBC;
begin
	IF hSTMT <> nil then SQLFreeHandle(SQL_HANDLE_STMT, hSTMT);
	IF hDBC <> nil then begin
		SQLDisconnect(hDBC);
		SQLFreeHandle(SQL_HANDLE_DBC, hDBC);
	end;
	IF hENV <> nil then SQLFreeHandle(SQL_HANDLE_ENV, hENV);
end;

//----------------------------------------------------------------------------//

function ExecuteSQL(const SQL: AnsiString): TableArray;
var ar : array of record tip: integer; len: integer;end;

	procedure getFieldInfo(num : word);
	const 
		ColNmDefLen = 40;
		TpNmDefLen  = 80;
	var
		ColCount : SQLSMALLINT;
		ColNM    : AnsiString;
		ColNmLen, TpNmLen, DtTp, DecDig, Null_:SQLSMALLINT;
		ColSz    : SQLUINTEGER;
		FlTp     : FieldType;
		FlSz     : word;
	begin
		SetLength(ColNm, ColNmDefLen);

		RetSql := SQLDescribeCol(hSTMT, num,
				@(ColNm[1]), ColNmDefLen + 1,
				ColNmLen, DtTp,
				ColSz, DecDig, Null_);

		SetLength(ColNm, ColNmLen);
		IF ColNmLen > ColNmDefLen then
		RetSql := SQLColAttribute(hSTMT, num, SQL_DESC_NAME,
					@(ColNm[1]), ColNmLen + 1,
					@ColNmLen, nil);

		FlSz := 0;
		ar[ num ].len := 10;

		case DtTp of
			SQL_WCHAR, SQL_WVARCHAR,
			SQL_CHAR: begin
				FlTp := ft_AnsiString;
				FlSz := ColSz + 1;
				ar[ num ].tip := SQL_C_CHAR;
				ar[ num ].len := FlSz + 1;
			end;
			SQL_VARCHAR: begin
				FlTp := ft_AnsiString;
				FlSz := ColSz + 1;
				ar[ num ].tip := SQL_C_CHAR;
				ar[ num ].len := FlSz + 1;
			end;
			SQL_LONGVARCHAR: begin
				FlTp := ft_AnsiString;
				ar[ num ].tip := SQL_C_CHAR;
				ar[ num ].len := FlSz + 1;
			end;
			SQl_DECIMAL: begin
				FlTp := ft_Float;
				ar[ num ].tip := SQL_C_DOUBLE;
			end;
			SQL_NUMERIC: begin
				FlTp := ft_Float;
				ar[ num ].tip := SQL_C_DOUBLE;
			end;
			SQL_SMALLINT: begin
				FlTp := ft_Int;
				ar[ num ].tip := SQL_C_SSHORT;
			end;
			SQL_INTEGER: begin
				FlTp := ft_Int;
				ar[ num ].tip := SQL_C_SLONG;
			end;
			SQL_REAL,
			SQL_DOUBLE,
			SQL_FLOAT: begin
				FlTp := ft_Float;
				ar[ num ].tip := SQL_C_DOUBLE;
			end;
			SQL_BIT: begin
				FlTp := ft_Boolean;
				ar[ num ].tip := SQL_C_BIT;
			end;
			SQL_TINYINT: begin
				FlTp := ft_Int;
				ar[ num ].tip := SQL_C_TINYINT;
			end;
			SQL_BIGINT: begin
				FlTp := ft_Int;
				ar[ num ].tip := SQL_C_SBIGINT;
			end;

			{     SQL_BINARY:     ;//begin FlTp:=ftBytes;     FlSz:=ColSz;end;
			SQL_VARBINARY:  ;//begin FlTp:=ftVarBytes;  FlSz:=ColSz;end;
			SQL_LONGVARBINARY:;//begin FlTp:=ftBlob;      FlSz:=0;end;}

			SQL_TYPE_DATE: begin
				FlTp := ft_Date;
				ar[ num ].tip := SQL_C_TYPE_DATE;
			end;
			SQL_TYPE_TIME: begin
				FlTp := ft_Date;
				ar[ num ].tip := SQL_C_TYPE_TIME;
			end;
			SQL_TYPE_TIMESTAMP: begin
				FlTp := ft_Date;
				ar[ num ].tip := SQL_C_TYPE_TIMESTAMP;
				ar[ num ].len := 16;
			end;
			{SQL_WCHAR: begin
				FlTp := ft_WideString;
				FlSz := ColSz + 1;
				ar[ num ].tip := SQL_C_CHAR;
				ar[ num ].len := (FlSz + 1) shl 1;
			end;
			SQL_WVARCHAR: begin
				FlTp := ft_WideString;
				FlSz := ColSz + 1;
				ar[ num ].tip := SQL_C_CHAR;
				ar[ num ].len := (FlSz + 1) shl 1;
			end;}
			SQL_WLONGVARCHAR: begin
				FlTp := ft_AnsiString;
				ar[ num ].tip := SQL_C_CHAR;
			end;
			SQL_GUID: begin
				FlTp := ft_AnsiString;
				FlSz := ColSz + 1;
				ar[ num ].tip := SQL_C_GUID;
				ar[ num ].len := FlSz + 1;
			end;

			else begin
				FlTp := ft_Pointer;
				FlSz := ColSz;
				ar[ num ].tip := SQL_C_CHAR;
			end;
		end;

		result.AddField(ColNM, FlTp, FlSz);

	end;

var
	i, j, nCols : SmallInt;
	buf         : array of byte;
	sz          : SQLINTEGER;
begin
	result := nil;
	IF Trim(SQL) = '' then begin
		ErrorSQL := 3;
		exit;
	end;

	retSql := SQLExecDirect(hSTMT, @SQL[1], Length(SQL));
	IF retSql = SQL_ERROR then begin ErrorSQL := 6; exit; end;

	retSql := SQLNumResultCols(hSTMT, nCols);
	//writeln('Count Fields = ',nCols,' : ',retSql <> SQL_ERROR);
	IF(retSql <> SQL_ERROR) and (nCols > 0) then begin

		Result := TableArray.Create;
		//    Result.CountCol := nCols;
		SetLength(ar, nCols + 1);
		//writeln;
		for i := 1 to nCols do //begin
			getFieldInfo(i);
		//write( result.NameField(i), ' ' );
		//end;


		repeat
			retSql := SQLFetch(hSTMT);
			while
				( (retSql = SQL_SUCCESS_WITH_INFO) or
				  (retSql = SQL_ROW_SUCCESS_WITH_INFO)
				) and
				(retSql <> SQL_NO_DATA)
			do retSql := SQLFetch(hSTMT);

			IF(retSql = SQL_SUCCESS) or (retSql = SQL_SUCCESS_WITH_INFO)then begin
				result.AddRow;
				for i := 1 to nCols do begin
					SetLength(buf, ar[i].len);

					for j := 0 to high(buf) do buf[ j ] := 0;

					retSql := SQLGetData(hSTMT, i, ar[ i ].tip, @buf[0], Length(Buf), @sz);
					case result.GetField(i)._Type of
						ft_Int   : result[i] := Int64(pointer(@buf[0])^);
						ft_Float : result[i] := Double(pointer(@buf[0])^);
						ft_Date  : begin
							case ar[ i ].tip of
								SQL_C_TYPE_TIME :
									IF sz <> SQL_NULL_DATA then
										result[ i ] := TimeStructToDateTime(PSQL_TIME_STRUCT(Pointer(@Buf[0])));

								SQL_C_TYPE_DATE :
									IF sz <> SQL_NULL_DATA then
										result[ i ] := DateStructToDateTime(PSQL_DATE_STRUCT(Pointer(@Buf[0])));

								SQL_C_TYPE_TIMESTAMP :
									IF sz <> SQL_NULL_DATA then
										result[ i ] := TIMESTAMPStructToDateTime(PSQL_TIMESTAMP_STRUCT(Pointer(@Buf[0])));
							end;
						end;
						ft_Boolean : result[i] := Boolean(buf[0]);
						ft_AnsiString : result[i] := AnsiString(pchar(@buf[0]));
						ft_WideString : result[i] := WideString(pwidechar(@buf[0]));
						else result[i] := 0;
					end;
				end;
			end else break;
		until retSql = SQL_ERROR;//}

		result.FixedData;

	end else ErrorSQL := 8;

	SQLCloseCursor(hSTMT);
end;

function ExecuteSQLNoTable(const SQL: AnsiString): Integer;
begin
	result := 0;
	IF Trim(SQL) = '' then begin
		ErrorSQL := 3;
		exit;
	end;

	retSql := SQLExecDirect(hSTMT, @SQL[1], Length(SQL));
	IF retSql = SQL_ERROR then begin ErrorSQL := 6; exit; end;

	retSql := SQLRowCount(hSTMT, result);
	IF retSql = SQL_ERROR then ErrorSQL := 9;

	SQLCloseCursor(hSTMT);
end;

end.
