unit unitUtils;
{$H+}
interface
uses sysUtils,strUtils,variants;

{
==== ver 1.1.2 ====
*      TableArray,  
*      TablrArray:
    + IsDelete    -     
    + Delete      -     
    + FilterMulti -       
+ GetArrayFilterParam -     TableArray;    
==== ver 1.1.1 ====
*   TableArray,     
==== ver 1.1 ====
*   Utf8
  *   "ArsUtf8"
  + SplitUtf8
  + JoinUtf8
  + AppendArsUtf8
  + FindArsUtf8

  * 
  + AsciiToUtf8
  + Utf8ToAscii

*  GrafArray, GrafStrArray (  ),
    (  ) => Graf2Array
  *  
  + GetDatas
  + PopP
  + PushP
  + ShifhP
  + UnShiftP

  *  GrafStrArray
  + Pop
  + Push
  + Shift
  + UnShift

==== ver 1.0.4.2 ====
+   Lazarus

==== ver 1.0.4.1 ====
* -    "F_To_S"        

==== ver 1.0.4 ====
*   "GrafArray"
  +   
    * SortKey  -     
    * SortVal  -     

==== ver 1.0.3 ====
*   "GrafArray"
  +   
    * EOF -    
-          

==== ver 1.0.2 ====

*   "GrafStrArray"
  -  ,     nil     
  *     ( 
+    Lazarus
*   
  + FindArs   -   

==== ver 1.0.1 ====

*   "GrafStrArray"
  +   "     "
  +     (   )
  +   
    + reverse   -     
    + ScrollPos -     
  -  :
    * F_To_S   -  ,     ":"
    * CMPFloat -   

==== ver 1.0 ====

(*)  
-         
+   "RPos"   "  "

==== OldVersion ===

+   "Ars" ( )
  +      :
    * Split      -     
    * Join       -      
    * AppendArs  -    
+   "ArInt" (  )
  +      :
    * AppendArInt

+   "GrafArray" (  )
  *   
    *    
    *     
    *    ( ,  ,  )
    *      
    *       
    *      
    *    (First, Next, Prior, Last, Key, Get, Position)

+   "GrafStrArray" (  )
  *    "GrafArray" 
    *  "Get"   "Str"

+      
  * dub
  * To_s
  * Test_Char
  * RPosC
  * S_To_F
  * F_To_S

+   
  * Stepen
  * CMPFloat

+   /
  * AnsiToAscii
  * AsciiToAnsi

+   "TFileHandle" (    )
  *   "DefaultFileHandle"   
  * TFile -  ,         
}

{********************************************
 ***                 ARS                  ***
 ********************************************}
type
	Ars = array of string; //  
	ArsUtf8 = array of UTF8String;
	ArInt = array of integer;
	//AsArs=array of record nm:string;vl:variant;end;

	Function  Split(s:string; const t :string) :Ars;
	//     ,   

	Function  Join(const s :Ars; const t :string = '') :string;
	//     ,     

	Procedure AppendArs(var a :Ars; const s :string);
	Function  FindArs(const a :Ars; const s :string) :longint;

	Procedure AppendArInt(var a :ArInt; i :integer);



	Function  SplitUtf8(s :Utf8String; const t :Utf8String) :ArsUtf8;
	//     ,   

	Function  JoinUtf8(const s :ArsUtf8; const t :Utf8String = '') :Utf8String;
	//     ,     

	Procedure AppendArsUtf8(var a :ArsUtf8; const s :Utf8String);
	Function  FindArsUtf8(const a :ArsUtf8; const s :Utf8String) :longint;


{********************************************
 ***               Grafs                  ***
 ********************************************}
type
	PGraf = ^TGraf;
	TGraf = record
		back, next :PGraf;
		name       :string;
		data       :pointer;
	end;

	TProcGraf = procedure(var p :pointer);
	TFuncGraf = function(var p :pointer) :pointer;
	TFuncGrafFind = function(const a, b :pointer) :boolean;
	TFuncGrafSort = function(const a, b :pointer; const aName, bName :string) :integer;
	TGrafFindOptions = set of(gfoBack, gfoNextFind, gfoIndex, gfoToStart);
	ClassGraf = class of GrafArray;

	GrafArray = class
		private
			st, ps, SavePs  :PGraf;
			_ps, ct, SaveI  :integer;
			er, ends, SaveE :boolean;
			function  _new(v :pointer = nil) :PGraf;
			procedure _del(var p :PGraf);
			procedure __del(var p :PGraf);
			protected
			procedure SetNum(i :integer);
			procedure SetName(const s :string; back :boolean = false; start :boolean = true);
			function  getN(i: integer): string;
			function  getV(const i: variant): pointer;
			procedure setN(i: integer; const _Value: string);
			procedure setV(const i: variant; const _Value: pointer);
			function  Clones(t :ClassGraf) :GrafArray;

			function data_New :pointer; virtual;
			procedure data_Dispose(var p :pointer); virtual;
			function data_Find(const a,b:pointer) :boolean; virtual;
			function data_Clone(var p :pointer) :pointer; virtual;
			function data_Str(var p :pointer) :string; virtual;
		public

			constructor Create;
			Destructor Destroy; override;
			Property  Count :integer read ct;
			Property  Errors :boolean read er;

			Function  Names :Ars;

			Function  Add(const nm :string; vl :pointer = nil; frst :boolean = false) :integer;
			Function  Delete(i :integer) :boolean; overload;
			Function  Delete(const v :string) :boolean; overload;
			function  DelNames(const v :string) :boolean;
			function  DelValues(v :pointer) :integer; virtual;
			procedure Clear;

			function  PopP :pointer;
			function  ShiftP :pointer;
			function  PushP(const v :pointer) :integer;
			function  UnShiftP(const v :pointer) :integer;

			Function  Clone :GrafArray; virtual;

			Property  Position :integer read _ps write SetNum;
			Property  Name[i :integer] :string read getN write setN;
			Property  Value[const i :variant] :pointer read getV write setV; default;

			function  IsName(const v :string) :boolean;
			function  IsVal(v :pointer) :boolean;

			function  Index(v :pointer) :string;
			function  rIndex(v :pointer) :string;
			function  IndexName(const v :string) :integer;
			function  rIndexName(const v :string) :integer;
			function  IndexAll(v :pointer) :Ars;
			function  IndexNameAll(const v :string) :ArInt;

			function  Find(v :pointer; option :TGrafFindOptions = [gfoToStart]) :variant;

			procedure First;
			procedure Last;
			procedure Next;
			procedure Prior;
			Property  EOF :boolean read ends;
			Function  Key :string;
			Function  Get :pointer;
			procedure SavePosition;
			procedure restoryPosition;

			procedure ScrollPos(i :integer);
			procedure reverse;

			procedure SortKey(Ups :boolean = false);
			procedure SortVal(func :TFuncGrafSort);

			function GetDatas(symData:String=':>'):String;
	end;

	Graf2Array=class(GrafArray)
		protected
			function  data_New :pointer ;override;
			procedure data_Dispose(var p :pointer); override;
			function  data_Find(const a, b :pointer) :boolean; override;
			function  data_Clone(var p :pointer) :pointer; override;
		public
			OnNew     :TProcGraf;
			OnDispose :TProcGraf;
			OnIsVal   :TFuncGrafFind;
			OnClone   :TFuncGraf;
			constructor Create;
			Procedure SetProc(_New_,_Dispose_:TProcGraf;_IsVal_:TFuncGrafFind;_clone_:TFuncGraf);
	end;

	GrafStrArray = class(GrafArray)
		private
			function  getS(const i: variant) : string;
			procedure setS(const i: variant; const _Value: string);
			protected
			function  data_New :pointer; override;
			procedure data_Dispose(var p :pointer); override;
			function  data_Find(const a, b :pointer) :boolean; override;
			function  data_Clone(var p :pointer) :pointer; override;
			function  data_Str(var p :pointer) :string; override;
		public
			Constructor Create;

			Property StrValue[const i :variant] :string read getS write setS; default;

			Function Add(const nm :string; const vl :string; frst :boolean = false) :integer; overload;
			function DelValues(const v :string) :integer; overload;
			function IsVal(const v :string) :boolean; overload;
			function Index(const v :string) :string; overload;
			function rIndex(const v :string) :string; overload;
			function IndexAll(const v :string) :Ars; overload;
			function Find(const v :string; option :TGrafFindOptions = [gfoToStart]) :variant; overload;
			Function Str :string;

			function Pop :string;
			function Shift :string;
			function Push(const vl :string) :integer;
			function UnShift(const vl :string) :integer;

			Function Clone :GrafArray; override;
	end;

function AdrToStr(const p :pointer) :string;
{procedure newStrPointer(var p :pointer);
procedure UnStrPointer(var p :pointer);
function CompareStrPointer(const a, b :pointer) :boolean;
function CopyStrPointer(var p :pointer) :pointer;}

{********************************************
 ***              String                  ***
 ********************************************}

type
	DFormatFloat = (dffNumber, dffComma, dffDecNumber, dffNullLeft);
	SFormatFloat = set of DFormatFloat;

	function dub(const s :string; w :word) :string;     //   - 
	function To_s(const ch :int64; zn :byte) :string;   //   
	function Test_Char(const s :string; c :char) :longword;
	function RPosC(const s :string; c :char) :longword;
	function rPos(const s1, s2 :string) :integer;
	function S_To_F(s :string) :extended;
	function F_To_S(const f :Extended; len, dec :byte) :string; overload;
	function F_To_S(const f :Extended; len, dec :byte; format :SFormatFloat) :string; overload;

	//function Str(v:variant):string;
	var toStr :function(const v :variant) :string;

	{********************************************
	***                Math                  ***
	********************************************}

	function Stepen(const n :int64; d :byte) :int64;
	function CMPFloat(const e1, e2 :extended; decimal :byte) :shortint;

	{********************************************
	***          Coding/deCoding             ***
	********************************************}

	function AnsiToAscii(const s: String) : String; // ANSI => ASCII
	function AsciiToAnsi(const s: String) : String; // ASCII => ANSI
	function AsciiToUtf8(const s: String) :Utf8String; // ASCII => Utf8
	function Utf8ToAscii(const s: Utf8String) :String; // Utf8 => ASCII


{********************************************
 ***               Table                  ***
 ********************************************}
const // flt = filter
	Flt_Not = 1;
	Flt_IgnorRegister = $80;

	Flt_Equ = 0;
	Flt_In = 2;

	Flt_Not_Equ = Flt_Not + Flt_Equ;
	Flt_Not_In = Flt_Not + Flt_In;
	Flt_Equ_And_IgnorReg = Flt_Equ + Flt_IgnorRegister;
	Flt_Not_Equ_And_IgnorReg = Flt_Not_Equ + Flt_IgnorRegister;
	flt_In_And_IgnorReg = Flt_In + Flt_IgnorRegister;
	flt_Not_In_And_IgnorReg = Flt_Not_In + Flt_IgnorRegister;

type
	FieldType = (ft_Pointer, ft_Int, ft_Float, ft_Date, ft_Boolean,
		ft_AnsiString, ft_WideString);
	FieldRec = record
		_Type: FieldType;
		Name : AnsiString;
		Size : LongWord;
	end;

	FieldDataType = record
		writes : boolean;
		case byte of
		0:(p: Pointer);
		1:(s: longword);
		2:(i: int64);
		3:(f: Double);
		4:(d: TDateTime);
		5:(b: Boolean);
	end;
	PFieldDataType = ^FieldDataType;

	ArrayFieldDataType = Array of FieldDataType;

	RecFilterParam = packed record
		FieldIndex : word;
		val        : AnsiString;
		param      : byte;
	end;
	ArrayFilterParam = Array of RecFilterParam;
	TableSortInformation = procedure(Progress : integer);

	TableArray = class
		private
			_Fields         : array of FieldRec;
			_Data           : Array of ArrayFieldDataType;
			_DataPos        : Array of integer;
			_DataDelete     : Array of boolean;
			_ps             : LongInt;
			_fix, _fixR, wr : boolean;
			maxStrIndex     : integer;
			__flt : packed record
				this      : TableArray;
				fl, Value : variant;
			end;

			procedure clearRecords(num: integer);

			function  getCC: word;
			function  getCR: LongWord;
			function  getF(nm: variant): variant;
			procedure setCC(const Value: word);
			procedure setCR(const Value: LongWord);
			procedure setF(nm: variant; const Value: variant);
			function  getPS: LongInt;
			procedure SetPS(const Value: LongInt);
			function  GetDataF(ps, w :integer): PFieldDataType;
			function  getFType( w : word): FieldType;
			procedure setModif;
			function  GetModif: boolean;
		public
			Constructor Create;
			Destructor Destroy;override;

			property  CountCol: word read getCC write setCC;
			property  CountRow: LongWord read getCR write setCR;

			Function  IndexField(const Name:AnsiString):word;
			Function  NameField(index : word):AnsiString;
			Function  AddField(const Name:AnsiString; _Type: FieldType; Size: LongWord = 0): word;

			Procedure EditField(numFl: word; const Name:AnsiString; _Type: FieldType; Size: LongWord = 0);
			Property  Modifikation : boolean read GetModif;

			procedure AddRow(num : integer = 0);
			procedure FixedData;

			function  MoveRecords(RecPosOne, RecPosTwo : integer): boolean;
			function  InsertCopyRecords(RecPos : integer): boolean;
			Function  FieldToStr(nm: variant; minSym:integer = 0; SymSep: AnsiChar = ' '; SepOrientationLeft:boolean = false): AnsiString;
			Function  FieldGetMaxSym( nm: variant): integer;

			procedure NumericReAll;

			Function  GetField(nm: variant): FieldRec;
			property  Field[nm : variant]:variant read getF write setF;default;
			Function  IsWriteField(nm: variant): boolean;
			function  GetNumRecord : integer;
			Property  Position : LongInt read getPS write SetPS;

			Function  IsDelete( num : Integer = -1): boolean;
			Procedure Delete( del : boolean = true; num : Integer = -1);

			Procedure First;
			Procedure Last;
			Procedure Next;
			Procedure Prior;

			Function  EOF  :boolean;
			Function  BOF  :boolean;
			Function  Ends :boolean;

			Procedure SortByField(const Fl : AnsiString; MinToMax : boolean = false; Func: TableSortInformation = nil);
			Function Filter(Fl, Value : variant): TableArray;
			Function FilterMulti(Param : ArrayFilterParam ): TableArray;
			Function Assaciative( Fl_Key, Fl_Value : variant): GrafStrArray;

	end;

	function GetArrayFilterParam(const ar: Array of const): ArrayFilterParam;


{********************************************
 ***               Files                  ***
 ********************************************}
type
	TFileHandleClass = class of TFileHandle;
	//       
	TFileHandle = class//    
		private
			Nm, pt :string;
		public
			Property Name :string read Nm;
			Property Path :string read pt;
			function Open(const FileName: string; Mode: LongWord) :boolean; virtual; abstract;
			function IsOpen :boolean; virtual; abstract;
			function Creates(const FileName: string): boolean; virtual; abstract;
			function Read(var Buffer; Count: LongWord): Integer; virtual; abstract;
			function Write(const Buffer; Count: LongWord): Integer; virtual; abstract;
			function Seek(Offset :Integer = 0; Origin: Integer = 0): Integer; overload; virtual; abstract;
			function Seek(Offset :int64; Origin: Integer = 0): Int64; overload; virtual; abstract;
			procedure Close; virtual; abstract;
			function Size :int64; overload; virtual; abstract;
			class function Exists(const FileName: string): Boolean; virtual;
			class procedure Rename(const OldName, NewName :string); virtual;
			class procedure Delete(const FileName :string); virtual;
			class function New :TFileHandle;
			class function Size(const FileName :string) :int64; overload; virtual;
			destructor Destroy; override;
		end;
		
	TFile = class(TFileHandle)//       
		private
			HNDL :integer;
		public
			function  Open(const FileName: string; Mode: LongWord) :boolean; override;
			function  IsOpen :boolean; override;
			function  Creates(const FileName: string): boolean; override;
			function  Read(var Buffer; Count: LongWord): Integer; override;
			function  Write(const Buffer; Count: LongWord): Integer; override;
			function  Seek(Offset :Integer = 0; Origin: Integer = 0): Integer; overload; override;
			function  Seek(Offset :int64; Origin: Integer=0): Int64; overload; override;
			procedure Close; override;
			function  Size :int64; overload; override;
			class function Size(const FileName :string) :int64; overload; override;
			class procedure Rename(const OldName, NewName :string); override;
			class procedure Delete(const FileName :string); override;
			class function Exists(const FileName: string): Boolean; override;
	end;

var
	DefaultFileHandle :TFileHandleClass = TFile;
implementation

{********************************************
 ***                 ARS                  ***
 ********************************************}
Function Split(s :string; const t :string) :Ars;
var i: integer;
begin
	SetLength(result,1);
	i := 0;
	while pos(t,s) > 0 do begin
		result[i] := copy(s, 1, pos(t,s) - 1);
		delete(s, 1, length(result[i]) + length(t));
		inc(i);
		SetLength(result, i + 1);
	end;
	result[i] := s;
end;

Function Join(const s:Ars;const t:string=''):string;
var i: integer;
begin
	result := '';
	IF length(s) > 0 then begin
		result := s[0];
		IF length(s) > 1 then 
			for i := 1 to high(s) do
				result := result + t + s[i];
	end;
end;


Procedure AppendArs(var a:Ars;const s:string);
begin
	SetLength(a, length(a) + 1);
	a[high(a)] := s;
end;

Function FindArs(const a:Ars;const s:string):longint;
begin
	result := 0;
	while result < length(a) do begin
		IF a[result] = s then exit;
		inc(result);
	end;
	result := -1;
end;

Procedure AppendArInt(var a:ArInt;i:integer);
begin
	SetLength(a, length(a) + 1);
	a[high(a)] := i;
end;
               {****}
Function SplitUtf8(s:Utf8String;const t:Utf8String):ArsUtf8;
var i: integer;
begin
	SetLength(result,1);
	i := 0;
	while pos(t, s) > 0 do begin
		result[i] := copy(s, 1, pos(t,s) - 1);
		delete(s, 1, length(result[i]) + length(t));
		inc(i);
		SetLength(result, i + 1);
	end;
	result[i] := s;
end;

Function JoinUtf8(const s:ArsUtf8;const t:Utf8String=''):Utf8String;
var i: integer;
begin
	result := '';
	IF length(s) > 0 then begin
		result := s[0];
		IF length(s) > 1 then
			for i := 1 to high(s) do
				result := result + t + s[i];
	end;
end;


Procedure AppendArsUtf8(var a:ArsUtf8;const s:Utf8String);
begin
	SetLength(a, length(a) + 1);
	a[high(a)] := s;
end;

Function FindArsUtf8(const a:ArsUtf8;const s:Utf8String):longint;
begin
	result := 0;
	while result < length(a) do begin
		IF a[result] = s then exit;
		inc(result);
	end;
	result := -1;
end;


{********************************************
 ***              String                  ***
 ********************************************}

function F_To_S(const f:Extended;len,dec:byte;format:SFormatFloat):string;
var e,t: string; i: smallint;
begin
	result := inttostr(trunc(f));
	If(result = '0') and (f < 0)then result := '-' + result;
	IF(dffNumber in format)and not(dffNullLeft in format)then begin
		i := length(result) - 2;
		while i > 1 do begin
			insert(' ', result, i);
			i := i - 3;
		end;
	end;
	while length(result) < len do IF dffNullLeft in format
		then result := '0' + result
		else result := ' ' + result;

	if dec > 0 then begin        {-trunc(f))}
		e := inttostr(round(Frac(f) * stepen(10, dec + 1))div 10);
		if e[1] = '-' then delete(e, 1, 1);

		if length(e) > dec then begin
			t:=copy(e, 1, length(e) - dec);
			delete(e, 1, length(t));
			IF length(t) > 1 then t := t[length(t)];
			result[length(result)] := char(byte(result[length(result)]) +
										 byte(t[1]) - 48);
		end;
		while length(e) < dec do e := '0' + e;
		IF dffDecNumber in format then begin
			i := 4;
			while i <= length(e) do begin
				insert(' ', e, i);
				i := i + 4;
			end;
		end;
		IF dffComma in format
			then result := result + ',' + e
			else result := result + '.' + e;
	end;
end;

function F_To_S(const f:Extended;len,dec:byte):string;
var 
	e, t: string; 
	eG: boolean; 
	i: smallint;//integer;
	procedure incR(var s: string; i: byte);
	begin
		IF s[i] = ' ' then s[i] := '1' else
		IF s[i] = '-' then begin
			s[i] := '1';
			IF i = 1
				then s := '-' + s
				else s[i - 1] := '-';
		end else
		IF i = 0 then s := '1' + s else
		IF s[i] = '.' then incR(s, i - 1) else
		IF s[i] = '9' then begin
			s[i] := '0';
			incR(s, i - 1);
		end else inc(s[i]);
	end;
begin
	result := inttostr(trunc(f));
	If(result = '0') and (f < 0)then result := '-' + result;
	while length(result) < len do result := ' ' + result;

	if dec > 0 then begin
		e := inttostr(round(Frac(f) * stepen(10, dec + 1)) div 10);
		if e[1] = '-' then delete(e, 1, 1);
		eG := length(e) > dec;
		IF not eG then
			while length(e) < dec do e := '0' + e;
		result := result + '.' + e;
		IF eG then begin
			i := pos('.', result) + 1 + dec;
			IF result[i] > '4' then IncR(result, i - 1);
			delete(result, i, 255);
		end;
	end;
end;

function S_To_F(s:string):extended;
begin
	IF pos('.',s) > 0 then begin
		insert(',', s, pos('.',s));
		delete(s, pos('.',s), 1);
	end;
	result := strtofloatDef(s, 0);
end;

function RPosC(const s:string;c:char):longword;
begin
	result := length(s);
	while result > 0 do 
		if s[result] = c
			then exit
			else dec(result);
end;

function rPos(const s1,s2:string):integer;
var i, l: integer;
begin
	result := 0;
	l := length(s1);
	for i := length(s2) - l downto 1 do IF copy(s2, i, l) = s1 then begin
		result := i;
		exit;
	end;
end;


function test_char(const s:string;c:char):longword;
var i: longword;
begin
	result := 0;
	IF s <> '' then
	for i := 1 to length(s) - 1 do
		if s[i] = c then inc(result);
end;

function To_s(const ch:int64;zn:byte):string;
begin
	result := IntToStr(ch);
	while length(result) < zn do
		result := '0' + result;
end;

function dub(const s:string;w:word):string;
begin
	result := '';
	while w > 0 do begin
		result := result + s;
		dec(w);
	end;
end;

{function Str(v:variant):string;
begin
	result := vartostr(v);
end;}

{********************************************
 ***                Math                  ***
 ********************************************}

function CMPFloat(const e1, e2 :extended; decimal :byte) :shortint;
var x1, x2: int64;
	function ___Get(const e: Extended): Int64;
	var k : string;
	begin
		k := FloatToStr(e);
		result := pos(',',k);
		IF result > 0 then begin
			k := LeftStr(k, result + decimal);
			delete(k, result, 1);
		end;
		result := StrToInt64Def(k, 0);
	end;
begin
	x1 := ___Get(e1);
	x2 := ___Get(e2);
	if x1 > x2 then result := 1 else
	if x1 < x2 then result := -1 else result := 0;
end;

function Stepen(const n:int64; d:byte):int64;
begin
	result := 1;
	while(d > 0)do begin
		result := result * n;
		dec(d);
	end;
end;


{********************************************
 ***          Coding/deCoding             ***
 ********************************************}

function AnsiToAscii(const s: String) : String;
Var i: Integer;
begin
	Result := s;
	for i := 1 to length(s) do
		case byte(s[i]) of
			192..239: Result[i] := Char(byte(s[i]) - 64);
			240..255: Result[i] := Char(byte(s[i]) - 16);
			168: Result[i] := #240;//
			184: Result[i] := #241;//
		end;
end;

function AsciiToAnsi(const s: String) : String;
Var i : Integer;
begin
	Result := s;
	for i := 1 to length(s) do
		case byte(s[i]) of
			128..175: Result[i] := Char(byte(s[i])+64);
			224..239: Result[i] := Char(byte(s[i])+16);
			240: Result[i] := #168;//
			241: Result[i] := #184;//
		end;
end;

function AsciiToUtf8(const s:String):Utf8String;
begin
	result := AnsiToUtf8(AsciiToAnsi(s));
end;

function Utf8ToAscii(const s:Utf8String):String;
begin
	result := AnsiToAscii(Utf8ToAnsi(s));
end;

{********************************************
 ***               Files                  ***
 ********************************************}

class function TFileHandle.New:TFileHandle;
begin
	result := DefaultFileHandle.Create;
end;

class function TFileHandle.Exists(const FileName: string):boolean;
begin
	result := DefaultFileHandle.Exists(FileName);
end;

class procedure TFileHandle.Rename(const OldName, NewName:string);
begin
	DefaultFileHandle.Rename(OldName,NewName);
end;

class procedure TFileHandle.Delete(const FileName:string);
begin
	DefaultFileHandle.Delete(FileName);
end;

class function TFileHandle.Size(const FileName:string):int64;
begin
	result := DefaultFileHandle.Size(FileName);
end;

destructor TFileHandle.Destroy;
begin
	close;
end;
/////////////////////////////////////////////////
function TFile.Open(const FileName: string; Mode: Cardinal):boolean;
begin
	IF HNDL > 0 then close;
	HNDL := FileOpen(FileName, Mode);
	pt := FileName;
	NM := ExtractFileName(pt);
	result := HNDL > 0;
end;

function TFile.IsOpen:boolean;
begin
	result := HNDL > 0;
end;

function TFile.Creates(const FileName: string):boolean;
begin
	IF HNDL > 0 then close;
	HNDL := FileCreate(FileName);
	pt := FileName;
	NM := ExtractFileName(pt);
	result := HNDL > 0;
end;

function TFile.Read(var Buffer; Count: Cardinal):integer;
begin
	result := FileRead(HNDL, Buffer, Count);
end;

function TFile.Write(const Buffer; Count: Cardinal):integer;
begin
	result:=FileWrite(HNDL, Buffer, Count);
end;

function TFile.Seek(Offset: Integer=0; Origin: Integer=0):integer;
begin
	result := FileSeek(HNDL, Offset, Origin);
end;

function TFile.Seek(Offset: Int64; Origin: Integer=0):int64;
begin
	result := FileSeek(HNDL, Offset, Origin);
end;

procedure TFile.Close;
begin
	IF HNDL > 0 then FileClose(HNDL);
	HNDL := 0;
	pt := '';
	NM := '';
end;

function TFile.Size:int64;
begin
  result := TFile.Size(pt);
end;

class function TFile.Size(const FileName: string):int64;
var dt: TSearchRec;
begin
	findfirst(FileName, $FFFF, dt);
	result := dt.Size;
	FindClose(dt);
end;

class function TFile.Exists(const FileName: string):boolean;
begin
	result := FileExists(FileName);
end;

class procedure TFile.Rename(const OldName:string; const NewName:string);
begin
	RenameFile(OldName, NewName);
end;

class procedure TFile.Delete(const FileName:string);
begin
	DeleteFile(FileName);
end;


{********************************************
 ***               Grafs                  ***
 ********************************************}
function AdrToStr(const p :pointer) :string;
begin
	IF p = nil then result := '' else result := PString(p)^; //String(pchar(p));
end;

(*procedure newStrPointer(var p:pointer);
//var pp:PChar;
begin
  //pp:='';
  //p:=pchar('');//pp;
  new(PString(p));
  PString(p)^:='';
end;

procedure UnStrPointer(var p:pointer);
//var pp:PChar;
begin
//  pp:=p;
//  pp:='';
//  pchar(p):='';
  PString(p)^:='';
  Dispose(PString(p));
  p:=nil;
end;

function CompareStrPointer(const a,b:pointer):boolean;
begin
  result:=PString(a)^=PString(b)^;//StrComp(pchar(a),pchar(b))=0;
end;

function CopyStrPointer(var p:pointer):pointer;
begin
  new(PString(result));
  PString(result)^:=PString(p)^;
end;                              //*)

{                             GrafArray                                       }

function GrafArray.Add(const nm: string; vl: pointer = nil; frst: boolean = false): integer;
var s: string;
begin
	IF nm <> '' then s := nm else begin
		result := ct;
		repeat
			s := intToStr(result);
			inc(result);
		until not IsName(s);
	end;
	ps := _new(vl);
	result := ct;
	ps^.name := s;
	IF ct = 1
		then st := ps
		else begin
			ps^.back := st^.back;
			ps^.back^.next := ps;
		end;
	st^.back := ps;
	ps^.next := st;
	IF frst
		then begin st := ps; _ps := 0;end
		else _ps := ct - 1;
end;

procedure GrafArray.Clear;
begin
	while ct > 0 do begin
		ps := st;
		st := ps^.next;
		_del(ps);
	end;
	_ps := -1;
end;

function GrafArray.Clone: GrafArray;
begin
	result := Clones(GrafArray);
end;

function GrafArray.Clones(t: ClassGraf): GrafArray;
var i: integer;
begin
	result := t.Create;
	IF ct > 0 then begin
		SavePosition;
		ps := st;
		repeat
			result.Add(ps^.name, data_Clone(ps^.data));
			{IF assigned(OnClone)
			then result.Add(ps^.name,OnClone(ps^.data))
			else result.Add(ps^.name,ps^.data);}
			ps := ps^.next;
		until ps = st;
		restoryPosition;
		//First;
	end;
end;

constructor GrafArray.Create;
begin
	ct := 0;
	_ps := -1;
	st := nil;
	ps := nil;
	ends := false;
end;

function GrafArray.data_Clone(var p: pointer): pointer;
begin
	result := p;
end;

procedure GrafArray.data_Dispose(var p: pointer);
begin
	p := nil;
end;

function GrafArray.data_Find(const a, b: pointer): boolean;
begin
	result := a = b;
end;

function GrafArray.data_New: pointer;
begin
	result := nil;
end;

function GrafArray.data_Str(var p: pointer): string;
begin
	IF p = nil
		then result := 'Nil'
		else result := IntToStr(LongWord(p));
end;

function GrafArray.Delete(i: integer): boolean;
begin
	SetNum(i);
	result := not ER;
	IF result then __del(ps);
	First;
end;

function GrafArray.Delete(const v: string): boolean;
begin
	SetName(v);
	result := not ER;
	IF result then __del(ps);
	First;
end;

function GrafArray.DelNames(const v: string): boolean;
var a: ArInt; i: integer;
begin
	a := IndexNameAll(v);
	result := length(a) > 0;
	IF result then
		for i := 0 to high(a) do Delete(a[i]);
	First;
end;

function GrafArray.DelValues(v:pointer):integer;
var p: PGraf;
begin
	result := 0;
	IF ct = 0 then exit;
	ps := st;
	repeat
		p := ps^.next;
		IF data_Find(ps^.data, v)then begin
			__del(ps);
			inc(result);
		end;
		ps := p;
	until(ps = st) or (ct = 0);
	First;
end;

destructor GrafArray.Destroy;
begin
	clear;
	inherited;
end;

function GrafArray.Find(v: pointer; option: TGrafFindOptions): variant;
var 
	i    : integer; 
	b, bk: boolean;
	
	procedure _ret;
	begin
		IF gfoIndex in option
			then result := _ps
			else result := ps^.name;
	end;
begin
	bk := gfoBack in option;
	IF gfoNextFind in option then begin
		IF bk then Prior else Next;
	end else IF bk then Last else First;

	ER := false;
	b := gfoToStart in option;
	IF not b then i := _ps;
	repeat
		IF data_Find(ps^.data, v) then begin _ret; exit;end;
		IF bk then Prior else Next;
	until(b and (ps = st)) or ((not b) and (_ps = i));

	ER := true;
end;

procedure GrafArray.First;
begin
	_ps := 0;
	ps := st;
	ends := false;
end;

function GrafArray.Get: pointer;
begin
	IF Assigned(ps)
		then result := ps^.data
		else result := nil;
end;

function GrafArray.GetDatas(symData:String = ':>'): String;
var i: integer; p: PGraf;
begin
	ER := false;
	p := st;
	result := '';
	symData := ' ' + symData + '[ ';
	repeat
		result := result + p^.name + symData + data_Str(p^.data) + ' ];'#13#10;
		p := p^.next;
	until p = st;
end;

function GrafArray.getN(i: integer): string;
begin
	SetNum(i);
	IF ER
		then result := ''
		else result := ps^.name;
end;

function GrafArray.getV(const i: variant): pointer;
begin
	result := nil;
	IF VarIsNumeric(i)then begin
		IF(i >= 0) and (i < ct) then SetNum(i) else exit;
	end else IF not IsName(VarToStr(i))then exit;
	IF not ER then result := ps^.data;
end;

function GrafArray.Index(v: pointer): string;
begin
	result := Find(v);
end;

function GrafArray.IndexAll(v: pointer): Ars;
var p: PGraf;
begin
	SetLength(result, 0);
	IF ct = 0 then exit;
	p := st;
	repeat
		IF data_Find(p^.data, v)then AppendArs(result, p^.name);
		p := p^.next;
	until p = st;
end;

function GrafArray.IndexName(const v: string): integer;
begin
	SetName(v);
	IF ER then result := -1 else result := _ps;
end;

function GrafArray.IndexNameAll(const v: string): ArInt;
var p: PGraf; i: integer;
begin
	SetLength(result, 0);
	IF ct = 0 then exit;
	p := st;
	i := 0;
	repeat
		IF p^.name = v then AppendArInt(result, i);
		p := p^.next;
		inc(i);
	until p = st;
end;

function GrafArray.IsName(const v: string): boolean;
begin
	ER := false;
	IF(ct > 0) and assigned(ps) and (ps^.name = v)then begin 
		result := true; 
		exit; 
	end;
	SetName(v);
	result := not ER;
end;

function GrafArray.IsVal(v: pointer): boolean;
begin
	result := not VarIsNull(Find(v));
end;

function GrafArray.Key: string;
begin
	IF assigned(ps)
		then result := ps^.name
		else result := '';
end;

procedure GrafArray.Last;
begin
	_ps := ct - 1;
	ps := st^.back;
	ends := false;
end;

function GrafArray.Names: Ars;
var p: PGraf;
begin
	SetLength(result, 0);
	IF ct = 0 then exit;
	p := st;
	repeat
		AppendArs(result, p^.name);
		p := p^.next;
	until p = st;
end;

procedure GrafArray.Next;
begin
	inc(_ps);
	ps := ps^.next;
	IF _ps >= ct then begin
		_ps := 0;
		ends := true;
	end;
end;

function GrafArray.PopP: pointer;
var p: PGraf;
begin
	p := st^.back;
	result := data_Clone(p^.data);
	__del(p);
end;

procedure GrafArray.Prior;
begin
	dec(_ps);
	ps := ps^.back;
	IF _ps < 0 then begin
		_ps := ct - 1;
		ends := true;
	end;
end;

function GrafArray.PushP(const v: pointer): integer;
begin
	result := Add('', v);
end;

procedure GrafArray.restoryPosition;
begin
	ps := SavePs;
	_ps := SaveI;
	ends := SaveE;
end;

procedure GrafArray.reverse;
var p: pointer;
begin
	ps := st;
	repeat
		p := ps^.next;
		ps^.next := ps^.back;
		ps^.back := p;
		ps := p;
	until ps = st;
	First;
end;

function GrafArray.rIndex(v: pointer): string;
begin
	result := Find(v, [gfoBack,gfoToStart]);
end;

function GrafArray.rIndexName(const v: string): integer;
begin
	SetName(v, true);
	IF ER
		then result := -1
		else result := _ps;
end;

procedure GrafArray.SavePosition;
begin
	SaveI := _ps;
	SavePs := ps;
	SaveE := ends;
end;

procedure GrafArray.ScrollPos(i: integer);
begin
	while i <> 0 do 
		IF i > 0 then begin
			st := st^.next;
			dec(i);
		end else begin
			st := st^.back;
			inc(i);
		end;
	First;
end;

procedure GrafArray.setN(i: integer; const _Value: string);
begin
	SetNum(i);
	IF not ER then ps^.name := _Value;
end;

procedure GrafArray.SetName(const s: string;back:boolean=false; start: boolean=true);
var i, pi_: integer; p_: pointer;
begin
	er := (_ps < 0) or (_ps >= ct);
	IF er then exit;
	p_ := ps;
	pi_ := _ps;

	IF start then begin
		IF back then Last else First;
	end else IF back then begin dec(_ps); ps := ps^.back;end
				   else begin inc(_ps); ps := ps^.next;end;


	IF back then begin
		for i := _ps downto 0 do IF ps^.name = s then exit else Prior;
	end else for i := _ps to ct - 1 do IF ps^.name = s then exit else Next;
	er := true;
	_ps := pi_;
	ps := p_;
end;

procedure GrafArray.SetNum(i: integer);
	procedure _next;
	begin
		while _ps < i do Next;
	end;
	procedure _back;
	begin
		while(_ps > i)do Prior;
	end;
begin
	er := (0 > i) or (i >= ct);
	IF er or (i = _ps) then exit;
	IF ct > 10 then begin
		IF(i > _ps)then begin
			IF(ct - i > i - _ps)
				then _next
				else begin
					Last;
					_back;
				end;
		end else IF(i > _ps - i)
			then _back
			else begin
				First;
				_next;
			end;
	end else begin
		First;
		_next;
	end;
end;

procedure GrafArray.setV(const i: variant; const _Value: pointer);
begin
	IF VarIsNumeric(i) then begin
		IF(i >= 0) and (i < ct)
			then SetNum(i)
			else begin
				Add(VarToStr(i), _Value);
				exit;
			end;
	end else IF not IsName(VarToStr(i))then
	begin Add(VarToStr(i), _Value); exit; end;

	IF ps^.data <> _Value then ps^.data := _Value;
end;

function GrafArray.ShiftP: pointer;
var p: PGraf;
begin
	p := st;
	result := data_Clone(p^.data);
	__del(p);
end;

procedure GrafArray.SortKey(Ups:boolean=false);
var p1, p2: PGraf; p: pointer; nm: string; b: boolean;
begin
	IF st <> nil then begin
		p1 := st;
		repeat
			p2 := st;
			repeat
				IF Ups
					then b := p1^.name < p2^.name
					else b := p1^.name > p2^.name;
				IF b then begin
					nm := p1^.name;
					p1^.name := p2^.name;
					p2^.name := nm;

					p := p1^.data;
					p1^.data := p2^.data;
					p2^.data := p;
				end;
				p2 := p2^.next;
			until p2 = st;
			p1 := p1^.next;
		until p1 = st;
	end;
end;

procedure GrafArray.SortVal(func: TFuncGrafSort);
var p1, p2: PGraf; p: pointer; nm: string;
begin
	IF(st <> nil) and assigned(func) then begin
		p1 := st;
		repeat
			p2 := st;
			repeat
				IF func(p1^.data, p2^.data, p1^.name, p2^.name) <> 0 then begin
					nm := p1^.name;
					p1^.name := p2^.name;
					p2^.name := nm;

					p := p1^.data;
					p1^.data := p2^.data;
					p2^.data := p;
				end;
				p2 := p2^.next;
			until p2 = st;
			p1 := p1^.next;
		until p1 = st;
	end;
end;

function GrafArray.UnShiftP(const v: pointer): integer;
begin
	result := Add('', v, true);
end;

procedure GrafArray._del(var p: PGraf);
begin
	data_Dispose(p^.data);
	p^.name := '';
	dispose(p);
	dec(ct);
end;

function GrafArray._new(v:pointer=nil): PGraf;
begin
	result := nil;
	new(result);
	result^.data := v;
	IF v=nil then result^.data := data_New;
	result^.back := nil;
	result^.next := nil;
	result^.name := '';
	inc(ct);
end;

procedure GrafArray.__del(var p: PGraf);
begin
	IF ct > 0 then begin
		IF st = p then st := p^.next;
		p^.back^.next := p^.next;
		p^.next^.back := p^.back;
		_del(p);
		IF ct = 0 then begin
			st := nil;
			ps := nil;
			_ps := -1;
		end;
	end;
end;


{                            Graf2Array                                        }

constructor Graf2Array.Create;
begin
	OnNew := nil;
	OnDispose := nil;
	OnIsVal := nil;
	OnClone := nil;
end;

function Graf2Array.data_Clone(var p: pointer): pointer;
begin
	IF assigned(OnClone)
		then result := OnClone(p)
		else result := p;
end;

procedure Graf2Array.data_Dispose(var p: pointer);
begin
	IF assigned(OnDispose) then OnDispose(p);
end;

function Graf2Array.data_Find(const a, b: pointer): boolean;
begin
	IF assigned(OnIsVal)
		then result := OnIsVal(a,b)
		else result := a = b;
end;

function Graf2Array.data_New: pointer;
begin
	result := nil;
	IF assigned(OnNew)then OnNew(result);
end;

procedure Graf2Array.SetProc(_New_, _Dispose_: TProcGraf;
  _IsVal_: TFuncGrafFind;_clone_:TFuncGraf);
begin
	OnNew := _New_;
	OnDispose := _Dispose_;
	OnIsVal := _IsVal_;
	OnClone := _clone_;
end;

{                             GrafStrArray                                     }

function GrafStrArray.Add(const nm:string;const vl: string;frst:boolean=false): integer;
var p: pchar;
begin
	new(PString(p));
	PString(p)^ := vl;
	result := inherited Add(nm, p, frst);
end;

function GrafStrArray.Clone: GrafArray;
begin
	result := Clones(GrafStrArray);
end;

constructor GrafStrArray.Create;
begin
	inherited Create;
end;

function GrafStrArray.data_Clone(var p: pointer): pointer;
begin
	new(PString(result));
	PString(result)^ := PString(p)^;
end;

procedure GrafStrArray.data_Dispose(var p: pointer);
begin
	PString(p)^ := '';
	Dispose(PString(p));
	p := nil;
end;

function GrafStrArray.data_Find(const a, b: pointer): boolean;
begin
	result := PString(a)^ = PString(b)^;
end;

function GrafStrArray.data_New: pointer;
begin
	result := nil;
	new(PString(result));
	PString(result)^ := '';
end;

function GrafStrArray.data_Str(var p: pointer): string;
begin
	result := AdrToStr(p);
end;

function GrafStrArray.DelValues(const v: string): integer;
begin
	result := inherited DelValues(pchar(v));
end;

function GrafStrArray.Find(const v: string; option: TGrafFindOptions): variant;
begin
	result := inherited Find(PString(@v),option);
end;

function GrafStrArray.Shift: string;
var p: PString;
begin
	p := ShiftP;
	result := p^;
	Dispose(p);
end;

function GrafStrArray.Str: string;
begin
	result := PString(Get)^;
end;

function GrafStrArray.UnShift(const vl: string): integer;
begin
	result := Add('', vl, true);
end;

function GrafStrArray.getS(const i: variant): string;
begin
	result := AdrToStr(getV(i));
end;

function GrafStrArray.Index(const v: string): string;
begin
	result := inherited Index(PString(@v));
end;

function GrafStrArray.IndexAll(const v: string): Ars;
begin
	result := inherited IndexAll(PString(@v));
end;

function GrafStrArray.IsVal(const v: string): boolean;
begin
	result := inherited IsVal(PString(@v));
end;

function GrafStrArray.Pop: string;
var p: PString;
begin
	p := PopP;
	result := p^;
	Dispose(p);
end;

function GrafStrArray.Push(const vl: string): integer;
begin
	result := Add('',vl);
end;

function GrafStrArray.rIndex(const v: string): string;
begin
	result := inherited rIndex(PString(@v));
end;

procedure GrafStrArray.setS(const i: variant; const _Value: string);
var p: pointer;
begin
	p := getV(i);
	IF p = nil then begin
		new(PString(p));
		PString(p)^ := _Value;
		setV(i, p);
	end else PString(p)^ := _Value;
end;

{ TableArray }

function GetArrayFilterParam(const ar: Array of const): ArrayFilterParam;
var i, j: integer;
begin
	SetLength(result, Length(ar)div 3);
	IF length(result) > 0 then
	for i:= 0 to high(result) do with result[i] do begin
		j := i * 3;
		FieldIndex := ar[j].VInteger;
		Val := AnsiString(ar[j + 1].VAnsiString);
		param := ar[j + 2].VInteger;
	end; 
end;



function TableArray.AddField(const Name: AnsiString; _Type: FieldType; Size: LongWord): word;
begin
	IF not _fix then begin
		result := Length(_Fields);
		Setlength(_Fields, result + 1);
		_Fields[ result ]._Type := _Type;
		_Fields[ result ].Name := AnsiLowerCase( Name );
		_Fields[ result ].Size := Size;
		inc(result);
	end else result := 0;
end;

procedure TableArray.AddRow(num : integer = 0);
begin
	IF __flt.this = nil then begin
		IF _fixR then wr := true;
		inc(maxStrIndex);
		IF num = 0
			then num := maxStrIndex
			else IF maxStrIndex < num
				then maxStrIndex := num;
		_ps := Length(_Data);
		SetLength(_Data, _ps + 1, Length(_Fields));
		_fix := true;
		SetLength(_DataPos, _ps + 1);
		SetLength(_DataDelete, _ps + 1);
		clearRecords(_ps);
		_DataPos[ _ps ] := num;
	end else __flt.this.AddRow(num);
end;

function TableArray.Assaciative(Fl_Key, Fl_Value: variant): GrafStrArray;
var wK, wV: word;
  i,p : integer;
begin
	result := nil;
	IF Length(_DataPos) = 0 then exit;

	IF not VarIsNumeric(Fl_Key)
		then wK := IndexField(Fl_Key) - 1
		else wK := Fl_Key - 1;
	IF (wK < GetCC{Length(_Fields)})then begin
		IF not VarIsNumeric(Fl_Value)
			then wV := IndexField(Fl_Value) - 1
			else wV := Fl_Value - 1;
		IF wV < GetCC{Length(_Fields)} then begin
			result := GrafStrArray.Create;

			inc(wK);
			inc(wV);

			p := _ps;

			for i := 0 to High(_DataPos) do begin
				_ps := i;
				result[ VarToStrDef(Field[wK],'NULL') ] :=
						VarToStrDef(Field[wV],'NULL');
			end;
			_ps := p;
		end;
	end;
end;

function TableArray.BOF: boolean;
begin
	result := _ps < 0;
end;

procedure TableArray.clearRecords(num: integer);
var i : word;
begin
	IF __flt.this = nil then begin
		IF Length(_Fields)> 0 then begin
			for i := 0 to high(_Fields)do begin
				_Data[num][i].writes := false;
				_Data[num][i].i := 0;
			end;
			_DataPos[num] := num;
			_DataDelete[num] := false;
		end;
	end else __flt.this.clearRecords(_DataPos[num]);
end;

constructor TableArray.Create;
begin
	SetLength(_Fields,0);
	SetLength(_Data,0);
	_ps:= -1;
	_fix := false;
	_fixR := false;
	wr := false;
	__flt.this := nil;
	__flt.fl := null;
	__flt.Value := null;
end;

function TableArray.MoveRecords(RecPosOne, RecPosTwo: integer): boolean;
var
  //dt: ArrayFieldDataType;
  dt : FieldDataType;
  dti : integer;
begin
	result := (RecPosOne > 0)and( RecPosOne <= length(_DataPos))and
		(RecPosTwo > 0)and( RecPosTwo <= length(_DataPos));
	IF result then begin
		dec(RecPosOne);
		dec(RecPosTwo);
		IF __flt.this = nil then
			for dti := 0 to high(_Data[RecPosOne])do begin
				dt := _Data[RecPosOne][dti];
				_Data[RecPosOne][dti] := _Data[RecPosTwo][dti];
				_Data[RecPosTwo][dti] := dt;
			end;
		dti := _DataPos[RecPosOne];
		_DataPos[RecPosOne] := _DataPos[RecPostwo];
		_DataPos[RecPosTwo] := dti;
	end;
end;

function TableArray.InsertCopyRecords(RecPos : integer): boolean;
var
  i : integer;
begin
	result := (RecPos > 0)and( RecPos <= length(_DataPos));
	IF result then begin
		dec(RecPos);
		IF __flt.this = nil then begin
			AddRow;
			for i := 0 to high(_Data[RecPos])do
				_Data[_ps][i] := _Data[RecPos][i];
		end else __flt.this.InsertCopyRecords(_DataPos[RecPos])
	end;

end;

destructor TableArray.Destroy;
var i, j : integer;
begin
	IF (length(_Data) > 0 )and( length(_Fields) > 0) then
		for i := 0 to high(_Data) do
			for j := 0 to high(_Fields) do case _Fields[j]._Type of
				ft_AnsiString: AnsiString(_Data[i][j].s) := '';
				ft_WideString: WideString(_Data[i][j].s) := '';
			end;
	SetLength(_Data,0,0);
	SetLength(_Fields,0);

	inherited;
end;

procedure TableArray.EditField(numFl: word; const Name: AnsiString;
  _Type: FieldType; Size: LongWord);
begin
	IF(not _fix)and( numFl > 0 )and( numFl <= Length(_Fields) )then begin
		dec(numFl);
		_Fields[ numFl ]._Type := _Type;
		_Fields[ numFl ].Name := AnsiLowerCase( Name );
		_Fields[ numFl ].Size := Size;
	end;
end;

function TableArray.Ends: boolean;
begin
	result := EOF or BOF;
end;

function TableArray.EOF: boolean;
begin
	IF _ps = -1 then result := true else
	IF __flt.this = nil
		then result := _ps > high(_Data)
		else result := _ps > high(_DataPos);
end;

function TableArray.FieldGetMaxSym(nm: variant): integer;
var
	w    : word;
	i,ri : integer;
	res  : Int64;
begin
	result := 0;
	IF __flt.this <> nil then result := __flt.this.FieldGetMaxSym(nm)else
	IF Length(_Data) > 0 then begin
		IF not VarIsNumeric(nm)
			then w := IndexField(nm) - 1
			else w := nm - 1;
		IF (w < GetCC) then
			case getFType(w) of
				ft_Pointer: result := 0;
				ft_Date : result := 17;
				ft_Boolean : result := 5;

				ft_Int: for i := 0 to high(_DataPos) do begin
					res:= GetDataF(i,w)^.i;
					ri := 0;
					while res > 0 do begin
						inc(ri);
						res := res div 10;
					end;
					IF ri = 0 then ri := 1;
					IF ri > result then result := ri;
				end;

				ft_Float: for i := 0 to high(_DataPos) do begin
					ri := Length(FloatToStr(GetDataF(i,w)^.f));
					IF ri > result then result := ri;
				end;

				ft_AnsiString : for i:= 0 to high(_DataPos) do begin
					ri := Length(AnsiString(GetDataF(i,w)^.s));
					IF ri > result then result := ri;
				end;
				ft_WideString : for i := 0 to high(_DataPos) do begin
					ri := Length(WideString(GetDataF(i,w)^.s));
					IF ri > result then result := ri;
			end;

		end;
	end;
end;

function TableArray.FieldToStr(nm: variant; minSym:integer = 0; SymSep: AnsiChar = ' '; SepOrientationLeft:boolean = false): AnsiString;
var w:word; p : PFieldDataType;
begin
	IF not Ends then begin
		IF not VarIsNumeric(nm)
			then w := IndexField(nm) - 1
			else w := nm - 1;
		IF (w < getCC) then begin
			p := GetDataF(_ps, w);
			IF p <> nil then
				case getFType(w) of
					ft_Int : result := IntToStr(p^.i);
					ft_Float : result := FloatToStr(p^.f);
					ft_Date : result := DateTimeToStr(p^.d);
					ft_Boolean : result := BoolToStr(p^.b,true);
					ft_AnsiString : result := AnsiString(p^.s);
					ft_WideString : result := WideString(p^.s);
					else result := '';
				end 
			else result := '';
		end else result := '';
	end else result := '';

	IF minSym > 0 then while Length(result) < minSym do begin
		IF SepOrientationLeft
			then result := SymSep + result
			else result := result + symSep;
	end;
end;

function TableArray.Filter(Fl, Value: variant): TableArray;
var 
	wK: word;
	s : AnsiString;
	i,p : integer;
begin
	result := nil;
	IF Length(_DataPos) = 0 then exit;

	IF not VarIsNumeric(Fl)
		then wK := IndexField(Fl) - 1
		else wK := Fl - 1;
	IF (wK < GetCC)then begin
		result := TableArray.Create;
		result.__flt.this := self;
		result.__flt.fl := Fl;
		result.__flt.Value := Value;
		s := Trim(VarToStrDef(Value,'NULL'));
		p := _ps;
		inc(wK);
		_ps := 0;
		while _ps < Length(_DataPos)do begin
			IF Trim(VarToStrDef(Field[wK],'NULL')) = s then begin
				SetLength(result._DataPos, Length(result._DataPos) + 1);
				result._DataPos[ high(result._DataPos) ] := _ps;
			end;
			inc(_ps);
		end;


		_ps := p;

		result.FixedData;
	end;
end;

Function TableArray.FilterMulti(Param : ArrayFilterParam ): TableArray;
var
	i, p : integer;
	b    : boolean;
	s    : AnsiString;
begin
	result := nil;
	IF Length(_DataPos) = 0 then exit;

	p := GetCC;
	i := 0;
	while i < Length(Param) do begin
		//dec(Param[i].FieldIndex);
		Param[i].val := Trim(Param[i].val);
		IF Param[i].param and Flt_IgnorRegister <> 0 then
			Param[i].val := AnsiLowerCase(Param[i].val);
		IF Param[i].FieldIndex >= p then begin
			Param[i] := Param[ high(Param) ];
			SetLength(Param, High(Param));
		end else inc(i);
	end;

	IF (Length(Param) > 0)then begin
		result := TableArray.Create;
		result.__flt.this := self;
		result.__flt.fl := 'Multi';
		result.__flt.Value := 'Multi';
		p := _ps;
		_ps := 0;
		while _ps < Length(_DataPos)do begin
			b := true;
			for i := 0 to High(Param) do begin
				s := Trim(VarToStrDef(Field[ Param[i].FieldIndex ],'NULL'));
				IF Param[i].param and Flt_IgnorRegister <> 0 then
					s := AnsiLowerCase(s);
				case Param[i].param and $7f of
					1 : b := b and (s <> Param[i].val);
					2 : b := b and (Pos(Param[i].val, s) > 0);
					3 : b := b and (Pos(Param[i].val, s) = 0);
					else b := b and (s = Param[i].val);
				end;
			end;
			IF b then begin
				SetLength(result._DataPos, Length(result._DataPos) + 1);
				result._DataPos[ high(result._DataPos) ] := _ps;
			end;
			inc(_ps);
		end;


		_ps := p;

		result.FixedData;
	end;

end;

Function TableArray.IsDelete( num : Integer = -1): boolean;
begin
	IF num = -1 then num := _ps else dec(num);
	IF(num >= 0) and (num <= high(_DataPos)) then begin
		IF __flt.this <> nil
			then result := __flt.this.IsDelete( _DataPos[num] + 1 )
			else result := _DataDelete[num];
	end else result := true;
end;

Procedure TableArray.Delete( del : boolean = true; num : Integer = -1);
begin
	IF num = -1 then num := _ps else dec(num);
	IF(num >= 0) and (num < Length(_DataPos)) then begin
		IF __flt.this <> nil
			then __flt.this.Delete(del, _DataPos[num] + 1 )
			else begin
				_DataDelete[num] := del;
				IF _fixR then setModif;
			end;
	end;
end;

procedure TableArray.First;
begin
	IF Length(_DataPos) > 0
		then _ps := 0
		else _ps := -1;
end;

procedure TableArray.FixedData;
begin
	_fix := true;
	_fixR := true;
end;

procedure TableArray.NumericReAll;
var i: integer;
begin
	IF __flt.this <> nil
		then __flt.this.NumericReAll
		else IF length(_DataPos) > 0 then begin
			for i := 0 to high(_DataPos) do
				_DataPos[i] := i + 1;
			maxStrIndex := Length(_DataPos);
			setModif;
	end;
end;

function TableArray.getCC: word;
begin
	IF __flt.this = nil
		then result := length(_Fields)
		else result := __flt.this.getCC;
end;

function TableArray.getCR: LongWord;
begin
	IF __flt.this = nil
		then result := Length(_Data)
		else result := Length(_DataPos);
end;

function TableArray.getF(nm: variant): variant;
var w:word;
begin
	IF not Ends then begin
		IF not VarIsNumeric(nm)
			then w := IndexField(nm) - 1
			else w := nm - 1;
		IF (w < GetCC) then
			case getFType(w) of
				ft_Int : result := GetDataF(_ps,w)^.i;
				ft_Float : result := GetDataF(_ps,w)^.f;
				ft_Date : result := GetDataF(_ps,w)^.d;
				ft_Boolean : result := GetDataF(_ps,w)^.b;
				ft_AnsiString : result := AnsiString(GetDataF(_ps,w)^.s);
				ft_WideString : result := WideString(GetDataF(_ps,w)^.s);
				else result := null;
			end 
		else result := null;
	end else result := null;

end;

function TableArray.GetField(nm: variant): FieldRec;
var w: word;
begin
	IF __flt.this = nil then begin
		IF not VarIsNumeric(nm)
			then w := IndexField(nm)
			else w := nm - 1;
		IF (w < Length(_Fields))
			then result := _Fields[w]
			else begin
				result._Type := ft_Int;
				result.Name := '';
				result.Size := 0;
			end;
	end else result:= __flt.this.GetField(nm);
end;

function TableArray.GetNumRecord: integer;
var p:integer;
begin
	IF __flt.this = nil then begin
		IF ends
			then result := 0
			else result := _DataPos[ _ps ];
	end else begin
		p := __flt.this._ps;
		__flt.this._ps := _DataPos[ _ps ];
		result:= __flt.this.GetNumRecord;
		__flt.this._ps := p;
	end;
end;

function TableArray.getPS: LongInt;
begin
	result := _ps + 1;
end;

function TableArray.IndexField(const Name: AnsiString): word;
var i : word; s : AnsiString;
begin
	IF __flt.this = nil then begin
		result := 0;
		IF Length(_Fields) > 0 then begin
			s := AnsiLowerCase(Name);
			For i := 0 to High(_Fields) do
				IF _Fields[i].Name = s then begin
					result := i + 1;
					exit;
				end;
		end;
	end else result := __flt.this.IndexField(Name);

end;

function TableArray.IsWriteField(nm: variant): boolean;
var w: word;
begin
	IF __flt.this = nil then begin
		IF not Ends then begin
			IF not VarIsNumeric(nm)
				then w := IndexField(nm)
				else w := nm - 1;
			IF (w < Length(_Fields))
				then result := _Data[ _ps ][ w ].writes
				else result := false;
		end else result:= false;
	end else result:= __flt.this.IsWriteField(nm);
end;

procedure TableArray.Last;
begin
	IF __flt.this = nil then begin
	IF Length(_Data) > 0
		then _ps := high(_Data)
		else _ps := -1;
	end else IF Length(_DataPos) > 0
		then _ps := high(_DataPos)
		else _ps := -1;
end;

function TableArray.NameField(index: word): AnsiString;
begin
	IF __flt.this = nil then begin
		IF(Index > 0)and( index <= Length(_Fields))
			then result := _Fields[Index - 1 ].Name
			else result := '';
	end else result := __flt.this.NameField(index);
end;

procedure TableArray.Next;
begin
	Inc(_ps);
end;

procedure TableArray.Prior;
begin
	Dec(_ps);
end;

procedure TableArray.setCC(const Value: word);
begin
	IF __flt.this <> nil
		then __flt.this.setCC(Value)
		else IF not _fix then
			SetLength(_Fields, Value);
end;

procedure TableArray.setCR(const Value: LongWord);
begin
	IF not _fixR then
		SetLength(_Data, value, Length(_Fields));
end;

procedure TableArray.setF(nm: variant; const Value: variant);
var w : word; p: PFieldDataType;
begin
	IF not ends then begin
		IF not VarIsNumeric(nm)
			then w := IndexField(nm) - 1
			else w := nm - 1;
		IF (w < GetCC) then begin
			p:= GetDataF(_ps, w);
			IF _fixR then begin
				p^.writes := true;
				setModif;
			end;
			case getFType(w) of
				ft_Int   : p^.i := StrToIntDef(VarToStrDef(Value,'0'),0);
				ft_Float : p^.f := StrToFloatDef(VarToStrDef(Value,'0'),0);
				ft_Date  : p^.d := StrToDateTimeDef(VarToStrDef(Value,'01.01.2000'),Date + Time);
				ft_Boolean : p^.b := VarIsType(Value, varBoolean ) and ( Value = true );
				ft_AnsiString : AnsiString(p^.s) := Trim(VarToStrDef(Value,''));
				ft_WideString : WideString(p^.s) := Trim(VarToStrDef(Value,''));
			end;
		end;
	end;
end;

procedure TableArray.SetPS(const Value: LongInt);
begin
	_ps := Value - 1;
end;

function TableArray.GetDataF(ps, w :integer): PFieldDataType;
begin
	IF __flt.this = nil
		then result := @_Data[ps][w]
		else result := __flt.this.GetDataF(_DataPos[_ps], w);
end;

procedure TableArray.setModif;
begin
	IF __flt.this = nil
		then wr := true
		else __flt.this.setModif;
end;

function TableArray.GetModif:boolean;
begin
	IF __flt.this = nil
		then result := wr
		else result := __flt.this.GetModif;
end;

function TableArray.getFType(w : word): FieldType;
begin
	IF __flt.this = nil
		then result := _Fields[w]._Type
		else result := __flt.this.getFType(w);
end;

procedure TableArray.SortByField(const Fl: AnsiString; MinToMax: boolean = false; Func: TableSortInformation = nil);
var ar        : Ars;
    arI, arSz : ArInt;

	function GetStrFields(num:integer):AnsiString;
	var
		i : word;
		p : integer;
	begin
		Result := '';
		_ps := num;
		for i := 0 to high(arI) do
			Result := Result + FieldToStr(arI[i], arSz[i] );
	end;

var i,j: integer;
	procedure Mov_(ifs:boolean);
	var s : AnsiString;
	begin
		IF ifs then begin
			MoveRecords(i + 1, j + 1);
			s := ar[i];
			ar[i] := ar[j];
			ar[j] := s;
		end;
	end;

begin
	IF Length(_DataPos) > 1 then begin
		SetLength(arI,0);
		ar := Split(fl,';');
		for i:= 0 to high(ar) do begin
			AppendArInt(arI, IndexField(ar[i]));
			ar[i] := '';
		end;

		SetLength(arSz, Length(arI));
		for i := 0 to Length(arI)do
			arSz[i] := FieldGetMaxSym(arI[i]);


		SetLength(ar,Length(_DataPos));
		j := _ps;
		for i := 0 to high(_DataPos) do
			ar[i] := GetStrFields(i);
		_ps := j;

		for i:= 0 to high(ar) do
			for j:= 0 to high(ar) do begin
				IF Assigned(Func) then Func(i);
				IF(i <> j)then begin
					IF MinToMax
						then Mov_(ar[i] < ar[j])
						else Mov_(ar[i] > ar[j]);
				end;
			end;
	end;
end;

initialization
	{$IFDEF FPC}
	toStr := @varTostr;
	{$ELSE}
	@toStr := @varTostr;
	{$ENDIF}
end.
