<?php
SYS::$_CONFIG = [
	'path' => [
		'template' => 'templates',    // каталог шаблонов
		'cache' => 'templates/cache', // каталог кеша шаблонов
		'init' => 'libs',             // каталог в котором находятся скрипты конфигурирования системы
		'loads' => [                  // массив каталогов, из которых следует вести подгрузку классов в систему
			'libs',                   //   основной каталог модулей системы и ее настроек
			'libs/core',              //   каталог ядра фреймворка, с базовыми модулями системы
			'controllers',            //   каталог для контроллеров
			'models'                  //   каталог для моделей данных
		],
		'fileControllers' => 'controllers/files/' // каталог, где находятся безклассовые контроллеры
	],
	'session' => [
		'name' => 'USERID',
		'timeout' => 0
	],

	'DB' => [
		'use' => 'postgresql',

		'postgresql' => [
			'host' => 'localhost',
			'password' => 'pass',
			'basename' => 'database_name',
			'user' => 'user',
			'port' => '5432',
		],

		'mysql' => [
			'host' => 'localhost',
			'user' => 'user',
			'password' => 'pass',
			'basename' => 'database_name',
			'port' => 3306
		]

	],

	'admin' => [
		'login' => '*user*',
		'key' => '*uniq_key*'
	],

	'modules' =>[ // принудительная загрузка модулей
	],

	'debug' => true
];