<?php
// last edit: 22.06.2018
/*
	Класс является базовым для создания меню.
	После наследования доствточно необходимо реализовать виртуальный метод "initMenu([$args])", 
	который должен вернуть массив <submenu_params> (описанние смотрите в MenuItem)
	Так же все, что будет передано в конструктор вашего класса будет переданно в этот же метод.
*/
class BaseMenu implements IteratorAggregate {
	/**
	* Объект меню, защищенный от прямого изменения.
	*/
	private $menu;

	/**
	* Наименование активного пункта меню (его ID)
	*/
	public $active = '';

	function __construct(...$args){
		$this->menu = (new MenuItem('menu_tree_ups',''));
		if(method_exists($this, 'initMenu'))
			$this->menu->SubMenu($this->initMenu(...$args));
	}

	function __toString(){
		return ''.count($this->menu);
	}

	/**
	* Возвращает объект меню
	*
	* @return object(MenuItem)
	*/
	function getMenu(){
		return $this->menu;
	}

	/**
	* Проверяет, является ли пункт меню активным
	*
	* @param object(MenuItem) $menuItem
	* @return bool
	*/
	function isActive($menuItem){
		return $menuItem->isId($this->active);
	}

	/**
	* Реализация интерфейса итератора
	*/
	function getIterator(){
		return $this->menu;
	}

	/**
	* Добавление пункта меню
	*
	* @param object(MenuItem) $menuItem
	* @return $this
	*/
	function addMenu($menuItem){
		$this->menu->addSubMenuItem($menuItem);
		return $this;
	}

	/**
	* Удаление муню, по его ID
	*
	* @param string $id
	*/
	function deleteMenu($id){
		$this->menu->deleteId($id);
	}

	/**
	* Добавление текста в конец наименования пункта меню по его ID
	*
	* @param string $id
	* @param string $text
	*/
	function appendNameForId($id, $text){
		$this->menu->appendForId($id, $text);
	}

	/**
	* Создание пункта меню
	*
	* @param string $id
	* @param string $name || array [<icon_string>, <name>]
	* @param string $url
	*/
	function add($id, $name, $url = false){
		$this->menu->createSubMenuItem($id, $name, $url);
		return $this;	
	}

	/**
	* Добавление структуры меню
	*
	* @param array $menuItems   - <submenu_params>
	* @return $this
	*/
	function addMenus($menuItems){
		$this->menu->SubMenu($menuItem);
		return $this;
	}

	/**
	* Проверяет, является ли пункт меню последний
	*
	* @param object(MenuItem) $menuItem
	*/
	function isEnd($menuItem){
		return $this->menu->isEnd($menuItem);
	}
}