<?php
class ItemPanelMenu {
	public $id, $name, $url, $img;

	function __construct($id, $name, $url = false, $img = false){
		$this->id = $id;
		$this->name = $name;
		$this->url = $url;
		$this->img = $img;
	}
}

class GroupPenelItems{
	public $menu = [], $visible = true, $id;

	function __construct($id){
		$this->id = $id;
	}

	function add($id,$name,$url = false,$img = false){
		$this->menu[] = new ItemPanelMenu($id,$name,$url,$img);
		return $this;
	}

	function addRow($arr){
		$obj = new ItemPanelMenu(null,null);
		foreach($arr as $key=>$value){
			if(is_numeric($key)){
				if(!isset($obj->id))
					$obj->id = $value;
				elseif(!isset($obj->name))
					$obj->name = $value;
				elseif(!isset($obj->url))
					$obj->url = $value;
				elseif(!isset($obj->img))
					$obj->img = $value;
			}else $obj->$key = $value;
		}

		$this->menu[] = $obj;
		return $this;
	}

	function find($id){
		foreach ($this->menu as $menu) 
			if($menu->id == $id)
				return $menu;
		return false;
	}
}


class BasePanelMenu {
	public $groups = [];

	function __construct(...$args){
		if(method_exists($this, 'init'))
			$this->add($this->init(...$args));
	}

	function add($arr){
		foreach ($arr as $value) 
			if(is_array($value)){
				$group = $this->lastGroup();
				if(!$group)
					$group = $this->addGroup('gr'.uniqid(''))->lastGroup();
				$group->addRow($value);
			}elseif(is_bool($value)){
				$group = $this->lastGroup();
				if(!$group)
					$group = $this->addGroup('gr'.uniqid(''))->lastGroup();
				$group->visible = $value;
			}else $this->addGroup($value);
		return $this;
	}

	function addGroup($id){
		$this->groups[] = new GroupPenelItems($id);
		return $this;
	}

	function lastGroup(){
		if(count($this->groups) == 0)
			return false;
		return $this->groups[count($this->groups)-1];
	}

	function findGroup($id){
		foreach ($this->groups as $group) 
			if($group->id == $id)
				return $group;
		return false;
	}

	function find($id){
		foreach($this->groups as $group){
			$temp = $group->find($id);
			if($temp)
				return $temp;
		}
		return false;
	}

}