<?php
// last edit: 01.04.2018

/*
	Класс хлебных крошек.
*/

class BreadCrumbs{
	/**
	* Шаблоны для формирования строки хлебных крошек
	*/
	static $TemplateA = '<a class={CSS} href="{URL}">{NAME}</a>';
	static $TemplateNoA = '<span>{NAME}</span>';
	static $CSSClass = 'bread-crumbs';
	static $delimiter = ' / ';

	/**
	* так как объект класса является singleton, храним единственный экземпляр в самом себе
	*/
	private static $single = null;

	/**
	* Массив ссылок
	*/
	private $crumbs = [];

	/**
	* возвращает свой экземплят
	* @return object(BreadCrumbs)
	*/
	static function get(){
		if(isset(self::$single))
			return self::$single;
		$obj = new BreadCrumbs();
		self::$single = $obj;
		return $obj;
	}

	/**
	* Добавляет в последовательность наименование закрепленную на нем ссылку
	*
	* @param string $name - выводимое на страницу имя
	* @param string $url - закрепленная за ним ссылка
	* @return $this
	*/
	function add($name, $url = null){
		$this->crumbs[] = [$name, $url];
		return $this;
	}

	/**
	* Позволяет изменить ссылку последней добавленной крошки в последовательности
	*
	* @param string $url - ссылка закрепленная под последним наименованием
	*/
	function setLastUrl($url){
		$this->crumbs[count($this->crumbs)-1][1] = $url;
		return $this;
	}

	function __toString(){
		$res = [];
		foreach($this->crumbs as $crumb)
			if($crumb[1])
				$res[] = str_replace(['{CSS}', '{URL}', '{NAME}'], [
					self::$CSSClass,
					$crumb[1],
					$crumb[0]
				], self::$TemplateA);
			else 
				$res[] = str_replace(['{CSS}', '{NAME}'], [
					self::$CSSClass,
					$crumb[0]
				], self::$TemplateNoA);
		return implode(self::$delimiter, $res);
	}

}