<?php
// last edit: 12.08.2018

/*
	Класс предназначен для работы с переданными в PHP данными.
	Класс еще не реализован в полной мере, и в данный момент имеет только базовый функционал.
*/

class Request{
	/**
	* Проверяем наличие переданного поля при запросе
	*
	* @param string $name - наименование поля, наличие которой необходимо проверить
	* @return bool
	*/
	static function has($name){
		return isset($_REQUEST[$name]);
	}


	/**
	* Возвращает значение из полученных полей при запросе
	*
	* @param string $name - наименнование поля, данные которой необходимо получить
	* @param mixed $def - значение по умолчанию, если переменная не существует
	* @return mixed
	*/
	static function input($name,$def = null){
		$val = $_REQUEST[$name] ?? $def;

		if(is_null($val))
			return null;

		if(is_numeric($val))
			return +$val;

		$lowVal = strtolower($val);
		if(in_array($lowVal, ['true','t','yes','on']))
			return true;

		if(in_array($lowVal, ['false','f','no','off']))
			return false;

		if(in_array($lowVal, ['null','nil']))
			return null;

		return $val;
	}


	/**
	* Проверяет был ли передан файл по указанному имени поля, и был ли он корректен
	*
	* @param string $name - наименование поля
	*/
	static function hasFile($name){
		return isset($_FILES[$name]) && is_uploaded_file($_FILES[$name]['tmp_name']);
	}

	/**
	* Перемещает загруженный файл по указанному имени поля, в указанное место на ЖД
	*
	* @param string $name   - наименование поля
	* @param string $toPath - путь, по которому следует сохранить файл на сервере
	* @return bool
	*/
	static function moveFile($name,$toPath){
		return move_uploaded_file($_FILES[$name]['tmp_name'], $toPath);
	}

	/**
	* Возвращает информацию о файле, по имени поля
	*
	* @param string $name - наименование поля
	* @param string key   - тип информации, который необходимо извлеч (может быть: 'ext', 'name', 'type', 'tmp_name', 'error', 'size')
	* @return string
	*/
	static function infoFile($name,$key){
		return $key=='ext' ? pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION) : ($key == 'name' ? basename($_FILES[$name]['name']) : $_FILES[$name][$key]);
	}
}