<?php
// last edit: 30.03.2018

/*
	Вспомогательный Класс, для формирования списка подключаемых ресурсов на страницу
*/
class ResourseForHeader {
	/**
	* так как объект класса является singleton, храним единственный экземпляр в самом себе
	*/
	private static $single = null; 

	/**
	* базовый путь к Css-файлам
	*/
	static $baseCss = '/res/css/';

	/**
	* базовый путь к JS-файлам
	*/
	static $baseJs = '/res/js/';

	/**
	* возвращает свой экземплят
	* @return object(ResourseForHeader)
	*/
	static function get(){
		if(isset(self::$single))
			return self::$single;
		$obj = new ResourseForHeader();
		self::$single = $obj;
		return $obj;
	}

	private $css = [], $js = [];

	/**
	* Добавляет css-файл в набор
	* @param string $url - имя файла в каталоге Css-файлов
	*/
	function css($url){
		$this->css[] = $url;
		return $this;
	}

	/**
	* Добавляет js-файл в набор
	* @param string $url - имя файла в каталоге js-файлов
	*/
	function js($url){
		$this->js[] = $url;
		return $this;
	}

	/**
	* для простого вывода списков CSS и JS файлов в шаблоне, используя только имя переменной
	*/
	function __toString(){
		$res = [];
		foreach ($this->css as $url) 
			$res[] = "<link href='".self::$baseCss.$url."' rel='stylesheet'>";

		foreach ($this->js as $url) 
			$res[] = "<script src='".self::$baseJs.$url."'></script>";

		return implode("\n\t", $res);
	}
}