<?php
// last edit: 23.03.2018

class Timer{ // класс для замера затраченного времени на какое-либо действие
	
	static $timeTest = 0; // общая переменная для глобального замера времени

	/**
	* Обнуляет глобальный таймер, делая текущее время точкой отсчета
	*/
	static function start_timer(){
		self::$timeTest = microtime(true);
	}

	/**
	* Показывает сколько времени прошло от точки отсчета глобального таймера, и устанавливает новую по текущему времени
	* @return string
	*/
	static function next_timer(){
		$time = microtime(true);
		$result = $time - self::$timeTest;
		self::$timeTest = microtime(true);
		return sprintf('%0.8f',$result);
	}

	/**
	* Показывает сколько времени прошло от точки отсчета глобального таймера
	* @return string
	*/
	static function get(){
		return sprintf('%0.8f',microtime(true) - self::$timeTest);
	}

	private $tm = 0; // переменная для замера времени, храниться в экземпляре таймера
	function __construct(){ // создает независимый таймер и в тот же момент делает текущее время точкой отсчета
		$this->tm = microtime(true);
	}

	/**
	* Обнуляет таймер, устанавливая текущее время как точку отсчета
	*/
	function start(){
		$this->tm = microtime(true);
	}

	/**
	* Показывает сколько времени прошло от точки отсчета таймера, и устанавливает новую по текущему времени
	* @return string
	*/
	function next(){
		$time = microtime(true);
		$result = $time - $this->tm;
		$this->tm = microtime(true);
		return sprintf('%0.8f', $result);
	}

	/**
	* Показывает сколько времени прошло от точки отсчета таймера
	* @return string
	*/
	function __toString(){
		return sprintf('%0.8f', microtime(true) - $this->tm);	
	}
}