<?php
/*
	last edit: 12.12.2018

	static::$field_delete       - из наследуемой модели, поле которое сохраняет время удаления.
	static::$field_delete_value - из наследуемой модели, какое значение вставляется в поле при удалении
	
	static::$field_sessionID   - наименование поля, которое хранит ID сессии, по нему определяется был ли пользователь авторизован

	static::$field_login       - поле в котором хранится логин
	static::$field_password    - поле в котором хранится пароль

*/
class BaseUser extends ModelNoDelete{
	static $thisUser;        // текущий пользователь
	static $is_login = null; // хранит флаг статуса, авторизован ли пользователь

	static $field_login = 'login';
	static $field_password = 'password';
	static $field_sessionID = 'sid';

	static function auto_login(){
		$res = static::one([static::$field_sessionID => session_id()]);
		if( !$res->isNew() ){
			$res->set(static::$field_sessionID, session_id());
			$res->save();
			static::$thisUser = $res;
			static::$is_login = true;
		}else static::$is_login = false;
	}

	static function oneById($id){
		if(static::$is_login && static::$thisUser->id == $id)
			return static::$thisUser;
		return parent::oneById($id);
	}

	static function oneByLogin($login){
		if(static::$is_login && static::$thisUser->{static::$field_login} == $login)
			return static::$thisUser;
		return static::one([static::$field_login=>$login]);
	}


	static function isLogin(){
		if(is_null(static::$is_login))
			static::auto_login();
		return static::$is_login;
	}

	static function login($login, $password){
		switch(SYS::$_CONFIG['DB']['use']){
			case 'mysql':
				$res = static::one([static::$field_login => $login, static::$field_delete => null]); 
				break;
				
			case 'postgresql':
				$res = static::one([[static::$field_login, 'ILIKE', $login], static::$field_delete  => null]); 
				break;

			default:
				$res = new static;
				break;
		}
		if(!$res->isNew() && password_verify($password, $res->{static::$field_password}))
			$res->as_login();
		else static::$is_login = false;

		return static::$is_login;
	}

	static function logout(){
		if(static::$is_login){
			static::$thisUser->logout;
			//static::$thisUser = null;
			static::$is_login = false;
		}
	}

	function as_login(){
		$this->set(static::$field_sessionID, session_id());
		$this->save();
		static::$thisUser = $this;
		static::$is_login = true;
	}

	function get_logout(){
		$this->set(static::$field_sessionID, '');
		return $this->save();
	}

	function set_password($value){
		$this->set(static::$field_password, password_hash($value, PASSWORD_DEFAULT));
	}
}