<?php
/*
	last edit: 12.12.2018

	static::$field_flags    - текстовое поле флагов
	static::$delimiter_flag - символ-разделитель флагов
*/

trait FlagsTrait{
	static $field_flags = 'flags';
	static $delimiter_flag = ' ';

	private $ar_flags = [];

	function initFlags(){
		if(!$this->isNew())
			$this->ar_flags = explode(static::$delimiter_flag, $this->{static::$field_flags});
	}

	function isFlag($name){
		if($this->{static::$field_flags} == 'ALL')
			return true;

		return in_array($name, $this->ar_flags);
	}

	function addFlag($name){
		$this->ar_flags[] = $name;
		$this->{static::$field_flags} = implode(static::$delimiter_flag, $this->ar_flags);
		return $this;
	}

	function removeFlag($name){
		$this->ar_flags = array_filter($this->ar_flags,function($val)use($name){ return $val != $name; });
		$this->{static::$field_flags} = implode(static::$delimiter_flag, $this->ar_flags);
		return $this;
	}
}