'use strict';

var price_sizes = {
	'10x15': {false:7.50,true:15},
	'15x21': {false:35,true:45},
	'21x30': {false:55,true:70},
	'30x40': {false:150,true:170}
};

function set_type_calc(key_size, key_select, key_speed){
	localStorage['key_size'] = key_size;
	localStorage['key_select'] = key_select;
	localStorage['key_speed'] = key_speed;
}

function calc_sum(){
	let key_size = $('#leftsizes [name=sizefoto]:checked').val(),
		key_select = $('#paper').val(),
		key_speed = $('[name=speed]')[0].checked ,
		one_foto = price_sizes[key_size]/*[key_select]*/[key_speed],
		count = 0;

	set_type_calc(key_size, key_select, key_speed ? 1 : 0);
	localStorage['key_brd'] = $('.fotobrd [name=fotoborder]:checked').val();

	var arImgs = [];

	$('.fotobrd .days').html( key_speed ? 'в течении <span>дня</span>' : '<span>2</span> рабочих дня');

	$('.fotobrd .print-day')[key_speed ? 'hide' : 'show']();

	$('.-sumadd input[type=number]').each(function(i){
		count += +this.value;
		arImgs[i] = this.value + ';';
	});

	$('.-sumadd input[type=hidden]').each(function(i){
		arImgs[i] += this.value;
	});
	localStorage['images'] = arImgs.join('|');

	if(key_size == '10x15' && key_speed && count > 10)
		one_foto = 12;

	$('.line-price .money span').html(one_foto);

	$('#countfoto').html(count);
	$('#typepaper').html($('#paper :selected').html());


	let sum = one_foto * count;
	$('.line-price .sum span').html( sum ? sum + ' руб.' : '' );
	$('.line-price .sum input')[0].disabled = sum == 0;
}

function load_sum(){
	if(localStorage['key_size'])
		$('#leftsizes [name=sizefoto][value='+localStorage['key_size']+']').click();
	if(localStorage['key_brd'])
		$('.fotobrd [name=fotoborder][value='+localStorage['key_brd']+']').click();
	if(localStorage['key_speed'])
		$('[name=speed]')[0].checked = localStorage['key_speed'] == 1;
	if(localStorage['key_select'])
		$('#paper').val(localStorage['key_select']);
	if(localStorage['images']){
		localStorage['images'].split('|').forEach(function(i){
			let data = i.split(';');
			addFotoFromDiv(data[1], data[0]);
		});
	}
};

function clearStorage(){
	localStorage.removeItem('key_size');
	localStorage.removeItem('key_brd');
	localStorage.removeItem('key_speed');
	localStorage.removeItem('key_select');
	localStorage.removeItem('images');
}


function openDlg(){
	$('.-full,.dialog.-one').removeClass('hide');
	$('#fotos_upload').html('');
}

function lupa(num){
	$('.-full,.dialog.-two').removeClass('hide');
	$('.dialog.-two img')[0].src = $('#fi_'+num+' img')[0].src;
}

function closeDlg(){
	$('.-full,.dialog').addClass('hide');
}

function addFotoFromDiv(path, ct){
	let fotos = $('#uploaded-images'),
		last = $('.-sumadd:last',fotos),
		num = last.length ? +last[0].id.substr(3) + 1 : 1;

	fotos.append(
		'<div id=fi_'+num+' class=-sumadd><div class=img><img src="' + path + 
		'"></div><input type=hidden name="foto[path][]" value="' + path +
		'">Количество: <input type=number name="foto[count][]" value="'+ct+'" min=1 onchange="calc_sum()">' +
		'<i class="fa fa-search" aria-hidden="true" onclick="lupa('+num+
		')"></i> <i class="fa fa-trash-o -delete-foto" aria-hidden="true" onclick="delFoto('+num+')"></i></div>'
	);
}

function closeDlgOK(){
	$('#fotos_upload div').each(function(){
		let path = $('input',this).val();
		addFotoFromDiv(path, 1);
	});

	closeDlg();
	calc_sum();
}


var NumLastFoto = 0;
function loadFotosAdd(req, data, name){
	NumLastFoto++;
	let num = NumLastFoto,
		dt = req.split(';'),
		size = dt[1];

	$('#pr'+name).remove();

	if(size < 2048)
		size += ' byte';
	else if( size < 2048 * 1024)
		size = (size / 1024).toFixed(1) + ' kb';
	else if( size < 2048 * 1024 * 1024)
		size = (size / (1024 * 1024)).toFixed(1) + ' mb';
	else 
		size = (size / (1024 * 1024 * 1024)).toFixed(1) + ' gb';

	$('#fotos_upload').append(
		'<div id=foto_'+num+
			' class=foto-add><img src="'+dt[0]+'"><input type=hidden value="'+dt[0]+'"><br>'+ size
			+'<i class="fa fa-trash-o" aria-hidden="true" onclick="delFotoLoad('+num+')"></i></div>'
		);
}

function loadFotosProgress(name, prc, loaded, total){
	let progress = $('#pr'+name);
	if(progress.length == 0)
		$('#fotos_upload').append(
			'<div id=pr'+name+' class=progress>' +
			'<div class=progress-pos><div style="width:'+(prc*100)+'px"></div></div>'+
			'<br><span>'+(prc*100).toFixed(1)+' %</span></div>'
		);
	else {
		$('span', progress).html((prc*100).toFixed(1)+' %');
		$('.progress-pos div', progress)[0].style.width = (prc*100)+'px';
	}
}

function delFotoLoad(num){
	let fotoDiv = $('#fotos_upload #foto_'+num),
		path = $('input', fotoDiv).val();

	dropImg(path, true);
	fotoDiv.remove();
}

function delFoto(num){
	let fotoDiv = $('#fi_'+num),
		path = $('input[type=hidden]',fotoDiv).val();
	dropImg(path, true);
	fotoDiv.remove();

	calc_sum();
}



$(function(){
	if($('#leftsizes').length){
		load_sum();
		calc_sum();
		$('form input,form select').change(calc_sum);
	}
});



