'use strict';

var OPTIONS_UPLOAD;

function uploadsSettings(options){
	/*
		idLoadInput: string
		idImg: string
		idDrop: string
		urlDrop: string
		urlLoadImg: string
		defaultImg: string
		hash: string
		load: function(req,data)
		progress: function(name, prc, loaded, total)
		drop: function(req,data)
		getData: function([dop])

	*/
	OPTIONS_UPLOAD = options;

	$(function(){
		let func = function(file, reader, i){
			//if(i==0){
				//$('body').append('<div id=blockdisplay></div>') );
				$$.FileUploader({
					file: file,
					reader: reader,
					path: '/sites/all/modules/fotos_price/uploadfile.php',
					uploadid: options.hash + i,
					portion: 1024*1024*512, // 512 Mb
					upload: function(prc, loaded, total){
						if(options.progress)
							options.progress(options.hash + i, prc, loaded, total);
						//$('#load').css({width: (300 * prc)+'px'}).html((prc*100).toFixed(1)+'%');
					},
					end: function(file){
						//$('#blockdisplay').remove();
						var data = {fname: file.name};
						if(options.getData)
							$$.include(data,options.getData());
						$$.post(options.urlLoadImg,data,function(req){
							let dt = $$.clone(data);
							if(options.load)
								options.load(req.trim(), data, options.hash + i);
						});
					}
				});
			//}
		};
		
		$$.event.ifile(func);
		$$.drop($(OPTIONS_UPLOAD.idDrop)[0],func);
	});
}


function loadImg(){
	$(OPTIONS_UPLOAD.idLoadInput).click();
}

function dropImg(imgname, isNoFunc){
	var data = {name:imgname, action:'drop'};
	if(OPTIONS_UPLOAD.getData)
		$$.include(data,OPTIONS_UPLOAD.getData(dop));
	$.post(OPTIONS_UPLOAD.urlDrop, data, function(req){
		if(OPTIONS_UPLOAD.drop && !isNoFunc)
			OPTIONS_UPLOAD.drop(req, data);
	});
}