Module.create :M_Agrigates do
	modules :M_Base_Initialize
	methods :variables => %q{
		FILE_NAME = 'Конфигурация агригатов'
		FIX_HASH_COMPARE = {'<' => 'l', '>' => 'g', '=' => 'e', '>=' => 'le', '<=' => 'ge', '!=' => 'ne', '<>' => 'ne', '==' => 'e', '=>' => 'le'}
		FIX_HASH_AGRIGATE = {'&&' => 'AND', '||' => 'OR', '!&&' => 'NOTAND', '!||' => 'NOTOR', 'or' => 'OR', 'and' => 'AND', 'notor' => 'NOTOR', 'notand' => 'NOTAND'}
		@agrs = nil
		@agrid_group = {}
		@init = nil
	},
		:class_Comparator => %q{
		
		class Comparator
			def self.edit agrid, id, type, value, newagrid = nil, newid = nil
				@@all ||= {}
				
				full = "#{newagrid}$#{id}"
				
				if @@all.key? full
					cmp = @@all[full] 
					cmp.param type, value
					if !newagrid.nil? && !newid.nil?
						cmp.full_id "#{newagrid}$#{newid}"
					elsif !newagrid.nil?
						cmp.contact newagrid
					elsif !newid.nil?
						cmp.id newid
					end
					cmp
				else
					Comparator.new( newagrid ? newagrid : agrid, newid ? newid : id, type, value )
				end
			end
			
			def self.[] id
				@@all ||= {}
				@@all[id] if @@all.key? id 
			end
			
			def self.clean
				@@all ||= {}
				@@all.delete_if do |key,obj| 
					unless Agrigate[ obj.contact ] 
						obj.done
						true
					end
				end
			end
			
			def self.delete id
				@@all ||= {}
				@@all.delete id
			end
			
			def self.find_all agrid
				@@all ||= {}
				@@all.select{|id,obj| obj.contact == agrid}
			end
			
			def uniq_id agrid
				all = Comparator.find_all(agrid).map{|id,obj| obj.id.to_i}
				start = 1
				start += 1 while all.include start
				start
			end
			
			def initialize agrid, id = "", type = 'e', value = 0
				
				@id = id.empty? ? "#{agrid}$#{uniq_id}" : "#{agrid}$#{id}"
				param type, value
				
				@@all ||= {}
				@@all[@id] = self
				
				init
			end
			
			def contact newAgrId = nil
				if newAgrId
					@@all.delete @id
					@id = "#{newAgrId}$#{id}"
					@@all[@id] = self
					self
				else
					@id[/[^$]+/]
				end
			end
			
			def id newId = nil
				if newId
					@@all.delete @id
					done
					@id = "#{contact}$#{newId}"
					@@all[@id] = self
					init
					self
				else
					@id[/[^$]+&/]
				end
			end
			
			def full_id newId = nil
				if newId
					@@all.delete @id
					done
					@id = newId
					@@all[@id] = self
					init
					self
				else
					@id
				end
			end
			
			def type small=true
				return @type if small
				case @type
					when 'l'
						'less'
					when 'g'
						'greater'
					when 'le'
						'less or equal'
					when 'ge'
						'greater or equal'
					when 'ne'
						'not equal'
					else
						'equal'
				end
			end
			
			def value
				@value
			end
			
			def param type, value
				#['less','equ','greater']
				type = FIX_HASH_COMPARE[type] if FIX_HASH_COMPARE.key? type
				@type  = ['l','g','e','le','ge','ne'].include?( type ) ? type : 'e'
				if value.class == String
					@value = User::Utils.parse_value value
					#if value.match(/^\d+(\.\d+)?$/)
					#	@value = value.to_f
					#elsif ['true','false'].include?(value.downcase)
					#	@value = value.downcase == 'true' ? true : false
					#else
					#	@value = value
					#end
				else
					@value = value
				end
			end
			
			def init
				User::M_Events_Driver.attac_event :Property, "#{id} change", self, "test"
			end
			
			def done
				User::M_Events_Driver.dispatch :Property, "#{id} change", self
			end
			
			def test event
				value = event[0]
				result = case @type
					when 'l'
						value < @value
					when 'g'
						value > @value
					when 'le'
						value <= @value
					when 'ge'
						value > @value
					when 'ne'
						value != @value
					else
						value == @value
					end
					
				agr = Agrigate[ contact ]
				agr[ id ]= result if agr
			end
			
			def to_s
				"<#{@id} | #{type(false)} ( #{@value.inspect} )>"
			end
			
			def to_node up_node = nil
				node = up_node ?
						  up_node.create_node( :COMPARE, id)
						: User::UniversalXML::Node.new( :COMPARE, id)
				
				node[:cmp] = @type
				node[:value] = @value
			end
		end
		},
		:class_Agrigate => %q{
		
		class Agrigate
			def self.edit id = "", &block
				@@all ||= {}
				if @@all.key? id
					@@all[id].instance_eval(&block) if block_given?
				else
					Agrigate.new id, &block
				end
			end
			
			def self.[] id
				@@all ||= {}
				@@all[id] if @@all.key? id
			end
			
			def self.clean
				@@all ||= {}
				@@all.delete_if{|key,obj| obj.reset_comporators_and_is_empty?}
			end
			
			def self.delete id
				@@all ||= {}
				@@all.delete(id)
			end
			
			def initialize id = "", oper = "OR", &block
				@@all ||= {}
				@__ok = false
				@result = {}
				@name = id.empty? ? "Agrigate_#{@@all.count}" : id
				@@all[@name] = self
				@oper = oper
				@obj_uid = nil
				@event = nil
				
				instance_eval(&block) if block_given?
				result.init
			end
			
			def name id=nil
				return @name unless id
				@name = id
			end
			
			def event событие
				@event = событие
			end
			
			def operator oper = "OR"
				oper = FIX_HASH_AGRIGATE[oper] if FIX_HASH_AGRIGATE.key? oper
				@oper = ["OR","AND","NOTAND","NOTOR"].include?( oper ) ? oper : "OR"
			end
			
			def objectAction uid
				@obj_uid = uid
			end
			
			def addComporate id, type, value
				Comparator.edit @name, id, type, value
			end
			
			
			
			def get_name
				@name
			end
			
			def get_last_result
				@__ok
			end
			
			def test_result
				return if @result.empty?
				result = @result.inject(!(@oper =~ /OR/))do |result, cmp_result| 
					if @oper =~ /OR/
						result || cmp_result[1]
					else 
						result && cmp_result[1]
					end
				end
				result = !result if @oper =~ /NOT/
				
				if @__ok != result
					@__ok = result
					
					User::M_Property[@obj_uid].set_value result, Time.now, 200, @name
					User::M_Events_Driver.exec_event self, :Agrigate, "#{@name} change", result
				end
				result
			end
			
			def [] cmpid, value
				@result[cmpid] = value
			end
			
			def reset_comporators_and_is_empty?
				@result.select!{|cmpid, value| Comparator[ cmpid ]}
				@result.empty?
			end
			
			def to_s
				"<#{@name} #{@oper} (#{@__ok}) #{@result} count(#{Comparator.find_all @name})>"
			end
			
			def to_node up_node=nil
				node = up_node ?
						  up_node.создать_узел( :AGRIGATE, @name)
						: User::UniversalXML::Node.new( :AGRIGATE, @name)
				node[:oper] = @oper
				node[:event]= @event
				node[:uid]  = @obj_uid
				Comparator.find_all(@name).each{ |id,obj| obj.to_node node}
			end
		end
		
		
	},
		:self_loads_group => %q{
		def self.loads группа = nil
			load unless @agrs
			
			def __load__ name
				a = *@agrs.xmlPath("##{name}")
				@agrid_group[name] = []
				return if a.empty?
				a[0].nodes.each do |agr|
					@agrid_group[name] << agr[:id]
					Agrigate.edit agr[:id] do
						operator agr[:oper]
						event agr[:event]
						objectAction agr[:uid]
						
						agr.nodes.each{|node| addComporate node[:id], node[:cmp], node[:value] }
					end
				end
			end
			
			
			[*группа].each{|name| __load__ name} if группа
			__load__ '' unless @agrid_group.key? ''
		end
	},
		:self_save_all => %q{
		def self.save_all
			Agrigate.clean
			@agrid_group.each do |name, arID|
				a = *@agrs.xmlPath("##{name}")
				return if a.empty? 
				a = a[0]
				a.clear
				arID.each do |id| 
					arg = Agrigate[id]
					arg.to_node a if arg
				end
			end
			User::UniversalXML.save FILE_NAME, @agrs if @agrs
		end
	},
		:self_load => %q{
		def self.load event
			init unless @init
			@agrs = User::UniversalXML.load FILE_NAME
		end
	},
		:self_delete => %q{
		def self.delete event
			@agrs = nil
		end
	},
		:self_init => %q{
		def self.init
			@init = true
			User::M_Events_Driver.attach_event :XML, "update: #{FILE_NAME}", self, "load"
			User::M_Events_Driver.attach_event :XML, "delete: #{FILE_NAME}", self, "delete"
			
		end
	},
		:self_initialize => %q{
		def self.initialize
			M_Base_Initialize.init self, :init
		rescue Exception => e
			logUtil.logger.error e
		end
	}
end