module M_OPC_Configurator
	
	class C_OPC_Configurator
		def initialize
			@files = User::UniversalXML::Node.new :FILES
			@temp = []
		end
		
		def load_group filename
			ar = @files.xmlPath "#:#{filename}"
			return unless ar.empty?
			User::UniversalXML.load( filename ).move_to @files
			init_file filename
		end
		
		def init_file filename
			@files.xmlPath( "#:#{filename}/*/INCLUDE" ).each do |node|
				load_group node[:file]
			end
			self
		end
		
		def groups
			@files.xmlPath("*/GROUP").map{|group| group[:id]}.uniq
		end
		
		private
		def threads group, f='*'
			f = "#:'#{f}'" if f != '*'
			group_node = @files.xmlPath("#{f}/#:'#{group}'")
			unless group_node.empty?
				group_node = group_node[0]
				@temp += group_node.get_nodes_by_tag :THREAD, false
				group_node.get_nodes_by_tag( :INCLUDE, false ).each{|node| threads node.id, node[:file]}
			end
		end
		
		public
		
		
		def open_threads group
			@temp = []
			threads group
			self
		end
		
		def list_threads
			@temp.map{|thread| thread.id}.uniq
		end

		
		
		def close_threads
			@temp = []
			self
		end
		
		def items thread, lowItem = false, lowParam = false
			result = {}
			thread = thread.to_s.to_java.to_lower_case
			@temp.each do |node|
				if node.id.to_s.to_java.to_lower_case == thread
					node.get_nodes_by_tag( :ITEM ).each do |item|
						result[lowItem ? item.id.to_java.to_lower_case : item.id] = 
							item.attrs(false)
								.inject({})do |result, param|
									param[0] = param[0].to_s
									if param[0] != 'id'
										param[0] = param[0].to_java.to_lower_case if lowParam
										result[param[0][1..-1].to_sym] = param[1]
										result
									else
										result
									end
								end
					end
				end
			end
			result
		end
	end
	
	class C_OPC_Objects
		def initialize filename
			@xml = User::UniversalXML.load( filename )
			
			@xml.nodes.map do |node|
				node.get_nodes_by_tag(:OPC_PARAM).each do |param|
					node.instance_eval(%Q{def #{param.id} current
						#{param.text}
						end
					})
				end
			end
		end
		
		def data_block id
			@xml.xmlPath("DATA_BLOCK|##{id}")[0]
		end
		def variable id
			@xml.xmlPath("VARIABLE|##{id}")[0]
		end
		def property id
			@xml.xmlPath("PROPERTY|##{id}")[0]
		end
	end
	
	def self.load_conf filename
		conf = C_OPC_Configurator.new
		conf.load_group filename
		conf
	end
	
	def self.load_pattern filename
		C_OPC_Objects.new filename
	end
end


conf = M_OPC_Configurator.load_conf 'Замоскорецкая линия'
puts conf.groups.inspect
conf.open_threads 'ZL'
puts conf.list_threads.inspect
conf.items( "MainThread" ).each{|key,hash| puts "#{key} => "
	hash.each{|param,val| puts "\t\t #{param} = #{val.inspect}"}
	puts ''
}