Module.modify :UniversalCSV do
	description "Модуль для работы с xml-файлами. Автор Сергеев Д.Н. Версия 1.0.2"
	methods :class_TableCSV => %q{ # {}
		# =================================
		# =      TableCSV Interface:      =
		# =================================
		#
		# ---------------------------------
		# -        Constructors           -
		# ---------------------------------
		#
		# ...= User::UniversalCSV::TableCSV.new text = nil, opts = {}
		#			<: text ~ nil or String
		# ...= User::UniversalCSV::TableCSV.load file_name, opts = {}
		#			<: file_name ~ String
		#
		# ---------------------------------
		# -         Self Methods          -
		# ---------------------------------
		#
		# User::UniversalCSV::TableCSV.to_type a, type
		#			<: a ~ Any
		#			<: type ~ 'Integer' or 'Float' or 'Boolean' othen equ as 'String'
		#			:> Any
		# User::UniversalCSV::TableCSV.get_type a,b
		#			<: a ~ Any
		#			<: b ~ Any
		#			:> 'Boolean' or 'Integer' or 'String' or nil
		# User::UniversalCSV::TableCSV.for_sort a, b
		#			<: a ~ Any
		#			<: b ~ Any
		#			:> -1 or 0 or 1
		#
		# ---------------------------------
		# -           Data R/W            -
		# ---------------------------------
		#
		# *.[] row, col = nil
		#			<: row ~ Number or <col> is col = nil
		#			<: col ~ Number or String or Symbol or nil
		#			:> Any
		# *.[]= *params, value
		#			<: *params ~> row, col = nil
		#				<: row ~ Number or <col> is col = nil
		#				<: col ~ Number or String or Symbol or nil
		#			<: value ~ Any
		# *.count_rows
		#			:> Integer
		# *.count_cols row = nil
		#			<: row ~ nil or Number
		#			:> Integer
		# *.count_columns
		#			:> Integer
		# *.rows ishash = false, row = nil
		#			<: ishash ~ Bool
		#			<: row ~ nil or Number
		#			:> Hash or Array of <Value>
		# *.insert ars = [], from = :last
		#			<: ars ~ Hash or Array of Any
		#			<: from ~ :row or :last or :first or Number
		#			:> self
		# *.update ars = [], from = :row
		#			<: ars ~ Hash or Array of Any
		#			<: from ~ :row or :last or :first or Number
		#			:> self
		# *.parse text, is_header = true, delemite = ';'
		#			<: text ~ String
		#			:> self
		# *.parse_insert text, delemite = ';'
		#			<: text ~ String
		#			:> self
		# *.delete_if ishash=false, &block
		#			<: ishash ~ Bool
		#			:> self
		# *.update! ishash = false, &block
		#			<: ishash ~ Bool
		#			:> self
		# *.sort! col = 0, от_А_до_Я = fasle
		#			<: col ~ Number or String or Symbol
		#			<: от_А_до_Я ~ Bool
		#			:> self
		#
		# ---------------------------------
		# -          Navigation           -
		# ---------------------------------
		#
		# *.position
		#			:> Integer
		# *.position= row
		#			<: row ~ Number
		# *.next!
		#			:> self
		# *.prev!
		#			:> self
		# *.first!
		#			:> self
		# *.last!
		#			:> self
		# *.next?
		#			:> Bool
		# *.prev?
		#			:> Bool
		# *.first?
		#			:> Bool
		# *.last?
		#			:> Bool
		# *.next
		#			:> Integer
		# *.prev
		#			:> Integer
		# *.first
		#			:> Integer
		# *.last
		#			:> Integer
		# *.each ishash=false, &block
		#			<: ishash ~ Bool
		#			:> self
		#
		# ---------------------------------
		# -         Columns R/W           -
		# ---------------------------------
		#
		# *.columns col, newname = nil
		#			<: col ~ Number or String or Symbol
		#			<: newname ~ String or Symbol
		#			:> self or Symbol
		# *.add_column name, defvalue = nil, index = :last
		#			<: name ~ String or Symbol
		#			<: defvalue ~ nil or Any
		#			<: index ~ :last or :first or Number
		#			:> self
		# *.delete_column *index
		#			<: index ~ :last or :first or Number
		#			:> self
		# *.rename_column oldname, newname
		#			<: oldname ~ :last or :first or Number or String or Symbol
		#			<: newname ~ String or Symbol
		#			:> self
		#
		# ---------------------------------
		# -            Other              -
		# ---------------------------------
		#
		# *.inspect
		#			:> String		
		# *.to_s
		#			:> String
		# *.to_csv, opts = {}
		#			:> String
		# *.save file_name, opts = {}
		#			<: file_name ~ String
		#			:> self
		# *.load file_name, opts = {}
		#			<: file_name ~ String
		#			:> self
		# *.filter &block
		#			:> User::UniversalCSV::TableCSV
		#
	
		class TableCSV	

			def self.to_type a, type
				case type
					when :Integer
						if a.respond_to? :to_i
							a.to_i
						else
							0
						end
					when :Float
						if a.respond_to? :to_f
							a.to_f
						else
							0.0
						end
					when :Boolean
						!!a ? 1 : 0
					else a.to_s
				end
			end

			def self.get_type a,b
				case (a.nil? ? b : a).class
					when TrueClass,FalseClass
						:Boolean
					when NilClass
						nil
					when Float
						:Float
					when Fixnum,Bignum
						:Integer
					else
						:String
				end
			end
			
			def self.for_sort a, b
				type = get_type a,b
				to_type(a,type) <=> to_type(b,type)
			end
			
			
			def initialize text = nil, opts = {}
				@table = []
				@head = []
				@row = 0
				if text
					if text.class == String
						parse text, opts
					else
						opts[:is_header] = true unless opts.key?(:is_header)
						@table = text.clone
						@head = @table.shift.map.with_index{|name,i| name.nil? ? i : name.to_s.to_sym} if opts[:is_header]
					end
				end
			end
			
			def parse text, opts = {}
				opts[:is_header] = true unless opts.key?(:is_header)
				opts[:delemite] = ';' unless opts.key?(:delemite)
				opts[:is_parse_value] = true unless opts.key?(:is_parse_value)
				text = text.force_encoding(Encoding::UTF_8) if text.encoding.to_s != 'UTF-8'

				tbl = CSV.new(text,{col_sep: opts[:delemite]}).to_a
				@table = opts[:is_parse_value] ? table_to_value(tbl) : tbl
				#puts @table.to_s
				@head = @table.shift.map.with_index{|name,i| name.nil? ? i : name.to_s.to_sym} if opts[:is_header]
				@row = 0
				self
			end
			
			def parse_insert text, opts = {}
				opts[:delemite] = ';' unless opts.key?(:delemite)
				opts[:is_parse_value] = true unless opts.key?(:is_parse_value)

				tbl = CSV.new(text,{col_sep: delemite}).to_a
				@table +=  opts[:is_parse_value] ? table_to_value(tbl) : tbl
				self
			end
			
			def inspect
				"<TABLE HEADS:#{@head.size} ROWS:#{@table.size} POSITION:#{@row}>"
			end
			
			private
			def __columns col
				unless col.is_a? Integer

					if col.class != String
						col = col.to_s 
						col = col.force_encoding(Encoding::UTF_8).to_sym if col.encoding != 'UTF-8'
					end
					
					col = @head.index col
				end
				col
			end

			def __parse_value str
				return nil unless str
				return str unless str.is_a? String

				if str.match(/^\\d+\\.\\d+$/)
					str.to_f
				elsif str.match(/^\\d+$/)
					str.to_i
				else case str.downcase
					when 'true'
						true
					when 'false'
						false
					when 'empty'
						''
					else
						str
					end
				end
			end

			def table_to_value ar_row
				ar_row.map{|row| row.map{|cell| __parse_value(cell)}}
			end

			def __insert_to array, value, from = :last
				case from
					when :last
						array << value
					when :first
						array.unshift value
					else
						array.insert from, value
				end
				array
			end

			def __val val
				val.nil? ? '' : val === '' ? 'empty' : val.to_s
			end
			
			
			
			public
			def [] row, col = nil
				if col.nil?
					col = row
					row = @row
				end
				#row = row.to_s
				#row = row.force_encoding(Encoding::UTF_8) if row.encoding != 'UTF-8'
				@table[row][__columns col]
			end
			
			def []= *params, value
				row, col = params
				if col.nil?
					col = row
					row = @row
				end
				#row = row.to_s
				#row = row.force_encoding(Encoding::UTF_8) if row.encoding != 'UTF-8'
				@table[row][__columns col] = value
			end
			
			def count_rows
				@table.size
			end
			
			def count_cols row = nil
				@table[row.nil? ? @row : row].size
			end
			
			def count_columns
				@head.size
			end
			
			def position
				@row
			end
			
			def position= row
				@row = row
				@row = 0 if @row < 0
				@row = @table.size - 1 if @row >= @table.size
			end
			
			def next!
				@row += 1 if @row < @table.size - 1
				self
			end
			
			def prev!
				@row -= 1 if @row > 0
				self
			end
			
			def next?
				if @row < @table.size - 1
					@row += 1
					true
				else
					false
				end
			end
			
			def prev?
				if @row > 0
					@row -= 1
					true
				else
					false
				end
			end
			
			def next
				@row + 1				
			end
			
			def prev
				@row - 1
			end
			
			def first
				@table.empty? ? -1 : 0
			end
			
			def last
				@table.size - 1
			end
			
			def first!
				@row = 0
				self
			end
			
			def last!
				@row = @table.size - 1
				self
			end
			
			def first?
				@row == 0
			end
			
			def last?
				@row == @table.size - 1
			end
			
			def columns col, newname = nil
				if col.is_a? Integer
					col = @head[col]
				else
					col = __columns col
				end
				if newname
					@head[col] = newname.to_s.to_sym
					self
				else
					col
				end
			end
			
			def each ishash=false, &block
				if block_given?
					@table.each_with_index do |row,num|
						if ishash
							i = 0;
							temp = row.inject({}) do |res, row| 
								res[@head[i]] = row
								i += 1
								res
							end
							yield temp, num
						else
							yield row.clone, num
						end
					end
				end
				self
			end

			def delete_if ishash=false, &block
				if block_given?
					@table.delete_if do |row|
						if ishash
							i = 0;
							temp = row.inject({}) do |res, cell| 
								res[@head[i]] = cell
								i += 1
								res
							end
							yield temp
						else
							yield row.clone
						end
					end
				end
				self
			end
			
			def update! ishash = false, &block
				if block_given?
					@table.map!.with_index do |row, num|
						res = if ishash
							i = 0;
							temp = row.inject({}) do |res, row| 
								res[@head[i]] = row
								i += 1
								res
							end
							yield temp, num
						else
							yield row, num
						end
						
						if res.class == Array
							res
						elsif res.class == Hash
							res.each do |key,value| 
								if i = @head.index(key)
									row[i] = value
								else
									row << value
								end
							end
							row
						else 
							row
						end
					end
				end
				self
			end
			
			def sort! col = 0, от_А_до_Я = fasle
				col = __columns col
				@table.sort!{|a,b| от_А_до_Я ? self.class.for_sort(a[col], b[col]) : self.class.for_sort(b[col], a[col])}
				self
			end
			
			def rows ishash = false, row = nil
				row = @row unless row
				if ishash
					i = 0;
					@table[row].inject({}) do |res, row| 
						res[@head[i]] = row
						i += 1
						res
					end
				else
					@table[row].clone
				end
			end
			
			def insert ars = [], from = :last
				if ars.class == Array
					ars << nil while ars.size < @head.size
					ar = ars
				else
					ar = @head.map{nil}
					ars.each{|key,value| if i = @head.index(key) then ar[i] = value else ar << value end}
				end
				@table = __insert_to @table, ar, from == :row ? @row : from
				@row = @table.size - 1
				self
			end
			
			def update ars = [], from = :row
				num = case from 
					when :first
						0
					when :row
						@row
					when :last
						-1
					else
						from
				end
				
				if ars.class == Array
					ars << nil while ars.size < @head.size
					ar = ars
				else
					ar = @table[num]
					ars.each do |key,value| 
						if i = @head.index(key)
							ar[i] = value
						else
							ar << value
						end
					end
				end
				
				@table[num] = ar
				self
			end
			
			def add_column name, defvalue = nil, index = :last
				@head = __insert_to @head, name.to_s.to_sym, index
				index = @head.size - 1 if index == :last
				@table.map!{|row| __insert_to row, defvalue, index}
				self
			end
			
			def delete_column *index
				index.each do |i|
					case i
						when :last
							@head.pop
							@table.map!{|row| row.pop;row}
						when :first
							@head.shift
							@table.map!{|row| row.shift;row}
						else
							@head.delete(i)
							@table.map!{|row| row.delete(index); row};
					end
				end
				self
			end
			
			def rename_column oldname, newname 
				newname = newname.to_s.to_sym
				case oldname
					when :last
						@head[-1] = newname
					when :first
						@head[0] = newname
					else
						@head[columns oldname] = newname
				end;
				self
			end

			def filter &block
				result = TableCSV.new
				@head.each{|th| result.add_column th}
				each true do |row|
					result.insert row if !block_given? || yield(row)
				end
				result
			end
			
			def to_s
				sizes = @head.map{|name| name.to_s.size}
				nsize = @table.size.to_s.size
				@table.each do |row| 
					row.each_with_index do |cell,i|
						cell_size = __val cell #.nil? ? '' : cell === '' ? 'empty' : ''#  User::Utils.value_to_s(cell).size
						sizes[i] = cell_size if i < @head.size && cell_size > sizes[i]
					end
				end
				
				result = [' ' * (nsize+1)]
				@head.each_with_index do |name,i| 
					temp = name.to_s
					temp = temp.force_encoding(Encoding::UTF_8) if temp.encoding.to_s != 'UTF-8'
					result[0] += "|%#{sizes[i]}s" % [temp] 
				end
				
				@table.each_with_index do |row,i|				 
					temp = row.map.with_index{|value, i| "%#{sizes[i]}s" % [__val(value)] }.join('|')
					result << (" %0#{nsize}d|" % [i] ) + temp
				end
				
				result.join("\\n#{'-' * result[0].size}\\n")
			end
			
			def to_csv opts = {}
				opts[:is_header] = true unless opts.key? :is_header
				opts[:delimite] = ';' unless opts.key? :delimite
				result = opts[:is_header] ? [@head.map(&:to_s).join(opts[:delimite])] : []
				@table.each do |row|
					result << row.to_csv({col_sep: opts[:delimite], row_sep: ''})#[0...-1]
				end
				result.join("\\n")
			end

			def to_a is_header = true
				if is_header
					@head + @table
				else
					@table.clone
				end
			end

			def save file_name, opts = {}
				File.open(flie_name, 'w+:utf-8') { |file|	file.write( to_csv(opts) )}
				self
			end

			def load file_name, opts = {}
				File.open(file_name, 'r+') { |file| parse file.read, opts }
				self
			end

			def self.load file_name, opts
				new.load file_name, opts
			end
		end
	},
		:self_load => %q{ # {}
		def self.load file_name, opts
			# на всякий случай хранить ссылку на binary не будем, мало ли
			binary = nil

			User::Binary.each do |id,bin|
				if bin.name == file_name && bin.file_ext == '.csv'
					binary = bin
					break
				end
			end
			if binary.nil?
				TableCSV.new
			else
				TableCSV.new binary.text, opts
			end
		end
	},
		:self_save => %q{ # {}
		def self.save file_name, csvTable, opts, desc = 'CSV файл настроек', bin_id = nil
			text = csvTable.to_csv opts
			unless bin_id
				User::Binary.each do |id,bin|
					if bin.name == file_name && bin.file_ext == '.csv'
						bin_id = id
						break
					end
				end
			end
			bin_id = nil if bin_id === true
			file_hash = Digest::MD5.hexdigest(text).to_s
			byte_array = text.to_java_bytes.to_a
			descriptor = [bin_id,file_name,desc,file_name,".csv",byte_array.size,Time.now,file_hash,byte_array,nil]

			if descriptor[0] == nil
				$space.binaryAccount._insert *descriptor
			else
				$space.binaryAccount._update *descriptor
			end
		end
	},
		:self_save_to_file => %q{ #{}
		def self.save_to_file csvTable, file_name, opts
			csvTable.save file_name, opts
		end
	},
		:self_load_from_file => %q{
		def self.load_from_file file_name, opts
			TableCSV.load file_name, opts
		end
	},
		:self_handleNotification => %q{ # {}
		def self.handleNotification  ntf
			if ntf.handler == :binaryAccount && ntf.file_ext == '.csv'
				if ntf.action == Notifier::DELETE
					User::M_Events_Driver.exec_event :CSV, "delete: #{ntf.name}", ntf
					User::M_Events_Driver.exec_event :CSV, "delete file", ntf
				elsif ntf.action == Notifier::INSERT || ntf.action == Notifier::UPDATE
					User::M_Events_Driver.exec_event :CSV, "update: #{ntf.name}", ntf
					User::M_Events_Driver.exec_event :CSV, "update file", ntf
				end
			end
		end
	},
		:self_subscribe => %q{ # {}
		def self.subscribe
			$space[:Main].accounts[:binaryAccount].subscribe self, nil  if User.constants.include? :M_Events_Driver
		end
	},
		:self_unsubscribe => %q{ # {}
		def self.unsubscribe
			$space[:Main].accounts[:binaryAccount].unsubscribe self, nil
		end
	},
		:self_initialize => %q{ # {}
		def self.initialize
			subscribe
		end
	}
end