﻿Module.recreate :Utils do
	methods :self_insert_to => %q{
		def self.insert_to array, value, from = :last
			case from
				when :last
					array << value
				when :first
					array.unshift value
				else
					array.insert from, value
			end
			array
		end
	},
		:self_value_to_s => %q{
		def self.value_to_s val
			if val.nil?
				''
			elsif val === ''
				'empty'
			else 
				val.to_s
			end
		end
	},
		:self_parse_value => %q{
		def self.parse_value str
			if str == ''
				nil
			elsif str == 'empty'
				''
			elsif str.match(/^\d+\.\d+$/)
				str.to_f
			elsif str.match(/^\d+$/)
				str.to_i
			elsif str.downcase == 'true'
				true
			elsif str.downcase == 'false'
				false
			else
				str
			end
		end
	},
		:self_change_class => %q{
		# Смена класса объекта с попыткой копирования аттрибутов

		def self.change_class obj, cls
			cls = User::UserClass.get(cls.to_s.to_sym)
			raise "Не найден класс :#{cls.to_s}" if cls.nil?

			cls_id = obj.class.to_s.split("::").last.to_sym

			# buffer = {}
			# User::UserClass.get(cls_id).modules.each do |m|
			# 	mod = User::Module.get(m)
			# 	mod.attrs.each_key do |attr|
			# 		buffer[attr] = obj.send(attr)
			# 	end
			# end
			
			id = obj.obj_id
			User::UserObject.modify id do
				change_class cls.name
			end

			obj = User::UserObject.get(id)
			# buffer.each_pair do |attr, value|
			# 	begin
			# 		obj.send("#{attr}=",value) if obj.respond_to?(attr)
			# 	rescue Exception => e
			# 		LogUtil.logger.error "#{self.to_s}.#{__method__} - ошибка при копировании аттрибута объекта"
			# 	end
			# end
			obj
		end
	}
end