Module.create :XML_export do
	description "Модуль для построения xml-файлов. Автор Звягин Ю.В. Версия 1.0.1"
	methods :create => %q{
		class XMLexporter
			def initialize 
				@result = []
				@tab = 0
			end

			def create name, &block
				result = ""
				result = construct_export_data &block if block_given?

				return nil if result.nil? || result.empty?

				raise "Не задан параметр path!" unless @path
				
				f = File.new(get_path,"w")
				begin
					f.write(result)
				rescue Exception => e
					LogUtil.logger.error "#{self.class}.#{__method__} - Ошибка при попытки записи в файл:\n#{e}"
				ensure
					f.close
				end
				get_path
			end

			def construct_export_data &block
				instance_eval(&block) if block_given?
				arr = []
				@result.each do |x|
					arr << %Q{<#{x[0]}#{x[1].get_layer_text}</#{x[0]}>}
				end
				temp_arr = []
				temp_arr << %Q{<?xml version="#{get_version}" encoding="#{get_encoding}"?>}
				(temp_arr << get_prefix) if get_prefix
				temp_arr << arr.join("\n")
				temp_arr.join("\n")
			end

			def simply_export_data &block
				instance_eval(&block) if block_given?
				arr = []
				@result.each do |x|
					arr << %Q{#{"\t" * @tab}<#{x[0]}#{x[1].get_layer_text}
#{"\t" * @tab}</#{x[0]}>}
				end
				text = arr.join("\n")
			end

			def prefix arg
				@prefix = arg.to_s
			end
			alias set_prefix prefix
			alias prefix= prefix

			def get_prefix
				@prefix ||= nil
			end

			def version arg
				@version = arg.to_s
			end
			alias set_version version
			alias version= version

			def get_version
				@version ||= "1.0"
				#@version
			end

			def encoding arg
				@encoding = arg.to_s
			end
			alias set_encoding encoding
			alias encoding= encoding

			def get_encoding
				@encoding ||= "utf-8"
				#@encoding
			end

			def name arg
				@name = arg.to_s
			end
			alias set_name name
			alias name= name

			def get_name
				@name ||= "default"
				#@name
			end

			def path arg
				@path = arg.to_s
			end
			alias set_path path
			alias path= path

			def get_path
				@path ||= "#{Dir.pwd}.#{get_name}.xls"
				#@path
			end

			#отступ, для construct
			def tab ind
				@tab = ind
			end

			class Layer

				def initialize parent
					@parent = parent
					@childrens = []
					@args = {}
					@text = nil
					@ind = 0
				end

				def level ind
					@ind = ind
				end

				def attribute key, value
					c_key, c_value = [key,value].map do |str|
						str.to_s
							.gsub('&','&amp;')
							.gsub('<','&lt;')
							.gsub('>','&gt;')
							.gsub("'",'&apos;')
							.gsub('"','&quot;')
					end
					@args[c_key] = c_value
				end
				alias attr attribute

				def layer name, &block
					obj = Layer.new self
					obj.level(@ind + 1)
					@childrens << [name.to_s, obj]
					obj.instance_eval(&block) if block_given?
				end

				def text arg
					@text = arg.to_s
								.gsub('&','&amp;')
								.gsub('<','&lt;')
								.gsub('>','&gt;')
				end

				def get_text
					@text
				end

				def get_layer_text
					arg_arr = []
					@args.each_pair do |key,val|
						arg_arr << %Q{#{key}="#{val}"}
					end
					body_arr = []
					pref = "\t" * (@ind + 1)
					@childrens.each do |x|
						body_arr << %Q{#{pref}<#{x[0]}#{x[1].get_layer_text}</#{x[0]}>}
					end
					arr = []
					arr << %Q{#{arg_arr.empty? ? "" : " "}#{arg_arr.join(" ")}>#{@text}}
					(arr << body_arr.join("\n")) if !body_arr.empty?
					temp = arr.join("\n")
					temp += "\n#{"\t" * @ind}" if !@childrens.empty?
					temp
				end
			end

			def layer name, &block
				obj = Layer.new nil
				# @result ||= []
				name = name.to_s
				@result << [name,obj]
				obj.level @tab
				obj.instance_eval(&block) if block_given?
			end
		end

		def self.create name, &block
			obj = XMLexporter.new
			obj.create name, &block
		end
	},
		:create_xml_text => %q{
		def self.create_xml_text &block
			obj = XMLexporter.new
			obj.construct_export_data &block
		end
	},
		:construct => %q{
		def self.construct &block
			obj = XMLexporter.new
			obj.simply_export_data &block
		end
	}
end