ServiceEntity.create :EDO_Doc_DU58, :module do
	description "Модуль описания документа ДУ-58. 02/02/2018"
	sub_modules :EDOBaseModule
end

Module.modify :EDO_Doc_DU58 do
	methods :document_template => %q{ # #{}
			def document_template
				<<-XML
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:sap-com:document:sap:soap:functions:mc-style">
	<soapenv:Header/>
	<soapenv:Body>
		<urn:InitBusinessProcess>
			<Request>
				<Businessprocesscode/>
				<Sourcesystem>
					<Systemcode>141</Systemcode>
					<Nodeid/>
				</Sourcesystem>
				<Documentdata>
					<Doctype></Doctype>
					<Sourcesystemdocid>1</Sourcesystemdocid>
					<Doccontent></Doccontent>
					<Docsigntab>
						<!--Zero or more repetitions:-->
					</Docsigntab>

					<Metadatatab>
						<!--Zero or more repetitions:-->
					</Metadatatab>
				</Documentdata>
			</Request>
		</urn:InitBusinessProcess>
	</soapenv:Body>
</soapenv:Envelope>
XML
			end
		},
		:get_pdf_template => %q{ # #{}
			def get_pdf_template
				<<-XML
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:sap-com:document:sap:soap:functions:mc-style">
	<soapenv:Header/>
	<soapenv:Body>
		<urn:GetDocPrintForm>
			<Request>
				<Docid></Docid>
			</Request>
		</urn:GetDocPrintForm>
	</soapenv:Body>
</soapenv:Envelope>
XML
			end
		},
		:super_initialize_and_structure => %q{ # #{}
			def initialize
				super
				self.structure_module = :EDOStructureDoc58
			end

			User::EDOBaseModule.ModuleStructure :EDOStructureDoc58

			User::EDOBaseModule.container :item do
				field :Sigstage
				field :Signnum, 1
				field :Signcontent
				field :Timestamp
			end

			User::EDOBaseModule.container :Docsigntab do
				array :item
			end

			User::EDOBaseModule.container :Metadatatab do
				hash :item, :Key, :Value
			end
		},

		:structure_data => %q{ # #{}
			def structure_data data, typeData
				if typeData == :EDO_send
					{
						'**/Documentdata/Doctype' => "DU-58",
						'**/Documentdata/Doccontent' => data[:Doccontent],
						'**/Documentdata/Docsigntab' => data[:Docsigntab],
						'**/Documentdata/Metadatatab' => data[:Metadatatab]
					}
				else
					{
						'**/Request/Docid' => self.docid
					}
				end
			end
		},

		:config => %q{ # #{}
			# таблица серверов (Комплекс/дорога)
			#        |   :Msk    |   :okt    | Прочее
			# :prom  | Suara msk | Suara okt | Sodden
			# :tk1   |   Capri   |   Capri   | Sodden
			# :tk2   |  Sodden   |  Sodden   | Sodden
			# Прочее |  Sodden   |  Sodden   | sodden
			
			TABLE_SERVERS = { 
				prom_msk: :SuaraMsk,
				prom_okt: :SuaraOkt,
				tk1_msk: :Capri,
				tk1_okt: :Capri
			}
			
			TABLE_SERVER_DATA = { # [ <domain>, <port>, <login>, <password>, <urls>]
				SuaraMsk: ['suara.gvc.oao.rzd', 8020, 'T141_17',   'isuzht17', {
					EDO_send: '/sap/bc/srt/rfc/sap/z_edo_bpm_processor/200/z_edo_bpm_processor/z_edo_bpm_processor_bnd',
					EDO_get:  '/sap/bc/srt/rfc/sap/z_edo_bpm_datarequest/200/z_edo_bpm_datarequest/edo_bpm_datarequest_bnd'
				}],
				SuaraOkt: ['suara.gvc.oao.rzd', 8020, 'T141_01',   '01isuzht', {
					EDO_send: '/sap/bc/srt/rfc/sap/z_edo_bpm_processor/200/z_edo_bpm_processor/z_edo_bpm_processor_bnd',
					EDO_get:  '/sap/bc/srt/rfc/sap/z_edo_bpm_datarequest/200/z_edo_bpm_datarequest/edo_bpm_datarequest_bnd'
				}],
				Capri:    ['capri.gvc.oao.rzd', 8000, 'UEDO_USER', 'ambulance', {
					EDO_send: '/sap/bc/srt/rfc/sap/z_edo_bpm_processor/200/z_edo_bpm_processor/z_edo_bpm_processor_bnd',
					EDO_get:  '/sap/bc/srt/rfc/sap/z_edo_bpm_datarequest/200/z_edo_bpm_datarequest/edo_bpm_datarequest_bnd'
				}],
				Sodden:   ['sodden.gvc.oao.rzd',8020, 'UEDO_USER', '12345678', {
					EDO_send: '/sap/bc/srt/rfc/sap/z_edo_bpm_processor/300/z_edo_bpm_processor/z_edo_bpm_processor_bnd',
					EDO_get:  '/sap/bc/srt/rfc/sap/z_edo_bpm_datarequest/300/z_edo_bpm_datarequest/edo_bpm_datarequest_bnd'
				}]
			}
			
			def config netConfig, typeConfig
				server = TABLE_SERVERS[ netConfig.thisNode ]
				server = :Sodden if server.nil?
				data = TABLE_SERVER_DATA[ server ]
			
				netConfig.set do
					#host 'capri.gvc.oao.rzd' #'sodden.gvc.oao.rzd'
					#port 8000 #8020
					#login 'UEDO_USER'
					#password 'ambulance'
					#url typeConfig == :EDO_send ?
					#	  '/sap/bc/srt/rfc/sap/z_edo_bpm_processor/200/z_edo_bpm_processor/z_edo_bpm_processor_bnd'
					#	: '/sap/bc/srt/rfc/sap/z_edo_bpm_datarequest/200/z_edo_bpm_datarequest/edo_bpm_datarequest_bnd'
					
					host     data[0]
					port     data[1]
					login    data[2]
					password data[3]
					url      data[4][typeConfig]
					typeAuth :basic
				end
			end
		}
end