module EDO_Doc_Type1
	def document_template
		%q{<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:sap-com:document:sap:soap:functions:mc-style">
	<soapenv:Header/>
	<soapenv:Body>
		<urn:InitBusinessProcess>
			<Request>
				<Businessprocesscode/>
				<Sourcesystem>
					<Systemcode>141</Systemcode>
					<Nodeid/>
				</Sourcesystem>
				<Documentdata>
					<Doctype></Doctype>
					<Sourcesystemdocid>1</Sourcesystemdocid>
					<Doccontent></Doccontent>
					<Docsigntab>
						<!--Zero or more repetitions:-->
					</Docsigntab>

					<Metadatatab>
						<!--Zero or more repetitions:-->
					</Metadatatab>
				</Documentdata>
			</Request>
		</urn:InitBusinessProcess>
	</soapenv:Body>
</soapenv:Envelope>}
	end

	def structure_containers
		container :Item do
			field :Sigstage
			field :Signnum, 1
			field :Signcontent
			field :Timestamp
		end
		
		container :Docsigntab do
			array :Item
		end
	end
end

module EDO_Doc_DU58
	def structure_containers
		super
		
		container :Metadatatab do
			hash :Item, :Key, :Value
		end
	end
	
	def structure_data data
		{
			'**/Documentdata/Doctype' => data[:Doctype],
			'**/Documentdata/Doccontent' => data[:Doccontent],
			'**/Documentdata/Docsigntab' => data[:Docsigntab],
			'**/Documentdata/Metadatatab' => data[:Metadatatab]
		}
	end
end

class Test
	include EDOBaseModule
	include EDO_Doc_Type1
	include EDO_Doc_DU58

	def config netConfig
		netConfig.set do
			host 'sodden.gvc.oao.rzd'
			port 8020
			url '/sap/bc/srt/wsdl/srvc_597658FBDD3912D0E10080000AF6682E/wsdl11/allinone_ws_policy/document?sap-client=300'
			typeAuth :basic
			login 'UEDO_USER'
			password '12345678'
		end
	end

	def edo_data
		{
			Doctype: "DU-58",
			Doccontent: "G48aHRtbD5cblx0PGhlYWQ+XG5cdFx0PG1ldGEgbmFtZT1cInZpZXdwb3J",
			Docsigntab: [
				{
					Signnum: 1,
					Signcontent: "G48aHRtbD5cblx0PGhlYWQ+XG5cdFx0PG1ldGEgbmFtZT1cInZpZXdwb3J",
					Timestamp: "MDEuMDEuMjAxNyAxMjowMDowMA=="
				},
				{
					Signnum: 2,
					Signcontent: "248aHRtbD5cblx0PGhlYWQ+XG5cdFx0PG1ldGEgbmFtZT1cInZpZXdwb3J",
					Timestamp: "2DEuMDEuMjAxNyAxMjowMDowMA=="
				}
			],
			Metadatatab: {
				dor_code: "01",
				du_id: 3,
				du_name: "ОКТ 105 СОНКОВСКИЙ",
				stan_name: "СОНКОВО",
				pred_name: "ТЧЭ-22",
				order_date: "15.08.2017", 
				order_time: "12:10",
				order_number: "1215",
				doc_creator: "Иванов Иван Иванович ДНЦ Лиски",
				ad_info: "Дополнительная информация"
			}
		}
	end
end

test = Test.new
puts test.send_to_edo
puts test.edo_result
puts test.edo_result_code
puts test.edo_result_message