ServiceEntity.create :EDOBaseModule, :module do
	description "Модуль для формирования и отправки документов EDO. Автор Сергеев Д.Н. Версия 1.1"
	attribute :last_status_code do
		type :Plain
		description "Статус-код последней отправки данных"
	end
	attribute :last_status_message do
		type :Plain
		description "Статус-текст сообщения последней отправки данных"
	end
	attribute :last_status do
		type :Plain
		description "Статус успеха последней отправки данных"
	end
	attribute :last_retcode do
		type :Plain
		description "Статус-код, в приходящем ответе"
	end
	attribute :last_retmessage do
		type :Plain
		description "Статус-текст, в приходящем ответе"
	end
	attribute :last_send_time do
		type :Plain
		description "Время последней отправки"
	end
	attribute :doc_send_time do
		type :Plain
		description "Время успешной отправки документа"
				  
	end
	attribute :docid do
		type :Plain
		description "Последний id при успешном ответе"
				  
	end
	attribute :structure_module do
		type :Plain
		description "Имя модуля, которых хранит в себе методы преобразования данных из Ruby в XML, заданной структуры"
	end
end

Module.modify :EDOBaseModule do
	methods :const_and_require => %q{# #{}
        require 'net/http'
        USED_TYPE_AUTH = [:none, :basic] # доступные типы авторизации
        USED_TYPE_SEND = [:get,:post] # доступные методы отправки данных
    },
        :initialize => %q{# #{}
        def initialize
            transient :soapResult, :last_pdf
            @soapResult = nil
            @last_pdf = nil
        end
    },

        :class_NetConfig => %q{# #{}
		# класс для настройки web-соединения, и запроса по нему с получением ответа от сервера
        class NetConfig
            def initialize &block
                @param = {
                    host: '',
                    port: 80,
                    login: '',
                    password: '',
                    auth: :none,
                    url: '',
					thisNode: :other,
                    protocol: :http   #:http || :https
                }
                instance_eval(&block) if block_given?
            end
			
			# настройка объекта в DSL-стиле
            def set &block
                instance_eval(&block) if block_given?
                self
            end
			
			# получение или изменение признака текущего сервера
			def thisNode value = nil
				if value
					@param[:thisNode] = value
					self
				else
					@param[:thisNode]
				end
			end
			
			# указание домена
            def host value
                @param[:host] = value
                self
            end
			
			# указание порта
            def port value
                @param[:port] = value
                self
            end
			
			# указание логина для авторизации
            def login value
                @param[:login] = value
                self
            end
			
			# указание пароля для авторизации
            def password value
                @param[:password] = value
                self
            end
			
			# указание типа авторизации
            def typeAuth value
                @param[:auth] = USED_TYPE_AUTH.include?(value) ? value : :none
                self
            end
			
			# указание адреса от домена по умолчанию, который необходимо запросить
            def url value
                @param[:url] = value
                self
            end
			
			# указание протокола, по которому необходимо работать (:http или :https)
            def protocol value
                @param[:protocol] = value if [:http,:https].include?(value)
                self
            end
			
			# сделать запрос и вернуть ответ сервера
            def sendReq data, type, url = nil
				# data - данные, которые следует прикрепить к запросу 
				# type - метод отправки серверу (:get или :post)
				# url  - адрес запроса, если он отличается от ранее настроенного п оумолчанию
				
                net = @param[:protocol] == :http ? Net::HTTP : Net::HTTPS
                net.start(@param[:host], @param[:port]) do |http|
                    req = (type == :post ? net::Post : net::Get).new(url ? url : @param[:url])
                    req.basic_auth(@param[:login], @param[:password]) if(@param[:auth]== :basic)
                    req.body = data
                    req.content_type = 'text/xml; charset=utf-8'


                    http.request(req)
                end
            end
			
			# сделать post-запрос и вернуть ответ сервера
            def post data, url = nil
				# data - данные, которые следует прикрепить к запросу 
				# url  - адрес запроса, если он отличается от ранее настроенного п оумолчанию
                sendReq data, :post, url
            end
			
			# сделать get-запрос и вернуть ответ сервера
            def get data, url = nil
				# data - данные, которые следует прикрепить к запросу 
				# url  - адрес запроса, если он отличается от ранее настроенного п оумолчанию
                sendReq data, :get, url
            end

        end
    },

        :class_FieldsStruct => %q{# #{}
		# класс, с помощью которого можно определить формирующуюся структуру, которая будет вставляться в XML-шаблон, формирующегося для отправки
        class FieldsStruct
            def initialize name, &block
                @name = name
                @struct = []
                @attr = []
                @ignoreHash = []
                @is_create = false
                @is_one = false
                instance_eval(&block) if block_given?
            end
			
			# подструктура
			# name - наименование ранее описанной структуры
			# tag  - если указать этот параметр, то структура будет вставляться под этим именем, а не своим
            def ref name, tag = nil
                @is_create = true if @is_one
                @is_one = true
                @struct << ['r',name, tag]
                self
            end
			
			# массив одинаковых подструктур
			# name - наименование ранее описанной структуры, которая будет повторяться в количестве переданных данных
			# tag  - если указать этот параметр, то структура будет вставляться под этим именем, а не своим
            def array name, tag = nil
                @is_create = true if @is_one
                @is_one = true
                @struct << ['a', name, tag]
                self
            end
			
			# поле / одиночный тег структуры, который будет хранить в себе данные
			# name - наименование тега
			# default - значение, которое будет подставляться в документ, если при формеровании не будет найден ключ с таким именем
            def field name, default = nil
                @is_create = true
                @struct << ['f', name, default]
                @ignoreHash << name
                self
            end
			
			# атрибут тега структуры, который будет вставлен в тег самой структуры
			# name - наименование атрибута
			# default - значение, которое будет подставляться в документ, если при формеровании не будет найден ключ с таким именем
            def attr name, default = nil
                @is_create = true
                @attr << [name, default]
                @ignoreHash << name
                self
            end
			
			# хэшь-структуры масива, в данном случае предполагается, что заранее неизвестно какие ключи будут в структуре, и нужно вставить все
			# tag - наименование тега, внутри которого будут размещена структура хеша
			# keyTag - наименование тега, в котором будет храниться ключ значения
			# valueTag - наименование тега, в который будет сохраняться значение ключа
            def hash tag, keyTag, valueTag
                @is_create = true if @is_one
                @is_one = true
                @struct << ['h', tag, keyTag, valueTag]
                self
            end
			
			# формирование данный структуры в наименование метода
            def getMethodName
                "convert_" + @name.to_s.downcase
            end
			
			# формирование кода медота преобразования Ruby-структуры в XML-структуру, согласно указанной в объекте класса
            def to_s
                lines = []
                temp = @is_create ? "node = upNode.create_node(tag ? tag : #{@name.inspect})" : ''
                lines << <<-STR

                    def self.#{getMethodName} upNode, value, tag = nil
                        ignore = #{@ignoreHash.inspect}
                        #{temp}
                STR
                @attr.each do |attr|
                    temp = attr[0].inspect
                    val = attr[1] ? attr[1].inspect : "''"
                    lines << <<-STR
                        node[#{temp}] = value[#{temp}] ? value[#{temp}] : #{val}
                    STR
                end

                @struct.each do |element|
                    temp = element[1].inspect
                    temp2 = element[1].to_s.downcase
                    val = element[2] ? element[2].inspect : (element[0]=='f' ? "''" : 'nil')
                    lines << case element[0]
                        when 'f'
                            <<-STR
                                node.text_node #{temp}, value[#{temp}] ? value[#{temp}] : #{val}
                            STR
                        when 'r'
                            <<-STR
                                convert_#{temp2}( #{@is_create?'node':'upNode'}, value[#{temp}], #{val}) if value[#{temp}]
                            STR
                        when 'a'
                            <<-STR
                                value.each{|elem| convert_#{temp2}( #{@is_create?'node':'upNode'}, elem, #{val} )} if value
                            STR
                        when 'h'
                            temp2 = element[2].inspect
                            val = element[3].inspect
                            <<-STR
                                value.each do |key, val|
                                    unless ignore.include?(key)
                                        if  val.is_a?(Array)
                                            val.each do |v|
                                                temp = #{@is_create?'node':'upNode'}.create_node(#{temp})
                                                temp.text_node(#{temp2}, key)
                                                temp.text_node(#{val}, v)
                                            end
                                        else
                                            temp = #{@is_create?'node':'upNode'}.create_node(#{temp})
                                            temp.text_node(#{temp2}, key)
                                            temp.text_node(#{val}, val)
                                        end
                                    end
                                end
                            STR
                    end
                end

                lines.join('') + "\nend"
            end
        end
    },
        :self_ModuleStructure => %q{ # #{}
		# указание наименования модуля, в который будет сохраняться методы преобразования данных 
        def self.ModuleStructure name
            @struct = name
            User::Module.create(@struct){} unless User::Module.get(@struct)
        end
    },
        :self_container => %q{# #{}
		# создание структуры данных, служащую для конвертации Ruby-структуры в XML-структуру
		# name - наименование структуры
        def self.container name, &block
            if @struct
                User::Module.create(@struct){} unless User::Module.get(@struct)

                mtd = FieldsStruct.new(name, &block)

                User::Module.modify @struct do
                    methods mtd.getMethodName.to_sym => mtd.to_s
                end
            end
        end
    },
        :abstract_methods => %q{# #{}
		# это абстрактные методы, которые необходимо переопределить ниже
		
		# метод должен возвращать XML-шаблон документа, который необходимо отправить в ЭДО на подтверждение
        def document_template
            ""
        end
		
		# метод должен возвращать XML-шаблон документа, который необходимо отправить в ЭДО для получения PDF-файла
        def get_pdf_template
            ""
        end
		
		# настройка подключения, вызывается каждый раз перед запросом
		# netConfig - объект класса NetConfig, который необходимо настроить, согласно параметрам подключения задачи
		# typeSend  - в данную переменную будет передаваться какой следует сделать запрос
        def config netConfig, typeSend  # :EDO_send, :EDO_get
            netConfig
        end
		
		# метод, который должен вернуть хэшь, ключи которого должны указывать XMLPath в шаблоне, 
		#    а значение на данные в Ruby-структуре, который необходимо вставить в XML-документ по указанному адресу, и согласно ранее созданной структуре.
		# data - данные, которые формируются в методе edo_data
		# typeSend  - в данную переменную будет передаваться какой следует сделать запрос
        def structure_data data, typeSend # :EDO_send, :EDO_get
            data
        end
		
		# медот должен вернуть данные, которые в дальнейшем будут встравляться в описанные места шаблона XML-документа
        def edo_data
            {}
        end
    },
        :edo_result_code => %q{# #{}
		# получить последний код запроса (2xx - успешно, 3xx - перенаправление, 4xx - ошибка клиента, 5xx - ошибка сервера, -1 - запроса еще небыло)
        def edo_result_code
            @soapResult ? @soapResult.code : -1
        end
    },
        :edo_result_message => %q{# #{}
		# получить последнее сообщение сервера (расшифровку кода возвращаемого методом edo_result_code
        def edo_result_message
            @soapResult ? @soapResult.message : ''
        end
    },
        :edo_result_type => %q{# #{}
		# получить класс ответа сервера (Если необходимо узнать)
        def edo_result_type
            @soapResult ? @soapResult.class : nil
        end
    },
        :edo_result_headers => %q{# #{}
		# получить http-заголовок, который прислал сервер
        def edo_result_headers
            @soapResult ? @soapResult.to_hash : {}
        end
    },
        :edo_result => %q{# #{}
		# получить текст ответа от сервера
        def edo_result
            @soapResult ? @soapResult.body : ''
        end
    },
        :constructEDO => %q{# #{}
		# вспомогательный метод, который собирает из шаблона, данных и настроенных структурах, получить готовый XML-документ для отправки
		# typeSend  - в данную переменную будет передаваться какой следует сделать запрос
        def constructEDO typeSend # :EDO_send, :EDO_get
            node = User::UniversalXML.parse_xml( typeSend == :EDO_send ? document_template : get_pdf_template )

            data = structure_data( typeSend == :EDO_send ? edo_data : nil, typeSend)

            data.each do |path, value|
                node.xmlPath( path ) do |thisNode|
                    if value.respond_to?(:each)
                        if User::Module.get(self.structure_module)
                            User.const_get(self.structure_module).send(('convert_'+thisNode.tag.downcase).to_sym, thisNode, value)
                        end
                    else
                        thisNode.text = value.to_s
                    end
                end
            end

            node.to_text true, [:esc, :small_end]
        end
    },
        :soap_result_parse => %q{ # #{}
		# вспомогательный метод, который разбирает ответ от сервера, и вытаскивает из него все необходимые значения для дальнейшей их обработки
        def soap_result_parse
			# разбор ответа сервера
            self.last_status_code = @soapResult.code.to_i
            self.last_status_message = @soapResult.message
            temp = @soapResult.body
            self.last_retcode = '-'
            self.last_retmessage = '-'
			
			# разбор полученного XML-документа
            if temp
                node = User::UniversalXML.parse_xml( temp )
                if node
                    temp = node.xmlPath('**/Retcode')[-1]
                    self.last_retcode = temp.text if temp
                    temp = node.xmlPath('**/Retmessage')[-1]
                    self.last_retmessage = temp.text if temp
                end
            else
                node = nil
            end
            self.last_send_time = Time.now
            self.last_status = self.last_status_code > 299 ? false : true
            node
        end
    },
		:zookeeper_send => %q{# #{}
		# вспомогательный метод для отправки сообщений в зукипер
		def zookeeper_send typeMsg, msg
			tp = typeMsg.to_s
			color = case tp
				when 'error'    then 'red'
				when 'critical' then 'red'
				when 'info'     then 'gray'
				when 'warn'     then 'yellow'
				                else 'green'
			end
			
			data = {
				:color => color,
				:event_type => tp,
				:description => msg,
				:tooltip => msg
			}
			
			$control.zookeeper.create_node "/rvec/topology/kp_edo", data, org.apache.zookeeper.CreateMode::PERSISTENT
		end
	},
        :send_to_edo => %q{# #{}
		# метод совершает запрос в ЭДО, который отправляет данные, возвращает true или false, в зависимости от успешности отправки
		# paramNode - указание сервера на котором запущен вектор
		# param1    - метод обращения к серверу (:get или :post)
		# param2    - адрес, на который необходимо отправить, если он отличается от адреса настроенного в методе config
        def send_to_edo paramNode = :other, param1 = :get, param2 = nil
            param1, param2 = param2, param1 if param1.is_a? String
            type = USED_TYPE_SEND.include?(param1) ? param1 : :get
            url = param2
			
			zookeeper_send 'info', 'Подготовка к отправки данных'
			$log.info "[EDO.INFO] запрос сервера :#{paramNode}"
			
			# получаем настройки подключения и XML-документ для отправки
            net = config(NetConfig.new.thisNode(paramNode), :EDO_send)
            xmlEDO = constructEDO(:EDO_send)

			# отправляем XML-документ и разбираем ответ от сервера
            @soapResult = net.sendReq xmlEDO, type, url
            node = soap_result_parse
            self.docid = ''
            if node
                temp = node.xmlPath('**/Docid')[-1]
                if temp && !temp.empty?
                    self.docid = temp.text
                    self.doc_send_time = self.last_send_time
					$log.info "[EDO.INFO] Документ успешно принят  Docid = #{self.docid}, doc_send_time = #{self.doc_send_time}"
					zookeeper_send 'normal', 'данные успешно отправлены'
					
					case self.last_retcode 
						when 0 then zookeeper_send( 'info', 'Нет данных')
						when 2 then zookeeper_send( 'normal', 'Отправлен')
						when 3 then zookeeper_send( 'critical', 'Нет доступа')
						when 4 then zookeeper_send( 'critical', 'Ошибка отправки')
						when 5 then zookeeper_send( 'critical', 'Ошибка доставки')
					end
				else
					$log.info "[EDO.INFO] Документ не принят, doc_send_time = #{self.doc_send_time}"
					zookeeper_send 'warn', 'Сервер не принял документ'
                end
            end
			unless self.last_status
				ret = self.last_retcode
				$log.info "[EDO.ERROR] При отправке произошла ошибка, статус сервера: #{self.last_status_code} (#{self.last_status_message})" + (ret ? ", статус документа: #{ret} (self.last_retmessage)" : "")
				zookeeper_send 'error', 'Ошибка сервера'
			end
            self.last_status
        end
    },
        :get_last_pdf => %q{ # #{}
		# метод возвращает готовый PDF-документ, полученный при запросе в методе get_edo_print_form
        def get_last_pdf
            return '' unless @last_pdf
            require 'base64'
            Base64.decode64(@last_pdf)
        end
    },
        :get_edo_print_form => %q{ # #{}
		# метод совершает запрос в ЭДО, для получения PDF-документа, хранящегося на сервере
		# paramNode - указание сервера на котором запущен вектор
		# param1    - метод обращения к серверу (:get или :post)
		# param2    - адрес, на который необходимо отправить, если он отличается от адреса настроенного в методе config
        def get_edo_print_form paramNode = :other, param1 = :get, param2 = nil
			if !self.docid || self.docid == ''
				zookeeper_send 'error', 'Неуказан DocId для получения документа'
				raise "документ неможет быть получен, так как отсутствует его DocID" 
			end
            param1, param2 = param2, param1 if param1.is_a? String
            type = USED_TYPE_SEND.include?(param1) ? param1 : :get
            url = param2
			
			zookeeper_send 'info', 'Подготовка к отправки данных, для получения документа'
			$log.info "[EDO.INFO] запрос документа с сервера :#{paramNode}, docid = #{self.docid}"

			# получаем настройки подключения и XML-документ для отправки
            net = config(NetConfig.new.thisNode(paramNode), :EDO_get)
            xmlEDO = constructEDO(:EDO_get)

			# отправляем XML-документ и разбираем ответ от сервера
            @soapResult = net.sendReq xmlEDO, type, url
            node = soap_result_parse
            @last_pdf = nil
            if node
                temp = node.xmlPath('**/Docprintformcontent')[-1]
				if temp && !temp.empty?
					@last_pdf = temp.text
					$log.info "[EDO.INFO] Документ успешно получен"
					zookeeper_send 'normal', 'Документ успешно получен'
					
					case self.last_retcode 
						when 0 then zookeeper_send( 'info', 'Нет данных')
						when 2 then zookeeper_send( 'normal', 'Отправлен')
						when 3 then zookeeper_send( 'critical', 'Нет доступа')
						when 4 then zookeeper_send( 'critical', 'Ошибка отправки')
						when 5 then zookeeper_send( 'critical', 'Ошибка доставки')
					end
				else
					$log.info "[EDO.INFO] Документ не получен"
					zookeeper_send 'warn', 'Сервер не вернул документ'
				end
            end
			unless self.last_status
				ret = self.last_retcode
				$log.info "[EDO.ERROR] При отправке произошла ошибка, статус сервера: #{self.last_status_code} (#{self.last_status_message})" + (ret ? ", статус документа: #{ret} (self.last_retmessage)" : "")
				zookeeper_send 'error', 'Ошибка сервера'
				raise "ошибка протокола: #{@soapResult.code} #{@soapResult.message}"
			end

            get_last_pdf
        end
    }
end