﻿
Module.modify :UniversalAMQ do
	methods :consts => <<-'METHOD'
		# {}
		# Константы, которые используются в классах и объектах
		STRING_TYPE = [
			:string,
			:normString,   # все символы перевода строки, табуляции, и перевода каретки преобразуются в обычный пробел (xsd:normalizedString)
			:token,	       # как token, но смежные пробелы сокращаются до одного, начальные и конечные удаляются
			:base64,       # GpM7  (xsd:base64Binary)
			:hex,          # 0FB7  (xsd:hexBinary)
			:anyUri,       # http://www.example.com/, http://www.example.com/doc.html#ID5
			:language      # en-GB, en-US, fr
		]
		
		DECIMAL_TYPE = [
			:decimal,   # числовое значение больших размеров, может быть как целым, так и вещественным (по стандарту все процессоры должны поддерживать не меньше 18 цифр)
			:integer,   # base(decimal) <- без дробной части
			:pInteger,  # base(integer) # > 0  // xsd:positiveInteger
			:nInteger,  # base(integet) # < 0  // xsd:negativeInteger
			:nnInteger, # base(integer) # >= 0 // xsd:nonNegativeInteger
			:npInteger, # base(integer) # <= 0 // xsd:nonPositiveInteger
			:tiny,      # +- 1 byte            // xsd:byte
			:byte,      # +  1 byte            // xsd:unsignedByte
			:small,     # +- 2 byte            // xsd:short
			:word,      # +  2 byte            // xsd:unsignedShort
			:int,       # +- 4 byte
			:dword,     # +  4 byte            // xsd:unsignedInt
			:long,      # +- 8 byte
			:qword      # +  8 byte            // xsd:unsignedLong
		]
		
		DATETIME_TYPE = [
			:time,      # 13:20:00.000, 13:20:00.000-05:00
			:dateTime,  # 1999-05-31T13:20:00.000-05:00 => 31 мая 1999 года 13 часов 20 минут Восточноевропейского стандартного времени, которое на 5 часов отстает от Универсального времени
			:duration,  # P1Y2M3DT10H30M12.3S => 1 год, 2 месяца, 3 дня, 10 часов, 30 минут, и 12.3 секунды
			:date,      # 1999-05-31
			:month,     # --05-- => май                                           // xsd:gMonth
			:year,      # 1999                                                    // xsd:gYear
			:yearMonth, # 1999-02 => Февраль 1999 года, не зависимо от номера дня // xsd:gYearMonth
			:day,       # ---31 => 31 день                                        // xsd:gDay
			:monthDay   # --05-31 => 31 мая                                       // xsd:gMonthDay
		]
		
		DEFAULT_TYPE = STRING_TYPE + DECIMAL_TYPE + DATETIME_TYPE + [
			:float,   # вещественное значение малой точности (4 байта)
			:double,  # вещественное значение большой точности (8 байт)
			:boolean
		]
		
		USE_TYPE_TO_XSD_TYPE = {
			string:       'xsd:string',
			normString:   'xsd:normalizedString',
			token:        'xsd:token',
			base64:       'xsd:base64Binary',
			hex:          'xsd:hexBinary',
			anyUri:       'xsd:anyUri',
			language:     'xsd:language',
			decimal:      'xsd:decimal',
			integer:      'xsd:integer',
			pInteger:     'xsd:positiveInteger',
			nInteger:     'xsd:negativeInteger',
			nnInteger:    'xsd:nonNegativeInteger',
			npInteger:    'xsd:nonPositiveInteger',
			tiny:         'xsd:byte',
			byte:         'xsd:unsignedByte',
			small:        'xsd:short',
			word:         'xsd:unsignedShort',
			int:          'xsd:int',
			dword:        'xsd:unsignedInt',
			long:         'xsd:long',
			qword:        'xsd:unsignedLong',
			time:         'xsd:time',
			dateTime:     'xsd:dateTime',
			duration:     'xsd:duration',
			date:         'xsd:date',
			month:        'xsd:gMonth',
			year:         'xsd:gYear',
			yearMonth:    'xsd:gYearMonth',
			day:          'xsd:gDay',
			monthDay:     'xsd:gMonthDay',
			float:        'xsd:float',
			double:       'xsd:double',
			boolean:      'xsd:boolean'
		}
		
		#require 'Base64'
		#require 'bigdecimal'
		
	METHOD
end
