﻿
Module.modify :UniversalAMQ do
	methods :self_a_send => <<-'METHOD'
		# {}
		# Класс для простой работы с ActiveMQ через artemis или стандартный.
			
		class SendActiveMQ
			class AMQErrorServer
				# подкласс для обработки внутренних ошибок ActiveMQ
				def initialize amq
					@amq = amq
				end
	
				def onException ex
					@amq.sererr ex
				end
			end
		
			private
			def seterr ex
				@err = ex
			end

			public

			def initialize
				self.transient :session
				self.transient :connection
				self.transient :destination
				@url = []
				@login = ''
				@pwd = ''
				@queue = 'esb-test-queue'
				@msg = ''
				@err = nil
			end
			

			def url value; @url << value; end      # позволяет добавить URL, к которому можно подключиться
			def login value; @login = value; end   # логин подключения, если нет, то необходимо указывать в nil
			def password value; @pwd = value; end  # пароль подключения, если нет, то необходимо указать nil
			def queue value; @queue = value; end   # очередь, к которой необходимо подкоючиться
			def message value; @msg = value; end   # отправка сообщения (можно неиспользовать)
			def error?; !!@err; end                # возвращает true, если была какая-то внутренняя ошибка очереди
			def getError; @err; end                # возвращает объект, который хранит информацию об ошибках
			
			def message?
				# возвращает true, если было настроенно сообщение поумолчанию
				!@msg.nil? && !@msg.empty?
			end
			
			def start type=:artemis #:artemis || :default
				# устанавливает соединение ActiveMQ, где:
				#   type - тип библиотеки работы с ActioveMQ
				#     :artemis - будет работать с org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory
				#     :default - будет работать с org.apache.activemq.ActiveMQConnectionFactory
				# return:
				#   true - все готово к работе с каналом связи ActiveMQ 
				#   nil  - что-то пошло не так, необходимо обойти алгоритм работы с ActiveMQ стороной, метот stop уже сработал
				@producer = nil
				@session = nil
				@connection = nil
				@err = nil
				begin
					# бежип по всем указанным адресам и пробуем подключиться к каждому, до первого успешного подключения
					@url.each do |tcp|
						begin
							connectionFactory = 
								if type == :artemis
									org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory.new(tcp, @login, @pwd)
								else
									org.apache.activemq.ActiveMQConnectionFactory.new(@login, @pwd, tcp)
								end
							@connection = connectionFactory.createConnection()
							break
						rescue
						end
					end
					
					return unless @connection  # выходим возвращая nil, если ни по одному из указанных адресов неудалось установить соелинение
					
					# устанавливаем соединение
					@connection.start()
					# регистрируем класс-экзепшен, который будет срабанывать при возникновении какой-либо внутренней ошибки
					err = AMQErrorServer.new(self) rescue 'ERROR' 
					@connection.setExceptionListener(err)

					# устанавливаем сессию соединения
					@session = @connection.createSession(false, javax.jms.Session.AUTO_ACKNOWLEDGE)
					# настраиваем работу на указанную очередь
					@destination = @session.createQueue(@queue)
					
				rescue
					# если что-то пошло не так закрываем все открытое в обратном порядке, и возвращаем nil, как невозможность работы канала
					@session.close() if @session
					@connection.close() if @connection
					@destination = nil
					@session = nil
					@connection = nil
					return
				end
				# возвращаем true, так как соединение установленно успешно, сессия была открыта, и настроенна работа с очередью
				true
			end
			
			def stop 
				# Сообщаем, что нам необходимо завершить работу с ActiveMQ, закрываем сессию, и рвем соединение
				@session.close() if @session
				@connection.close() if @connection
				@destination = nil
				@session = nil
				@connection = nil
				@err = nil
			end
			
			def send msg
				# метод производит отправку сообщения через ActiveMQ, где
				#   msg - строка данных, которые необходимо отправить
				# return:
				#   true - сообщение успешно отправленно
				#   nil  - произошла какая-то ошибка при попытке отправки сообщения


				@err = nil
				# создаем объект-упаковщик, который будет отправлять наше сообщение
				producer = @session.createProducer(@destination)
				producer.setDeliveryMode(javax.jms.DeliveryMode.PERSISTENT)
				begin
					# создаем объект-сообщение, который будет отправлен в очередь ActiveMQ
					message_send = @session.createTextMessage(msg)
					# отправляем сообщение в ActiveMQ
					producer.send(message_send)
				rescue
					# что-то пошло нетак, наример оборвалось соединение, возвращаем nil, как признак ошибки
					stop
					return
				end
				# возвращаем true, так как сообщение было успешно отправленно
				true
			end

			def read timeout = 1000
				# метод читаем сообщение из очереди, где
				#    timeout - время в ms, которое следует ожидать появления сообщения в очереди, после чего возвращаем nil
				# return:
				#   nil   - очередь пуста, и в течении timeout ms никто не положил в очередь нового сообщения
				#  другое - мы что-то прочитали из очереди (обычно строка, с другими вариантами пока неработали)
				return unless @connection
				consumer = @session.createConsumer(@destination)
				message = consumer.receive(timeout)
				result = message.is_a?(javax.jms.TextMessage) ? message.getText() : message
				consumer.close()
				result
			end
			
			def only_send msg = nil, type=:default
				# отправка одним методом (автоалгоритм, последовательно выполняющий методы: start, send, stop), где 
				#    msg  - сообщение которое необходимо отправить
				#    type - драйвер подключения ActiveMQ
				# return:
				#   nil  - отправка сообщения неудалась
				#   true - сообщение было успешно отправленно
				msg ||= @msg
				# выполняем отправку только если есть что отправлять
				unless msg.nil?
					# устанавливаем соединение ActiveMQ
					if start type
						# соединение установленно, делаем попытку отправки сообщения
						if send(msg)
							# сообщение успешно отправленно закрываем соединение
							stop
						else
							# произошла ошибка отправки, возвращаем nil
							return
						end
					else
						# произошла ошибка подключения, возвращаем nil
						return
					end
					# возвращаем true, так как сообщение было успешно отправленно
					true
				end
				# возвращаем nil, так как отправлять нам нечего
			end
		end
		
		def self.a_send &block
			# создание объекта канала ActiveMQ, с его настройками в стиле DSL
			if block_given?
				objActiveMQ = SendActiveMQ.new
				objActiveMQ.instance_eval &block # настройка ActiveMQ в стиле DSL
				objActiveMQ.only_send if objActiveMQ.message? # если в настройках было указано сообщение, то отправляем его сразу
				objActiveMQ # возвращаем созданный и настроенный объект канала ActiveMQ
			end
		end
	METHOD
end
