
Module.modify :UniversalAMQ do
	methods :class_XSDAttribute => <<-'METHOD'
		# {}
		# Класс для создания xsd-атрибутов, а так же их преобразование в XML
		class XSDAttribute
			USE_VALUE = [
				:required,  # обязателен
				:optional,  # необязателен
				:prohibited # запрещен
			]
			
			def initialize _name, _type, dop_param = nil
				# _name     - наименование атрибута тега
				# _type     - тип данных, который будет передаваться в атрибуте
				# dop_param:
				#    nil  - никаких доп. настроек атрибута
				#    :required | :optional | :prohibited  - устанавливает указанное определение атрибута
				#  другое - определяет атрибут как :optional, и dop_param делает как значение поумолчанию

				_type = _type.to_s.to_sym unless _type.is_a?(Symbol)
				raise "тип '#{_type}' нельзя установить для атрибута" unless DEFAULT_TYPE.include?(_type)
				
				@name = _name.is_a?(Symbol) ? _name : _name.to_s.to_sym
				@type = _type
				if dop_value = nil
					@default = nil
					@use = nil
				elsif USE_VALUE.include?(dop_param)
					@use = dop_param
					@default = nil
				else
					@use = :optional
					@default = dop_param
				end
				@fixed = nil
			end
			
			def use _type = nil
				# возвращает определение атрибута, если _type = nil, или устанавливает новое значение, в другом случае
				return @use if _type.nil?
				_type = _type.to_s.to_sym unless _type.is_a?(Symbol)
				raise "значение '#{_type}' нельзя установить, доступные значения смотирте в UniversalAMQ::XSDAttribute::USE_VALUE" unless USE_VALUE.include?(_type)
				@use = _type
				@default = nil if _type != :optional  # если определяем атрибут как опциональный, то сбрасываем значение по умолчанию
				@fixed = nil if _type == :prohibited  # если атрибут запрещен, то его нельзя сделать фиксированным
				self
			end
			
			def name # метод возвращает имя атрибута
				@name
			end
			
			def type # метод возвращает тип данных атрибута
				@type
			end
			
			def default? # метод возвращает true, если было установленно значение поумолчанию, и false в противном случае
				!@default.nil?
			end
			
			def fixed? # метод возвращает true, если атрибут был зафиксирован, и false в противном случае
				!@fixed.nil?
			end
			
			def use? # метод возвращает true, если атрибут был определен типом, и false в противном случае
				!@use.nil?
			end
			
			def default value = nil 
				# метод возвращает установленное значечие поумолчанию, если вызвать метод без параметра, или устанавливает новое значение поумолчанию
				return @default if value.nil?
				@use = :optional # значение поумолчанию может быть только у опционального атрибута
				@default = value
				@fixed = nil
				self
			end
			
			def to_module_methodTo 
				# генерирует строку-скрипт преобразования хеш-данных в XML-документ
				attr_set = "node[:#{@name}] = User::UniversalAMQ.def_type_to_s( data[:#{@name}], :#{@type} ) "
				if @use == :optional
					"#{attr_set} if data.key?(:#{@name})\n"
				else
					attr_set + "\n"
				end
			end
			
			def fixed value = nil
				# метод возвращает установленное фиксированное значечие, если вызвать метод без параметра, или фиксирует новое значение
				return @fixed if value.nil?
				@fixed = value
				@default = nil
				self
			end
			
			def to_s
				# метод преобразовывает объект в его описание в XSD-схеме
				[
					"<xsd:attribute name=\"#{@name}\" type=\"#{USE_TYPE_TO_XSD_TYPE[@type]}\"",
					@use.nil? ? '' : " use=\"#{@use}\"",
					@default.nil? ? '' : " default=\"#{@default}\"",
					@fixed.nil? ? '' : " fixed=\"#{@fixed}\"",
					'/>'
				].join
			end
			
			def to_node up_node = nil
				# метод преобразовывает объект в узел типа UniversalXML::Node, в его XSD-вид
				node = unless up_node.nil? 
					up_node.create_node :attribute
				else
					User::UniversalXML::Node.new :attribute
				end
				node.prefix 'xsd'
				node.attr :name, @name
				node.attr :type, USE_TYPE_TO_XSD_TYPE[@type]
				node.attr(:use, @use)         unless @use.nil?
				node.attr(:default, @default) unless @default.nil?
				node.attr(:fixed, @fixed)     unless @fixed.nil?
				
				node
			end
			
			def to_h
				# метод преобразовывает объект в простой Hash, с данными настройки объекта
				result = {name: @name, type: USE_TYPE_TO_XSD_TYPE[@type]}
				result[:use]     = @use     unless @use.nil?
				result[:default] = @default unless @default.nil?
				result[:fixed]   = @fixed   unless @fixed.nil?
				result
			end
		end
	METHOD
end
