﻿
Module.modify :UniversalAMQ do
	methods :class_XSDBase => <<-'METHOD'
		# {}
		# Базовый класс для создания xsd типов и вложенных структур, а так же их преобразование в XML
		class XSDBase
			def initialize
				@attrs = {}
					# [XSDAttribute, ...]
				@elements = {}
					# [XSDElement, ...]
				@schema = nil
			end
			
			def attr _name, type, dop_param = nil
				# создает в структуру атрибут тега
				@attrs[_name] = XSDAttribute.new( _name, type, dop_param)
				self
			end
			
			def attrFixed _name, type, fixed
				# создает в структуру атрибут тега, значение которого может быть только указанным
				@attrs[_name] = XSDAttribute.new(_name, type).fixed(fixed)
				self
			end
			
			def attr? _name
				# возвращает true, если указанное имя атрибута тега в структуре уже существует и false в другом случае
				@attrs.key? _name
			end
			
			def attribute _name
				# возвращает объект, хранящий настройки указанного атрибута тега, или nil, в случае отсутствия такового
				@attrs[_name]
			end
			
			def attrs &block
				# возвращает хеш настроек созданных атрибутов тега, или передает каждый из них в блок, если такогой был передан
				return @attrs.values unless block_given?
				@attrs.values.each(&block)
				self
			end
			
			def element? _name
				# возвращает true, если указанный тег существует в структуре, и false в противном случае
				@elements.key? _name
			end
			
			def each &block
				# позволяет пробежаться по всем вложенным тегам в структуре
				@elements.values.each(&block)
			end
			
			def getElement _name
				# позволяет получить настройки указанного вложенного в структуру тега
				@elements[_name]
			end
			
			def element _name, type, &block
				# создает новый вложенный тег в текущую структуру, где
				#   _name - наименование тега, который будет находиться в текущей структуре
				#   type  - тип данных, который будет хранить в себе тег
				#  &block - если указан, то внутри позволяет настроить создаваемый тег в стиле DSL
				elem = XSDElement.new(_name, @schema).type(type)
				elem.instance_eval(&block) if block_given?
				@elements[_name] = elem
				self
			end
			
			def ref type, &block
				# вставляет ранее созданную структуру в текущую, делая ее подструктурой
				#   type - наименование структуры, которую необходимо включить в текущую
				#  &block - если указан, то внутри позволяет настроить создаваемый тег в стиле DSL
				elem = XSDElement.new(nil, @schema).ref(type)
				elem.instance_eval(&block) if block_given?
				@elements[@elements.size] = elem
				self
			end
			
			def array type, maxCount = :unbounded, &block
				# вставляет в текущий тег массив указанной структуры (повторяющаяся структура)
				#   type     - наименование структуры, которая будет являться элементом массива, и будет повторяться в текущей структуре
				#   maxCount - максимольное количество повторений указанной структуры, при указании :unbounded, делает неограниченное повторение
				#   &block   - если указан, то внутри позволяет настроить создаваемый тег в стиле DSL
				elem = XSDElement.new(nil, @schema)
						.ref(type)
						.maxOccurs(maxCount)
						.minOccurs(0)
				elem.instance_eval(&block) if block_given?
				@elements[@elements.size] = elem
				self
			end
			
			def to_module_methodTo 
				# генерирует строку-скрипт преобразования хеш-данных в XML-документ
				result = []
				@attrs.each{|k,v| result << v.to_module_methodTo}
				@elements.each{|k,v| result << v.to_module_methodTo}
				result.join("\t\t\t\t\t\t\t")
			end
		end
	METHOD
end
